/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.subscription;

import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.BaseProperties;
import com.sybase.rsmplugin.components.BasePropertyPage;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.components.functionrepdef.FunctionRepDef;
import com.sybase.rsmplugin.components.logical.LogConnection;
import com.sybase.rsmplugin.components.storedprocedure.StoredProcedure;
import com.sybase.rsmplugin.components.subscription.SubPropWherePanel;
import com.sybase.rsmplugin.components.subscription.SubWizGeneralPanel;
import com.sybase.rsmplugin.components.subscription.Subscription;
import com.sybase.rsmplugin.components.table.Table;
import com.sybase.rsmplugin.components.tablerepdef.TableRepDef;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SubWizard
extends BaseProperties {
    protected SCPageController[] _pages = null;
    protected BaseContainer _parent;
    protected String _controllingRS;
    protected String _repDS;
    protected String _repDB;
    protected String _repOwner;
    protected String _repName;
    protected String _env;
    protected String _name;
    protected String _repdef;
    protected boolean _isTable;
    protected String _where;
    protected String _method;
    protected boolean _truncateTable = false;
    protected boolean _autoCorrection = false;

    public SubWizard(String string, String string2, String string3, String string4, String string5, boolean bl, BaseContainer baseContainer, SCDialogSupport2 sCDialogSupport2, String string6) {
        super(sCDialogSupport2);
        Dbg.wassert(baseContainer != null, "Null parent BaseContainer parameter.");
        Dbg.wassert(string != null && string.length() > 0, "Null or empty controlling rs, parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty rep DS parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty rep DB parameter.");
        Dbg.wassert(string4 != null && string4.length() > 0, "Null or empty rep owner parameter.");
        Dbg.wassert(string5 != null && string5.length() > 0, "Null or empty rep object name parameter.");
        Dbg.wassert(string6 != null && string6.length() > 0, "Null or empty environment name parameter.");
        this._parent = baseContainer;
        this._controllingRS = string;
        this._repDS = string2;
        this._repDB = string3;
        this._repOwner = string4;
        this._repName = string5;
        this._isTable = bl;
        this._env = string6;
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("SubRes", "ADD_SUB_TITLE");
    }

    public String getDomainName() {
        return this._env;
    }

    public String getControllingRS() {
        return this._controllingRS;
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = new SCPageController[]{new GeneralPage(this), new WherePage(this)};
        }
        return this._pages;
    }

    @Override
    public BaseItem getItem() {
        return this._parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onOk() {
        boolean bl = false;
        this.getDialogSupport().startWait();
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        try {
            Subscription subscription = semanticFactory.getSubscription(this._name, this._controllingRS, this._repDS, this._repDB, this._repdef);
            subscription.create(this._method == null ? "" : this._method, this._truncateTable, this._autoCorrection, this._where == null ? "" : this._where);
            bl = true;
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
        finally {
            this.getDialogSupport().endWait();
        }
        if (bl) {
            bl = super.onOk();
            PluginSupport.refreshDomain(this._parent);
        }
        return bl;
    }

    @Override
    public void onApply() {
        super.onApply();
    }

    @Override
    public int getEnabledStandardButtons() {
        int n = this.isModified() ? 11 : 10;
        return n;
    }

    class WherePage
    extends BasePropertyPage {
        private SubPropWherePanel _goPage;

        public WherePage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("SubRes", "WHERE_PAGE_TAG"));
            this._goPage = new SubPropWherePanel();
            this.setPreferredWidth();
        }

        @Override
        public void onInitDialog() {
        }

        @Override
        public boolean onOk() {
            SubWizard.this._where = this._goPage.txt_editor.getText();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }
    }

    class GeneralPage
    extends BasePropertyPage
    implements ActionListener,
    DocumentListener {
        private SubWizGeneralPanel _goPage;
        private List _connList;
        private List _objList;

        public GeneralPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("SubRes", "GENERAL_PAGE_TAG"));
            this._goPage = new SubWizGeneralPanel();
            this.setPreferredWidth();
        }

        @Override
        public void onInitDialog() {
            SCDialogSupport2 sCDialogSupport2 = this.getDialogSupport();
            this.getDialogSupport();
            JButton jButton = sCDialogSupport2.getStandardButtonById(4);
            jButton.setVisible(false);
            jButton.setEnabled(false);
            this._goPage.cbx_repConn.addItem((Object)(SubWizard.this._repDS + "." + SubWizard.this._repDB));
            this._goPage.cbx_repConn.setEnabled(false);
            this._goPage.cbx_repObj.addItem((Object)(SubWizard.this._repOwner + "." + SubWizard.this._repName));
            this._goPage.cbx_repObj.setEnabled(false);
            if (SubWizard.this._isTable) {
                this._goPage.cbx_method.addItem((Object)BundleManager.getString("SubRes", "MATERIAL_NONE"));
                this._goPage.cbx_method.addItem((Object)BundleManager.getString("SubRes", "MATERIAL_ATOMIC"));
                this._goPage.cbx_method.addItem((Object)BundleManager.getString("SubRes", "MATERIAL_NON_ATOMIC"));
                this._goPage.cbx_method.addItem((Object)BundleManager.getString("SubRes", "MATERIAL_INCREMENT"));
                this._goPage.cbx_method.addItem((Object)BundleManager.getString("SubRes", "MATERIAL_BULK"));
            } else {
                this._goPage.cbx_method.addItem((Object)BundleManager.getString("SubRes", "MATERIAL_NONE"));
                this._goPage.cbx_method.addItem((Object)BundleManager.getString("SubRes", "MATERIAL_BULK"));
                this._goPage.lbl_priObj.setText(BundleManager.getString("SubRes", "STORED_PROCEDURE"));
                this._goPage.lbl_priObj.setDisplayedMnemonic(BundleManager.getMnemonic("SubRes", "STORED_PROCEDURE_MNEM"));
                this._goPage.chk_truncTable.setVisible(false);
                this._goPage.chk_autoCorrect.setVisible(false);
            }
            try {
                this.loadConns();
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            this._goPage.fld_name.getDocument().addDocumentListener(this);
            this._goPage.fld_name.requestFocusInWindow();
            this.setModified(this.isInfoSet());
        }

        @Override
        public boolean onOk() {
            SubWizard.this._name = this._goPage.fld_name.getText();
            SubWizard.this._repdef = this._goPage.cbx_priRepDef.getSelectedString();
            SubWizard.this._method = this._goPage.cbx_method.getSelectedString();
            if (SubWizard.this._isTable) {
                SubWizard.this._truncateTable = this._goPage.chk_truncTable.isSelected();
                SubWizard.this._autoCorrection = this._goPage.chk_autoCorrect.isSelected();
            } else {
                SubWizard.this._truncateTable = false;
                SubWizard.this._autoCorrection = false;
            }
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getSource() == this._goPage.cbx_priConn) {
                    this.loadObjects();
                }
                if (actionEvent.getSource() == this._goPage.cbx_priObj) {
                    if (SubWizard.this._isTable) {
                        this.loadTableRepDefs();
                    } else {
                        this.loadFunctionRepDefs();
                    }
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            this.setModified(this.isInfoSet());
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setModified(this.isInfoSet());
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setModified(this.isInfoSet());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setModified(this.isInfoSet());
        }

        public boolean isInfoSet() {
            String string = this._goPage.fld_name.getText();
            String string2 = this._goPage.cbx_priRepDef.getSelectedString();
            return string != null && string.length() > 0 && string2 != null && string2.length() > 0;
        }

        protected void loadConns() throws SQLException {
            this._goPage.cbx_priConn.removeActionListener((ActionListener)this);
            this._goPage.cbx_priConn.removeAllItems();
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(SubWizard.this.getDomainName());
            if (semanticFactory != null) {
                this._connList = semanticFactory.getKnownPhyConnections(SubWizard.this.getControllingRS());
                ListIterator<LogConnection> listIterator = this._connList.listIterator();
                while (listIterator.hasNext()) {
                    PhyConnection phyConnection = (PhyConnection)listIterator.next();
                    if (phyConnection.getDS().equals(SubWizard.this._repDS) && phyConnection.getDB().equals(SubWizard.this._repDB)) {
                        listIterator.remove();
                        continue;
                    }
                    if (phyConnection.isRSSD()) {
                        listIterator.remove();
                        continue;
                    }
                    if (!phyConnection.isPrimary()) {
                        listIterator.remove();
                        continue;
                    }
                    if (phyConnection.isPartOfLogicalConnection()) {
                        LogConnection logConnection;
                        listIterator.remove();
                        if (!phyConnection.isStandby() || (logConnection = semanticFactory.getLogConnection(phyConnection.getControllingRS(), phyConnection.getLDS(), phyConnection.getLDB())).getLDS().equals(SubWizard.this._repDS) && logConnection.getLDB().equals(SubWizard.this._repDB)) continue;
                        logConnection.load();
                        if (!logConnection.exists()) continue;
                        listIterator.add(logConnection);
                        this._goPage.cbx_priConn.addItem((Object)logConnection.getName());
                        continue;
                    }
                    this._goPage.cbx_priConn.addItem((Object)phyConnection.getName());
                }
            }
            this._goPage.cbx_priConn.addActionListener((ActionListener)this);
            this.loadObjects();
        }

        protected Object getSelectedConn() throws SQLException {
            Object var1_1 = null;
            int n = this._goPage.cbx_priConn.getSelectedIndex();
            if (n >= 0 && this._connList != null && this._connList.size() > n) {
                var1_1 = this._connList.get(n);
            }
            return var1_1;
        }

        protected void loadObjects() throws SQLException {
            Object object;
            this._goPage.cbx_priObj.removeActionListener((ActionListener)this);
            this._goPage.cbx_priObj.removeAllItems();
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(SubWizard.this.getDomainName());
            if (semanticFactory != null && (object = this.getSelectedConn()) != null) {
                String string = null;
                String string2 = null;
                if (object instanceof PhyConnection) {
                    string = ((PhyConnection)object).getDS();
                    string2 = ((PhyConnection)object).getDB();
                } else if (object instanceof LogConnection) {
                    string = ((LogConnection)object).getActiveDS();
                    string2 = ((LogConnection)object).getActiveDB();
                } else {
                    Dbg.wassert(false, "Unexpected object type in connection list.");
                }
                if (string != null && string.length() > 0) {
                    if (SubWizard.this._isTable) {
                        this._objList = semanticFactory.getTables(string, string2);
                        ListIterator listIterator = this._objList.listIterator();
                        while (listIterator.hasNext()) {
                            Table table = (Table)listIterator.next();
                            if (table.getName().startsWith("rs_")) {
                                listIterator.remove();
                                continue;
                            }
                            this._goPage.cbx_priObj.addItem((Object)(table.getOwner() + "." + table.getName()));
                        }
                    } else {
                        this._objList = semanticFactory.getStoredProcedures(string, string2);
                        ListIterator listIterator = this._objList.listIterator();
                        while (listIterator.hasNext()) {
                            StoredProcedure storedProcedure = (StoredProcedure)listIterator.next();
                            if (storedProcedure.getName().startsWith("rs_")) {
                                listIterator.remove();
                                continue;
                            }
                            this._goPage.cbx_priObj.addItem((Object)(storedProcedure.getOwner() + "." + storedProcedure.getName()));
                        }
                    }
                }
            }
            this._goPage.cbx_priObj.addActionListener((ActionListener)this);
            if (SubWizard.this._isTable) {
                this.loadTableRepDefs();
            } else {
                this.loadFunctionRepDefs();
            }
        }

        protected Table getSelectedTable() throws SQLException {
            Table table = null;
            int n = this._goPage.cbx_priObj.getSelectedIndex();
            if (n >= 0 && this._objList != null && this._objList.size() > n) {
                table = (Table)this._objList.get(n);
            }
            return table;
        }

        protected StoredProcedure getSelectedProc() throws SQLException {
            StoredProcedure storedProcedure = null;
            int n = this._goPage.cbx_priObj.getSelectedIndex();
            if (n >= 0 && this._objList != null && this._objList.size() > n) {
                storedProcedure = (StoredProcedure)this._objList.get(n);
            }
            return storedProcedure;
        }

        protected void loadTableRepDefs() throws SQLException {
            this._goPage.cbx_priRepDef.removeActionListener((ActionListener)this);
            this._goPage.cbx_priRepDef.removeAllItems();
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(SubWizard.this.getDomainName());
            if (semanticFactory != null) {
                Object object = this.getSelectedConn();
                Table table = this.getSelectedTable();
                if (object != null && table != null) {
                    String string = null;
                    String string2 = null;
                    String string3 = null;
                    String string4 = null;
                    String string5 = null;
                    if (object instanceof PhyConnection) {
                        string = ((PhyConnection)object).getControllingRS();
                        string2 = ((PhyConnection)object).getDS();
                        string3 = ((PhyConnection)object).getDB();
                        string4 = null;
                        string5 = null;
                    } else if (object instanceof LogConnection) {
                        string = ((LogConnection)object).getControllingRS();
                        string2 = ((LogConnection)object).getActiveDS();
                        string3 = ((LogConnection)object).getActiveDB();
                        string4 = ((LogConnection)object).getLDS();
                        string5 = ((LogConnection)object).getLDB();
                    } else {
                        Dbg.wassert(false, "Unexpected object type in connection list.");
                    }
                    if (string2 != null && string2.length() > 0) {
                        List list = semanticFactory.getTableRepDefs(string, string4, string5, string2, string3, table.getName(), table.getOwner());
                        ListIterator listIterator = list.listIterator();
                        while (listIterator.hasNext()) {
                            String string6;
                            TableRepDef tableRepDef = (TableRepDef)listIterator.next();
                            tableRepDef.loadTableRepDef();
                            String string7 = tableRepDef.getReplicateTableOwner();
                            if (string7 == null || string7.length() == 0) {
                                string7 = tableRepDef.getPrimaryTableOwner();
                            }
                            if ((string6 = tableRepDef.getReplicateTableName()) == null || string6.length() == 0) {
                                string6 = tableRepDef.getPrimaryTableName();
                            }
                            if (tableRepDef.getRepDefOwnerQual()) {
                                if (!string6.equals(SubWizard.this._repName)) continue;
                                if (string7 != null && string7.length() > 0) {
                                    if (!string7.equals(SubWizard.this._repOwner)) continue;
                                    this._goPage.cbx_priRepDef.addItem((Object)tableRepDef.getName());
                                    continue;
                                }
                                this._goPage.cbx_priRepDef.addItem((Object)tableRepDef.getName());
                                continue;
                            }
                            if (!string6.equals(SubWizard.this._repName)) continue;
                            this._goPage.cbx_priRepDef.addItem((Object)tableRepDef.getName());
                        }
                    }
                }
            }
            this._goPage.cbx_priRepDef.addActionListener((ActionListener)this);
        }

        protected void loadFunctionRepDefs() throws SQLException {
            this._goPage.cbx_priRepDef.removeActionListener((ActionListener)this);
            this._goPage.cbx_priRepDef.removeAllItems();
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(SubWizard.this.getDomainName());
            if (semanticFactory != null) {
                Object object = this.getSelectedConn();
                StoredProcedure storedProcedure = this.getSelectedProc();
                if (object != null && storedProcedure != null) {
                    String string = null;
                    String string2 = null;
                    String string3 = null;
                    String string4 = null;
                    String string5 = null;
                    if (object instanceof PhyConnection) {
                        string = ((PhyConnection)object).getControllingRS();
                        string2 = ((PhyConnection)object).getDS();
                        string3 = ((PhyConnection)object).getDB();
                        string4 = null;
                        string5 = null;
                    } else if (object instanceof LogConnection) {
                        string = ((LogConnection)object).getControllingRS();
                        string2 = ((LogConnection)object).getActiveDS();
                        string3 = ((LogConnection)object).getActiveDB();
                        string4 = ((LogConnection)object).getLDS();
                        string5 = ((LogConnection)object).getLDB();
                    } else {
                        Dbg.wassert(false, "Unexpected object type in connection list.");
                    }
                    if (string2 != null && string2.length() > 0) {
                        List list = semanticFactory.getFunctionRepDefs(string, string4, string5, string2, string3, storedProcedure.getName(), storedProcedure.getOwner());
                        ListIterator listIterator = list.listIterator();
                        while (listIterator.hasNext()) {
                            FunctionRepDef functionRepDef = (FunctionRepDef)listIterator.next();
                            functionRepDef.loadFunctionRepDef();
                            String string6 = functionRepDef.getReplicateProcName();
                            if (string6 == null || !string6.equals(SubWizard.this._repName)) continue;
                            this._goPage.cbx_priRepDef.addItem((Object)functionRepDef.getName());
                        }
                    }
                }
            }
            this._goPage.cbx_priRepDef.addActionListener((ActionListener)this);
        }
    }
}

