/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.table;

import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseSemantic;
import com.sybase.rsmplugin.components.DataServer;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.util.Dbg;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class Column
implements BaseSemantic,
Cloneable {
    private EnvDomain _domain = null;
    private String _name = null;
    private String _type = null;
    private int _typeID;
    private int _colID;
    private int _length;
    private int _status;
    private boolean _isKey = false;
    private static final String[] _variableLengthDatatypeList = new String[]{"char", "varchar", "nchar", "nvarchar", "unichar", "univarchar", "binary", "varbinary"};
    private static final String[] _textImageDatatypeList = new String[]{"text", "unitext", "image", "rawobject"};
    private static final int LOB_DO_NOT_REPLICATE = 8;
    private static final int LOB_ALWAYS_REPLICATE = 9;
    private static final int LOB_REPLICATE_IF_CHANGED = 10;

    public Column(String string, String string2, int n, int n2, int n3, int n4, EnvDomain envDomain) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty column name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty column type parameter.");
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        this._name = string;
        this._type = string2;
        this._typeID = n;
        this._colID = n2;
        this._length = n3;
        this._status = n4;
        this._domain = envDomain;
    }

    public Object clone() {
        Column column = null;
        try {
            column = (Column)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Dbg.wassert(false, "Unexpected exception thrown.");
        }
        return column;
    }

    public EnvDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain;
    }

    @Override
    public String getDomainName() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain.getName();
    }

    @Override
    public boolean isControlledByRSMS() {
        return false;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    public String getName() {
        Dbg.wassert(this._name != null && this._name.length() > 0, "Null or empty table name attribute.");
        return this._name;
    }

    public String getDatatype() {
        Dbg.wassert(this._type != null && this._type.length() > 0, "Null or empty datatype attribute.");
        return this._type;
    }

    public String getFormattedDatatype() {
        return Column.isVariableLengthDatatype(this.getDatatype()) ? this.getDatatype() + "(" + this.getLength() + ")" : this.getDatatype();
    }

    public int getDatatypeID() {
        return this._typeID;
    }

    public int getColumnID() {
        return this._colID;
    }

    public int getLength() {
        return this._length;
    }

    public static boolean isVariableLengthDatatype(String string) {
        for (int i = 0; i < _variableLengthDatatypeList.length; ++i) {
            if (!_variableLengthDatatypeList[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTextImageDatatype(String string) {
        for (int i = 0; i < _textImageDatatypeList.length; ++i) {
            if (!_textImageDatatypeList[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isReplicated() {
        return this.isMarkedReplicateAlways() || this.isMarkedReplicateIfChanged();
    }

    public boolean isMarkedReplicateAlways() {
        return (this._status & 9) == 9;
    }

    public boolean isMarkedReplicateIfChanged() {
        return (this._status & 0xA) == 10;
    }

    public boolean isKey() {
        return this._isKey;
    }

    public void setKey(boolean bl) {
        this._isKey = bl;
    }

    public static List getColumns(String string, String string2, String string3, String string4, EnvDomain envDomain) throws SQLException {
        List list = null;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(envDomain.getName());
        DataServer dataServer = semanticFactory.getDataServer(string);
        list = dataServer != null ? dataServer.getColumns(string2, string3, string4) : new ArrayList();
        return list;
    }
}

