/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.table;

import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.DataServer;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.table.Table;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.util.Dbg;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DomainTable
implements Table {
    private EnvDomain _domain = null;
    private String _DS = null;
    private String _DB = null;
    private String _name = null;
    private String _owner = null;
    private int _status;
    private int _stat2;
    static final int SP_SETREPLICATE_BIT = 32768;
    static final int SP_OWNER_QUALIFIED_BIT = 4096;

    public DomainTable(String string, String string2, String string3, String string4, EnvDomain envDomain) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty data server parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty database name parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty owner name parameter.");
        Dbg.wassert(string4 != null && string4.length() > 0, "Null or empty table name parameter.");
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        this._DS = string;
        this._DB = string2;
        this._owner = string3;
        this._name = string4;
        this._domain = envDomain;
    }

    public EnvDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain;
    }

    @Override
    public String getDomainName() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain.getName();
    }

    @Override
    public boolean isControlledByRSMS() {
        return false;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getName() {
        Dbg.wassert(this._name != null && this._name.length() > 0, "Null or empty table name attribute.");
        return this._name;
    }

    @Override
    public String getDataServer() {
        Dbg.wassert(this._DS != null && this._DS.length() > 0, "Null or empty data server name attribute.");
        return this._DS;
    }

    @Override
    public String getDatabase() {
        Dbg.wassert(this._DB != null && this._DB.length() > 0, "Null or empty database name attribute.");
        return this._DB;
    }

    @Override
    public String getOwner() {
        Dbg.wassert(this._owner != null && this._owner.length() > 0, "Null or empty data server name attribute.");
        return this._owner;
    }

    public int getStatus() {
        return this._status;
    }

    public void setStatus(int n) {
        this._status = n;
    }

    public int getStat2() {
        return this._stat2;
    }

    public void setStat2(int n) {
        this._stat2 = n;
    }

    @Override
    public boolean getOwnerQualifiedStatus() {
        return (this._stat2 & 0x1000) == 4096;
    }

    @Override
    public boolean getReplicateStatus() {
        return (this._status & 0x8000) == 32768;
    }

    @Override
    public void alter(boolean bl) throws SQLException {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomain().getName());
        DataServer dataServer = semanticFactory.getDataServer(this.getDataServer());
        if (dataServer != null) {
            if (bl) {
                dataServer.markTable(this.getDatabase(), this.getOwner(), this.getName(), false);
            } else {
                dataServer.unmarkTable(this.getDatabase(), this.getOwner(), this.getName());
            }
        }
    }

    @Override
    public List getColumns() throws SQLException {
        List list = null;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomain().getName());
        DataServer dataServer = semanticFactory.getDataServer(this.getDataServer());
        list = dataServer != null ? dataServer.getColumns(this.getDatabase(), this.getOwner(), this.getName()) : new ArrayList();
        return list;
    }

    @Override
    public List getKeyColumns() throws SQLException {
        List list = null;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomain().getName());
        DataServer dataServer = semanticFactory.getDataServer(this.getDataServer());
        list = dataServer != null ? dataServer.getKeyColumns(this.getDatabase(), this.getOwner(), this.getName()) : new ArrayList();
        return list;
    }

    @Override
    public void loadTable() throws SQLException {
        DomainTable domainTable;
        Dbg.wassert(this._DS != null && this._DS.length() > 0, "Null or empty data server parameter.");
        Dbg.wassert(this._DB != null && this._DB.length() > 0, "Null or empty database parameter.");
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomain().getName());
        DataServer dataServer = semanticFactory.getDataServer(this.getDataServer());
        if (dataServer != null && (domainTable = dataServer.getTable(this.getDatabase(), this.getOwner(), this.getName())) != null) {
            this.setStatus(domainTable.getStatus());
            this.setStat2(domainTable.getStat2());
        }
    }

    public static List getTables(String string, String string2, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty data server parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(envDomain != null, "Null domain connection parameter.");
        ArrayList arrayList = null;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(envDomain.getName());
        DataServer dataServer = semanticFactory.getDataServer(string);
        arrayList = dataServer != null ? dataServer.getTables(string2) : new ArrayList();
        return arrayList;
    }
}

