/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.table;

import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.BaseProperties;
import com.sybase.rsmplugin.components.BasePropertyPage;
import com.sybase.rsmplugin.components.table.Column;
import com.sybase.rsmplugin.components.table.Table;
import com.sybase.rsmplugin.components.table.TablePropColumnPanel;
import com.sybase.rsmplugin.components.table.TablePropGeneralPanel;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class TableProp
extends BaseProperties {
    protected SCPageController[] _pages = null;
    protected Table _table = null;
    protected BaseItem _item = null;
    protected String _name;
    private boolean _enableRep = false;

    TableProp(Table table, BaseItem baseItem, SCDialogSupport2 sCDialogSupport2) {
        super(sCDialogSupport2);
        Dbg.wassert(table != null, "Null TableSO item parameter.");
        Dbg.wassert(baseItem != null, "Null BaseItem parameter.");
        this._item = baseItem;
        this._table = table;
    }

    BaseItem getTable() {
        Dbg.wassert(this._item != null, "Null Table attribute.");
        return this._item;
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("TableRes", "PROPERTIES_TITLE", this._table.getName());
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = new SCPageController[]{new GeneralPage(this), new ColumnPage(this)};
        }
        return this._pages;
    }

    @Override
    public BaseItem getItem() {
        return null;
    }

    @Override
    public void onApply() {
        if (this._pages[0].isModified()) {
            try {
                this._table.alter(this._enableRep);
                super.onApply();
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            this._item.refresh();
        }
    }

    @Override
    public boolean onOk() {
        if (this._pages[0].isModified()) {
            try {
                this._table.alter(this._enableRep);
                super.onApply();
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            this._item.refresh();
        }
        return super.onOk();
    }

    class ColumnPage
    extends BasePropertyPage {
        private TablePropColumnPanel _goPage;

        public ColumnPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("TableRes", "COLUMN_PAGE_TAG"));
            this._goPage = new TablePropColumnPanel();
        }

        @Override
        public void onInitDialog() {
            Object var1_1 = null;
            Object var2_2 = null;
            ImageIcon imageIcon = null;
            imageIcon = new ImageIcon(RSMImages.getTable());
            this._goPage.tbl_columns.requestFocus();
            this._goPage.tbl_columns.setColumnHasIconTextData(0, true);
            try {
                ListIterator listIterator = TableProp.this._table.getColumns().listIterator();
                while (listIterator.hasNext()) {
                    Column column = (Column)listIterator.next();
                    Vector<String> vector = new Vector<String>(2);
                    vector.add(column.getName());
                    vector.add(column.getFormattedDatatype());
                    imageIcon = column.isKey() ? new ImageIcon(RSMImages.getKey()) : new ImageIcon(RSMImages.getColumn());
                    this._goPage.tbl_columns.addRowWithIcon((Icon)imageIcon, vector);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public boolean onOk() {
            return true;
        }
    }

    class GeneralPage
    extends BasePropertyPage
    implements ActionListener {
        private TablePropGeneralPanel _goPage;

        public GeneralPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("TableRes", "GENERAL_PAGE_TAG"));
            this._goPage = new TablePropGeneralPanel();
        }

        @Override
        public void onInitDialog() {
            this._goPage.fld_tableName.setText(TableProp.this._table.getName());
            this._goPage.fld_owner.setText(TableProp.this._table.getOwner());
            String string = TableProp.this._table.getDataServer();
            String string2 = TableProp.this._table.getDatabase();
            this._goPage.fld_dsdb.setText(string + '.' + string2);
            this._goPage.chk_enableReplication.addActionListener((ActionListener)this);
            this._goPage.chk_enableReplication.requestFocus();
            if (TableProp.this._table.getReplicateStatus()) {
                this._goPage.chk_enableReplication.setSelected(true);
            } else {
                this._goPage.chk_enableReplication.setSelected(false);
            }
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public boolean onOk() {
            if (this.isModified()) {
                TableProp.this._enableRep = this._goPage.chk_enableReplication.isSelected();
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.chk_enableReplication) {
                this.setModified(true);
            }
        }
    }
}

