/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.tablerepdef;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.DataServer;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.table.Column;
import com.sybase.rsmplugin.components.tablerepdef.RepDefColumn;
import com.sybase.rsmplugin.components.tablerepdef.TableRepDef;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class DomainTableRepDef
implements TableRepDef {
    private EnvDomain _domain = null;
    private String _rs = null;
    private String _priTableName = null;
    private String _deliverAs = null;
    private String _repdefTableOwner = null;
    private String _tableRepDefName = null;
    private String _lds = null;
    private String _ldb = null;
    private String _physDS = null;
    private String _physDB = null;
    private String _tableOwner = null;
    private String _replicateTableOwner = null;
    private String _replicateTableName = null;
    private int _attributes = -1;
    private boolean _repMinCols = false;
    private String _minver = null;
    private String _standbyType = null;
    private boolean _repdefOwnerQual = false;
    private boolean _newTableOwnerQual = false;
    private boolean _repSQL = true;
    private List _columnList;
    private static final int REP_MIN_COLS = 4;
    private static final int REP_STANDBY = 128;
    private static final int REP_COLS_FOR_STANDBY = 256;
    private static final int REP_DYNAMIC_SQL = 0x800000;
    private static final int IDENTITY_COLUMN = 1;
    private static final int IDENTITY_COLUMN_PUBLISHED = 512;
    private static final int JAVA_COLUMN = 4096;
    private static final int JAVA_COLUMN_PUBLISHED = 8192;
    private static final int TIMESTAMP_COLUMN = 2;
    private static final int TIMESTAMP_COLUMN_PUBLISHED = 1024;
    private static final int REPLICATE_IF_CHANGED = 8;
    private static final int IMAGE_TEXT_NULLABLE = 16;
    private static final String GET_RS_TABLEREPDEFS = "GET_RS_TABLEREPDEFS";
    private static final String GET_DSDB_TABLEREPDEFS = "GET_DSDB_TABLEREPDEFS";
    private static final String GET_TABLEREPDEFS = "GET_TABLEREPDEFS";
    private static final String GET_REPDEF_BY_NAME = "GET_REPDEF_BY_NAME";
    private static final String CREATE_TABLEREPDEF = "CREATE_TABLEREPDEF";
    private static final String DROP_TABLEREPDEF = "DROP_TABLEREPDEF";
    private static final String LOAD_TABLEREPDEF = "LOAD_TABLEREPDEF";
    private static final String ALTER_REPDEF_REP_TABLE = "ALTER_REPDEF_REP_TABLE";
    private static final String ALTER_REPDEF_COLS = "ALTER_REPDEF_COLS";
    private static final String ALTER_REPDEF_ADD_COLS = "ALTER_REPDEF_ADD_COLS";
    private static final String ALTER_REPDEF_SEARCH_COLS = "ALTER_REPDEF_SEARCH_COLS";
    private static final String ALTER_REPDEF_MIN_COLS = "ALTER_REPDEF_MIN_COLS";
    private static final String ALTER_REPDEF_DYNAMIC_SQL = "ALTER_REPDEF_DYNAMIC_SQL";
    private static final String ALTER_REPDEF_SEND_STANDBY_OFF = "ALTER_REPDEF_SEND_STANDBY_OFF";
    private static final String ALTER_REPDEF_SEND_STANDBY_ALL = "ALTER_REPDEF_SEND_STANDBY_ALL";
    private static final String ALTER_REPDEF_SEND_STANDBY_REPDEF_COLS = "ALTER_REPDEF_SEND_STANDBY_REPDEF_COLS";
    private static final String ALTER_REPDEF_REP_IF_CHANGED = "ALTER_REPDEF_REP_IF_CHANGED";
    private static final String ALTER_REPDEF_ALWAYS_REP = "ALTER_REPDEF_ALWAYS_REP";
    private static final String ALTER_REPDEF_ADD_PRIMARY = "ALTER_REPDEF_ADD_PRIMARY";
    private static final String ALTER_REPDEF_DROP_PRIMARY = "ALTER_REPDEF_DROP_PRIMARY";
    private static final String ALTER_REPDEF_DROP_SEARCH_COLS = "ALTER_REPDEF_DROP_SEARCH_COLS";
    private static final String ALTER_REPDEF_ALTER_DATATYPE = "ALTER_REPDEF_ALTER_DATATYPE";
    private static final String ALTER_REPDEF_ALTER_MAPTO = "ALTER_REPDEF_ALTER_MAPTO";
    private static final String ALTER_REPDEF_NULLABLE = "ALTER_REPDEF_NULLABLE";
    private static final String ALTER_REPDEF_NOT_NULLABLE = "ALTER_REPDEF_NOT_NULLABLE";
    private static final String GET_COL_DATATYPES = "GET_COL_DATATYPES";
    private static final String GET_ALL_USER_DATATYPES = "GET_ALL_USER_DATATYPES";
    private static final String GET_USER_DATATYPES = "GET_USER_DATATYPES";
    private static final Object[][] contents = new Object[][]{{"GET_RS_TABLEREPDEFS", new Integer(1200), "rmp_table_source_projections ''{0}'', ''*'', ''*'', ''*'', ''*''"}, {"GET_DSDB_TABLEREPDEFS", new Integer(1200), "rmp_table_source_projections ''*'', ''{0}'', ''{1}'', ''*'', ''*''"}, {"GET_TABLEREPDEFS", new Integer(1200), "rmp_table_source_projections ''*'', ''{0}'', ''{1}'', ''*'', ''{2}''"}, {"GET_REPDEF_BY_NAME", new Integer(1200), "rmp_rep_def_by_name ''{0}''"}, {"ALTER_REPDEF_REP_TABLE", new Integer(1200), "alter replication definition {0}\nwith replicate table named {1}"}, {"ALTER_REPDEF_COLS", new Integer(1200), "alter replication definition {0}\nalter columns with {1} as {2}"}, {"ALTER_REPDEF_ADD_COLS", new Integer(1200), "alter replication definition {0}\nadd {1}"}, {"ALTER_REPDEF_SEARCH_COLS", new Integer(1200), "alter replication definition {0}\nadd searchable columns {1}"}, {"ALTER_REPDEF_DROP_SEARCH_COLS", new Integer(1200), "alter replication definition {0}\ndrop searchable columns {1}"}, {"ALTER_REPDEF_MIN_COLS", new Integer(1200), "alter replication definition {0}\nreplicate {1} columns"}, {"ALTER_REPDEF_DYNAMIC_SQL", new Integer(1200), "alter replication definition {0}\n{1} dynamic sql"}, {"ALTER_REPDEF_SEND_STANDBY_OFF", new Integer(1200), "alter replication definition {0}\nsend standby off"}, {"ALTER_REPDEF_SEND_STANDBY_ALL", new Integer(1200), "alter replication definition {0}\nsend standby all columns"}, {"ALTER_REPDEF_SEND_STANDBY_REPDEF_COLS", new Integer(1200), "alter replication definition {0}\nsend standby replication definition columns"}, {"ALTER_REPDEF_REP_IF_CHANGED", new Integer(1200), "alter replication definition {0}\nreplicate_if_changed {1}"}, {"ALTER_REPDEF_ALWAYS_REP", new Integer(1200), "alter replication definition {0}\nalways_replicate {1}"}, {"ALTER_REPDEF_ADD_PRIMARY", new Integer(1200), "alter replication definition {0}\nadd primary key {1}"}, {"ALTER_REPDEF_DROP_PRIMARY", new Integer(1200), "alter replication definition {0}\ndrop primary key {1}"}, {"ALTER_REPDEF_NULLABLE", new Integer(1200), "alter replication definition {0}\nalter columns with {1} {2} null"}, {"ALTER_REPDEF_NOT_NULLABLE", new Integer(1200), "alter replication definition {0}\nalter columns with {1} {2} not null"}, {"ALTER_REPDEF_ALTER_DATATYPE", new Integer(1200), "alter replication definition {0}\nalter columns with {1} {2}"}, {"ALTER_REPDEF_ALTER_MAPTO", new Integer(1200), "alter replication definition {0}\nalter columns with {1} {2} map to {3}"}, {"GET_COL_DATATYPES", new Integer(1200), "select name from rs_tvalues \nwhere type = 'DT' \norder by name asc"}, {"GET_ALL_USER_DATATYPES", new Integer(1200), "select dtname from rs_datatype \norder by dtname asc"}, {"GET_USER_DATATYPES", new Integer(1200), "select dtname from rs_datatype, rs_classes \nwhere rs_datatype.classid = rs_classes.classid \nand classname = ''{0}'' \norder by dtname asc"}, {"CREATE_TABLEREPDEF", new Integer(1200), "create replication definition {0} \nwith primary at {1}.{2} \n{3} \n{4} {5} \n{6} \n{7} \n{8} \n{9} \n{10} \n{11} \n{12}"}, {"DROP_TABLEREPDEF", new Integer(1200), "drop replication definition {0}"}, {"LOAD_TABLEREPDEF", new Integer(1200), "rmp_load_rep_def ''{0}'', ''{1}'', ''{2}'', ''{3}''"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public DomainTableRepDef(String string, String string2, String string3, String string4, String string5, String string6, EnvDomain envDomain) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty name parameter.");
        Dbg.wassert(string5 != null && string5.length() > 0, "Null or empty DS parameter.");
        Dbg.wassert(string6 != null && string6.length() > 0, "Null or empty DB parameter.");
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty Repserver parameter.");
        this._tableRepDefName = string;
        this._lds = string3;
        this._ldb = string4;
        this._physDS = string5;
        this._physDB = string6;
        this._domain = envDomain;
        this._rs = string2;
        this._columnList = new ArrayList();
    }

    @Override
    public Object clone() {
        DomainTableRepDef domainTableRepDef = null;
        try {
            domainTableRepDef = (DomainTableRepDef)super.clone();
            domainTableRepDef._columnList = new ArrayList();
            ListIterator listIterator = this._columnList.listIterator();
            while (listIterator.hasNext()) {
                RepDefColumn repDefColumn = (RepDefColumn)listIterator.next();
                domainTableRepDef._columnList.add(repDefColumn.clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Dbg.wassert(false, "Unexpected exception thrown.");
        }
        return domainTableRepDef;
    }

    public EnvDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain;
    }

    @Override
    public String getDomainName() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain.getName();
    }

    @Override
    public boolean isControlledByRSMS() {
        return false;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getDS() {
        Dbg.wassert(this._physDS != null && this._physDS.length() > 0, "Null or empty data server name attribute.");
        return this._physDS;
    }

    @Override
    public String getDB() {
        Dbg.wassert(this._physDB != null && this._physDB.length() > 0, "Null or empty database name attribute.");
        return this._physDB;
    }

    @Override
    public String getLDS() {
        return this._lds;
    }

    @Override
    public String getLDB() {
        return this._ldb;
    }

    @Override
    public boolean isLogical() {
        return this._lds != null;
    }

    @Override
    public String getRS() {
        Dbg.wassert(this._rs != null && this._rs.length() > 0, "Null or empty database name attribute.");
        return this._rs;
    }

    @Override
    public String getName() {
        Dbg.wassert(this._tableRepDefName != null && this._tableRepDefName.length() > 0, "Null or empty tableRepDef name attribute.");
        return this._tableRepDefName;
    }

    @Override
    public void setName(String string) {
        this._tableRepDefName = string;
    }

    @Override
    public String getPrimaryTableName() {
        return this._priTableName;
    }

    @Override
    public void setPrimaryTableName(String string) {
        this._priTableName = string;
    }

    @Override
    public String getPrimaryTableOwner() {
        return this._tableOwner;
    }

    @Override
    public void setPrimaryTableOwner(String string) {
        this._tableOwner = string;
    }

    @Override
    public String getDeliverAs() {
        return this._deliverAs;
    }

    private boolean getRepMinColsValue() {
        return (this._attributes & 4) == 4;
    }

    private boolean getRepSQLValue() {
        return (this._attributes & 0x800000) != 0x800000;
    }

    @Override
    public boolean getRepMinCols() {
        return this._repMinCols;
    }

    @Override
    public void setRepMinCols(boolean bl) {
        this._repMinCols = bl;
    }

    @Override
    public boolean getRepSQL() {
        return this._repSQL;
    }

    @Override
    public void setRepSQL(boolean bl) {
        this._repSQL = bl;
    }

    @Override
    public String getReplicateTableOwner() {
        return this._replicateTableOwner;
    }

    @Override
    public void setReplicateTableOwner(String string) {
        this._replicateTableOwner = string;
    }

    @Override
    public String getReplicateTableName() {
        return this._replicateTableName;
    }

    @Override
    public void setReplicateTableName(String string) {
        this._replicateTableName = string;
    }

    @Override
    public String getMinVer() {
        return this._minver;
    }

    @Override
    public boolean getRepDefOwnerQual() {
        return this._repdefOwnerQual;
    }

    @Override
    public void setNewTableOwnerQual(boolean bl) {
        this._newTableOwnerQual = bl;
    }

    @Override
    public boolean getNewTableOwnerQual() {
        return this._newTableOwnerQual;
    }

    @Override
    public void setRepDefOwnerQual(boolean bl) {
        this._repdefOwnerQual = bl;
    }

    public void setDeliverAs(String string) {
        this._deliverAs = string;
    }

    @Override
    public List getRepDefColumns() {
        return this._columnList;
    }

    public String getStandbyAttrType() {
        this._standbyType = (this._attributes & 0x80) == 128 ? ((this._attributes & 0x100) == 256 ? BundleManager.getString("TableRepDefRes", "PROP_STANDBY_COLUMNS") : BundleManager.getString("TableRepDefRes", "PROP_STANDBY_ALL")) : BundleManager.getString("TableRepDefRes", "PROP_STANDBY_DO_NOT_USE");
        return this._standbyType;
    }

    @Override
    public String getStandbyType() {
        return this._standbyType;
    }

    @Override
    public void setStandbyType(String string) {
        this._standbyType = string;
    }

    @Override
    public String getRepDefTableOwner() {
        return this._repdefTableOwner;
    }

    @Override
    public void setRepDefTableOwner(String string) {
        this._repdefTableOwner = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getRepDefDatatypes(String string) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.getDatatypes(string));
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        DataServer dataServer = semanticFactory.getDataServer(this.getDS());
        if (dataServer != null) {
            int n = this.getDomain().getVersionNumber(string);
            String string2 = _cmdBundle.getCommand(GET_USER_DATATYPES, n, dataServer.getUDDClass());
            Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty command string.");
            RSMConnection rSMConnection = this.getDomain().getRSSD(string);
            if (rSMConnection != null) {
                RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
                try {
                    rSMResultSet.open(string2);
                    while (rSMResultSet.getNextRow()) {
                        String string3 = rSMResultSet.getColumnString(1);
                        arrayList.add(string3);
                    }
                }
                finally {
                    rSMResultSet.close();
                    rSMConnection.unlock();
                }
            } else {
                throw new SQLException(BundleManager.getString("TableRepDefRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getColumnPropPublishDatatypes(String string) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        arrayList.addAll(this.getDatatypes(string));
        int n = this.getDomain().getVersionNumber(string);
        String string2 = _cmdBundle.getCommand(GET_ALL_USER_DATATYPES, n);
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty command string.");
        RSMConnection rSMConnection = this.getDomain().getRSSD(string);
        if (rSMConnection != null) {
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(1);
                    arrayList.add(string3);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("TableRepDefRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getDatatypes(String string) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.getDomain().getVersionNumber(string);
        String string2 = _cmdBundle.getCommand(GET_COL_DATATYPES, n);
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty command string.");
        RSMConnection rSMConnection = this.getDomain().getRSSD(string);
        if (rSMConnection != null) {
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(1);
                    if (string3.equalsIgnoreCase("longchar") || string3.equalsIgnoreCase("longbinary")) continue;
                    arrayList.add(string3);
                }
                arrayList.add("identity");
                arrayList.add("rawobject");
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("TableRepDefRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
        return arrayList;
    }

    @Override
    public String getControllingRS() {
        Dbg.wassert(this._rs != null && this._rs.length() > 0, "Null or empty RS name attribute.");
        return this._rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean emptyRepDefList() throws SQLException {
        Object object;
        boolean bl = true;
        int n = this.getDomain().getVersionNumber(this.getControllingRS());
        String string = null;
        if (this.isLogical()) {
            object = new String[]{this.getLDS(), this.getLDB(), this.getPrimaryTableName()};
            string = _cmdBundle.getCommand(GET_TABLEREPDEFS, n, (Object[])object);
        } else {
            object = new String[]{this.getDS(), this.getDB(), this.getPrimaryTableName()};
            string = _cmdBundle.getCommand(GET_TABLEREPDEFS, n, (Object[])object);
        }
        Dbg.wassert(string != null && string.length() > 0, "Null or empty command string.");
        object = this.getDomain().getRSSD(this.getControllingRS());
        if (object == null) throw new SQLException(BundleManager.getString("TableRepDefRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        RSMResultSet rSMResultSet = new RSMResultSet((RSMConnection)object);
        try {
            rSMResultSet.open(string);
            if (!rSMResultSet.getNextRow()) return bl;
            bl = false;
            return bl;
        }
        finally {
            rSMResultSet.close();
            ((RSMConnection)object).unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop() throws SQLException {
        boolean bl = false;
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{this.getName()};
            String string = _cmdBundle.getCommand(DROP_TABLEREPDEF, n, objectArray);
            Dbg.wassert(string != null, "Unable to get drop command, repserver version: " + n);
            try {
                rSMConnection.execute(string);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
        if (this.emptyRepDefList()) {
            this.unmarkTable();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getTableRepDefs(String string, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(envDomain != null, "Null domain connnection parameter.");
        int n = envDomain.getVersionNumber(string);
        String string2 = _cmdBundle.getCommand(GET_RS_TABLEREPDEFS, n, string);
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty command string.");
        ArrayList<DomainTableRepDef> arrayList = new ArrayList<DomainTableRepDef>();
        RSMConnection rSMConnection = envDomain.getRSSD(string);
        if (rSMConnection != null) {
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(2);
                    String string4 = rSMResultSet.getColumnString(4);
                    string4 = string4.trim();
                    String string5 = rSMResultSet.getColumnString(5);
                    String string6 = rSMResultSet.getColumnString(7);
                    String string7 = rSMResultSet.getColumnString(8);
                    String string8 = rSMResultSet.getColumnString(9);
                    if (string3 == null || string3.length() <= 0 || string5 == null || string5.length() <= 0 || string6 == null || string6.length() <= 0) continue;
                    DomainTableRepDef domainTableRepDef = new DomainTableRepDef(string3, string, string7, string8, string7, string8, envDomain);
                    domainTableRepDef.setPrimaryTableName(string5);
                    domainTableRepDef.setPrimaryTableOwner(string4);
                    domainTableRepDef.setRepDefTableOwner(string4);
                    domainTableRepDef.setDeliverAs(string6);
                    if (string4 != null && string4.length() > 0) {
                        domainTableRepDef.setRepDefOwnerQual(true);
                    }
                    arrayList.add(domainTableRepDef);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getTableRepDefs(String string, String string2, String string3, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty data server parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(envDomain != null, "Null domain connnection parameter.");
        int n = envDomain.getVersionNumber(string);
        Object[] objectArray = new String[]{string2, string3};
        String string4 = _cmdBundle.getCommand(GET_DSDB_TABLEREPDEFS, n, objectArray);
        Dbg.wassert(string4 != null && string4.length() > 0, "Null or empty command string.");
        ArrayList<DomainTableRepDef> arrayList = new ArrayList<DomainTableRepDef>();
        RSMConnection rSMConnection = envDomain.getRSSD(string);
        if (rSMConnection != null) {
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string4);
                while (rSMResultSet.getNextRow()) {
                    String string5 = rSMResultSet.getColumnString(2);
                    String string6 = rSMResultSet.getColumnString(4);
                    string6 = string6.trim();
                    String string7 = rSMResultSet.getColumnString(5);
                    String string8 = rSMResultSet.getColumnString(7);
                    if (string5 == null || string5.length() <= 0 || string7 == null || string7.length() <= 0 || string8 == null || string8.length() <= 0) continue;
                    DomainTableRepDef domainTableRepDef = new DomainTableRepDef(string5, string, string2, string3, string2, string3, envDomain);
                    domainTableRepDef.setPrimaryTableName(string7);
                    domainTableRepDef.setPrimaryTableOwner(string6);
                    domainTableRepDef.setRepDefTableOwner(string6);
                    domainTableRepDef.setDeliverAs(string8);
                    if (string6 != null && string6.length() > 0) {
                        domainTableRepDef.setRepDefOwnerQual(true);
                    }
                    arrayList.add(domainTableRepDef);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getTableRepDefs(String string, String string2, String string3, String string4, String string5, String string6, String string7, EnvDomain envDomain) throws SQLException {
        Object object;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(envDomain != null, "Null domain connnection parameter.");
        Dbg.wassert(string4 != null && string4.length() > 0, "Null or empty data server parameter.");
        Dbg.wassert(string5 != null && string5.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string6 != null && string6.length() > 0, "Null or empty table name parameter.");
        Dbg.wassert(string7 != null && string7.length() > 0, "Null or empty table name parameter.");
        int n = envDomain.getVersionNumber(string);
        String string8 = null;
        if (string2 == null || string3 == null) {
            object = new String[]{string4, string5, string6};
            string8 = _cmdBundle.getCommand(GET_TABLEREPDEFS, n, (Object[])object);
        } else {
            object = new String[]{string2, string3, string6};
            string8 = _cmdBundle.getCommand(GET_TABLEREPDEFS, n, (Object[])object);
        }
        Dbg.wassert(string8 != null && string8.length() > 0, "Null or empty command string.");
        object = new ArrayList();
        RSMConnection rSMConnection = envDomain.getRSSD(string);
        if (rSMConnection != null) {
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string8);
                while (rSMResultSet.getNextRow()) {
                    String string9 = rSMResultSet.getColumnString(2);
                    String string10 = rSMResultSet.getColumnString(4);
                    string10 = string10.trim();
                    String string11 = rSMResultSet.getColumnString(5);
                    String string12 = rSMResultSet.getColumnString(7);
                    if (string9 == null || string9.length() <= 0 || string11 == null || string11.length() <= 0 || string12 == null || string12.length() <= 0) continue;
                    DomainTableRepDef domainTableRepDef = new DomainTableRepDef(string9, string, string2, string3, string4, string5, envDomain);
                    domainTableRepDef.setPrimaryTableName(string11);
                    domainTableRepDef.setPrimaryTableOwner(string7);
                    domainTableRepDef.setRepDefTableOwner(string10);
                    domainTableRepDef.setDeliverAs(string12);
                    if (string10 != null && string10.length() > 0) {
                        domainTableRepDef.setRepDefOwnerQual(true);
                    }
                    ((ArrayList)object).add(domainTableRepDef);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableRepDef getTableRepDef(String string, String string2, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty repdef name parameter.");
        Dbg.wassert(envDomain != null, "Null domain connnection parameter.");
        int n = envDomain.getVersionNumber(string);
        String string3 = null;
        string3 = _cmdBundle.getCommand(GET_REPDEF_BY_NAME, n, string2);
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty command string.");
        DomainTableRepDef domainTableRepDef = null;
        RSMConnection rSMConnection = envDomain.getRSSD(string);
        if (rSMConnection != null) {
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string3);
                if (rSMResultSet.getNextRow()) {
                    String string4 = rSMResultSet.getColumnString(2);
                    string4 = string4.trim();
                    String string5 = rSMResultSet.getColumnString(3);
                    String string6 = rSMResultSet.getColumnString(4);
                    string6 = string6.trim();
                    String string7 = rSMResultSet.getColumnString(5);
                    String string8 = rSMResultSet.getColumnString(6);
                    String string9 = rSMResultSet.getColumnString(7);
                    String string10 = rSMResultSet.getColumnString(8);
                    String string11 = rSMResultSet.getColumnString(9);
                    String string12 = "";
                    String string13 = "";
                    if (string10 != null && string10.length() > 0) {
                        string12 = string8;
                        string13 = string9;
                        string8 = string10;
                        string9 = string11;
                    }
                    String string14 = rSMResultSet.getColumnString(10);
                    if (string5 != null && string5.length() > 0 && string7 != null && string7.length() > 0 && string8 != null && string8.length() > 0 && string9 != null && string9.length() > 0 && string14 != null && string14.length() > 0) {
                        domainTableRepDef = new DomainTableRepDef(string2, string14, string12, string13, string8, string9, envDomain);
                        domainTableRepDef.setPrimaryTableName(string5);
                        domainTableRepDef.setPrimaryTableOwner(string4);
                        domainTableRepDef.setRepDefTableOwner(string4);
                        domainTableRepDef.setDeliverAs(string7);
                        domainTableRepDef.setReplicateTableOwner(string6);
                        if (string4 != null && string4.length() > 0) {
                            domainTableRepDef.setRepDefOwnerQual(true);
                        }
                    }
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        return domainTableRepDef;
    }

    protected SQLException execRS(String string, String[] stringArray) throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            String string2 = _cmdBundle.getCommand(string, n, stringArray);
            Dbg.wassert(string2 != null, "Unable to get alter connection command, repserver version: " + n);
            try {
                rSMConnection.execute(string2);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == 31124) {
                    SQLException sQLException2 = sQLException;
                    return sQLException2;
                }
                throw sQLException;
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
        return null;
    }

    protected SQLException appendException(SQLException sQLException, SQLException sQLException2) {
        if (sQLException == null) {
            return sQLException2;
        }
        SQLException sQLException3 = sQLException;
        while (sQLException3.getNextException() != null) {
            sQLException3 = sQLException3.getNextException();
        }
        sQLException3.setNextException(sQLException2);
        return sQLException;
    }

    @Override
    public void create() throws SQLException {
        String string;
        String string2 = null;
        String string3 = this.getName();
        String string4 = null;
        String string5 = null;
        if (this.isLogical()) {
            string4 = this.getLDS();
            string5 = this.getLDB();
        } else {
            string4 = this.getDS();
            string5 = this.getDB();
        }
        String string6 = "with primary table named ";
        if (this.getNewTableOwnerQual()) {
            string2 = this.getPrimaryTableOwner();
            if (string2 != null && string2.length() > 0) {
                string6 = string6 + string2;
                string6 = string6 + ".";
                string6 = string6 + this.getPrimaryTableName();
            }
        } else {
            string6 = string6 + this.getPrimaryTableName();
        }
        String string7 = "with replicate table named ";
        string2 = this.getReplicateTableOwner();
        if (string2 != null && string2.length() > 0) {
            string7 = string7 + string2;
            string7 = string7 + ".";
            string7 = string7 + this.getReplicateTableName();
        } else {
            string7 = string7 + this.getReplicateTableName();
        }
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        List list = this.getRepDefColumns();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            string = "";
            boolean bl = false;
            RepDefColumn repDefColumn = (RepDefColumn)listIterator.next();
            if (!repDefColumn.isReplicated()) continue;
            string8 = string8.length() <= 0 ? string8 + "(" : string8 + ", ";
            string8 = string8 + repDefColumn.getColumnName();
            string = repDefColumn.getReplColName();
            if (string != null && string.length() > 0) {
                string8 = string8 + " as ";
                string8 = string8 + string;
            }
            string8 = string8 + " ";
            string8 = string8 + repDefColumn.getFormattedRepDefDatatype();
            string = repDefColumn.getFormattedPublishedDatatype();
            if (string != null && string.length() > 0) {
                string8 = string8 + " map to ";
                string8 = string8 + string;
            }
            if (Column.isTextImageDatatype(repDefColumn.getRepDefDatatype()) && repDefColumn.getIsNullable()) {
                string8 = string8 + " null";
            }
            if (repDefColumn.isPrimaryKey()) {
                if (string9.length() <= 0) {
                    string9 = string9 + "primary key (";
                    string9 = string9 + repDefColumn.getColumnName();
                } else {
                    string9 = string9 + ", ";
                    string9 = string9 + repDefColumn.getColumnName();
                }
            }
            if (repDefColumn.isSearchable()) {
                if (string10.length() <= 0) {
                    string10 = string10 + "searchable columns (";
                    string10 = string10 + repDefColumn.getColumnName();
                } else {
                    string10 = string10 + ", ";
                    string10 = string10 + repDefColumn.getColumnName();
                }
            }
            if (!Column.isTextImageDatatype(repDefColumn.getRepDefDatatype())) continue;
            if (repDefColumn.isRepIfChanged()) {
                if (string11.length() <= 0) {
                    string11 = string11 + "replicate_if_changed (";
                    string11 = string11 + repDefColumn.getColumnName();
                    continue;
                }
                string11 = string11 + ", ";
                string11 = string11 + repDefColumn.getColumnName();
                continue;
            }
            if (string12.length() <= 0) {
                string12 = string12 + "always_replicate (";
                string12 = string12 + repDefColumn.getColumnName();
                continue;
            }
            string12 = string12 + ", ";
            string12 = string12 + repDefColumn.getColumnName();
        }
        string = "send standby ";
        string2 = this.getStandbyType();
        string = string2.equals(BundleManager.getString("TableRepDefRes", "PROP_STANDBY_COLUMNS")) ? string + "replication definition columns" : (string2.equals(BundleManager.getString("TableRepDefRes", "PROP_STANDBY_ALL")) ? string + "all columns" : "");
        String string14 = "replicate ";
        string14 = !this.getRepMinCols() ? string14 + "all columns" : string14 + "minimal columns";
        int n = this.getDomain().getVersionNumber(this.getControllingRS());
        string13 = n >= 1510 ? (!this.getRepSQL() ? "without dynamic sql" : "with dynamic sql") : "";
        if (string8 != null && string8.length() > 0) {
            string8 = string8 + ")";
        }
        if (string9 != null && string9.length() > 0) {
            string9 = string9 + ")";
        }
        if (string10 != null && string10.length() > 0) {
            string10 = string10 + ")";
        }
        if (string11 != null && string11.length() > 0) {
            string11 = string11 + ")";
        }
        if (string12 != null && string12.length() > 0) {
            string12 = string12 + ")";
        }
        boolean bl = this.emptyRepDefList();
        this.markTable(bl);
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            int n2 = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{string3, string4, string5, string6, string7, string8, string9, string10, string, string14, string11, string12, string13};
            String string15 = _cmdBundle.getCommand(CREATE_TABLEREPDEF, n2, objectArray);
            Dbg.wassert(string15 != null, "Unable to get alter connection command, repserver version: " + n2);
            try {
                rSMConnection.execute(string15);
            }
            catch (SQLException sQLException) {
                if (bl) {
                    this.unmarkTable();
                }
                throw sQLException;
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            if (bl) {
                this.unmarkTable();
            }
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
        this.markLOBColumns();
    }

    protected void markTable(boolean bl) throws SQLException {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        DataServer dataServer = semanticFactory.getDataServer(this.getDS());
        if (dataServer != null) {
            if (bl) {
                if (dataServer.isTableMarked(this.getDB(), this.getPrimaryTableOwner(), this.getPrimaryTableName())) {
                    if (dataServer.isTableOwnerQualified(this.getDB(), this.getPrimaryTableOwner(), this.getPrimaryTableName()) != this.getNewTableOwnerQual()) {
                        dataServer.ownerQualifyTable(this.getDB(), this.getPrimaryTableOwner(), this.getPrimaryTableName(), true);
                        this.setRepDefOwnerQual(this.getNewTableOwnerQual());
                    }
                } else {
                    dataServer.markTable(this.getDB(), this.getPrimaryTableOwner(), this.getPrimaryTableName(), this.getNewTableOwnerQual());
                    this.setRepDefOwnerQual(this.getNewTableOwnerQual());
                }
            } else {
                if (dataServer.isTableOwnerQualified(this.getDB(), this.getPrimaryTableOwner(), this.getPrimaryTableName()) != this.getNewTableOwnerQual()) {
                    throw new SQLException(BundleManager.getString("TableRepDefRes", "BAD_OWNER_QUAL"), "_RSM_", 3);
                }
                this.setRepDefOwnerQual(this.getNewTableOwnerQual());
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getDS()), "_RSM_", 3);
        }
    }

    protected void unmarkTable() throws SQLException {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        DataServer dataServer = semanticFactory.getDataServer(this.getDS());
        if (dataServer == null) {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getDS()), "_RSM_", 3);
        }
        dataServer.unmarkTable(this.getDB(), this.getPrimaryTableOwner(), this.getPrimaryTableName());
    }

    protected void markLOBColumns() throws SQLException {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        DataServer dataServer = semanticFactory.getDataServer(this.getDS());
        if (dataServer != null) {
            List list = this.getRepDefColumns();
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                RepDefColumn repDefColumn = (RepDefColumn)listIterator.next();
                if (!Column.isTextImageDatatype(repDefColumn.getRepDefDatatype())) continue;
                if (repDefColumn.isReplicated()) {
                    dataServer.markLOBColumn(this.getDB(), this.getPrimaryTableOwner(), this.getPrimaryTableName(), repDefColumn.getColumnName(), !repDefColumn.isRepIfChanged());
                    continue;
                }
                dataServer.unmarkLOBColumn(this.getDB(), this.getPrimaryTableOwner(), this.getPrimaryTableName(), repDefColumn.getColumnName());
            }
        }
    }

    @Override
    public void alter(TableRepDef tableRepDef) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String[] stringArray;
        int n;
        SQLException sQLException;
        SQLException sQLException2 = null;
        if (tableRepDef.getRepMinCols() != this.getRepMinCols()) {
            String[] stringArray2;
            if (this.getRepMinCols()) {
                stringArray2 = new String[]{this.getName(), "minimal"};
                sQLException = this.execRS(ALTER_REPDEF_MIN_COLS, stringArray2);
            } else {
                stringArray2 = new String[]{this.getName(), "all"};
                sQLException = this.execRS(ALTER_REPDEF_MIN_COLS, stringArray2);
            }
            if (sQLException != null) {
                sQLException2 = this.appendException(sQLException2, sQLException);
            } else {
                this.setRepMinCols(this.getRepMinCols());
            }
        }
        if ((n = this.getDomain().getVersionNumber(this.getControllingRS())) >= 1510 && tableRepDef.getRepSQL() != this.getRepSQL()) {
            if (this.getRepSQL()) {
                stringArray = new String[]{this.getName(), "with"};
                sQLException = this.execRS(ALTER_REPDEF_DYNAMIC_SQL, stringArray);
            } else {
                stringArray = new String[]{this.getName(), "without"};
                sQLException = this.execRS(ALTER_REPDEF_DYNAMIC_SQL, stringArray);
            }
            if (sQLException != null) {
                sQLException2 = this.appendException(sQLException2, sQLException);
            } else {
                this.setRepSQL(this.getRepSQL());
            }
        }
        stringArray = tableRepDef.getRepDefColumns();
        List list = this.getRepDefColumns();
        RepDefColumn repDefColumn = null;
        boolean bl = false;
        ListIterator listIterator = stringArray.listIterator();
        while (listIterator.hasNext()) {
            Object object6;
            object5 = (RepDefColumn)listIterator.next();
            if (object5 == null) continue;
            String string = ((RepDefColumn)object5).getColumnName();
            object4 = list.listIterator();
            while (object4.hasNext()) {
                repDefColumn = (RepDefColumn)object4.next();
                String string2 = repDefColumn.getColumnName();
                if (!string2.equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            object3 = null;
            if (((RepDefColumn)object5).isReplicated() != repDefColumn.isReplicated()) {
                if (repDefColumn.isReplicated()) {
                    object3 = repDefColumn.getColumnName();
                    object2 = repDefColumn.getReplColName();
                    if (object2 != null && ((String)object2).length() > 0) {
                        object3 = (String)object3 + " as ";
                        object3 = (String)object3 + (String)object2;
                    }
                    if ((object = repDefColumn.getFormattedRepDefDatatype()) != null && ((String)object).length() > 0) {
                        object3 = (String)object3 + " ";
                        object3 = (String)object3 + (String)object;
                        if (Column.isTextImageDatatype(repDefColumn.getRepDefDatatype())) {
                            object3 = repDefColumn.getIsNullable() ? (String)object3 + " null" : (String)object3 + " not null";
                        }
                    }
                    if ((object6 = repDefColumn.getFormattedPublishedDatatype()) != null && ((String)object6).length() > 0) {
                        object3 = (String)object3 + " map to ";
                        object3 = (String)object3 + (String)object6;
                    }
                }
                if ((sQLException = this.execRS(ALTER_REPDEF_ADD_COLS, (String[])(object2 = new String[]{this.getName(), object3}))) != null) {
                    sQLException2 = this.appendException(sQLException2, sQLException);
                } else {
                    ((RepDefColumn)object5).setReplicated(repDefColumn.isReplicated());
                }
            }
            if (!((RepDefColumn)object5).isReplicated()) continue;
            if (!((RepDefColumn)object5).getReplColName().equalsIgnoreCase(repDefColumn.getReplColName())) {
                object2 = new String[]{this.getName(), repDefColumn.getColumnName(), repDefColumn.getReplColName()};
                sQLException = this.execRS(ALTER_REPDEF_COLS, (String[])object2);
                if (sQLException != null) {
                    sQLException2 = this.appendException(sQLException2, sQLException);
                } else {
                    ((RepDefColumn)object5).setReplColName(repDefColumn.getReplColName());
                }
            }
            if (!((RepDefColumn)object5).getRepDefDatatype().equalsIgnoreCase(repDefColumn.getRepDefDatatype()) || ((RepDefColumn)object5).getRepDefLength() != repDefColumn.getRepDefLength()) {
                object2 = repDefColumn.getFormattedRepDefDatatype();
                object = new String[]{this.getName(), repDefColumn.getColumnName(), object2};
                sQLException = this.execRS(ALTER_REPDEF_ALTER_DATATYPE, (String[])object);
                if (sQLException != null) {
                    sQLException2 = this.appendException(sQLException2, sQLException);
                } else {
                    ((RepDefColumn)object5).setRepDefDatatype(repDefColumn.getRepDefDatatype());
                    ((RepDefColumn)object5).setRepDefLength(repDefColumn.getRepDefLength());
                }
            }
            if (!((RepDefColumn)object5).getPublishedDatatype().equalsIgnoreCase(repDefColumn.getPublishedDatatype()) || ((RepDefColumn)object5).getPublishedLength() != repDefColumn.getPublishedLength()) {
                object2 = repDefColumn.getFormattedRepDefDatatype();
                object = repDefColumn.getFormattedPublishedDatatype();
                if (((String)object).equalsIgnoreCase("")) {
                    object6 = new String[]{this.getName(), repDefColumn.getColumnName(), object2};
                    sQLException = this.execRS(ALTER_REPDEF_ALTER_DATATYPE, (String[])object6);
                    if (sQLException != null) {
                        sQLException2 = this.appendException(sQLException2, sQLException);
                    } else {
                        ((RepDefColumn)object5).setPublishedDatatype(repDefColumn.getPublishedDatatype());
                        ((RepDefColumn)object5).setPublishedLength(repDefColumn.getPublishedLength());
                    }
                } else {
                    object6 = new String[]{this.getName(), repDefColumn.getColumnName(), object2, object};
                    sQLException = this.execRS(ALTER_REPDEF_ALTER_MAPTO, (String[])object6);
                    if (sQLException != null) {
                        sQLException2 = this.appendException(sQLException2, sQLException);
                    } else {
                        ((RepDefColumn)object5).setPublishedDatatype(repDefColumn.getPublishedDatatype());
                        ((RepDefColumn)object5).setPublishedLength(repDefColumn.getPublishedLength());
                    }
                }
            }
            if (((RepDefColumn)object5).getInRow() != repDefColumn.getInRow()) {
                ((RepDefColumn)object5).setInRow(repDefColumn.getInRow());
            }
            if (((RepDefColumn)object5).getIsNullable() != repDefColumn.getIsNullable()) {
                object2 = new String[]{this.getName(), repDefColumn.getColumnName(), repDefColumn.getRepDefDatatype()};
                sQLException = repDefColumn.getIsNullable() ? this.execRS(ALTER_REPDEF_NULLABLE, (String[])object2) : this.execRS(ALTER_REPDEF_NOT_NULLABLE, (String[])object2);
                if (sQLException != null) {
                    sQLException2 = this.appendException(sQLException2, sQLException);
                } else {
                    ((RepDefColumn)object5).setIsNullable(repDefColumn.getIsNullable());
                }
            }
            if (((RepDefColumn)object5).isPrimaryKey() != repDefColumn.isPrimaryKey()) {
                object2 = new String[]{this.getName(), repDefColumn.getColumnName()};
                sQLException = repDefColumn.isPrimaryKey() ? this.execRS(ALTER_REPDEF_ADD_PRIMARY, (String[])object2) : this.execRS(ALTER_REPDEF_DROP_PRIMARY, (String[])object2);
                if (sQLException != null) {
                    sQLException2 = this.appendException(sQLException2, sQLException);
                } else {
                    ((RepDefColumn)object5).setPrimaryKey(repDefColumn.isPrimaryKey());
                }
            }
            if (((RepDefColumn)object5).isSearchable() != repDefColumn.isSearchable()) {
                object2 = new String[]{this.getName(), repDefColumn.getColumnName()};
                sQLException = repDefColumn.isSearchable() ? this.execRS(ALTER_REPDEF_SEARCH_COLS, (String[])object2) : this.execRS(ALTER_REPDEF_DROP_SEARCH_COLS, (String[])object2);
                if (sQLException != null) {
                    sQLException2 = this.appendException(sQLException2, sQLException);
                } else {
                    ((RepDefColumn)object5).setSearchable(repDefColumn.isSearchable());
                }
            }
            if (((RepDefColumn)object5).isRepIfChanged() == repDefColumn.isRepIfChanged()) continue;
            object2 = new String[]{this.getName(), repDefColumn.getColumnName()};
            sQLException = repDefColumn.isRepIfChanged() ? this.execRS(ALTER_REPDEF_REP_IF_CHANGED, (String[])object2) : this.execRS(ALTER_REPDEF_ALWAYS_REP, (String[])object2);
            if (sQLException != null) {
                sQLException2 = this.appendException(sQLException2, sQLException);
                continue;
            }
            ((RepDefColumn)object5).setRepIfChanged(repDefColumn.isRepIfChanged());
            object = PluginSupport.getSemanticFactory(this.getDomainName());
            object6 = object.getDataServer(this.getDS());
            if (object6 == null) continue;
            object6.markLOBColumn(this.getDB(), this.getPrimaryTableOwner(), this.getPrimaryTableName(), repDefColumn.getColumnName(), !repDefColumn.isRepIfChanged());
        }
        object5 = null;
        object4 = null;
        object3 = null;
        if (!tableRepDef.getReplicateTableOwner().equals(this.getReplicateTableOwner())) {
            object5 = this.getReplicateTableOwner();
        }
        if (!tableRepDef.getReplicateTableName().equals(this.getReplicateTableName())) {
            object4 = this.getReplicateTableName();
        }
        if (object4 != null && ((String)object4).length() > 0) {
            if (object5 != null && ((String)object5).length() > 0) {
                object3 = object5;
                object3 = (String)object3 + ".";
                object3 = (String)object3 + (String)object4;
            } else if (object5 != null && ((String)object5).length() == 0) {
                object3 = object4;
            } else if (object5 == null) {
                object5 = tableRepDef.getReplicateTableOwner();
                if (object5 != null && ((String)object5).length() > 0) {
                    object3 = object5;
                    object3 = (String)object3 + ".";
                    object3 = (String)object3 + (String)object4;
                } else {
                    object3 = object4;
                }
            }
        } else if (object4 != null && ((String)object4).length() == 0) {
            object3 = object4;
        } else if (object4 == null) {
            object4 = tableRepDef.getReplicateTableName();
            if (object4 != null && ((String)object4).length() > 0) {
                if (object5 != null && ((String)object5).length() > 0) {
                    object3 = object5;
                    object3 = (String)object3 + ".";
                    object3 = (String)object3 + (String)object4;
                } else if (object5 != null && ((String)object5).length() == 0) {
                    object3 = object4;
                } else if (object5 == null) {
                    object3 = null;
                }
            } else {
                object3 = null;
            }
        }
        if (object3 != null && ((String)object3).length() >= 0) {
            object2 = new String[]{"", ""};
            if (((String)object3).length() == 0) {
                object2[0] = tableRepDef.getName();
                object2[1] = "\"\"";
            } else {
                object2[0] = tableRepDef.getName();
                object2[1] = object3;
            }
            sQLException = this.execRS(ALTER_REPDEF_REP_TABLE, (String[])object2);
            if (sQLException != null) {
                sQLException2 = this.appendException(sQLException2, sQLException);
            } else {
                this.setReplicateTableOwner(this.getReplicateTableOwner());
                this.setReplicateTableName(this.getReplicateTableName());
            }
        }
        if (!tableRepDef.getStandbyType().equals(this.getStandbyType())) {
            object2 = this.getStandbyType();
            if (((String)object2).equalsIgnoreCase(BundleManager.getString("TableRepDefRes", "PROP_STANDBY_DO_NOT_USE"))) {
                object = new String[]{tableRepDef.getName()};
                sQLException = this.execRS(ALTER_REPDEF_SEND_STANDBY_OFF, (String[])object);
            } else if (((String)object2).equalsIgnoreCase(BundleManager.getString("TableRepDefRes", "PROP_STANDBY_COLUMNS"))) {
                object = new String[]{tableRepDef.getName()};
                sQLException = this.execRS(ALTER_REPDEF_SEND_STANDBY_REPDEF_COLS, (String[])object);
            } else {
                object = new String[]{tableRepDef.getName()};
                sQLException = this.execRS(ALTER_REPDEF_SEND_STANDBY_ALL, (String[])object);
            }
            if (sQLException != null) {
                sQLException2 = this.appendException(sQLException2, sQLException);
            } else {
                this.setStandbyType(this.getStandbyType());
            }
        }
    }

    @Override
    public void loadNewTableRepDef() throws SQLException {
        this._columnList.clear();
        this._columnList = RepDefColumn.getNewColumns(this.getDS(), this.getDB(), this.getPrimaryTableOwner(), this.getPrimaryTableName(), this.getDomain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadTableRepDef() throws SQLException {
        block26: {
            Object object;
            boolean bl = true;
            this.loadNewTableRepDef();
            ListIterator listIterator = this._columnList.listIterator();
            while (listIterator.hasNext()) {
                RepDefColumn repDefColumn = (RepDefColumn)listIterator.next();
                repDefColumn.setReplicated(false);
                repDefColumn.setSearchable(false);
            }
            int n = this.getDomain().getVersionNumber(this.getControllingRS());
            String string = null;
            if (this.isLogical()) {
                object = new String[]{this.getPrimaryTableName(), this.getName(), this.getLDS(), this.getLDB()};
                string = _cmdBundle.getCommand(LOAD_TABLEREPDEF, n, (Object[])object);
            } else {
                object = new String[]{this.getPrimaryTableName(), this.getName(), this.getDS(), this.getDB()};
                string = _cmdBundle.getCommand(LOAD_TABLEREPDEF, n, (Object[])object);
            }
            Dbg.wassert(string != null && string.length() > 0, "Null or empty command string.");
            object = this.getDomain().getRSSD(this.getControllingRS());
            if (object != null) {
                RSMResultSet rSMResultSet = new RSMResultSet((RSMConnection)object);
                try {
                    rSMResultSet.open(string);
                    while (rSMResultSet.getNextRow()) {
                        bl = false;
                        this._minver = rSMResultSet.getColumnString(8);
                        this._replicateTableOwner = rSMResultSet.getColumnString(9);
                        this._replicateTableOwner = this._replicateTableOwner.trim();
                        this._replicateTableName = rSMResultSet.getColumnString(10);
                        this._replicateTableName = this._replicateTableName.trim();
                        this._attributes = rSMResultSet.getColumnInt(11);
                        this._repMinCols = this.getRepMinColsValue();
                        this._repSQL = this.getRepSQLValue();
                        this._standbyType = this.getStandbyAttrType();
                        int n2 = rSMResultSet.getColumnInt(15);
                        String string2 = rSMResultSet.getColumnString(16);
                        int n3 = rSMResultSet.getColumnInt(17);
                        boolean bl2 = n3 == 1;
                        int n4 = rSMResultSet.getColumnInt(18);
                        String string3 = rSMResultSet.getColumnString(19);
                        String string4 = rSMResultSet.getColumnString(1);
                        int n5 = rSMResultSet.getColumnInt(4);
                        boolean bl3 = n5 == 1;
                        int n6 = rSMResultSet.getColumnInt(5);
                        boolean bl4 = n6 == 1;
                        int n7 = rSMResultSet.getColumnInt(12);
                        int n8 = rSMResultSet.getColumnInt(13);
                        String string5 = rSMResultSet.getColumnString(14);
                        RepDefColumn repDefColumn = this.findRepDefColumn(string4);
                        if (repDefColumn == null) continue;
                        repDefColumn.setReplicated(bl4);
                        repDefColumn.setSearchable(bl3);
                        repDefColumn.setStatus(n2);
                        if (string2 != null && !string2.equals(repDefColumn.getColumnName())) {
                            repDefColumn.setReplColName(string2);
                        }
                        repDefColumn.setPrimaryKey(bl2);
                        repDefColumn.setRepDefDatatype(string5);
                        repDefColumn.setRepDefLength(n8);
                        repDefColumn.setPublishedDatatype(string3);
                        repDefColumn.setPublishedLength(n4);
                        if (string3.equalsIgnoreCase(string5) && n4 == n8) {
                            repDefColumn.setPublishedDatatype("");
                            repDefColumn.setPublishedLength(0);
                        } else {
                            repDefColumn.setPublishedDatatype(string3);
                            repDefColumn.setPublishedLength(n4);
                        }
                        repDefColumn.setIsNullable((n2 & 0x10) == 16);
                        repDefColumn.setRepIfChanged((n2 & 8) == 8);
                        if (string5.equalsIgnoreCase("varbinary")) {
                            if ((n2 & 0x1000) == 4096) {
                                repDefColumn.setRepDefDatatype("rawobject");
                                repDefColumn.setInRow(true);
                            } else if ((n2 & 0x2000) == 8192) {
                                repDefColumn.setPublishedDatatype("rawobject");
                            } else {
                                repDefColumn.setInRow(false);
                            }
                        }
                        if (string5.equalsIgnoreCase("varbinary")) {
                            if ((n2 & 2) == 2) {
                                repDefColumn.setRepDefDatatype("timestamp");
                            } else if ((n2 & 0x400) == 1024) {
                                repDefColumn.setPublishedDatatype("timestamp");
                            }
                        }
                        if (string5.equalsIgnoreCase("image")) {
                            if ((n2 & 0x1000) == 4096) {
                                repDefColumn.setRepDefDatatype("rawobject");
                                repDefColumn.setInRow(false);
                            } else if ((n2 & 0x2000) == 8192) {
                                repDefColumn.setPublishedDatatype("rawobject");
                            }
                        }
                        if (!string5.equalsIgnoreCase("numeric")) continue;
                        if ((n2 & 1) == 1) {
                            repDefColumn.setRepDefDatatype("identity");
                            continue;
                        }
                        if ((n2 & 0x200) != 512) continue;
                        repDefColumn.setPublishedDatatype("identity");
                    }
                    if (bl) {
                        throw new SQLException(BundleManager.getString("TableRepDefRes", "OBJECT_NOT_FOUND", this.getName()), "_RSM_", 10);
                    }
                    break block26;
                }
                finally {
                    rSMResultSet.close();
                    ((RSMConnection)object).unlock();
                }
            }
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
    }

    protected RepDefColumn findRepDefColumn(String string) {
        ListIterator listIterator = this._columnList.listIterator();
        while (listIterator.hasNext()) {
            RepDefColumn repDefColumn = (RepDefColumn)listIterator.next();
            if (!repDefColumn.getColumnName().equals(string)) continue;
            return repDefColumn;
        }
        return null;
    }

    @Override
    public String getRCLScript() {
        String string;
        String string2 = null;
        string2 = "-- Create Table Replication Definition " + this.getName() + "\n";
        string2 = string2 + "create replication definition " + this.getName() + "\n";
        string2 = this.isLogical() ? string2 + "\twith primary at " + this.getLDS() + "." + this.getLDB() + "\n" : string2 + "\twith primary at " + this.getDS() + "." + this.getDB() + "\n";
        string2 = string2 + "\twith primary table named ";
        string2 = this.getNewTableOwnerQual() ? string2 + this.getPrimaryTableOwner() + "." + this.getPrimaryTableName() + "\n" : string2 + this.getPrimaryTableName() + "\n";
        string2 = string2 + " \twith replicate table named ";
        String string3 = null;
        string3 = this.getReplicateTableOwner();
        string2 = string3 != null && string3.length() > 0 ? string2 + string3 + "." + this.getReplicateTableName() + "\n" : string2 + this.getReplicateTableName() + "\n";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        List list = this.getRepDefColumns();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            string = "";
            boolean bl = false;
            RepDefColumn repDefColumn = (RepDefColumn)listIterator.next();
            if (!repDefColumn.isReplicated()) continue;
            string4 = string4.length() <= 0 ? string4 + "\t(" : string4 + ", ";
            string4 = string4 + repDefColumn.getColumnName();
            string = repDefColumn.getReplColName();
            if (string != null && string.length() > 0) {
                string4 = string4 + " as ";
                string4 = string4 + string;
            }
            string4 = string4 + " ";
            string4 = string4 + repDefColumn.getFormattedRepDefDatatype();
            string = repDefColumn.getFormattedPublishedDatatype();
            if (string != null && string.length() > 0) {
                string4 = string4 + " map to ";
                string4 = string4 + string;
            }
            if (Column.isTextImageDatatype(repDefColumn.getRepDefDatatype()) && repDefColumn.getIsNullable()) {
                string4 = string4 + " null";
            }
            if (repDefColumn.isPrimaryKey()) {
                if (string5.length() <= 0) {
                    string5 = string5 + "\tprimary key (";
                    string5 = string5 + repDefColumn.getColumnName();
                } else {
                    string5 = string5 + ", ";
                    string5 = string5 + repDefColumn.getColumnName();
                }
            }
            if (repDefColumn.isSearchable()) {
                if (string6.length() <= 0) {
                    string6 = string6 + "\tsearchable columns (";
                    string6 = string6 + repDefColumn.getColumnName();
                } else {
                    string6 = string6 + ", ";
                    string6 = string6 + repDefColumn.getColumnName();
                }
            }
            if (!Column.isTextImageDatatype(repDefColumn.getRepDefDatatype())) continue;
            if (repDefColumn.isRepIfChanged()) {
                if (string7.length() <= 0) {
                    string7 = string7 + "\treplicate_if_changed (";
                    string7 = string7 + repDefColumn.getColumnName();
                    continue;
                }
                string7 = string7 + ", ";
                string7 = string7 + repDefColumn.getColumnName();
                continue;
            }
            if (string8.length() <= 0) {
                string8 = string8 + "\talways_replicate (";
                string8 = string8 + repDefColumn.getColumnName();
                continue;
            }
            string8 = string8 + ", ";
            string8 = string8 + repDefColumn.getColumnName();
        }
        string = "\tsend standby ";
        string3 = this.getStandbyType();
        string = string3.equals(BundleManager.getString("TableRepDefRes", "PROP_STANDBY_COLUMNS")) ? string + "replication definition columns\n" : (string3.equals(BundleManager.getString("TableRepDefRes", "PROP_STANDBY_ALL")) ? string + "all columns\n" : "");
        String string9 = "\treplicate ";
        string9 = !this.getRepMinCols() ? string9 + "all columns\n" : string9 + "minimal columns\n";
        if (string4 != null && string4.length() > 0) {
            string4 = string4 + ")\n";
        }
        if (string5 != null && string5.length() > 0) {
            string5 = string5 + ")\n";
        }
        if (string6 != null && string6.length() > 0) {
            string6 = string6 + ")\n";
        }
        if (string7 != null && string7.length() > 0) {
            string7 = string7 + ")\n";
        }
        if (string8 != null && string8.length() > 0) {
            string8 = string8 + ")\n";
        }
        string2 = string2 + string4;
        string2 = string2 + string5;
        string2 = string2 + string6;
        string2 = string2 + string;
        string2 = string2 + string9;
        string2 = string2 + string7;
        string2 = string2 + string8;
        int n = this.getDomain().getVersionNumber(this.getControllingRS());
        if (n >= 1510) {
            String string10 = "";
            string10 = !this.getRepSQL() ? string10 + "\twithout dynamic sql\n" : string10 + "\twith dynamic sql\n";
            string2 = string2 + string10;
        }
        return string2;
    }
}

