/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.tablerepdef;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.DataServer;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.table.Column;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.RSMObjectRow;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class RepDefColumn
implements RSMObjectRow,
Cloneable {
    private String _tableName;
    private String _tableOwner;
    private boolean _isReplicated;
    private boolean _isSearchable;
    private boolean _primaryKey = false;
    private String _replColName = "";
    private Column _column = null;
    private String _repdefDatatype = "";
    private int _repdefLength = 0;
    private String _publishedDatatype = "";
    private int _publishedLength = 0;
    private boolean _isInRow = false;
    private boolean _isNullable = false;
    private boolean _imageRepIfChanged = false;
    private int _status = 0;
    protected boolean _isModified = false;
    private EnvDomain _domain = null;
    private static final int COLUMN_COUNT = 4;

    public RepDefColumn(String string, String string2, Column column, EnvDomain envDomain) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty table owner parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty table name parameter.");
        Dbg.wassert(column != null, "Null column object parameter.");
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        this._tableName = string2;
        this._tableOwner = string;
        this._column = column;
        this._domain = envDomain;
    }

    public Object clone() {
        RepDefColumn repDefColumn = null;
        try {
            repDefColumn = (RepDefColumn)super.clone();
            repDefColumn._column = (Column)this._column.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Dbg.wassert(false, "Unexpected exception thrown.");
        }
        return repDefColumn;
    }

    public EnvDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain;
    }

    public static List getNewColumns(String string, String string2, String string3, String string4, EnvDomain envDomain) throws SQLException {
        ArrayList<RepDefColumn> arrayList = new ArrayList<RepDefColumn>();
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(envDomain.getName());
        DataServer dataServer = semanticFactory.getDataServer(string);
        if (dataServer != null) {
            ListIterator listIterator = dataServer.getColumns(string2, string3, string4).listIterator();
            while (listIterator.hasNext()) {
                Column column = (Column)listIterator.next();
                RepDefColumn repDefColumn = new RepDefColumn(string3, string4, column, envDomain);
                repDefColumn.setReplicated(true);
                repDefColumn.setPrimaryKey(column.isKey());
                repDefColumn.setSearchable(column.isKey());
                repDefColumn.setRepDefDatatype(column.getDatatype());
                repDefColumn.setRepDefLength(column.getLength());
                repDefColumn.setRepIfChanged(column.isMarkedReplicateIfChanged());
                arrayList.add(repDefColumn);
            }
        }
        return arrayList;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int n) {
        switch (n) {
            case 0: {
                return this.getColumnName();
            }
            case 1: {
                return this.getIsReplicatedValue();
            }
            case 2: {
                return this.getIsSearchableValue();
            }
            case 3: {
                return this.getFormattedRepDefDatatype();
            }
        }
        return " ";
    }

    @Override
    public void setValueAt(Object object, int n) {
    }

    public String getTableName() {
        return this._tableName;
    }

    public String getTableOwner() {
        return this._tableOwner;
    }

    public boolean isReplicated() {
        return this._isReplicated;
    }

    protected String getIsReplicatedValue() {
        if (this.isReplicated()) {
            return BundleManager.getString("ComponentRes", "DISP_YES_TEXT");
        }
        return BundleManager.getString("ComponentRes", "DISP_NO_TEXT");
    }

    public void setReplicated(boolean bl) {
        this._isReplicated = bl;
    }

    public boolean isSearchable() {
        return this._isSearchable;
    }

    protected String getIsSearchableValue() {
        if (this.isSearchable()) {
            return BundleManager.getString("ComponentRes", "DISP_YES_TEXT");
        }
        return BundleManager.getString("ComponentRes", "DISP_NO_TEXT");
    }

    public void setSearchable(boolean bl) {
        this._isSearchable = bl;
    }

    public boolean isPrimaryKey() {
        return this._primaryKey;
    }

    public void setPrimaryKey(boolean bl) {
        this._primaryKey = bl;
    }

    public String getReplColName() {
        return this._replColName;
    }

    public void setReplColName(String string) {
        this._replColName = string;
    }

    public String getColumnName() {
        return this._column.getName();
    }

    public String getColumnDatatype() {
        return this._column.getDatatype();
    }

    public int getColumnLength() {
        return this._column.getLength();
    }

    public int getColDatatypeID() {
        return this._column.getDatatypeID();
    }

    public int getColumnID() {
        return this._column.getColumnID();
    }

    public String getFormattedColumnDatatype() {
        return this._column.getFormattedDatatype();
    }

    public String getRepDefDatatype() {
        return this._repdefDatatype;
    }

    public void setRepDefDatatype(String string) {
        this._repdefDatatype = string;
    }

    public int getRepDefLength() {
        return this._repdefLength;
    }

    public void setRepDefLength(int n) {
        this._repdefLength = n;
    }

    public String getFormattedRepDefDatatype() {
        return Column.isVariableLengthDatatype(this.getRepDefDatatype()) ? this.getRepDefDatatype() + "(" + String.valueOf(this.getRepDefLength()) + ")" : this.getRepDefDatatype();
    }

    public String getPublishedDatatype() {
        return this._publishedDatatype;
    }

    public void setPublishedDatatype(String string) {
        this._publishedDatatype = string;
    }

    public int getPublishedLength() {
        return this._publishedLength;
    }

    public void setPublishedLength(int n) {
        this._publishedLength = n;
    }

    public String getFormattedPublishedDatatype() {
        return Column.isVariableLengthDatatype(this.getPublishedDatatype()) ? this.getPublishedDatatype() + "(" + this.getPublishedLength() + ")" : this.getPublishedDatatype();
    }

    public void setInRow(boolean bl) {
        this._isInRow = bl;
    }

    public boolean getInRow() {
        return this._isInRow;
    }

    public void setIsNullable(boolean bl) {
        this._isNullable = bl;
    }

    public boolean getIsNullable() {
        return this._isNullable;
    }

    public boolean isRepIfChanged() {
        return this._imageRepIfChanged;
    }

    public void setRepIfChanged(boolean bl) {
        this._imageRepIfChanged = bl;
    }

    public int getStatus() {
        return this._status;
    }

    public void setStatus(int n) {
        this._status = n;
    }

    public String getExtendedType() {
        return "";
    }
}

