/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.tablerepdef;

import com.sybase.central.DefaultSCMenu;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.DeleteItemsDlg;
import com.sybase.rsmplugin.components.MenuItem;
import com.sybase.rsmplugin.components.tablerepdef.TableRepDef;
import com.sybase.rsmplugin.components.tablerepdef.TableRepDefProp;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import com.sybase.rsmplugin.util.RCLEditor;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public abstract class TableRepDefBase
extends BaseContainer {
    private static final int CMD_ADD_FUNCTION_STRING_CLASS = 3008;
    private static final int CMD_SUBSCRIBE_TO = 3009;
    private TableRepDef _so;
    private String _rs;
    private static ImageIcon _icon = null;
    private static DefaultSCMenu _contextMenu = null;

    public TableRepDefBase(TableRepDef tableRepDef, BaseContainer baseContainer, String string) {
        super(baseContainer);
        Dbg.wassert(tableRepDef != null, "Null physical connection semantic object parameter.");
        this._so = tableRepDef;
        this._rs = string;
    }

    public TableRepDefBase(TableRepDef tableRepDef, BaseContainer baseContainer) {
        super(baseContainer);
        Dbg.wassert(tableRepDef != null, "Null physical connection semantic object parameter.");
        this._so = tableRepDef;
        this._rs = null;
    }

    public TableRepDef getTableRepDef() {
        return this._so;
    }

    public String getControllingRS() {
        return this._rs;
    }

    @Override
    public String getName() {
        return this._so.getName();
    }

    public String getObjectName() {
        return this._so.getPrimaryTableName();
    }

    public String getDeliverAs() {
        return this._so.getDeliverAs();
    }

    @Override
    public Icon getImage(boolean bl) {
        if (_icon == null) {
            _icon = new ImageIcon(RSMImages.getTableRepDef());
        }
        return _icon;
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        return 108;
    }

    @Override
    public String getDisplayName(int n) {
        switch (n) {
            case 0: {
                return this.getName();
            }
            case 1: {
                String string = this._so.getRepDefTableOwner();
                if (string != null && string.length() > 0) {
                    string = string + ".";
                    string = string + this._so.getPrimaryTableName();
                } else {
                    string = this._so.getPrimaryTableName();
                }
                return string;
            }
            case 2: {
                return this._so.getDeliverAs();
            }
        }
        return "";
    }

    @Override
    public boolean isOkToBatch(int n) {
        return n == 106;
    }

    @Override
    public SCMenu getContextMenu() {
        _contextMenu = new DefaultSCMenu();
        _contextMenu.addItem((SCMenuItem)MenuItem.getRCLGenMenuItem());
        _contextMenu.addItem((SCMenuItem)MenuItem.getDeleteMenuItem());
        _contextMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
        _contextMenu.addItem((SCMenuItem)MenuItem.getPropertiesMenuItem());
        return _contextMenu;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 3008: {
                break;
            }
            case 3009: {
                break;
            }
            case 3001: {
                try {
                    this._so.loadTableRepDef();
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
                RCLEditor.open(this._so.getRCLScript());
                break;
            }
            case 106: {
                List list = CollectionUtility.enumToList(enumeration);
                DeleteItemsDlg deleteItemsDlg = new DeleteItemsDlg(PluginSupport.getDialogSupport(jFrame), list);
                if (!deleteItemsDlg.showDialog()) break;
                PluginSupport.getViewerSupport().startWait();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    BaseItem baseItem = (BaseItem)listIterator.next();
                    if (!(baseItem instanceof TableRepDefBase)) continue;
                    ((TableRepDefBase)baseItem).drop();
                    listIterator.remove();
                }
                PluginSupport.refreshDomain(this);
                PluginSupport.getViewerSupport().endWait();
                break;
            }
            case 107: {
                BaseController baseController = PluginSupport.getDialog(TableRepDefProp.class, this.getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(jFrame);
                TableRepDefProp tableRepDefProp = new TableRepDefProp(this._so, this, sCDialogSupport2);
                tableRepDefProp.showDialog();
                break;
            }
        }
    }

    public void drop() {
        try {
            this._so.drop();
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
    }

    @Override
    protected String[] getHeadings() {
        return new String[]{BundleManager.getString("TableRepDefRes", "COL_HEADER_NAME")};
    }
}

