/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.eventlist;

import com.sybase.asa.ASAMultiList;
import com.sybase.central.SCProvider;
import com.sybase.central.viewer.SCImageLoader;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.ase.ASE;
import com.sybase.rsmplugin.components.ase.ASEContainer;
import com.sybase.rsmplugin.components.connection.ConnectionItem;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.components.directconnect.DirectConnect;
import com.sybase.rsmplugin.components.directconnect.DirectConnectContainer;
import com.sybase.rsmplugin.components.hds.HDS;
import com.sybase.rsmplugin.components.hds.HDSContainer;
import com.sybase.rsmplugin.components.lanrepagent.LANRepAgent;
import com.sybase.rsmplugin.components.lanrepagent.LANRepAgentContainer;
import com.sybase.rsmplugin.components.logical.LogConnection;
import com.sybase.rsmplugin.components.logical.LogConnectionItem;
import com.sybase.rsmplugin.components.mirrorrepagent.MirrorRepAgent;
import com.sybase.rsmplugin.components.mirrorrepagent.MirrorRepAgentContainer;
import com.sybase.rsmplugin.components.queue.QueueItem;
import com.sybase.rsmplugin.components.queue.RSQueue;
import com.sybase.rsmplugin.components.remoterms.RemoteRMS;
import com.sybase.rsmplugin.components.remoterms.RemoteRMSContainer;
import com.sybase.rsmplugin.components.repserver.RepServer;
import com.sybase.rsmplugin.components.repserver.RepServerContainer;
import com.sybase.rsmplugin.components.route.Route;
import com.sybase.rsmplugin.components.route.RouteItem;
import com.sybase.rsmplugin.status.StatusItem;
import com.sybase.rsmplugin.status.StatusSO;
import com.sybase.rsmplugin.util.DateCellRenderer;
import com.sybase.rsmplugin.util.Dbg;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;

public class EventList
implements MouseListener {
    private static final int MAX_LOG_ENTRIES = 500;
    private static final String COLUMN_WIDTH_PROFILE_KEY = "EventListWidth";
    private static final String VISIBLE_PROFILE_KEY = "EventListVisible";
    private ASAMultiList _tableList = null;
    Action _selectAllAction;
    Action _deleteAction;

    public synchronized void initialize() {
        Object object;
        boolean bl = PluginSupport.readProfileBoolean(VISIBLE_PROFILE_KEY, true);
        Object[] objectArray = new String[]{BundleManager.getString("EventListRes", "EVENT_COL_HDR_OBJECT"), BundleManager.getString("EventListRes", "EVENT_COL_HDR_TIME"), BundleManager.getString("EventListRes", "EVENT_COL_HDR_STATE"), BundleManager.getString("EventListRes", "EVENT_COL_HDR_SRC"), BundleManager.getString("EventListRes", "EVENT_COL_HDR_DESC")};
        this._tableList = new ASAMultiList(objectArray);
        int[] nArray = PluginSupport.readProfileIntArray(COLUMN_WIDTH_PROFILE_KEY);
        if (nArray != null && nArray.length == 5) {
            this._tableList.setColumnWidths(nArray);
        } else {
            object = new int[]{100, 100, 100, 100, 200};
            this._tableList.setColumnWidths(object);
            PluginSupport.writeProfileIntArray(COLUMN_WIDTH_PROFILE_KEY, object);
        }
        this._tableList.setColumnHasIconTextData(0, true);
        this._tableList.setSortedColumnNumber(1);
        PluginSupport.getViewerSupport().setBottomJComponent((JComponent)this._tableList.getScrollPane(), BundleManager.getString("EventListRes", "EVENT_MENU_ITEM"), BundleManager.getString("EventListRes", "EVENT_MENU_HINT"), (SCProvider)PluginSupport.getPlugin(), bl);
        this._tableList.addMouseListener((MouseListener)this);
        object = this._tableList.getInputMap(0);
        ActionMap actionMap = this._tableList.getActionMap();
        this._selectAllAction = new SelectAllAction();
        object.put((KeyStroke)this._selectAllAction.getValue("AcceleratorKey"), "selectAll");
        actionMap.put("selectAll", this._selectAllAction);
        this._deleteAction = new DeleteAction();
        object.put((KeyStroke)this._deleteAction.getValue("AcceleratorKey"), "delete");
        actionMap.put("delete", this._deleteAction);
        this._tableList.getColumnModel().getColumn(1).setCellRenderer(new DateCellRenderer());
    }

    public void releaseResources() {
        Dbg.wassert(this._tableList != null, "The event list initialize method has not been executed.");
        PluginSupport.writeProfileBoolean(VISIBLE_PROFILE_KEY, this.isVisible());
        int n = 0;
        int[] nArray = new int[this._tableList.getColumnCount()];
        Enumeration<TableColumn> enumeration = this._tableList.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            nArray[n++] = tableColumn.getPreferredWidth();
        }
        PluginSupport.writeProfileIntArray(COLUMN_WIDTH_PROFILE_KEY, nArray);
        this.clearAll();
        this._tableList.releaseResources();
    }

    public synchronized void add(Image image, String string, String string2, String string3, String string4) {
        Dbg.wassert(this._tableList != null, "The event list initialize method has not been executed.");
        Dbg.wassert(string != null && string.length() > 0, "Null or empty event object parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty event source parameter.");
        Date date = new Date();
        Dbg.trace(1024, string + ", " + date.toString() + ", " + string2 + ", " + string3 + ", " + string4);
        Vector<Object> vector = new Vector<Object>(5);
        vector.add(string);
        vector.add(date);
        vector.add(string2 == null ? "" : string2);
        vector.add(string3);
        vector.add(string4 == null ? "" : string4);
        ImageIcon imageIcon = null;
        imageIcon = image != null ? new ImageIcon(image) : new ImageIcon(RSMImages.getBlank());
        this.addRow(imageIcon, vector);
    }

    public synchronized void add(StatusSO statusSO) {
        Dbg.wassert(this._tableList != null, "The event list initialize method has not been executed.");
        Dbg.wassert(statusSO != null, "Null status semantic object parameter.");
        Vector<Object> vector = new Vector<Object>(5);
        Icon icon = null;
        String string = "";
        Date date = new Date();
        StatusItem statusItem = this.getStatusItem(statusSO);
        if (statusItem == null) {
            string = String.valueOf(statusSO.getRSState());
        } else {
            string = statusItem.getStateDescription() == null ? "" : statusItem.getStateDescription();
            icon = statusItem.getImage();
            statusItem.releaseResources();
        }
        Dbg.trace(1024, statusSO.getName() + ", " + date.toString() + ", " + string + ", " + statusSO.getDomainName() + ", " + statusSO.getReason());
        vector.add(statusSO.getName());
        vector.add(date);
        vector.add(string);
        vector.add(statusSO.getDomainName());
        vector.add(statusSO.getReason());
        if (icon == null) {
            icon = new ImageIcon(RSMImages.getBlank());
        }
        this.addRow(icon, vector);
    }

    public synchronized void clearAll() {
        Dbg.wassert(this._tableList != null, "The event list initialize method has not been executed.");
        this.dump();
        this._tableList.clear();
    }

    public boolean isVisible() {
        return PluginSupport.getViewerSupport().isBottomJComponentVisible((SCProvider)PluginSupport.getPlugin());
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            JPopupMenu jPopupMenu = this.getContextMenu();
            jPopupMenu.show((Component)this._tableList, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            JPopupMenu jPopupMenu = this.getContextMenu();
            jPopupMenu.show((Component)this._tableList, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        }
    }

    private StatusItem getStatusItem(StatusSO statusSO) {
        if (statusSO != null) {
            try {
                if (statusSO instanceof RepServer) {
                    return new RepServerContainer((RepServer)statusSO);
                }
                if (statusSO instanceof ASE) {
                    return new ASEContainer((ASE)statusSO);
                }
                if (statusSO instanceof LANRepAgent) {
                    return new LANRepAgentContainer((LANRepAgent)statusSO);
                }
                if (statusSO instanceof MirrorRepAgent) {
                    return new MirrorRepAgentContainer((MirrorRepAgent)statusSO);
                }
                if (statusSO instanceof DirectConnect) {
                    return new DirectConnectContainer((DirectConnect)statusSO);
                }
                if (statusSO instanceof RemoteRMS) {
                    return new RemoteRMSContainer((RemoteRMS)statusSO);
                }
                if (statusSO instanceof HDS) {
                    return new HDSContainer((HDS)statusSO);
                }
                if (statusSO instanceof PhyConnection) {
                    return new ConnectionItem((PhyConnection)statusSO);
                }
                if (statusSO instanceof LogConnection) {
                    return new LogConnectionItem((LogConnection)statusSO);
                }
                if (statusSO instanceof Route) {
                    return new RouteItem((Route)statusSO);
                }
                if (statusSO instanceof RSQueue) {
                    return new QueueItem((RSQueue)statusSO);
                }
                Dbg.trace(1024, "ERROR! Unable to get item for '" + statusSO.getName() + "' (Type: '" + statusSO.getType() + "')");
            }
            catch (ClassCastException classCastException) {
                Dbg.trace(1024, "CASTING ERROR! Unable to get item for '" + statusSO.getName() + "' (Type: '" + statusSO.getType() + "')");
            }
        }
        return null;
    }

    private JPopupMenu getContextMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(this._selectAllAction);
        jMenuItem.setAccelerator((KeyStroke)this._selectAllAction.getValue("AcceleratorKey"));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this._deleteAction);
        jMenuItem.setAccelerator((KeyStroke)this._deleteAction.getValue("AcceleratorKey"));
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    private void addRow(Icon icon, Vector vector) {
        while (this._tableList.getRowCount() >= 500) {
            this._tableList.removeRow(0);
        }
        this._tableList.addRowWithIcon(icon, vector);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n = EventList.this._tableList.getRowCount() - 1;
                Rectangle rectangle = EventList.this._tableList.getCellRect(n, 0, true);
                EventList.this._tableList.scrollRectToVisible(rectangle);
            }
        });
    }

    private synchronized void dump() {
        if (Dbg.isOn() && Dbg.isFlagOn(1024)) {
            int n = 0;
            if (this._tableList != null) {
                n = this._tableList.getRowCount();
            }
            Dbg.trace(1024, "Event List [" + String.valueOf(n) + "]:");
            for (int i = 0; i < n; ++i) {
                Vector vector = this._tableList.getRow(i);
                Dbg.trace(1024, vector.get(0) + ", " + vector.get(1) + ", " + vector.get(2) + ", " + vector.get(3) + ", " + vector.get(4));
            }
        }
    }

    public class FindAction
    extends AbstractAction {
        public FindAction() {
            this.putValue("Name", BundleManager.getString("EventListRes", "MENU_TEXT_FIND"));
            this.putValue("SmallIcon", new ImageIcon(RSMImages.getBlank()));
            this.putValue("MnemonicKey", new Integer(BundleManager.getMnemonic("EventListRes", "MENU_MNEM_FIND")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl F"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            this.putValue("Name", BundleManager.getString("ComponentRes", "MENU_TEXT_DELETE"));
            this.putValue("SmallIcon", SCImageLoader.getImageIcon((String)"delete", (int)1000));
            this.putValue("MnemonicKey", new Integer(BundleManager.getMnemonic("ComponentRes", "MENU_MNEM_DELETE")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = EventList.this._tableList.getSelectedRows();
            for (int i = nArray.length - 1; i >= 0; --i) {
                EventList.this._tableList.removeRow(nArray[i]);
            }
        }
    }

    public class SelectAllAction
    extends AbstractAction {
        public SelectAllAction() {
            this.putValue("Name", BundleManager.getString("EventListRes", "MENU_TEXT_SELECT_ALL"));
            this.putValue("SmallIcon", new ImageIcon(RSMImages.getBlank()));
            this.putValue("MnemonicKey", new Integer(BundleManager.getMnemonic("EventListRes", "MENU_MNEM_SELECT_ALL")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl A"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EventList.this._tableList.selectAll();
        }
    }
}

