/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.routeupgrade;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.bkgnd.BkgndSummaryThread;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.repserver.DomainRepServer;
import com.sybase.rsmplugin.components.repserver.RepServer;
import com.sybase.rsmplugin.components.route.DomainRoute;
import com.sybase.rsmplugin.routeupgrade.UpgradeRule;
import com.sybase.rsmplugin.routeupgrade.UpgradeScript;
import com.sybase.rsmplugin.sql.ASAConnection;
import com.sybase.rsmplugin.sql.ASEConnection;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.RSConnection;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;

public class RouteUpgrade {
    private DomainRoute _route;
    private int _serialNr;
    private List _scriptList;
    private static boolean _threadRunning = false;
    private static final String BEGIN_MARKER_TYPE = "begin";
    private static final String PASSTHRU_MARKER_TYPE = "passthru";
    private static final String COMMIT_MARKER_TYPE = "commit";
    private static final String MARKER = "MARKER";
    private static final String CHECK_MARKER = "CHECK_MARKER";
    private static final String GET_ROUTE_VERSIONS = "GET_ROUTE_VERSIONS";
    private static final String SET_ROUTE_STATUS = "SET_ROUTE_STATUS";
    private static final String SET_ROUTE_VERSION = "SET_ROUTE_VERSION";
    private static final String SET_ROUTE_IN_FLUX = "SET_ROUTE_IN_FLUX";
    private static final String IS_SERIAL_NR_SET = "IS_SERIAL_NR_SET";
    private static final String INSERT_SERIAL_NR = "INSERT_SERIAL_NR";
    private static final String INCREMENT_SERIAL_NR = "INCREMENT_SERIAL_NR";
    private static final String GET_SERIAL_NR = "GET_SERIAL_NR";
    private static final Object[][] contents = new Object[][]{{"MARKER", new Integer(1200), "exec rs_marker ''alter route to {0} set vers {1} {2}''"}, {"CHECK_MARKER", new Integer(1200), "select count(*) from rs_routeversions\n\twhere source_rsid = {0} and dest_rsid = {1} and marker_serial_no = {2}"}, {"GET_ROUTE_VERSIONS", new Integer(1200), "select route_version, proposed_version from rs_routeversions\n\twhere source_rsid = {0} and dest_rsid = {1}"}, {"SET_ROUTE_STATUS", new Integer(1200), "update rs_routeversions set status = {0}\n\twhere source_rsid = {1} and dest_rsid = {2}"}, {"SET_ROUTE_VERSION", new Integer(1200), "update rs_routeversions set route_version = {0}\n\twhere source_rsid = {1} and dest_rsid = {2}"}, {"SET_ROUTE_IN_FLUX", new Integer(1200), "update rs_routeversions set proposed_version = {0}, status = {1}\n\twhere source_rsid = {2} and dest_rsid = {3}"}, {"IS_SERIAL_NR_SET", new Integer(1200), "select count (*) from rs_routeversions\n\twhere source_rsid = 0 and dest_rsid = 0"}, {"INSERT_SERIAL_NR", new Integer(1200), "insert rs_routeversions values (0, 0, 0, 0, 0, 0, 0, 0)"}, {"INCREMENT_SERIAL_NR", new Integer(1200), "update rs_routeversions set marker_serial_no = marker_serial_no + 1\n\twhere source_rsid = 0 and dest_rsid = 0"}, {"GET_SERIAL_NR", new Integer(1200), "select marker_serial_no from rs_routeversions where\n\tsource_rsid = 0 and dest_rsid = 0"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public RouteUpgrade(DomainRoute domainRoute) {
        Dbg.wassert(domainRoute != null, "Null route parameter.");
        this._route = domainRoute;
    }

    public DomainRoute getRoute() {
        return this._route;
    }

    public synchronized boolean isThreadRunning() {
        return _threadRunning;
    }

    protected synchronized void setThreadRunning(boolean bl) {
        _threadRunning = bl;
    }

    public void upgrade() {
        String string = BundleManager.getString("RouteUpgradeRes", "DLG_UPGRADE_TITLE", this.getRoute().getName());
        Object[] objectArray = new String[]{this.getRoute().getName(), String.valueOf(this.getRoute().getUpgradeVersion())};
        String string2 = BundleManager.getString("RouteUpgradeRes", "ROUTE_UPGRADE_DESC", objectArray);
        BkgndSummaryThread bkgndSummaryThread = new BkgndSummaryThread(string, string2, this.getRoute().getDomainName(), true){

            @Override
            public void run() {
                Dbg.wassert(!RouteUpgrade.this.isThreadRunning(), "RouteUpgrade Thread is currently running.");
                RouteUpgrade.this.setThreadRunning(true);
                try {
                    this.setStatus(0, BundleManager.getString("RouteUpgradeRes", "LOAD_UPGRADE_SCRIPTS"));
                    RouteUpgrade.this._scriptList = UpgradeScript.getUpgradeScripts();
                    this.setStatus(0, BundleManager.getString("RouteUpgradeRes", "FIND_REQUIRED_SCRIPTS"));
                    RouteUpgrade.this.sortRequiredScripts();
                    RouteUpgrade.this.testThreshold(RouteUpgrade.this.getRoute().getVersion(), RouteUpgrade.this.getRoute().getUpgradeVersion());
                    this.setStatus(0, BundleManager.getString("RouteUpgradeRes", "TEST_FOR_REMATERIALIZATION"));
                    RouteUpgrade.this.testForRematerialization();
                    if (RouteUpgrade.this._scriptList.size() == 0) {
                        this.setStatus(0, BundleManager.getString("RouteUpgradeRes", "SEND_PASSTHRU_MARKER"));
                        RouteUpgrade.this.sendEndMarker(false);
                    } else {
                        RouteUpgrade.this.loadSerialNr();
                        this.setStatus(0, BundleManager.getString("RouteUpgradeRes", "SEND_MARKER"));
                        RouteUpgrade.this.sendBeginMarker();
                        this.setStatus(0, BundleManager.getString("RouteUpgradeRes", "WAIT_FOR_MARKER"));
                        boolean bl = false;
                        while (!Thread.interrupted() && !bl) {
                            Thread.sleep(2000L);
                            bl = RouteUpgrade.this.checkMarker();
                        }
                        this.setStatus(0, BundleManager.getString("RouteUpgradeRes", "HIBERNATION_ON", RouteUpgrade.this.getRoute().getDestinationRS()));
                        RouteUpgrade.this.setHiberation(RouteUpgrade.this.getRoute().getDestinationRS(), true);
                        RouteUpgrade.this.setReplicateRouteInFlux();
                        this.setStatus(0, BundleManager.getString("RouteUpgradeRes", "REMATERIALIZE_DATA"));
                        RouteUpgrade.this.applyRules("queries");
                        if (RouteUpgrade.this.getRoute().getUpgradeVersion() < 1260) {
                            RouteUpgrade.this.setRouteVersion(RouteUpgrade.this.getRoute().getDestinationRS(), RouteUpgrade.this.getRoute().getUpgradeVersion());
                        }
                        this.setStatus(0, BundleManager.getString("RouteUpgradeRes", "SEND_COMMIT_MARKER"));
                        RouteUpgrade.this.sendEndMarker(true);
                        RouteUpgrade.this.setRouteStatus(RouteUpgrade.this.getRoute().getDestinationRS(), 0);
                        this.setStatus(0, BundleManager.getString("RouteUpgradeRes", "HIBERNATION_OFF", RouteUpgrade.this.getRoute().getDestinationRS()));
                        RouteUpgrade.this.setHiberation(RouteUpgrade.this.getRoute().getDestinationRS(), false);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception exception) {
                    this.setStatus(2, exception.getMessage());
                    this.setError(true);
                }
                if (!this.errorOccurred()) {
                    this.setStatus(0, BundleManager.getString("RouteUpgradeRes", "ROUTE_UPGRADE_COMPLETE"));
                }
                this.close();
                RouteUpgrade.this.setThreadRunning(false);
            }
        };
        bkgndSummaryThread.start();
    }

    public void recover() {
        String string = BundleManager.getString("RouteUpgradeRes", "DLG_RECOVER_TITLE", this.getRoute().getName());
        Object[] objectArray = new String[]{this.getRoute().getName(), String.valueOf(this.getRoute().getUpgradeVersion())};
        String string2 = BundleManager.getString("RouteUpgradeRes", "ROUTE_RECOVER_DESC", objectArray);
        BkgndSummaryThread bkgndSummaryThread = new BkgndSummaryThread(string, string2, this.getRoute().getDomainName(), true){

            @Override
            public void run() {
                Dbg.wassert(!RouteUpgrade.this.isThreadRunning(), "RouteUpgrade Thread is currently running.");
                RouteUpgrade.this.setThreadRunning(true);
                try {
                    if (!RouteUpgrade.this.isRRSHibernating()) {
                        throw new Exception(BundleManager.getString("RouteUpgradeRes", "RS_NOT_HIBERNATING", RouteUpgrade.this.getRoute().getDestinationRS()));
                    }
                    int[] nArray = RouteUpgrade.this.getRouteVersions(RouteUpgrade.this.getRoute().getDestinationRS());
                    if (nArray != null && nArray[0] == nArray[1]) {
                        this.setStatus(0, BundleManager.getString("RouteUpgradeRes", "UPGRADE_FINISHED_COPY"));
                        this.setStatus(0, BundleManager.getString("RouteUpgradeRes", "SEND_PASSTHRU_MARKER"));
                        RouteUpgrade.this.sendEndMarker(false);
                    } else {
                        this.setStatus(0, BundleManager.getString("RouteUpgradeRes", "LOAD_UPGRADE_SCRIPTS"));
                        RouteUpgrade.this._scriptList = UpgradeScript.getUpgradeScripts();
                        this.setStatus(0, BundleManager.getString("RouteUpgradeRes", "FIND_REQUIRED_SCRIPTS"));
                        RouteUpgrade.this.sortRequiredScripts();
                        RouteUpgrade.this.testThreshold(nArray[0], nArray[1]);
                        if (RouteUpgrade.this._scriptList.size() > 0) {
                            this.setStatus(0, BundleManager.getString("RouteUpgradeRes", "RECOVER_DATA"));
                            RouteUpgrade.this.applyRules("recovery");
                            this.setStatus(0, BundleManager.getString("RouteUpgradeRes", "REMATERIALIZE_DATA"));
                            RouteUpgrade.this.applyRules("queries");
                        }
                        if (nArray[1] < 1260) {
                            RouteUpgrade.this.setRouteVersion(RouteUpgrade.this.getRoute().getDestinationRS(), nArray[1]);
                        }
                        this.setStatus(0, BundleManager.getString("RouteUpgradeRes", "SEND_COMMIT_MARKER"));
                        RouteUpgrade.this.sendEndMarker(true);
                    }
                    RouteUpgrade.this.setRouteStatus(RouteUpgrade.this.getRoute().getDestinationRS(), 0);
                    this.setStatus(0, BundleManager.getString("RouteUpgradeRes", "HIBERNATION_OFF", RouteUpgrade.this.getRoute().getDestinationRS()));
                    RouteUpgrade.this.setHiberation(RouteUpgrade.this.getRoute().getDestinationRS(), false);
                }
                catch (Exception exception) {
                    this.setStatus(2, exception.getMessage());
                    this.setError(true);
                }
                if (!this.errorOccurred()) {
                    this.setStatus(0, BundleManager.getString("RouteUpgradeRes", "ROUTE_UPGRADE_COMPLETE"));
                }
                this.close();
                RouteUpgrade.this.setThreadRunning(false);
            }
        };
        bkgndSummaryThread.start();
    }

    protected void sortRequiredScripts() {
        Dbg.wassert(this._scriptList != null, "Null script list attribute.");
        Dbg.trace(32768, "Proposed Version: " + String.valueOf(this.getRoute().getUpgradeVersion()));
        Dbg.trace(32768, "Sort the script files by threshold");
        for (int i = 0; i < this._scriptList.size(); ++i) {
            int n = i;
            for (int j = i; j < this._scriptList.size(); ++j) {
                if (((UpgradeScript)this._scriptList.get(j)).getLowerThresholdVersion() < ((UpgradeScript)this._scriptList.get(n)).getLowerThresholdVersion()) {
                    n = j;
                    continue;
                }
                if (((UpgradeScript)this._scriptList.get(j)).getLowerThresholdVersion() != ((UpgradeScript)this._scriptList.get(n)).getLowerThresholdVersion() || ((UpgradeScript)this._scriptList.get(j)).getUpperThresholdVersion() <= ((UpgradeScript)this._scriptList.get(n)).getUpperThresholdVersion()) continue;
                n = j;
            }
            UpgradeScript upgradeScript = (UpgradeScript)this._scriptList.remove(n);
            this._scriptList.add(i, upgradeScript);
            Dbg.trace(32768, "Script file " + upgradeScript.getFileName() + " Threshold: " + String.valueOf(upgradeScript.getLowerThresholdVersion()) + "->" + String.valueOf(upgradeScript.getUpperThresholdVersion()));
        }
    }

    protected void testThreshold(int n, int n2) {
        int n3 = 0;
        ListIterator listIterator = this._scriptList.listIterator();
        while (listIterator.hasNext()) {
            UpgradeScript upgradeScript = (UpgradeScript)listIterator.next();
            if (n < upgradeScript.getLowerThresholdVersion() && n2 >= upgradeScript.getUpperThresholdVersion()) {
                if (upgradeScript.getUpperThresholdVersion() > n3) {
                    n3 = upgradeScript.getUpperThresholdVersion();
                    continue;
                }
                listIterator.remove();
                Dbg.trace(32768, "The proposed version does not fall between the threshold in the script " + upgradeScript.getFileName());
                continue;
            }
            listIterator.remove();
            Dbg.trace(32768, "The proposed version does not fall between the threshold in the script " + upgradeScript.getFileName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testForRematerialization() throws Exception {
        if (this._scriptList.size() > 0) {
            String string = this.getRoute().getOriginRS();
            ListIterator listIterator = this._scriptList.listIterator();
            while (listIterator.hasNext()) {
                boolean bl = false;
                UpgradeScript upgradeScript = (UpgradeScript)listIterator.next();
                if (!upgradeScript.findSection("test_queries", this.getRoute().getOriginVersion())) continue;
                String string2 = upgradeScript.readSQLQuery();
                while (string2 != null) {
                    block12: {
                        string2 = this.replaceSystemParameters(string2);
                        RSMConnection rSMConnection = this.getRoute().getDomain().getRSSD(string);
                        if (rSMConnection != null) {
                            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
                            try {
                                rSMResultSet.open(string2);
                                if (rSMResultSet.getNextRow()) {
                                    if (rSMResultSet.getColumnCount() != 1) {
                                        throw new Exception(BundleManager.getString("RouteUpgradeRes", "INVALID_TEST_QUERY", upgradeScript.getFileName()));
                                    }
                                    int n = rSMResultSet.getColumnInt(1);
                                    boolean bl2 = bl = n > 0;
                                    if (bl) break;
                                }
                                if (rSMResultSet.getNextRow()) {
                                    throw new Exception(BundleManager.getString("RouteUpgradeRes", "INVALID_TEST_QUERY", upgradeScript.getFileName()));
                                }
                                if (rSMResultSet.getNextResultSet()) {
                                    throw new Exception(BundleManager.getString("RouteUpgradeRes", "INVALID_TEST_QUERY", upgradeScript.getFileName()));
                                }
                                break block12;
                            }
                            finally {
                                rSMResultSet.close();
                                rSMConnection.unlock();
                            }
                        }
                        throw new Exception(BundleManager.getString("RouteUpgradeRes", "RSSD_CONNECTION_FAILED", string));
                    }
                    string2 = upgradeScript.readSQLQuery();
                }
                if (bl) continue;
                listIterator.remove();
                Dbg.trace(32768, "The test queries in the script " + upgradeScript.getFileName() + " did not identify any data to materialize.");
            }
        }
    }

    protected void sendEndMarker(boolean bl) throws Exception {
        String string = this.getRoute().getOriginRS();
        RSMConnection rSMConnection = this.getRoute().getDomain().getRSSD(string);
        if (rSMConnection != null) {
            int n = this.getRoute().getDomain().getVersionNumber(string);
            try {
                rSMConnection.execute("begin tran");
                Object[] objectArray = new String[]{String.valueOf(this.getRoute().getDestinationID()), String.valueOf(this.getRoute().getUpgradeVersion()), bl ? COMMIT_MARKER_TYPE : PASSTHRU_MARKER_TYPE};
                String string2 = _cmdBundle.getCommand(MARKER, n, objectArray);
                Dbg.wassert(string2 != null, "Unable to load the passthru marker cmd, repserver version: " + n);
                rSMConnection.execute(string2);
                Object[] objectArray2 = new String[]{String.valueOf(2), String.valueOf(this.getRoute().getOriginID()), String.valueOf(this.getRoute().getDestinationID())};
                string2 = _cmdBundle.getCommand(SET_ROUTE_STATUS, n, objectArray2);
                Dbg.wassert(string2 != null, "Unable to load the update route version cmd, repserver version: " + n);
                rSMConnection.execute(string2);
                rSMConnection.execute("commit tran");
            }
            catch (Exception exception) {
                rSMConnection.execute("rollback tran");
                throw exception;
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new Exception(BundleManager.getString("RouteUpgradeRes", "RSSD_CONNECTION_FAILED", string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendBeginMarker() throws Exception {
        String string = this.getRoute().getOriginRS();
        RSMConnection rSMConnection = this.getRoute().getDomain().getRSSD(string);
        if (rSMConnection != null) {
            int n = this.getRoute().getDomain().getVersionNumber(string);
            try {
                Object[] objectArray = new String[]{String.valueOf(this.getRoute().getDestinationID()), String.valueOf(this.getRoute().getUpgradeVersion()), "seq " + String.valueOf(this.getSerialNr())};
                String string2 = _cmdBundle.getCommand(MARKER, n, objectArray);
                Dbg.wassert(string2 != null, "Unable to load the passthru marker cmd, repserver version: " + n);
                rSMConnection.execute(string2);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new Exception(BundleManager.getString("RouteUpgradeRes", "RSSD_CONNECTION_FAILED", string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkMarker() throws Exception {
        Dbg.trace(32768, "Checking for the marker at the destination site.");
        boolean bl = false;
        String string = this.getRoute().getDestinationRS();
        RSMConnection rSMConnection = this.getRoute().getDomain().getRSSD(string);
        if (rSMConnection == null) throw new Exception(BundleManager.getString("RouteUpgradeRes", "RSSD_CONNECTION_FAILED", string));
        int n = this.getRoute().getDomain().getVersionNumber(string);
        Object[] objectArray = new String[]{String.valueOf(this.getRoute().getOriginID()), String.valueOf(this.getRoute().getDestinationID()), String.valueOf(this.getSerialNr())};
        String string2 = _cmdBundle.getCommand(CHECK_MARKER, n, objectArray);
        Dbg.wassert(string2 != null, "Unable to load check marker test cmd, repserver version: " + n);
        RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
        try {
            int n2;
            rSMResultSet.open(string2);
            if (!rSMResultSet.getNextRow() || (n2 = rSMResultSet.getColumnInt(1)) != 1) return bl;
            bl = true;
            return bl;
        }
        finally {
            rSMResultSet.close();
            rSMConnection.unlock();
        }
    }

    protected int getSerialNr() {
        return this._serialNr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSerialNr() throws Exception {
        String string = this.getRoute().getOriginRS();
        RSMConnection rSMConnection = this.getRoute().getDomain().getRSSD(string);
        if (rSMConnection != null) {
            int n = this.getRoute().getDomain().getVersionNumber(string);
            try {
                rSMConnection.execute("begin tran");
                String string2 = _cmdBundle.getCommand(IS_SERIAL_NR_SET, n);
                Dbg.wassert(string2 != null, "Unable to load serial number test cmd, repserver version: " + n);
                RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
                try {
                    int n2;
                    rSMResultSet.open(string2);
                    if (rSMResultSet.getNextRow() && (n2 = rSMResultSet.getColumnInt(1)) == 0) {
                        string2 = _cmdBundle.getCommand(INSERT_SERIAL_NR, n);
                        Dbg.wassert(string2 != null, "Unable to load insert serial number cmd, repserver version: " + n);
                        rSMConnection.execute(string2);
                    }
                }
                catch (Exception exception) {
                    rSMConnection.execute("rollback tran");
                    throw exception;
                }
                finally {
                    rSMResultSet.close();
                }
                string2 = _cmdBundle.getCommand(INCREMENT_SERIAL_NR, n);
                Dbg.wassert(string2 != null, "Unable to load update serial number cmd, repserver version: " + n);
                rSMConnection.execute(string2);
                string2 = _cmdBundle.getCommand(GET_SERIAL_NR, n);
                Dbg.wassert(string2 != null, "Unable to load get serial number cmd, repserver version: " + n);
                rSMResultSet = new RSMResultSet(rSMConnection);
                try {
                    rSMResultSet.open(string2);
                    if (rSMResultSet.getNextRow()) {
                        this._serialNr = rSMResultSet.getColumnInt(1);
                        Dbg.trace(32768, "PRS upgrade serial number = " + String.valueOf(this._serialNr));
                    }
                }
                catch (Exception exception) {
                    rSMConnection.execute("rollback tran");
                    throw exception;
                }
                finally {
                    rSMResultSet.close();
                }
                rSMConnection.execute("commit tran");
            }
            finally {
                rSMConnection.unlock();
            }
        }
        throw new Exception(BundleManager.getString("RouteUpgradeRes", "RSSD_CONNECTION_FAILED", string));
    }

    protected void setHiberation(String string, boolean bl) throws Exception {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getRoute().getDomainName());
        RepServer repServer = semanticFactory.getRepServer(string);
        repServer.setHibernation(bl);
    }

    protected boolean isRRSHibernating() throws Exception {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getRoute().getDomainName());
        DomainRepServer domainRepServer = (DomainRepServer)semanticFactory.getRepServer(this.getRoute().getDestinationRS());
        domainRepServer.monitor();
        return domainRepServer.isHibernating();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setReplicateRouteInFlux() throws Exception {
        String string = this.getRoute().getDestinationRS();
        RSMConnection rSMConnection = this.getRoute().getDomain().getRSSD(string);
        if (rSMConnection != null) {
            int n = this.getRoute().getDomain().getVersionNumber(string);
            Object[] objectArray = new String[]{String.valueOf(this.getRoute().getUpgradeVersion()), String.valueOf(1), String.valueOf(this.getRoute().getOriginID()), String.valueOf(this.getRoute().getDestinationID())};
            String string2 = _cmdBundle.getCommand(SET_ROUTE_IN_FLUX, n, objectArray);
            Dbg.wassert(string2 != null, "Unable to load update route status cmd, repserver version: " + n);
            try {
                rSMConnection.execute(string2);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new Exception(BundleManager.getString("RouteUpgradeRes", "RSSD_CONNECTION_FAILED", string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRouteStatus(String string, int n) throws Exception {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server parameter.");
        RSMConnection rSMConnection = this.getRoute().getDomain().getRSSD(string);
        if (rSMConnection != null) {
            int n2 = this.getRoute().getDomain().getVersionNumber(string);
            Object[] objectArray = new String[]{String.valueOf(n), String.valueOf(this.getRoute().getOriginID()), String.valueOf(this.getRoute().getDestinationID())};
            String string2 = _cmdBundle.getCommand(SET_ROUTE_STATUS, n2, objectArray);
            Dbg.wassert(string2 != null, "Unable to load update route status cmd, repserver version: " + n2);
            try {
                rSMConnection.execute(string2);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new Exception(BundleManager.getString("RouteUpgradeRes", "RSSD_CONNECTION_FAILED", string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRouteVersion(String string, int n) throws Exception {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server parameter.");
        RSMConnection rSMConnection = this.getRoute().getDomain().getRSSD(string);
        if (rSMConnection != null) {
            int n2 = this.getRoute().getDomain().getVersionNumber(string);
            Object[] objectArray = new String[]{String.valueOf(n), String.valueOf(this.getRoute().getOriginID()), String.valueOf(this.getRoute().getDestinationID())};
            String string2 = _cmdBundle.getCommand(SET_ROUTE_VERSION, n2, objectArray);
            Dbg.wassert(string2 != null, "Unable to load update route version cmd, repserver version: " + n2);
            try {
                rSMConnection.execute(string2);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new Exception(BundleManager.getString("RouteUpgradeRes", "RSSD_CONNECTION_FAILED", string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int[] getRouteVersions(String string) throws Exception {
        int[] nArray = null;
        Dbg.trace(32768, "Checking for the marker at the destination site.");
        RSMConnection rSMConnection = this.getRoute().getDomain().getRSSD(string);
        if (rSMConnection == null) throw new Exception(BundleManager.getString("RouteUpgradeRes", "RSSD_CONNECTION_FAILED", string));
        int n = this.getRoute().getDomain().getVersionNumber(string);
        Object[] objectArray = new String[]{String.valueOf(this.getRoute().getOriginID()), String.valueOf(this.getRoute().getDestinationID())};
        String string2 = _cmdBundle.getCommand(GET_ROUTE_VERSIONS, n, objectArray);
        Dbg.wassert(string2 != null, "Unable to load check marker test cmd, repserver version: " + n);
        RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
        try {
            rSMResultSet.open(string2);
            if (!rSMResultSet.getNextRow()) return nArray;
            nArray = new int[]{rSMResultSet.getColumnInt(1), rSMResultSet.getColumnInt(2)};
            return nArray;
        }
        finally {
            rSMResultSet.close();
            rSMConnection.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void applyRules(String string) throws Exception {
        RSMConnection rSMConnection = null;
        try {
            rSMConnection = this.getDestRSSDConnection();
            if (rSMConnection == null) throw new Exception(BundleManager.getString("RouteUpgradeRes", "RSSD_CONNECTION_FAILED", this.getRoute().getDestinationRS()));
            String string2 = this.getRoute().getOriginRS();
            ListIterator listIterator = this._scriptList.listIterator();
            while (listIterator.hasNext()) {
                void var7_7;
                void var7_9;
                HashMap<void, UpgradeRule> hashMap = new HashMap<void, UpgradeRule>();
                UpgradeScript upgradeScript = (UpgradeScript)listIterator.next();
                Dbg.trace(32768, "Reading rules in script file " + upgradeScript.getFileName());
                if (!upgradeScript.findSection("processing_rules")) throw new Exception(BundleManager.getString("RouteUpgradeRes", "MISSING_RULES_SECTION", upgradeScript.getFileName()));
                String[] stringArray = upgradeScript.readKeyValue();
                while (var7_9 != null) {
                    hashMap.put(var7_9[0], new UpgradeRule((String)var7_9[0], (String)var7_9[1]));
                    String[] stringArray2 = upgradeScript.readKeyValue();
                }
                Dbg.trace(32768, "Reading queries in script file " + upgradeScript.getFileName());
                if (!upgradeScript.findSection(string, this.getRoute().getOriginVersion())) throw new Exception(BundleManager.getString("RouteUpgradeRes", "MISSING_QUERY_SECTION", upgradeScript.getFileName()));
                String string3 = upgradeScript.readSQLQuery();
                while (var7_7 != null) {
                    String string4 = this.replaceSystemParameters((String)var7_7);
                    RSMConnection rSMConnection2 = this.getRoute().getDomain().getRSSD(string2);
                    if (rSMConnection2 == null) throw new Exception(BundleManager.getString("RouteUpgradeRes", "RSSD_CONNECTION_FAILED", string2));
                    RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection2);
                    try {
                        rSMResultSet.open(string4);
                        int n = rSMResultSet.getColumnCount();
                        if (n > 0) {
                            Object object;
                            ResultSetMetaData resultSetMetaData = rSMResultSet.getResultSetMetaData();
                            int n2 = resultSetMetaData.getColumnCount();
                            String[] stringArray3 = new String[n2];
                            for (int i = 1; i <= n2; ++i) {
                                object = resultSetMetaData.getColumnLabel(i);
                                if (object == null || ((String)object).length() <= 0) {
                                    throw new Exception(BundleManager.getString("RouteUpgradeRes", "INVALID_QUERY_MISSING_HEADER", upgradeScript.getFileName()));
                                }
                                stringArray3[i - 1] = object;
                            }
                            String[] stringArray4 = new String[n];
                            while (rSMResultSet.getNextRow()) {
                                Object[] objectArray;
                                for (int i = 1; i <= n2; ++i) {
                                    objectArray = rSMResultSet.getColumnString(i);
                                    stringArray4[i - 1] = objectArray != null ? objectArray : "";
                                }
                                object = (UpgradeRule)hashMap.get(stringArray4[0]);
                                if (object != null) {
                                    objectArray = ((UpgradeRule)object).generateQuery(stringArray3, stringArray4);
                                    rSMConnection.execute((String)objectArray);
                                    continue;
                                }
                                objectArray = new String[]{upgradeScript.getFileName(), stringArray4[0]};
                                throw new Exception(BundleManager.getString("RouteUpgradeRes", "INVALID_QUERY_UNKNOWN_RULE", objectArray));
                            }
                        }
                    }
                    finally {
                        rSMResultSet.close();
                        rSMConnection2.unlock();
                    }
                    String string5 = upgradeScript.readSQLQuery();
                }
            }
            return;
        }
        finally {
            if (rSMConnection != null) {
                rSMConnection.close();
            }
        }
    }

    protected String replaceSystemParameters(String string) {
        String string2 = string.replaceAll("%prsid", String.valueOf(this.getRoute().getOriginID()));
        return string2;
    }

    protected RSMConnection getDestRSSDConnection() throws SQLException {
        String string = this.getRoute().getDestinationRS();
        RSMConnection rSMConnection = null;
        RSConnection rSConnection = (RSConnection)this.getRoute().getDomain().getConnection(string);
        if (rSConnection != null) {
            String string2 = rSConnection.getRSSD();
            rSConnection.unlock();
            RSMConnection rSMConnection2 = this.getRoute().getDomain().getRSSD(string);
            if (rSMConnection2 != null) {
                ConnAttributes connAttributes = rSMConnection2.getAttributes();
                rSMConnection2.unlock();
                if (connAttributes.getType().equals("ASE")) {
                    rSMConnection = new ASEConnection(connAttributes);
                    rSMConnection.open();
                    ((ASEConnection)rSMConnection).use(string2);
                } else {
                    rSMConnection = new ASAConnection(connAttributes);
                    rSMConnection.open();
                    ((ASAConnection)rSMConnection).use(string2);
                }
            }
        }
        return rSMConnection;
    }
}

