/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.routeupgrade;

import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseDialog;
import com.sybase.rsmplugin.components.BasePage;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.repserver.RepServer;
import com.sybase.rsmplugin.components.route.Route;
import com.sybase.rsmplugin.routeupgrade.RouteUpgradePanel;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RouteUpgradeDlg
extends BaseDialog {
    protected SCPageController[] _page = null;
    protected RepServer _rs;

    public RouteUpgradeDlg(SCDialogSupport2 sCDialogSupport2, RepServer repServer) {
        super(sCDialogSupport2);
        Dbg.wassert(repServer != null, "Null rep server parameter.");
        this._rs = repServer;
    }

    public RepServer getControllingRS() {
        return this._rs;
    }

    @Override
    public void showDialog() {
        this.getDialogSupport().setDialogController((SCDialogController)this);
        this.getDialogSupport().setTitle(this.getTitle());
        this.getDialogSupport().setResizable(true);
        this.getDialogSupport().setStandardButtons(false);
        this.getDialogSupport().setModal(false);
        this.getDialogSupport().setHelpButton(false);
        PluginSupport.registerDialog(this);
        this.getDialogSupport().render();
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("RouteUpgradeRes", "DLG_UPGRADE_TITLE", this.getControllingRS().getName());
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._page == null) {
            this._page = new SCPageController[]{new RouteUpgradePage()};
        }
        return this._page;
    }

    class RouteUpgradePage
    extends BasePage
    implements ActionListener,
    ListSelectionListener {
        private RouteUpgradePanel _goPage = new RouteUpgradePanel();

        @Override
        public void onInitDialog() {
            this._goPage.tbl_routes.getSelectionModel().addListSelectionListener(this);
            this._goPage.tbl_routes.getInputMap().put(KeyStroke.getKeyStroke(27, 0, false), "ESC_KEY");
            this._goPage.tbl_routes.getActionMap().put("ESC_KEY", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RouteUpgradeDlg.this.closeDialog();
                }
            });
            this._goPage.btn_upgrade.addActionListener((ActionListener)this);
            this._goPage.btn_recover.addActionListener((ActionListener)this);
            this._goPage.btn_cancel.addActionListener((ActionListener)this);
            try {
                this.displayRoutes();
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            this.setButtons();
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.setButtons();
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Route route;
            int n;
            if (actionEvent.getSource() == this._goPage.btn_cancel) {
                RouteUpgradeDlg.this.closeDialog();
            } else if (actionEvent.getSource() == this._goPage.btn_upgrade) {
                Route route2;
                int n2 = this._goPage.tbl_routes.getSelectedRow();
                if (n2 >= 0 && PluginSupport.askQuestion(BundleManager.getString("RouteUpgradeRes", "CONFIRM_UPGRADE", (route2 = (Route)this._goPage.tbl_routes.getRSMObjectRow(n2)).getName()), RouteUpgradeDlg.this.getDialogSupport().getJDialog(), false)) {
                    if (route2.upgrade()) {
                        RouteUpgradeDlg.this.closeDialog();
                    } else {
                        String string = BundleManager.getString("RouteUpgradeRes", "UPGRADE_RUNNING");
                        PluginSupport.showError(string, string);
                    }
                }
            } else if (actionEvent.getSource() == this._goPage.btn_recover && (n = this._goPage.tbl_routes.getSelectedRow()) >= 0 && PluginSupport.askQuestion(BundleManager.getString("RouteUpgradeRes", "CONFIRM_RECOVERY", (route = (Route)this._goPage.tbl_routes.getRSMObjectRow(n)).getName()), RouteUpgradeDlg.this.getDialogSupport().getJDialog(), false)) {
                if (route.recover()) {
                    RouteUpgradeDlg.this.closeDialog();
                } else {
                    String string = BundleManager.getString("RouteUpgradeRes", "UPGRADE_RUNNING");
                    PluginSupport.showError(string, string);
                }
            }
        }

        protected void setButtons() {
            if (this._goPage.tbl_routes.getSelectedRowCount() == 0) {
                this._goPage.btn_upgrade.setEnabled(false);
                this._goPage.btn_recover.setEnabled(false);
            } else {
                int n = this._goPage.tbl_routes.getSelectedRow();
                Route route = (Route)this._goPage.tbl_routes.getRSMObjectRow(n);
                this._goPage.btn_recover.setEnabled(route.isRecoveryRequired());
                this._goPage.btn_upgrade.setEnabled(!route.isRecoveryRequired());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void displayRoutes() throws SQLException {
            this._goPage.tbl_routes.clear();
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(RouteUpgradeDlg.this.getControllingRS().getDomainName());
            Dbg.wassert(semanticFactory != null, "Unable to get semantic factory for '" + RouteUpgradeDlg.this.getControllingRS().getDomainName() + "'.");
            try {
                RouteUpgradeDlg.this.getDialogSupport().startWait();
                List list = semanticFactory.getOriginRoutes(RouteUpgradeDlg.this.getControllingRS().getName());
                if (list != null) {
                    ListIterator listIterator = list.listIterator();
                    while (listIterator.hasNext()) {
                        Route route = (Route)listIterator.next();
                        route.loadProperties();
                        if (route.isUpgradeCandidate() || route.isRecoveryRequired()) continue;
                        listIterator.remove();
                    }
                    if (list.size() > 0) {
                        this._goPage.tbl_routes.addRows(list);
                    }
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            finally {
                RouteUpgradeDlg.this.getDialogSupport().endWait();
            }
            if (this._goPage.tbl_routes.getRowCount() > 0) {
                this._goPage.tbl_routes.requestFocus();
            }
            this._goPage.tbl_routes.refresh();
        }
    }
}

