/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.routeupgrade;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class UpgradeRule {
    private static final String PARAM_DELIMITER = "\\?";
    private String _name;
    private String _rule;
    private List _paramList;

    protected UpgradeRule(String string, String string2) throws Exception {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty rule parameter.");
        this._name = string;
        this._paramList = new ArrayList();
        this._rule = "";
        int n = 0;
        boolean bl = string2.startsWith(PARAM_DELIMITER);
        String[] stringArray = string2.split(PARAM_DELIMITER);
        for (int i = 0; i < stringArray.length; ++i) {
            if (bl) {
                this._paramList.add(stringArray[i]);
                this._rule = this._rule + "{" + String.valueOf(n++) + "}";
            } else {
                this._rule = this._rule + stringArray[i];
            }
            bl = !bl;
        }
        this._rule = MessageText.doubleUpSingleQuotes(this._rule);
        Dbg.trace(32768, "Upgrade Rule: " + this.getName() + " = " + this._rule);
    }

    public String getName() {
        return this._name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String generateQuery(String[] stringArray, String[] stringArray2) throws Exception {
        String string = null;
        if (this._paramList.size() > 0) {
            Object[] objectArray;
            int n;
            if (stringArray.length != stringArray2.length) throw new Exception(BundleManager.getString("RouteUpgradeRes", "MISMATCH_QUERY_VALUES", this.getName()));
            Object[] objectArray2 = new String[this._paramList.size()];
            for (n = 0; n < objectArray2.length; ++n) {
                objectArray2[n] = null;
            }
            for (n = 0; n < stringArray.length; ++n) {
                objectArray = stringArray[n];
                String string2 = stringArray2[n];
                string2 = string2 == null ? "" : string2;
                for (int i = 0; i < this._paramList.size(); ++i) {
                    if (!objectArray.equals((String)this._paramList.get(i))) continue;
                    objectArray2[i] = string2;
                }
            }
            for (n = 0; n < objectArray2.length; ++n) {
                if (objectArray2[n] != null) continue;
                objectArray = new String[]{this.getName(), (String)this._paramList.get(n)};
                throw new Exception(BundleManager.getString("RouteUpgradeRes", "MISSING_PARAMETER", objectArray));
            }
            string = MessageFormat.format(this._rule, objectArray2);
        } else {
            string = this._rule;
        }
        Dbg.trace(32768, "Generate query: " + this.getName() + " = " + string);
        return string;
    }
}

