/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.routeupgrade;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.RMEnv;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class UpgradeScript {
    public static final String SCRIPT_FILE_NAME = "routeupgrade";
    public static final String SCRIPT_FILE_TYPE = ".loc";
    public static final String COPYRIGHT_SECTION = "copyright";
    public static final String FILE_FORMAT_SECTION = "file_format";
    public static final String THRESHOLD_VERSION_SECTION = "versions";
    public static final String PROCESSING_RULES_SECTION = "processing_rules";
    public static final String QUERIES_SECTION = "queries";
    public static final String TEST_QUERIES_SECTION = "test_queries";
    public static final String RECOVERY_SECTION = "recovery";
    public static final String FILE_TYPE_KEY = "file_type";
    public static final String FORMAT_VERSION_KEY = "file_format_version";
    public static final String THRESHOLD_KEY = "threshold";
    public static final String FILE_TYPE_VALUE = "rematerialization_script";
    public static final String SCRIPT_EXECUTE_CMD = "go";
    private File _scriptFile;
    private BufferedReader _reader;
    private int _formatVersion;
    private int _lowerThresholdVersion;
    private int _upperThresholdVersion;

    protected UpgradeScript(File file) throws Exception {
        block17: {
            String[] stringArray;
            String[] stringArray2;
            this._scriptFile = null;
            this._reader = null;
            this._formatVersion = 0;
            this._lowerThresholdVersion = 0;
            this._upperThresholdVersion = 0;
            Dbg.wassert(file != null, "Null script file parameter.");
            this._scriptFile = file;
            if (this.findSection(FILE_FORMAT_SECTION)) {
                boolean bl = false;
                stringArray2 = this.readKeyValue();
                while (stringArray2 != null) {
                    if (stringArray2[0].equals(FILE_TYPE_KEY)) {
                        if (!stringArray2[1].equals(FILE_TYPE_VALUE)) {
                            throw new Exception(BundleManager.getString("RouteUpgradeRes", "INVALID_SCRIPT_FILE", this.getFileName()));
                        }
                        bl = true;
                    } else if (stringArray2[0].equals(FORMAT_VERSION_KEY)) {
                        try {
                            this._formatVersion = Integer.parseInt(stringArray2[1]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            Object[] objectArray = new String[]{stringArray2[1], this.getFileName()};
                            throw new Exception(BundleManager.getString("RouteUpgradeRes", "INVALID_FILE_VERSION", objectArray));
                        }
                    }
                    stringArray2 = this.readKeyValue();
                }
                if (!bl) {
                    throw new Exception(BundleManager.getString("RouteUpgradeRes", "MISSING_FILE_TYPE", this.getFileName()));
                }
                if (this._formatVersion == 0) {
                    throw new Exception(BundleManager.getString("RouteUpgradeRes", "MISSING_FORMAT_VERSION"));
                }
            } else {
                throw new Exception(BundleManager.getString("RouteUpgradeRes", "INVALID_SCRIPT_FILE", this.getFileName()));
            }
            if (this.findSection(THRESHOLD_VERSION_SECTION) && (stringArray = this.readKeyValue()) != null && stringArray[0].equals(THRESHOLD_KEY)) {
                stringArray2 = stringArray[1].split(",");
                try {
                    if (stringArray2.length == 1) {
                        this._lowerThresholdVersion = Integer.parseInt(stringArray2[0]);
                        this._upperThresholdVersion = Integer.parseInt(stringArray2[0]);
                        break block17;
                    }
                    if (stringArray2.length == 2) {
                        this._lowerThresholdVersion = Integer.parseInt(stringArray2[0]);
                        this._upperThresholdVersion = Integer.parseInt(stringArray2[1]);
                        break block17;
                    }
                    throw new Exception(BundleManager.getString("RouteUpgradeRes", "INVALID_VERSION_THRESHOLD", this.getFileName()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Exception(BundleManager.getString("RouteUpgradeRes", "INVALID_VERSION_THRESHOLD", this.getFileName()));
                }
            }
        }
        if (this._lowerThresholdVersion == 0 || this._upperThresholdVersion == 0) {
            throw new Exception(BundleManager.getString("RouteUpgradeRes", "INVALID_VERSION_THRESHOLD", this.getFileName()));
        }
        Dbg.trace(32768, "Route Upgrade Script: file='" + this.getFileName() + "' " + "lower threshold='" + String.valueOf(this._lowerThresholdVersion) + "' " + "upper threshold='" + String.valueOf(this._upperThresholdVersion) + "' " + "file version='" + String.valueOf(this._formatVersion) + "' ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public String getFileName() {
        if (this._scriptFile != null) {
            return this._scriptFile.getName();
        }
        return "";
    }

    public static List getUpgradeScripts() throws Exception {
        Dbg.trace(32768, "Get route upgrade script files");
        ArrayList<UpgradeScript> arrayList = new ArrayList<UpgradeScript>();
        int n = 1;
        File file = null;
        do {
            String string;
            if ((string = RMEnv.getRMScriptsDir()) == null) {
                throw new SQLException(BundleManager.getString("ProviderRes", "ERR_SYBROOT_NOT_SET"), "_RSM_", 6);
            }
            String string2 = SCRIPT_FILE_NAME + String.valueOf(n) + SCRIPT_FILE_TYPE;
            file = new File(string, string2);
            if (file != null) {
                if (!file.exists()) {
                    file = null;
                } else {
                    if (!file.canRead()) {
                        throw new SQLException(BundleManager.getString("ProviderRes", "ERR_READ_PERMISSIONS", file.getAbsolutePath()), "_RSM_", 4);
                    }
                    UpgradeScript upgradeScript = new UpgradeScript(file);
                    arrayList.add(upgradeScript);
                }
            }
            ++n;
        } while (file != null);
        return arrayList;
    }

    public int getLowerThresholdVersion() {
        return this._lowerThresholdVersion;
    }

    public int getUpperThresholdVersion() {
        return this._upperThresholdVersion;
    }

    public int getFormatVersion() {
        return this._formatVersion;
    }

    public String getCopyright() {
        String string = "";
        try {
            String[] stringArray;
            if (this.findSection(COPYRIGHT_SECTION) && (stringArray = this.readKeyValue()) != null) {
                string = stringArray[1];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public boolean findSection(String string) throws Exception {
        this.open();
        boolean bl = false;
        if (this.isOpen()) {
            String string2 = this._reader.readLine();
            while (string2 != null) {
                if (!this.isComment(string2) && this.isSection(string2, string)) {
                    bl = true;
                    break;
                }
                string2 = this._reader.readLine();
            }
        }
        if (bl) {
            Dbg.trace(32768, "Found Section: file='" + this.getFileName() + "' " + "section='[" + string + "]'");
        } else {
            Dbg.trace(32768, "Section [" + string + "] not found.");
        }
        return bl;
    }

    public boolean findSection(String string, int n) throws Exception {
        boolean bl = this.findSection(string);
        if (bl) {
            boolean bl2 = false;
            int n2 = (int)this._scriptFile.length();
            this._reader.mark(n2);
            String string2 = this._reader.readLine();
            while (string2 != null) {
                if (!this.isComment(string2)) {
                    if (this.isVersionVariant(string2, n)) {
                        bl2 = true;
                        break;
                    }
                    if (this.isSection(string2) || this.isVersionVariant(string2)) break;
                }
                string2 = this._reader.readLine();
            }
            if (bl2) {
                Dbg.trace(32768, "Found version sub-section: {" + String.valueOf(n) + "}");
            } else {
                this._reader.reset();
                Dbg.trace(32768, "Version sub-section {" + String.valueOf(n) + "} not found.");
            }
        }
        return bl;
    }

    public String[] readKeyValue() throws Exception {
        String[] stringArray = null;
        if (this.isOpen()) {
            String string = this._reader.readLine();
            while (string != null && (this.isComment(string) || string.trim().length() == 0)) {
                string = this._reader.readLine();
            }
            if (string != null && !this.isSection(string) && !this.isVersionVariant(string)) {
                stringArray = string.split("=", 2);
                if (stringArray.length == 2) {
                    stringArray[0] = stringArray[0].trim();
                    stringArray[1] = stringArray[1].trim();
                    if (stringArray[1].startsWith("\"")) {
                        stringArray[1] = stringArray[1].substring(1);
                        stringArray[1] = stringArray[1] + "\n";
                        string = this._reader.readLine();
                        while (string != null) {
                            if (!this.isComment(string) && string.trim().length() > 0) {
                                if (this.isSection(string) || this.isVersionVariant(string)) {
                                    Object[] objectArray = new String[]{stringArray[0], this.getFileName()};
                                    throw new Exception(BundleManager.getString("RouteUpgradeRes", "MISSING_END_OF_VALUE", objectArray));
                                }
                                stringArray[1] = stringArray[1] + string.trim();
                                if (stringArray[1].endsWith("\"")) break;
                                stringArray[1] = stringArray[1] + "\n";
                            }
                            string = this._reader.readLine();
                        }
                        if (stringArray[1].endsWith("\"")) {
                            stringArray[1] = stringArray[1].substring(0, stringArray[1].length() - 1);
                        }
                    }
                } else {
                    Object[] objectArray = new String[]{string, this.getFileName()};
                    throw new Exception(BundleManager.getString("RouteUpgradeRes", "INVALID_KEYVALUE_ENTRY", objectArray));
                }
            }
        }
        if (stringArray != null) {
            Dbg.trace(32768, "Read Key/Value: file='" + this.getFileName() + "' " + "key='" + (String)stringArray[0] + "' " + "value='" + stringArray[1] + "' ");
        }
        return stringArray;
    }

    public String readSQLQuery() throws Exception {
        String string = "";
        if (this.isOpen()) {
            String string2 = this._reader.readLine();
            while (string2 != null) {
                if (!this.isComment(string2) && string2.trim().length() > 0) {
                    if (string2.trim().equalsIgnoreCase(SCRIPT_EXECUTE_CMD)) break;
                    if (this.isSection(string2) || this.isVersionVariant(string2)) {
                        if (string.length() == 0) break;
                        throw new Exception(BundleManager.getString("RouteUpgradeRes", "MISSING_END_OF_QUERY", this.getFileName()));
                    }
                    string = string + string2 + "\n";
                }
                string2 = this._reader.readLine();
            }
        }
        String string3 = string = string.length() == 0 ? null : string;
        if (string != null) {
            Dbg.trace(32768, "Read SQL Query: file='" + this.getFileName() + "' " + "query='" + string + "' ");
        }
        return string;
    }

    public void close() {
        if (this._reader != null) {
            try {
                this._reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._reader = null;
        }
    }

    protected void open() throws Exception {
        this.close();
        FileReader fileReader = new FileReader(this._scriptFile);
        this._reader = new BufferedReader(fileReader);
    }

    protected boolean isOpen() {
        return this._reader != null;
    }

    protected boolean isComment(String string) {
        return string.trim().startsWith(";");
    }

    protected boolean isSection(String string) {
        return string.startsWith("[");
    }

    protected boolean isSection(String string, String string2) {
        String string3 = "[" + string2 + "]";
        return string.startsWith("[") && string.equals(string3);
    }

    protected boolean isVersionVariant(String string) {
        return string.startsWith("{");
    }

    protected boolean isVersionVariant(String string, int n) {
        boolean bl = false;
        if (this.isVersionVariant(string)) {
            String string2 = string.trim();
            string2 = string2.substring(1, string2.length() - 1);
            String[] stringArray = string2.split(",");
            try {
                if (stringArray.length == 1) {
                    int n2 = Integer.parseInt(stringArray[0].trim());
                    bl = n2 == n;
                } else if (stringArray.length == 2) {
                    int n3 = Integer.parseInt(stringArray[0].trim());
                    int n4 = Integer.parseInt(stringArray[1].trim());
                    bl = n >= n3 && n <= n4;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return bl;
    }
}

