/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.sql;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;

public class ASAConnection
extends RSMConnection {
    public static final int ERSSD_VERSION_NR = 8020000;
    private static final int MINIMUM_VERSION_NR = 8020000;
    private static final String MINIMUM_VERSION_NR_STR = "8.0.2";
    private static final String VERSION_PRODUCT_NAME = "Adaptive Server Anywhere";
    protected String _versionString = null;

    public ASAConnection(ConnAttributes connAttributes) {
        super(connAttributes);
    }

    @Override
    public synchronized void open() throws SQLException {
        super.open();
        try {
            this.execute("SET TEMPORARY OPTION QUOTED_IDENTIFIER='OFF'");
            this.initServerVersion();
        }
        catch (SQLException sQLException) {
            this.close();
            throw new SQLException(BundleManager.getString("ProviderRes", "INVALID_ASA_SERVER"), "_RSM_", 1);
        }
    }

    @Override
    public String getDisplayVersionNumber() {
        return this._versionString;
    }

    @Override
    public int getVersionNumber() {
        if (this._versionString != null && this._versionString.length() > 0) {
            return MessageText.toVersionNr(this._versionString, 7);
        }
        return 8020000;
    }

    @Override
    public String getVersionString() {
        return this._versionString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initServerVersion() throws SQLException {
        RSMResultSet rSMResultSet = new RSMResultSet(this);
        try {
            rSMResultSet.open("select @@version");
            if (rSMResultSet.getNextRow()) {
                this._versionString = rSMResultSet.getColumnString(1);
                if (this._versionString != null) {
                    if (this._versionString.length() > 0) {
                        if (PluginSupport.logSQL()) {
                            Object[] objectArray = new String[]{this.getType(), this.getServerName(), this._versionString};
                            String string = BundleManager.getString("ProviderRes", "VERSION_STRING_HDR", objectArray);
                            PluginSupport.LogInfoMessage(string, string);
                        }
                    } else {
                        this._versionString = null;
                    }
                }
            }
        }
        finally {
            rSMResultSet.close();
        }
    }

    public void use(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty db parameter.");
        this.execute("use " + string);
    }
}

