/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.sql;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class ASEConnection
extends RSMConnection {
    private static final String GALAXY_ESD_TAG = "ESD#";
    public static final int AVATAR_VERSION_NR = 120000;
    public static final int EVEREST_VERSION_NR = 125000;
    public static final int VOYAGER_VERSION_NR = 125100;
    public static final int GALAXY_VERSION_NR = 150000;
    public static final int GALAXY_ESD1_VERSION_NR = 150001;
    private static final int MINIMUM_VERSION_NR = 120000;
    private static final String MINIMUM_VERSION_NR_STR = "12.0";
    private static final String VERSION_PRODUCT_NAME = "Adaptive Server Enterprise";
    protected String _versionNr = null;
    protected String _versionString = null;
    protected int _iVersionNr = 120000;

    public ASEConnection(ConnAttributes connAttributes) {
        super(connAttributes);
    }

    @Override
    public synchronized void open() throws SQLException {
        this._props.put("SQLINITSTRING", "set quoted_identifier off");
        try {
            super.open();
        }
        catch (SQLException sQLException) {
            if (this.getState() == 5) {
                this.setReason(BundleManager.getString("ProviderRes", "INVALID_ASE_SERVER"));
                throw new SQLException(this.getReason(), "_RSM_", 1);
            }
            throw sQLException;
        }
        try {
            this.initServerVersion();
        }
        catch (SQLException sQLException) {
            this.close();
            this.setState(5);
            this.setReason(BundleManager.getString("ProviderRes", "INVALID_ASE_SERVER"));
            throw new SQLException(this.getReason(), "_RSM_", 1);
        }
        if (this.getVersionNumber() < 120000) {
            this.close();
            Object[] objectArray = new String[]{this.getDisplayVersionNumber(), MINIMUM_VERSION_NR_STR};
            this.setState(5);
            this.setReason(BundleManager.getString("ProviderRes", "INVALID_ASE_VERSION", objectArray));
            throw new SQLException(this.getReason(), "_RSM_", 2);
        }
    }

    @Override
    public String getDisplayVersionNumber() {
        return this._versionNr;
    }

    @Override
    public int getVersionNumber() {
        return this._iVersionNr;
    }

    @Override
    public String getVersionString() {
        return this._versionString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initServerVersion() throws SQLException {
        RSMResultSet rSMResultSet = new RSMResultSet(this);
        try {
            rSMResultSet.open("select @@version");
            if (rSMResultSet.getNextRow()) {
                this._versionString = rSMResultSet.getColumnString(1);
                if (this._versionString != null) {
                    if (this._versionString.length() > 0) {
                        if (PluginSupport.logSQL()) {
                            Object[] objectArray = new String[]{this.getType(), this.getServerName(), this._versionString};
                            String string = BundleManager.getString("ProviderRes", "VERSION_STRING_HDR", objectArray);
                            PluginSupport.LogInfoMessage(string, string);
                        }
                        this._versionNr = this.parseVersionNr(this._versionString);
                        if (this._versionNr != null && this._versionNr.length() > 0) {
                            this._iVersionNr = MessageText.toVersionNr(this._versionNr, 6);
                            if (this._iVersionNr >= 150000) {
                                this._iVersionNr += this.parseESDNr(this._versionString);
                            }
                        } else {
                            this._versionNr = MINIMUM_VERSION_NR_STR;
                            this._iVersionNr = 120000;
                        }
                    } else {
                        this._versionString = null;
                    }
                }
            }
        }
        finally {
            rSMResultSet.close();
        }
    }

    protected int parseESDNr(String string) throws SQLException {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (stringTokenizer.countTokens() >= 3) {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            int n2 = string4.indexOf(GALAXY_ESD_TAG);
            if (n2 >= 0) {
                string4 = string4.substring(n2);
                if ((string4 = string4.replaceAll("\\D", "")).length() > 0) {
                    n = Integer.parseInt(string4);
                }
            }
        } else {
            Object[] objectArray = new String[]{this.getType(), this.getServerName(), string, String.valueOf(stringTokenizer.countTokens())};
            SQLException sQLException = new SQLException(BundleManager.getString("ProviderRes", "VERSION_PARSE_ERR_MSG", objectArray));
            throw sQLException;
        }
        return n;
    }

    public void use(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty db parameter.");
        this.execute("use " + string);
    }
}

