/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.sql;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.sql.HDSConnAttributes;
import com.sybase.rsmplugin.sql.RSConnAttributes;
import com.sybase.rsmplugin.sql.ServerInterfaces;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.Dbg;
import java.util.ArrayList;
import java.util.List;

public class ConnAttributes {
    public static final String RS_SERVER = "Replication Server";
    public static final String ASE_SERVER = "ASE";
    public static final String SA_SERVER = "ASA";
    public static final String IQ_SERVER = "IQ";
    public static final String RA_SERVER = "Replication Agent";
    public static final String MRA_SERVER = "Mirror Replication Agent";
    public static final String DC_SERVER = "DirectConnect";
    public static final String OPEN_SERVER = "Open Server";
    public static final String DB_LTM = "LTM";
    public static final String ORACLE_SERVER = "Oracle";
    public static final String MICROSOFT_SERVER = "MSSS";
    public static final String UDB_SERVER = "UDB";
    public static final String INFORMIX_SERVER = "Informix";
    public static final String RMS_SERVER = "RMS";
    public static final String[] TYPE_LIST = new String[]{"Replication Server", "ASE", "Replication Agent", "Mirror Replication Agent", "DirectConnect", "Oracle", "MSSS", "UDB", "RMS"};
    public static final String RS_SERVER_NAME = "Replication Server";
    public static final String ASE_SERVER_NAME = "Adaptive Server Enterprise";
    public static final String SA_SERVER_NAME = "SQL Anywhere";
    public static final String IQ_SERVER_NAME = "Sybase IQ";
    public static final String RA_SERVER_NAME = "Replication Agent";
    public static final String MRA_SERVER_NAME = "Mirror Replication Agent";
    public static final String DC_SERVER_NAME = "DirectConnect Service";
    public static final String OPEN_SERVER_NAME = "Open Server";
    public static final String DB_LTM_NAME = "Database LTM";
    public static final String ORACLE_SERVER_NAME = "Oracle DBMS";
    public static final String MICROSOFT_SERVER_NAME = "Microsoft SQL Server";
    public static final String UDB_SERVER_NAME = "IBM Universal Database";
    public static final String INFORMIX_SERVER_NAME = "Informix DBMS";
    public static final String RMS_SERVER_NAME = "Replication Monitoring Services";
    public static final String[] TYPE_NAME_LIST = new String[]{"Replication Server", "Adaptive Server Enterprise", "Replication Agent", "Mirror Replication Agent", "DirectConnect Service", "Oracle DBMS", "Microsoft SQL Server", "IBM Universal Database", "Replication Monitoring Services"};
    protected static final String SERVER_NAME = "Server";
    protected static final String SERVER_HOST = "Host";
    protected static final String SERVER_PORT = "Port";
    protected static final String SERVER_TYPE = "Type";
    protected static final String SERVER_USER = "User";
    protected static final String SERVER_PWD = "Password";
    protected static final String SERVER_CHARSET = "Charset";
    protected static final String SERVER_LANG = "Language";
    public static final String DEFAULT_BLANK_PWD = "__XSRO__";
    public static final String ADDRESS_SEPARATOR = ":";
    private String _type;
    private String _server;
    private String _host;
    private String _port;
    private String _username;
    private String _password = null;
    private String _charset = null;
    private String _language = null;
    private boolean _saveAddressLocally = false;

    public static ConnAttributes load(String string, String string2) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty domain name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty server name parameter.");
        String string3 = "Domain." + string + "." + string2 + ".";
        ConnAttributes connAttributes = null;
        String string4 = PluginSupport.readProfileString(string3 + SERVER_TYPE);
        if (string4 != null && string4.length() > 0) {
            connAttributes = string4.equalsIgnoreCase("Replication Server") ? new RSConnAttributes() : (string4.equalsIgnoreCase(ORACLE_SERVER) || string4.equalsIgnoreCase(MICROSOFT_SERVER) || string4.equalsIgnoreCase(UDB_SERVER) || string4.equalsIgnoreCase(INFORMIX_SERVER) ? new HDSConnAttributes() : new ConnAttributes());
            connAttributes.setType(string4);
            connAttributes.setServer(string2);
            connAttributes.load(string3);
        }
        return connAttributes;
    }

    protected void load(String string) {
        String string2 = PluginSupport.readProfileString(string + SERVER_HOST);
        if (string2 != null && string2.length() > 0) {
            this.setHost(string2);
            this.setPort(PluginSupport.readProfileString(string + SERVER_PORT));
            this.setSaveAddress(true);
        } else {
            this.setHost("");
            this.setPort("");
            this.setSaveAddress(false);
        }
        string2 = PluginSupport.readProfileString(string + SERVER_USER);
        this.setUser(string2);
        string2 = PluginSupport.readProfileStringEncrypted(string + SERVER_PWD);
        string2 = string2 == null || string2.equals(DEFAULT_BLANK_PWD) ? "" : string2;
        this.setPassword(string2);
        string2 = PluginSupport.readProfileString(string + SERVER_CHARSET);
        this.setCharset(string2);
        string2 = PluginSupport.readProfileString(string + SERVER_LANG);
        this.setLanguage(string2);
    }

    public void save(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty domain name parameter.");
        Dbg.trace(1, "Save connection attributes for env.server '" + string + "." + this.getServer() + "'. Spec: " + this.toString());
        ConnAttributes.remove(string, this.getServer());
        String string2 = "Domain." + string + "." + this.getServer() + ".";
        PluginSupport.writeProfileString(string2 + SERVER_TYPE, this.getType());
        if (!this.getType().equalsIgnoreCase(RMS_SERVER)) {
            PluginSupport.writeProfileString(string2 + SERVER_USER, this.getUser());
            String string3 = this.getPassword();
            if (string3 == null || string3.length() == 0) {
                string3 = DEFAULT_BLANK_PWD;
            }
            PluginSupport.writeProfileStringEncrypted(string2 + SERVER_PWD, string3);
        }
        PluginSupport.writeProfileString(string2 + SERVER_CHARSET, this.getCharset());
        PluginSupport.writeProfileString(string2 + SERVER_LANG, this.getLanguage());
        if (this.isAddressSavedLocally()) {
            PluginSupport.writeProfileString(string2 + SERVER_HOST, this.getHost());
            PluginSupport.writeProfileString(string2 + SERVER_PORT, this.getPort());
        }
    }

    public static void remove(String string, String string2) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty domain name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty server name parameter.");
        Dbg.trace(1, "Remove connection attributes for domain.server '" + string + "." + string2);
        String string3 = "Domain." + string + "." + string2 + ".";
        PluginSupport.deleteProfileString(string3 + SERVER_TYPE);
        PluginSupport.deleteProfileString(string3 + SERVER_USER);
        PluginSupport.deleteProfileString(string3 + SERVER_PWD);
        PluginSupport.deleteProfileString(string3 + SERVER_CHARSET);
        PluginSupport.deleteProfileString(string3 + SERVER_LANG);
        PluginSupport.deleteProfileString(string3 + SERVER_HOST);
        PluginSupport.deleteProfileString(string3 + SERVER_PORT);
        RSConnAttributes.remove(string, string2);
        HDSConnAttributes.remove(string, string2);
    }

    public boolean equals(ConnAttributes connAttributes) {
        boolean bl = false;
        if (connAttributes != null) {
            bl = this.getType().equals(connAttributes.getType()) && this.getServer().equals(connAttributes.getServer()) && this.getUser().equals(connAttributes.getUser()) && this.getCharset().equals(connAttributes.getCharset()) && this.getLanguage().equals(connAttributes.getLanguage()) && this.getHost().equals(connAttributes.getHost()) && this.getPort().equals(connAttributes.getPort());
        }
        return bl;
    }

    public List toList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getType());
        arrayList.add(this.getUser());
        arrayList.add(this.getPassword());
        arrayList.add(this.getCharset());
        arrayList.add(this.getLanguage());
        return arrayList;
    }

    public String toString() {
        return CollectionUtility.toString(this.toList(), ",");
    }

    public String toFormattedString() {
        String string;
        String string2 = "";
        string2 = this.getType() != null && this.getType().length() > 0 && this.getServer() != null && this.getServer().length() > 0 ? string2 + this.getType() + " '" + this.getServer() + "'\n" : string2 + "\n";
        string2 = string2 + "\t" + BundleManager.getString("ProviderRes", "ATTR_SUMMARY_USER", this.getUser()) + "\n";
        if (this.getAddress() != null && this.getAddress().length() > 0) {
            string2 = string2 + "\t" + BundleManager.getString("ProviderRes", "ATTR_SUMMARY_CONN", this.getAddress()) + "\n";
        }
        if ((string = this.getCharset()) == null) {
            string = "default";
        }
        string2 = string2 + "\t" + BundleManager.getString("ProviderRes", "ATTR_SUMMARY_CHARSET", string) + "\n";
        string = this.getLanguage();
        if (string == null) {
            string = "default";
        }
        string2 = string2 + "\t" + BundleManager.getString("ProviderRes", "ATTR_SUMMARY_LANGUAGE", string) + "\n";
        return string2;
    }

    public String getAddress() {
        String string = "";
        if (this.isAddressSavedLocally()) {
            string = this.getHost() + ADDRESS_SEPARATOR + this.getPort();
        } else {
            try {
                ServerInterfaces serverInterfaces = new ServerInterfaces();
                String string2 = serverInterfaces.getHostName(this.getServer());
                String string3 = serverInterfaces.getPortNumber(this.getServer());
                string = string2 + ADDRESS_SEPARATOR + string3;
            }
            catch (Exception exception) {
                PluginSupport.LogErrorMessage(exception.getMessage(), exception.getMessage());
            }
        }
        return string;
    }

    public String getType() {
        return this._type;
    }

    public String getDisplayTypeName() {
        for (int i = 0; i < TYPE_LIST.length; ++i) {
            if (!this.getType().equals(TYPE_LIST[i])) continue;
            return TYPE_NAME_LIST[i];
        }
        Dbg.wassert(false, "The type lists are out of order.");
        return "";
    }

    public void setTypeFromDisplayName(String string) {
        for (int i = 0; i < TYPE_NAME_LIST.length; ++i) {
            if (!TYPE_NAME_LIST[i].equals(string)) continue;
            this.setType(TYPE_LIST[i]);
        }
    }

    public void setType(String string) {
        Dbg.wassert(string.equalsIgnoreCase("Replication Server") || string.equalsIgnoreCase(ASE_SERVER) || string.equalsIgnoreCase(SA_SERVER) || string.equalsIgnoreCase(IQ_SERVER) || string.equalsIgnoreCase("Replication Agent") || string.equalsIgnoreCase("Mirror Replication Agent") || string.equalsIgnoreCase(DC_SERVER) || string.equalsIgnoreCase("Open Server") || string.equalsIgnoreCase(DB_LTM) || string.equalsIgnoreCase(ORACLE_SERVER) || string.equalsIgnoreCase(MICROSOFT_SERVER) || string.equalsIgnoreCase(UDB_SERVER) || string.equalsIgnoreCase(INFORMIX_SERVER) || string.equalsIgnoreCase(RMS_SERVER), "'" + string + "' is not a valid Server Type");
        this._type = string;
    }

    public String getServer() {
        return this._server;
    }

    public void setServer(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty server name parameter.");
        this._server = string;
    }

    public String getUser() {
        return this._username;
    }

    public void setUser(String string) {
        this._username = string;
    }

    public String getPassword() {
        return this._password == null ? "" : this._password;
    }

    public void setPassword(String string) {
        this._password = string;
    }

    public String getCharset() {
        return this._charset == null ? "" : this._charset;
    }

    public void setCharset(String string) {
        String string2;
        this._charset = string != null ? ((string2 = string.trim()).equalsIgnoreCase("default") ? "" : string2) : "";
    }

    public String getLanguage() {
        return this._language == null ? "" : this._language;
    }

    public void setLanguage(String string) {
        String string2;
        this._language = string != null ? ((string2 = string.trim()).equalsIgnoreCase("default") ? "" : string2) : "";
    }

    public String getHost() {
        return this._host == null ? "" : this._host;
    }

    public void setHost(String string) {
        this._host = string;
    }

    public String getPort() {
        return this._port == null ? "" : this._port;
    }

    public void setPort(String string) {
        this._port = string;
    }

    public boolean isAddressSavedLocally() {
        return this._saveAddressLocally;
    }

    public void setSaveAddress(boolean bl) {
        this._saveAddressLocally = bl;
    }
}

