/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.sql;

import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.sql.ASAConnection;
import com.sybase.rsmplugin.sql.ASEConnection;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.DCConnection;
import com.sybase.rsmplugin.sql.MRAConnection;
import com.sybase.rsmplugin.sql.RAConnection;
import com.sybase.rsmplugin.sql.RMSConnection;
import com.sybase.rsmplugin.sql.RSConnAttributes;
import com.sybase.rsmplugin.sql.RSConnection;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Timer;
import java.util.TimerTask;

public class ConnectionManager {
    private static ConnectionManager _mgr = null;
    private List _connList = null;
    Timer _fadeoutTimer;
    private static final int FADEOUT_LIMIT = 900;
    private static final int FADEOUT_INTERVAL = 300000;
    public static final String NUM_CONN_PROFILE_KEY = "MaxConnections";
    public static final int MIN_NUM_CONNECTIONS = 10;
    public static final int MAX_NUM_CONNECTIONS = 35;
    private static int _maxConnections = -1;

    public static int getVersionNumber(ConnAttributes connAttributes) {
        Dbg.wassert(connAttributes != null, "Null connection attributes parameter.");
        if (_mgr == null) {
            _mgr = new ConnectionManager();
        }
        return _mgr.getVersionNr(connAttributes);
    }

    public static RSMConnection getConnection(ConnAttributes connAttributes) {
        RSMConnection rSMConnection;
        Dbg.wassert(connAttributes != null, "Null connection attributes parameter.");
        if (_mgr == null) {
            _mgr = new ConnectionManager();
        }
        if ((rSMConnection = _mgr.get(connAttributes)) == null) {
            rSMConnection = _mgr.add(connAttributes, true);
        }
        return rSMConnection;
    }

    public static void dropConnection(ConnAttributes connAttributes) {
        Dbg.wassert(connAttributes != null, "Null connection attributes parameter.");
        if (_mgr == null) {
            _mgr = new ConnectionManager();
        }
        _mgr.drop(connAttributes);
    }

    public static RSMConnection testConnection(ConnAttributes connAttributes) {
        Dbg.wassert(connAttributes != null, "Null connection attributes parameter.");
        if (_mgr == null) {
            _mgr = new ConnectionManager();
        }
        return _mgr.createConnection(connAttributes, false);
    }

    public static int getMaxConnections() {
        if (_maxConnections == -1 && (_maxConnections = PluginSupport.readProfileInt(NUM_CONN_PROFILE_KEY)) < 10) {
            _maxConnections = 10;
            ConnectionManager.setMaxConnections(_maxConnections);
        }
        return _maxConnections;
    }

    public static void setMaxConnections(int n) {
        if (n < 10) {
            n = 10;
        } else if (n > 35) {
            n = 35;
        }
        if (n != _maxConnections) {
            _maxConnections = n;
            PluginSupport.writeProfileInt(NUM_CONN_PROFILE_KEY, _maxConnections);
        }
    }

    protected ConnectionManager() {
        ArrayList arrayList = new ArrayList(ConnectionManager.getMaxConnections());
        this._connList = Collections.synchronizedList(arrayList);
        this._fadeoutTimer = new Timer(true);
        TimerTask timerTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (ConnectionManager.this._connList != null) {
                    ListIterator listIterator = ConnectionManager.this._connList.listIterator();
                    while (listIterator.hasNext()) {
                        RSMConnection rSMConnection;
                        RSMConnection rSMConnection2 = rSMConnection = (RSMConnection)listIterator.next();
                        synchronized (rSMConnection2) {
                            if (!rSMConnection.getType().equals("RMS")) {
                                boolean bl = false;
                                if (!rSMConnection.isConnectionOpen()) {
                                    bl = true;
                                } else if (!rSMConnection.isLocked() && rSMConnection.getLastAccessedTime() > 900L) {
                                    bl = true;
                                }
                                if (bl) {
                                    rSMConnection.close();
                                    listIterator.remove();
                                    rSMConnection.unlock();
                                    Dbg.trace(24576, "Connection to server '" + rSMConnection.getServerName() + "' is inactive and has been dropped.");
                                }
                            }
                        }
                    }
                }
            }
        };
        this._fadeoutTimer.schedule(timerTask, 300000L, 300000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        this._fadeoutTimer.cancel();
        try {
            ListIterator listIterator = this._connList.listIterator();
            while (listIterator.hasNext()) {
                RSMConnection rSMConnection = (RSMConnection)listIterator.next();
                rSMConnection.getConnection().close();
            }
            this._connList.clear();
            _mgr = null;
        }
        finally {
            super.finalize();
        }
    }

    protected int getVersionNr(ConnAttributes connAttributes) {
        RSMConnection rSMConnection;
        int n = -1;
        ListIterator listIterator = this._connList.listIterator();
        while (listIterator.hasNext()) {
            rSMConnection = (RSMConnection)listIterator.next();
            if (!connAttributes.equals(rSMConnection.getAttributes())) continue;
            n = rSMConnection.getVersionNumber();
            break;
        }
        if (n == -1 && (rSMConnection = this.add(connAttributes, false)) != null) {
            n = rSMConnection.getVersionNumber();
        }
        return n;
    }

    protected RSMConnection get(ConnAttributes connAttributes) {
        Dbg.trace(8192, "Get the connection to the server '" + connAttributes.getServer() + "'. " + Thread.currentThread().getName());
        ListIterator listIterator = this._connList.listIterator();
        while (listIterator.hasNext()) {
            RSMConnection rSMConnection = (RSMConnection)listIterator.next();
            if (!connAttributes.equals(rSMConnection.getAttributes())) continue;
            this.lock(rSMConnection);
            Dbg.trace(8192, "Connection to the server '" + connAttributes.getServer() + "' is locked.");
            return rSMConnection;
        }
        return null;
    }

    protected void lock(RSMConnection rSMConnection) {
        while (rSMConnection.isLocked()) {
            Dbg.trace(24576, "Connection to the server '" + rSMConnection.getServerName() + "' is locked by another thread. " + rSMConnection.getOwningThread());
            try {
                rSMConnection.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {}
        }
        rSMConnection.lock();
    }

    protected RSMConnection add(ConnAttributes connAttributes, boolean bl) {
        RSMConnection rSMConnection = null;
        rSMConnection = this.createConnection(connAttributes, bl);
        if (rSMConnection != null) {
            this._connList.add(rSMConnection);
        }
        return rSMConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drop(ConnAttributes connAttributes) {
        RSMConnection rSMConnection = this.get(connAttributes);
        if (rSMConnection != null) {
            Object object = rSMConnection;
            synchronized (object) {
                rSMConnection.close();
                this._connList.remove(rSMConnection);
                rSMConnection.unlock();
                Dbg.trace(24576, "Connection to server '" + connAttributes.getServer() + "' has been dropped.");
            }
            if (rSMConnection.getType().equals("RMS")) {
                object = this._connList.listIterator();
                while (object.hasNext()) {
                    RSMConnection rSMConnection2 = (RSMConnection)object.next();
                    String string = rSMConnection2.getControllingRMS();
                    if (string == null || !string.equals(rSMConnection.getType())) continue;
                    this.lock(rSMConnection2);
                    RSMConnection rSMConnection3 = rSMConnection;
                    synchronized (rSMConnection3) {
                        rSMConnection2.close();
                        object.remove();
                        rSMConnection2.unlock();
                        Dbg.trace(24576, "Connection to server '" + rSMConnection2.getServerName() + "' has been dropped.");
                    }
                }
            }
        }
    }

    protected RSMConnection createConnection(ConnAttributes connAttributes, boolean bl) {
        Dbg.trace(8192, "Create a connection to the server '" + connAttributes.getServer() + "'.");
        RSMConnection rSMConnection = null;
        if (connAttributes.getType().equals("RMS")) {
            rSMConnection = new RMSConnection(connAttributes);
        } else if (connAttributes.getType().equals("Replication Server")) {
            rSMConnection = new RSConnection((RSConnAttributes)connAttributes);
        } else if (connAttributes.getType().equals("ASE")) {
            rSMConnection = new ASEConnection(connAttributes);
        } else if (connAttributes.getType().equals("ASA")) {
            rSMConnection = new ASAConnection(connAttributes);
        } else if (connAttributes.getType().equals("DirectConnect")) {
            rSMConnection = new DCConnection(connAttributes);
        } else if (connAttributes.getType().equals("Replication Agent")) {
            rSMConnection = new RAConnection(connAttributes);
        } else if (connAttributes.getType().equals("Mirror Replication Agent")) {
            rSMConnection = new MRAConnection(connAttributes);
        } else if (!(connAttributes.getType().equals("Oracle") || connAttributes.getType().equals("MSSS") || connAttributes.getType().equals("UDB") || connAttributes.getType().equals("Informix"))) {
            Dbg.wassert(false, "Invalid server type parameter.");
        }
        if (bl) {
            rSMConnection.lock();
        }
        try {
            ((RSMConnection)rSMConnection).open();
        }
        catch (SQLException sQLException) {
            PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
        return rSMConnection;
    }
}

