/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.sql;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;

public class DCConnection
extends RSMConnection {
    public static final int DURGA_VERSION_NR = 1260;
    public static final int ZIRA_VERSION_NR = 1500;
    public static final int MINIMUM_VERSION_NR = 1260;
    public static final String MINIMUM_VERSION_NR_STR = "12.6";
    private static final String VERSION_PRODUCT_NAME = "Mirror Replication Agent";
    protected String _versionNr = null;
    protected String _versionString = null;

    public DCConnection(ConnAttributes connAttributes) {
        super(connAttributes);
    }

    @Override
    public synchronized void open() throws SQLException {
        this._props.put("SERVICENAME", this.getServerName());
        try {
            super.open();
        }
        catch (SQLException sQLException) {
            if (this.getState() == 5) {
                this.setReason(BundleManager.getString("ProviderRes", "INVALID_ASE_SERVER"));
                throw new SQLException(this.getReason(), "_RSM_", 1);
            }
            throw sQLException;
        }
        try {
            this.initServerVersion();
        }
        catch (SQLException sQLException) {
            this.close();
            this.setState(5);
            this.setReason(BundleManager.getString("ProviderRes", "ERR_DC_QUERY_FAILED"));
            throw new SQLException(this.getReason(), "_RSM_", 13);
        }
    }

    @Override
    public String getDisplayVersionNumber() {
        return this._versionNr;
    }

    @Override
    public int getVersionNumber() {
        if (this._versionNr != null && this._versionNr.length() > 0) {
            return MessageText.toVersionNr(this._versionNr, 5);
        }
        return 1260;
    }

    @Override
    public String getVersionString() {
        return this._versionString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initServerVersion() throws SQLException {
        RSMResultSet rSMResultSet = new RSMResultSet(this);
        try {
            rSMResultSet.open("select @@version");
            if (rSMResultSet.getNextRow()) {
                this._versionString = rSMResultSet.getColumnString(1);
                String string = this._versionString = this._versionString.trim();
                if (!(string = string.toUpperCase()).startsWith("DIRECTCONNECT")) {
                    this._versionString = null;
                    return;
                }
                if (this._versionString != null) {
                    if (this._versionString.length() > 0) {
                        if (PluginSupport.logSQL()) {
                            Object[] objectArray = new String[]{this.getType(), this.getServerName(), this._versionString};
                            String string2 = BundleManager.getString("ProviderRes", "VERSION_STRING_HDR", objectArray);
                            PluginSupport.LogInfoMessage(string2, string2);
                        }
                    } else {
                        this._versionString = null;
                    }
                }
            }
        }
        finally {
            rSMResultSet.close();
        }
    }
}

