/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.sql;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.Version;
import com.sybase.rsmplugin.sql.ASAConnection;
import com.sybase.rsmplugin.sql.ASEConnection;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.ConnectionManager;
import com.sybase.rsmplugin.sql.Domain;
import com.sybase.rsmplugin.sql.HDSConnAttributes;
import com.sybase.rsmplugin.sql.RSConnAttributes;
import com.sybase.rsmplugin.sql.RSConnection;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.sql.SQLScript;
import com.sybase.rsmplugin.sql.ServerInterfaces;
import com.sybase.rsmplugin.status.EnvFilterManager;
import com.sybase.rsmplugin.status.MonitorTimer;
import com.sybase.rsmplugin.status.StatusSO;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;

public class EnvDomain
implements Domain {
    public static final String DOMAIN_LIST_KEY = "DomainList";
    public static final String DOMAIN_USER = "User";
    public static final String DOMAIN_PASSWORD = "Password";
    private static final String MONITORING = "Monitoring";
    private static final String MONITOR_INTERVAL = "MonitorInterval";
    private static final String SCRIPT_VERSION_SP = "rmp_proc_version";
    public static final int MONITOR_DEFAULT_INTERVAL = 60;
    public static final int MONITOR_MINIMUM_INTERVAL = 10;
    public static final int MONITOR_MAXIMUM_INTERVAL = 25000;
    private String _domainName = null;
    private List _attributeList;
    private String _username = "";
    private String _password = "";
    private MonitorTimer _timer = null;
    private int _monitorInterval = 60;
    private boolean _monitoring = true;
    private Date _lastMonitored = null;
    private EnvFilterManager _connFilter = null;

    public EnvDomain(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty domain name parameter.");
        this._domainName = string;
        this._connFilter = new EnvFilterManager(this);
        ArrayList arrayList = new ArrayList();
        this._attributeList = Collections.synchronizedList(arrayList);
    }

    public static List getDomains() {
        List list = PluginSupport.readProfileStringList(DOMAIN_LIST_KEY);
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    @Override
    public void save() {
        List list = EnvDomain.getDomains();
        Dbg.wassert(list != null, "Unexpected null List. This List should not be null.");
        boolean bl = false;
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext() && !bl) {
            bl = listIterator.next().toString().equals(this.getName());
        }
        if (!bl) {
            list.add(this.getName());
            PluginSupport.writeProfileStringList(DOMAIN_LIST_KEY, list);
        }
        this.saveUsername();
        this.savePassword();
        this.saveMonitorInterval();
        this.saveMonitoringFlag();
        Dbg.trace(1, "Add environment '" + this.getName() + "' to the SC repository.");
    }

    public void delete() {
        if (this._timer != null) {
            this.stopMonitor();
        }
        this.deleteUsername();
        this.deletePassword();
        this.deleteMonitoringFlag();
        this.deleteMonitorInterval();
        this.getFilterManager().delete();
        this.deleteAllServers();
        List list = EnvDomain.getDomains();
        Dbg.wassert(list != null, "Unexpected null List. This List should not be null.");
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            if (!listIterator.next().toString().equals(this.getName())) continue;
            listIterator.remove();
            PluginSupport.writeProfileStringList(DOMAIN_LIST_KEY, list);
            break;
        }
        if (!listIterator.hasNext() && !listIterator.hasPrevious()) {
            PluginSupport.deleteProfileString(DOMAIN_LIST_KEY);
        }
        Dbg.trace(1, "Remove environment '" + this.getName() + "' from the SC repository.");
    }

    public boolean load() {
        Dbg.trace(1, "Load environment '" + this.getName() + "'");
        boolean bl = false;
        this.loadUsername();
        if (this.getUsername() != null && this.getUsername().length() > 0) {
            bl = true;
            this.loadPassword();
            this.loadMonitorInterval();
            this.loadMonitoringFlag();
        }
        return bl;
    }

    public void connect(String string, String string2) throws SQLException {
        Dbg.trace(1, "Connect to environment '" + this.getName() + "'");
        if (this.load()) {
            if (!this.getUsername().equals(string) || !this.getPassword().equals(string2)) {
                throw new SQLException(BundleManager.getString("ProviderRes", "SRV_LOGIN_FAILED", this.getName()));
            }
        } else {
            throw new SQLException(BundleManager.getString("DomainRes", "ERR_DOMAIN_LOAD", this.getName()));
        }
        PluginSupport.registerDomain(this);
        this.loadServers(true);
        this.startMonitor();
    }

    @Override
    public void disconnect() {
        if (this._timer != null) {
            this.stopMonitor();
        }
        ListIterator listIterator = this._attributeList.listIterator();
        while (listIterator.hasNext()) {
            ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
            ConnectionManager.dropConnection(connAttributes);
        }
        PluginSupport.unregisterDomain(this);
    }

    @Override
    public boolean isEnvironment() {
        return true;
    }

    @Override
    public boolean isRMS() {
        return false;
    }

    @Override
    public String getName() {
        Dbg.wassert(this._domainName != null && this._domainName.length() > 0, "Null or empty domain name attribute.");
        return this._domainName;
    }

    @Override
    public String getDescription() {
        return BundleManager.getString("DomainRes", "ENV_DOMAIN_DESC");
    }

    public String toString() {
        String string = this.getName() + ": ";
        ListIterator listIterator = this._attributeList.listIterator();
        while (listIterator.hasNext()) {
            ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
            string = string + connAttributes.getServer() + ", ";
            if (!connAttributes.getType().equals("Replication Server")) continue;
            string = string + ((RSConnAttributes)connAttributes).getRSSD().getServer() + ", ";
        }
        return string;
    }

    public String toFormattedString() {
        String string = BundleManager.getString("DomainRes", "DOMAIN_SUMMARY_NAME", this.getName()) + "\n";
        if (this._attributeList != null) {
            ListIterator listIterator = this._attributeList.listIterator();
            while (listIterator.hasNext()) {
                ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
                string = string + connAttributes.toFormattedString();
            }
        }
        return string;
    }

    public String getUsername() {
        Dbg.wassert(this._username != null, "Null username attribute.");
        return this._username;
    }

    public void setUsername(String string) {
        this._username = string == null ? "" : string;
    }

    protected void loadUsername() {
        String string = "Domain." + this.getName() + "." + DOMAIN_USER;
        String string2 = PluginSupport.readProfileString(string);
        this._username = string2 == null ? "" : string2;
    }

    protected void saveUsername() {
        String string = "Domain." + this.getName() + "." + DOMAIN_USER;
        PluginSupport.writeProfileString(string, this._username);
    }

    protected void deleteUsername() {
        String string = "Domain." + this.getName() + "." + DOMAIN_USER;
        PluginSupport.deleteProfileString(string);
    }

    public String getPassword() {
        Dbg.wassert(this._password != null, "Null password attribute.");
        return this._password;
    }

    public void setPassword(String string) {
        this._password = string == null ? "" : string;
    }

    protected void loadPassword() {
        String string = "Domain." + this.getName() + "." + DOMAIN_PASSWORD;
        String string2 = PluginSupport.readProfileStringEncrypted(string);
        this._password = string2 == null || string2.equals("__XSRO__") ? "" : string2;
    }

    protected void savePassword() {
        String string = this._password;
        if (string == null || string.length() == 0) {
            string = "__XSRO__";
        }
        String string2 = "Domain." + this.getName() + "." + DOMAIN_PASSWORD;
        PluginSupport.writeProfileStringEncrypted(string2, string);
    }

    protected void deletePassword() {
        String string = "Domain." + this.getName() + "." + DOMAIN_PASSWORD;
        PluginSupport.deleteProfileString(string);
    }

    public int getMonitorInterval() {
        Dbg.wassert(this._monitorInterval > 0, "Negitive monitoring interval.");
        return this._monitorInterval;
    }

    public void setMonitorInterval(int n) {
        Dbg.wassert(n > 0, "Negitive monitor interval parameter.");
        if (this._monitorInterval != n) {
            this._monitorInterval = n < 10 || n > 25000 ? 60 : n;
            if (this._timer == null) {
                this.startMonitor();
            }
            this._timer.setInterval(this._monitorInterval);
        }
    }

    protected void loadMonitorInterval() {
        String string = "Domain." + this.getName() + "." + MONITOR_INTERVAL;
        this._monitorInterval = PluginSupport.readProfileInt(string);
        if (this._monitorInterval < 10 || this._monitorInterval > 25000) {
            this._monitorInterval = 60;
        }
    }

    protected void saveMonitorInterval() {
        String string = "Domain." + this.getName() + "." + MONITOR_INTERVAL;
        PluginSupport.writeProfileInt(string, this._monitorInterval);
    }

    protected void deleteMonitorInterval() {
        String string = "Domain." + this.getName() + "." + MONITOR_INTERVAL;
        PluginSupport.deleteProfileString(string);
    }

    public boolean isMonitoring() {
        return this._monitoring;
    }

    public void setMonitoring(boolean bl) {
        if (this._monitoring != bl) {
            this._monitoring = bl;
            if (this._timer == null) {
                this.startMonitor();
            }
            this._timer.setMonitoring(this._monitoring);
        }
    }

    protected void loadMonitoringFlag() {
        String string = "Domain." + this.getName() + "." + MONITORING;
        this._monitoring = PluginSupport.readProfileBoolean(string, this._monitoring);
    }

    protected void saveMonitoringFlag() {
        String string = "Domain." + this.getName() + "." + MONITORING;
        PluginSupport.writeProfileBoolean(string, this._monitoring);
    }

    protected void deleteMonitoringFlag() {
        String string = "Domain." + this.getName() + "." + MONITORING;
        PluginSupport.deleteProfileString(string);
    }

    public Date getLastMonitoredDate() {
        return this._lastMonitored;
    }

    public void setLastMonitoredDate(Date date) {
        this._lastMonitored = date;
    }

    @Override
    public synchronized void refreshStatus() {
        if (this._timer == null) {
            this.startMonitor();
        }
        this._timer.refreshStatus();
    }

    public StatusSO getStatus(String string, String string2) {
        if (this._timer == null) {
            this.startMonitor();
        }
        return this._timer.getStatus(string, string2);
    }

    protected void startMonitor() {
        if (this._timer == null) {
            this._timer = new MonitorTimer(this, this.isMonitoring(), this.getMonitorInterval());
            this._timer.start();
        }
    }

    protected void stopMonitor() {
        if (this._timer != null) {
            this._timer.end();
            this._timer = null;
        }
    }

    public EnvFilterManager getFilterManager() {
        return this._connFilter;
    }

    @Override
    public void addServer(ConnAttributes connAttributes) {
        Dbg.wassert(connAttributes != null, "Null attributes parameter.");
        if (this.getServer(connAttributes.getServer()) == null) {
            String string;
            ArrayList<String> arrayList;
            this._attributeList.add(connAttributes);
            if (connAttributes.getType().equals("Replication Server")) {
                try {
                    this.installRSSDScripts(connAttributes.getServer(), false, true);
                }
                catch (SQLException sQLException) {
                    PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
            }
            if ((arrayList = PluginSupport.readProfileStringList(string = "Domain." + this.getName())) == null) {
                arrayList = new ArrayList<String>(1);
            }
            arrayList.add(connAttributes.getServer());
            PluginSupport.writeProfileStringList(string, arrayList);
            connAttributes.save(this.getName());
            Dbg.trace(1, "Add Server '" + connAttributes.getServer() + "' to environment '" + this.getName() + "' to the SC Repository.");
        }
    }

    @Override
    public void deleteServer(String string) {
        Object object;
        Object object2;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty server parameter.");
        ListIterator listIterator = this._attributeList.listIterator();
        while (listIterator.hasNext()) {
            object2 = (ConnAttributes)listIterator.next();
            if (!((ConnAttributes)object2).getServer().equals(string)) continue;
            if (((ConnAttributes)object2).getType().equals("Replication Server")) {
                object = ((RSConnAttributes)object2).getRSSD();
                ConnectionManager.dropConnection((ConnAttributes)object);
            }
            ConnectionManager.dropConnection((ConnAttributes)object2);
            ConnAttributes.remove(this.getName(), string);
            listIterator.remove();
            break;
        }
        if ((object = PluginSupport.readProfileStringList((String)(object2 = "Domain." + this.getName()))) != null) {
            ListIterator listIterator2 = object.listIterator();
            while (listIterator2.hasNext()) {
                String string2 = (String)listIterator2.next();
                if (!string2.equals(string)) continue;
                listIterator2.remove();
                PluginSupport.writeProfileStringList((String)object2, (List)object);
                Dbg.trace(1, "Delete Server '" + string + "' from environment '" + this.getName() + "' from the SC Repository.");
                break;
            }
        }
        if (!listIterator.hasNext() && !listIterator.hasPrevious()) {
            PluginSupport.deleteProfileString((String)object2);
        }
    }

    protected void deleteAllServers() {
        Object object;
        ListIterator listIterator = this._attributeList.listIterator();
        while (listIterator.hasNext()) {
            object = (ConnAttributes)listIterator.next();
            if (((ConnAttributes)object).getType().equals("Replication Server")) {
                ConnectionManager.dropConnection(((RSConnAttributes)object).getRSSD());
            }
            ConnectionManager.dropConnection((ConnAttributes)object);
            listIterator.remove();
        }
        object = "Domain." + this.getName();
        List list = PluginSupport.readProfileStringList((String)object);
        if (list != null) {
            ListIterator listIterator2 = list.listIterator();
            while (listIterator2.hasNext()) {
                String string = listIterator2.next().toString();
                ConnAttributes.remove(this.getName(), string);
            }
        }
        object = "Domain." + this.getName();
        PluginSupport.deleteProfileString((String)object);
    }

    public void alterServer(ConnAttributes connAttributes) {
        Dbg.wassert(connAttributes != null, "Null attributes parameter.");
        if (this.getServer(connAttributes.getServer()) != null) {
            this.deleteServer(connAttributes.getServer());
            this.addServer(connAttributes);
        }
    }

    public ConnAttributes getServer(String string) {
        ListIterator listIterator = this._attributeList.listIterator();
        while (listIterator.hasNext()) {
            ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
            if (!connAttributes.getServer().equals(string)) continue;
            return connAttributes;
        }
        return null;
    }

    public ConnAttributes getRSSDServer(String string) {
        ConnAttributes connAttributes = null;
        ConnAttributes connAttributes2 = this.getServer(string);
        if (connAttributes2 != null && connAttributes2 instanceof RSConnAttributes) {
            connAttributes = ((RSConnAttributes)connAttributes2).getRSSD();
        }
        return connAttributes;
    }

    protected void loadServers(boolean bl) {
        Object object;
        Object object2;
        Object object3;
        String string = "Domain." + this.getName();
        List list = PluginSupport.readProfileStringList(string);
        if (list != null) {
            object3 = list.listIterator();
            while (object3.hasNext()) {
                object2 = object3.next().toString();
                if (object2 == null || ((String)object2).length() <= 0) continue;
                object = ConnAttributes.load(this.getName(), object2);
                this._attributeList.add(object);
                if (object == null || !((ConnAttributes)object).getType().equals("Replication Server") || !bl) continue;
                try {
                    this.installRSSDScripts(((ConnAttributes)object).getServer(), false, true);
                }
                catch (SQLException sQLException) {
                    PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
            }
        }
        object3 = new ArrayList();
        object2 = this._attributeList.listIterator();
        while (object2.hasNext()) {
            object = (ConnAttributes)object2.next();
            if (!((ConnAttributes)object).getType().equals("DirectConnect")) continue;
            ((ArrayList)object3).add(((ConnAttributes)object).getServer());
        }
        object2 = ((ArrayList)object3).listIterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            this.deleteServer((String)object);
        }
    }

    @Override
    public List getServerNames() {
        return this.getServerNames("*");
    }

    public List getASEServerNames() {
        return this.getServerNames("ASE");
    }

    public List getHDSNames() {
        List list = this.getServerNames("Oracle");
        list.addAll(this.getServerNames("MSSS"));
        list.addAll(this.getServerNames("UDB"));
        list.addAll(this.getServerNames("Informix"));
        return list;
    }

    public List getRepServerNames() {
        return this.getServerNames("Replication Server");
    }

    public List getLANRepAgentServerNames() {
        return this.getServerNames("Replication Agent");
    }

    public List getMirrorRepAgentServerNames() {
        return this.getServerNames("Mirror Replication Agent");
    }

    public List getDirectConnectServerNames() {
        return this.getServerNames("DirectConnect");
    }

    protected List getServerNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ListIterator listIterator = this._attributeList.listIterator();
        while (listIterator.hasNext()) {
            ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
            if (!string.equals("*") && !string.equals(connAttributes.getType())) continue;
            arrayList.add(connAttributes.getServer());
        }
        return arrayList;
    }

    @Override
    public boolean isPartofDomain(String string) {
        boolean bl = false;
        if (string != null && string.length() > 0) {
            bl = this.getServer(string) != null;
        }
        return bl;
    }

    public void installRSSDScripts(String string, boolean bl) throws SQLException {
        this.installRSSDScripts(string, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installRSSDScripts(String string, boolean bl, boolean bl2) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null Rep Server name parameter.");
        RSConnection rSConnection = (RSConnection)this.getConnection(string);
        if (rSConnection != null) {
            int n = rSConnection.getVersionNumber();
            rSConnection.unlock();
            if (bl) {
                this.loadScript(string, n);
            } else {
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                RSMConnection rSMConnection = this.getRSSD(string);
                if (rSMConnection != null) {
                    RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
                    try {
                        if (this.isRSSDScriptInstalled(rSMConnection)) {
                            rSMResultSet.open(SCRIPT_VERSION_SP);
                            if (rSMResultSet.getNextRow()) {
                                n2 = rSMResultSet.getColumnInt(1);
                                n3 = rSMResultSet.getColumnInt(2);
                                n4 = rSMResultSet.getColumnInt(3);
                                Dbg.trace(4, "rmp_proc_version results: RMP Version '" + String.valueOf(n2) + "'," + " RMP Revision '" + String.valueOf(n3) + "'," + " Rep Server Script Version '" + String.valueOf(n4) + "'");
                            }
                        }
                    }
                    finally {
                        rSMResultSet.close();
                        rSMConnection.unlock();
                    }
                    if (bl2) {
                        String string2;
                        if ((n != n4 || n2 != Version.getVersionNumber() || n3 != Version.getScriptRevision()) && PluginSupport.askQuestion(string2 = BundleManager.getString("DomainRes", "INSTALL_RSM_SCRIPTS", string), false)) {
                            this.loadScript(string, n);
                        }
                    } else if (n != n4 || n2 != Version.getVersionNumber() || n3 != Version.getScriptRevision()) {
                        this.loadScript(string, n);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRSSDScriptInstalled(RSMConnection rSMConnection) throws SQLException {
        Dbg.wassert(rSMConnection != null, "Null RSSD connection parameter.");
        boolean bl = false;
        RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
        String string = "select name from sysobjects where name = 'rmp_proc_version' and type = 'P'";
        try {
            String string2;
            rSMResultSet.open(string);
            if (rSMResultSet.getNextRow() && (string2 = rSMResultSet.getColumnString(1)) != null && string2.equals(SCRIPT_VERSION_SP)) {
                bl = true;
            }
        }
        finally {
            rSMResultSet.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadScript(String string, int n) throws SQLException {
        RSMConnection rSMConnection = this.getRSSD(string);
        if (rSMConnection != null) {
            try {
                PluginSupport.getViewerSupport().startWait();
                String string2 = "rmp" + String.valueOf(n) + ".sql";
                SQLScript sQLScript = new SQLScript();
                sQLScript.execute(rSMConnection, string2);
            }
            finally {
                rSMConnection.unlock();
                PluginSupport.getViewerSupport().endWait();
            }
        }
    }

    @Override
    public List getServerKeys() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        ListIterator listIterator = this._attributeList.listIterator();
        while (listIterator.hasNext()) {
            ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
            String[] stringArray = new String[]{this.getName(), connAttributes.getServer(), connAttributes.getType()};
            arrayList.add(stringArray);
        }
        return arrayList;
    }

    public RSMConnection getConnection(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty server parameter.");
        RSMConnection rSMConnection = null;
        ConnAttributes connAttributes = this.getServer(string);
        if (connAttributes != null) {
            if (connAttributes instanceof HDSConnAttributes) {
                connAttributes = ((HDSConnAttributes)connAttributes).getInterface();
            }
            rSMConnection = ConnectionManager.getConnection(connAttributes);
        }
        return rSMConnection;
    }

    public RSMConnection getRSSD(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        RSMConnection rSMConnection = null;
        ConnAttributes connAttributes = this.getServer(string);
        if (connAttributes != null) {
            Dbg.wassert(connAttributes.getType().equals("Replication Server"), "Incorrect connection attribute found. Expecting Rep Server.");
            Dbg.wassert(connAttributes instanceof RSConnAttributes, "Incorrect connection attribute found. Expecting an RSConnAttribute.");
            ConnAttributes connAttributes2 = ((RSConnAttributes)connAttributes).getRSSD();
            RSConnection rSConnection = (RSConnection)ConnectionManager.getConnection(connAttributes);
            String string2 = rSConnection.getRSSD();
            rSConnection.unlock();
            if (string2 != null && string2.length() > 0) {
                try {
                    if (connAttributes2.getType().equals("ASE")) {
                        rSMConnection = ConnectionManager.getConnection(connAttributes2);
                        ((ASEConnection)rSMConnection).use(string2);
                    } else {
                        rSMConnection = ConnectionManager.getConnection(connAttributes2);
                        ((ASAConnection)rSMConnection).use(string2);
                    }
                }
                catch (SQLException sQLException) {
                    PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
            }
        }
        return rSMConnection;
    }

    public int getVersionNumber(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty server parameter.");
        int n = 0;
        ConnAttributes connAttributes = this.getServer(string);
        if (connAttributes != null) {
            n = ConnectionManager.getVersionNumber(connAttributes);
        }
        return n;
    }

    @Override
    public List getAvailableServers() throws Exception {
        ServerInterfaces serverInterfaces = new ServerInterfaces();
        return serverInterfaces.getAllServerNames();
    }
}

