/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.sql;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.util.Dbg;
import java.util.ArrayList;
import java.util.List;

public class HDSConnAttributes
extends ConnAttributes {
    public static final String[] INTERFACE_SERVER_LIST = new String[]{"Replication Agent", "Mirror Replication Agent", "DirectConnect Service"};
    protected static final String INTERFACE_PREFIX = "Interface";
    protected static final String HDS_DATABASE = "Database";
    private ConnAttributes _interfaceSrv = new ConnAttributes();
    private String _database = null;

    @Override
    protected void load(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Invalid base key parameter.");
        String string2 = PluginSupport.readProfileString(string + HDS_DATABASE);
        this.setDatabase(string2);
        string = string + INTERFACE_PREFIX;
        ConnAttributes connAttributes = null;
        string2 = PluginSupport.readProfileString(string + "Type");
        if (string2 != null && string2.length() > 0) {
            connAttributes = new ConnAttributes();
            connAttributes.setType(string2);
            String string3 = PluginSupport.readProfileString(string + "Server");
            connAttributes.setServer(string3);
            string2 = PluginSupport.readProfileString(string + "Host");
            if (string2 != null && string2.length() > 0) {
                connAttributes.setHost(string2);
                connAttributes.setPort(PluginSupport.readProfileString(string + "Port"));
                connAttributes.setSaveAddress(true);
            } else {
                connAttributes.setHost("");
                connAttributes.setPort("");
                connAttributes.setSaveAddress(false);
            }
            string2 = PluginSupport.readProfileString(string + "User");
            connAttributes.setUser(string2);
            string2 = PluginSupport.readProfileStringEncrypted(string + "Password");
            string2 = string2.equals("__XSRO__") ? "" : string2;
            connAttributes.setPassword(string2);
            string2 = PluginSupport.readProfileString(string + "Charset");
            connAttributes.setCharset(string2);
            string2 = PluginSupport.readProfileString(string + "Language");
            connAttributes.setLanguage(string2);
        }
        this.setInterface(connAttributes);
    }

    @Override
    public void save(String string) {
        Dbg.trace(1, "Save connection attributes for env.server '" + string + "." + this.getServer() + "'. Spec: " + this.toString());
        HDSConnAttributes.remove(string, this.getServer());
        String string2 = "Domain." + string + "." + this.getServer() + ".";
        PluginSupport.writeProfileString(string2 + "Type", this.getType());
        if (this.getDatabase() != null) {
            PluginSupport.writeProfileString(string2 + HDS_DATABASE, this.getDatabase());
        }
        string2 = string2 + INTERFACE_PREFIX;
        ConnAttributes connAttributes = this.getInterface();
        if (connAttributes != null) {
            PluginSupport.writeProfileString(string2 + "Server", connAttributes.getServer());
            PluginSupport.writeProfileString(string2 + "Type", connAttributes.getType());
            PluginSupport.writeProfileString(string2 + "User", connAttributes.getUser());
            String string3 = connAttributes.getPassword();
            if (string3 == null || string3.length() == 0) {
                string3 = "__XSRO__";
            }
            PluginSupport.writeProfileStringEncrypted(string2 + "Password", string3);
            PluginSupport.writeProfileString(string2 + "Charset", connAttributes.getCharset());
            PluginSupport.writeProfileString(string2 + "Language", connAttributes.getLanguage());
            if (connAttributes.isAddressSavedLocally()) {
                PluginSupport.writeProfileString(string2 + "Host", connAttributes.getHost());
                PluginSupport.writeProfileString(string2 + "Port", connAttributes.getPort());
            }
        }
    }

    public static void remove(String string, String string2) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty domain name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty server name parameter.");
        String string3 = "Domain." + string + "." + string2 + ".";
        PluginSupport.deleteProfileString(string3 + HDS_DATABASE);
        string3 = string3 + INTERFACE_PREFIX;
        PluginSupport.deleteProfileString(string3 + "Server");
        PluginSupport.deleteProfileString(string3 + "Type");
        PluginSupport.deleteProfileString(string3 + "User");
        PluginSupport.deleteProfileString(string3 + "Password");
        PluginSupport.deleteProfileString(string3 + "Charset");
        PluginSupport.deleteProfileString(string3 + "Language");
        PluginSupport.deleteProfileString(string3 + "Host");
        PluginSupport.deleteProfileString(string3 + "Port");
    }

    @Override
    public List toList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getType());
        arrayList.add(this.getInterface().getServer());
        arrayList.add(this.getInterface().getType());
        arrayList.add(this.getInterface().getUser());
        arrayList.add(this.getInterface().getPassword());
        arrayList.add(this.getInterface().getCharset());
        arrayList.add(this.getInterface().getLanguage());
        return arrayList;
    }

    @Override
    public String toFormattedString() {
        String string = "";
        string = this.getType() != null && this.getType().length() > 0 && this.getServer() != null && this.getServer().length() > 0 ? string + this.getDisplayTypeName() + " '" + this.getServer() + "'\n" : string + "\n";
        string = string + BundleManager.getString("ProviderRes", "ATTR_SUMMARY_INTERFACE_TYPE") + "\n";
        string = string + this.getInterface().toFormattedString();
        return string;
    }

    public ConnAttributes getInterface() {
        Dbg.wassert(this._interfaceSrv != null, "Null interface type attribute.");
        return this._interfaceSrv;
    }

    public void setInterface(ConnAttributes connAttributes) {
        Dbg.wassert(connAttributes != null, "Null interface server ConnAttributes parameter.");
        this._interfaceSrv = connAttributes;
    }

    public String getDatabase() {
        return this._database;
    }

    public void setDatabase(String string) {
        this._database = string;
    }

    @Override
    public String getAddress() {
        return this.getInterface().getAddress();
    }
}

