/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.sql;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;

public class RAConnection
extends RSMConnection {
    public static final int NELLIE_VERSION_NR = 1200;
    public static final int RABBIT_VERSION_NR = 1210;
    public static final int TITUS_VERSION_NR = 1250;
    public static final int DURGA_VERSION_NR = 1260;
    public static final int ZIRA_VERSION_NR = 1500;
    public static final int MINIMUM_VERSION_NR = 1200;
    public static final String MINIMUM_VERSION_NR_STR = "12.0";
    private static final String VERSION_PRODUCT_NAME = "Sybase Replication Agent";
    protected String _versionNr = null;
    protected String _versionString = null;

    public RAConnection(ConnAttributes connAttributes) {
        super(connAttributes);
    }

    @Override
    public synchronized void open() throws SQLException {
        try {
            super.open();
        }
        catch (SQLException sQLException) {
            if (this.getState() == 5) {
                this.setReason(BundleManager.getString("ProviderRes", "INVALID_ASE_SERVER"));
                throw new SQLException(this.getReason(), "_RSM_", 1);
            }
            throw sQLException;
        }
        try {
            this.initServerVersion();
        }
        catch (SQLException sQLException) {
            this.close();
            this.setState(5);
            this.setReason(BundleManager.getString("ProviderRes", "INVALID_ASE_SERVER"));
            throw new SQLException(this.getReason(), "_RSM_", 1);
        }
        if (this.getVersionNumber() < 1200) {
            this.close();
            Object[] objectArray = new String[]{this.getDisplayVersionNumber(), MINIMUM_VERSION_NR_STR};
            this.setState(5);
            this.setReason(BundleManager.getString("ProviderRes", "INVALID_ASE_VERSION", objectArray));
            throw new SQLException(this.getReason(), "_RSM_", 2);
        }
    }

    @Override
    public String getDisplayVersionNumber() {
        return this._versionNr;
    }

    @Override
    public int getVersionNumber() {
        if (this._versionNr != null && this._versionNr.length() > 0) {
            return MessageText.toVersionNr(this._versionNr, 5);
        }
        return 1200;
    }

    @Override
    public String getVersionString() {
        return this._versionString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initServerVersion() throws SQLException {
        RSMResultSet rSMResultSet = new RSMResultSet(this);
        try {
            rSMResultSet.open("ra_version");
            if (rSMResultSet.getNextRow()) {
                this._versionString = rSMResultSet.getColumnString(1);
                if (this._versionString != null) {
                    if (this._versionString.length() > 0) {
                        if (PluginSupport.logSQL()) {
                            Object[] objectArray = new String[]{this.getType(), this.getServerName(), this._versionString};
                            String string = BundleManager.getString("ProviderRes", "VERSION_STRING_HDR", objectArray);
                            PluginSupport.LogInfoMessage(string, string);
                        }
                        this._versionNr = this.parseVersionNr(this._versionString);
                        if (this._versionNr == null) {
                            this._versionNr = MINIMUM_VERSION_NR_STR;
                        }
                    } else {
                        this._versionString = null;
                    }
                }
            }
        }
        finally {
            rSMResultSet.close();
        }
    }
}

