/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.sql;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class RMSConnection
extends RSMConnection {
    public static final int ZIRA_VERSION_NR = 15000;
    public static final int ZIRA_EBF_1_VERSION_NR = 15001;
    public static final int MINIMUM_VERSION_NR = 15000;
    public static final String MINIMUM_VERSION_NR_STR = "15.0";
    public static final String EBF_TAG = "EBF";
    protected String _versionNr = "15.0";
    protected int _iVersionNr = 15000;
    protected String _versionString = null;

    public RMSConnection(ConnAttributes connAttributes) {
        super(connAttributes);
    }

    @Override
    public synchronized void open() throws SQLException {
        this._props.put("USE_METADATA", "false");
        super.open();
        try {
            this.initServerVersion();
        }
        catch (SQLException sQLException) {
            this.close();
            this.setState(5);
            this.setReason(BundleManager.getString("ProviderRes", "INVALID_RMA", this.getServerName()));
            throw new SQLException(this.getReason(), "_RSM_", 1);
        }
    }

    @Override
    protected void processOpenException(SQLException sQLException) throws SQLException {
        this.clearLastAccessedTime();
        if (sQLException.getSQLState() != null) {
            if (sQLException.getSQLState().equals("JZ00L")) {
                this.setState(2);
                this.setReason(BundleManager.getString("ProviderRes", "SRV_LOGIN_FAILED", this.getServerName()));
            } else if (sQLException.getSQLState().equals("JZ006")) {
                this.setState(4);
                this.setReason(BundleManager.getString("ProviderRes", "SRV_CONN_FAILED", this.getServerName()));
            } else {
                this.setState(5);
                this.setReason(sQLException.getLocalizedMessage());
            }
        } else {
            this.setState(5);
            this.setReason(sQLException.getLocalizedMessage());
        }
        throw new SQLException(this.getReason(), "_RSM_", this.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initServerVersion() throws SQLException {
        RSMResultSet rSMResultSet = new RSMResultSet(this);
        try {
            rSMResultSet.open("get version");
            if (rSMResultSet.getNextRow()) {
                this._versionString = rSMResultSet.getColumnString(1);
                if (this._versionString != null) {
                    if (this._versionString.length() > 0) {
                        if (PluginSupport.logSQL()) {
                            Object[] objectArray = new String[]{this.getType(), this.getServerName(), this._versionString};
                            String string = BundleManager.getString("ProviderRes", "VERSION_STRING_HDR", objectArray);
                            PluginSupport.LogInfoMessage(string, string);
                        }
                        this._versionNr = this.parseVersionNr(this._versionString);
                        if (this._versionNr == null) {
                            this._versionNr = MINIMUM_VERSION_NR_STR;
                        }
                    } else {
                        this._versionString = null;
                    }
                }
            }
        }
        finally {
            rSMResultSet.close();
        }
    }

    @Override
    protected String parseVersionNr(String string) throws SQLException {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (stringTokenizer.countTokens() >= 2) {
            String string3 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            this._iVersionNr = MessageText.toVersionNr(string2, 5);
            if (string4.startsWith(EBF_TAG)) {
                string2 = string2 + " " + string4;
                String string5 = string4.replaceFirst(EBF_TAG, "").trim();
                int n = 0;
                try {
                    n = Integer.parseInt(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    Dbg.wassert(false, "Unexpected RMS EBF token in version string.");
                }
                this._iVersionNr += n;
            } else if (this._iVersionNr == 15000) {
                String string6 = BundleManager.getString("RMSRes", "RMS_EBF_REQUIRED", string2);
                PluginSupport.LogWarningMessage(string6, string6);
            }
        } else {
            this._iVersionNr = 15000;
            Object[] objectArray = new String[]{this.getType(), this.getServerName(), string, String.valueOf(stringTokenizer.countTokens())};
            SQLException sQLException = new SQLException(BundleManager.getString("ProviderRes", "VERSION_PARSE_ERR_MSG", objectArray));
            throw sQLException;
        }
        return string2;
    }

    @Override
    public String getDisplayVersionNumber() {
        return this._versionNr;
    }

    @Override
    public int getVersionNumber() {
        return this._iVersionNr;
    }

    @Override
    public String getVersionString() {
        return this._versionString;
    }
}

