/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.sql;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.ConnectionManager;
import com.sybase.rsmplugin.sql.Domain;
import com.sybase.rsmplugin.sql.RMSConnection;
import com.sybase.rsmplugin.sql.RSConnAttributes;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.status.RMSStatusMonitor;
import com.sybase.rsmplugin.status.StatusSO;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class RMSDomain
implements Domain {
    private static final String DOMAIN_LIST_KEY = "RMSDomainList";
    private String _domainName = null;
    private ConnAttributes _rmsAttributes;
    private RMSStatusMonitor _monitor = null;
    private static final String GET_USERNAME = "GET_USERNAME";
    private static final String SET_USERNAME = "SET_USERNAME";
    private static final String SET_PASSWORD = "SET_PASSWORD";
    private static final String ADD_SERVER = "ADD_SERVER";
    private static final String DROP_SERVER = "DROP_SERVER";
    private static final String GET_SERVER = "GET_SERVER";
    private static final String GET_ALL_SERVERS = "GET_ALL_SERVERS";
    private static final String GET_ALL_CONN_SPEC = "GET_ALL_CONN_SPEC";
    private static final String GET_SERVERS_CONN_SPEC = "GET_SERVERS_CONN_SPEC";
    private static final Object[][] contents = new Object[][]{{"GET_USERNAME", new Integer(1500), "configure username"}, {"SET_USERNAME", new Integer(1500), "configure username = {0}"}, {"SET_PASSWORD", new Integer(1500), "configure password = {0}"}, {"ADD_SERVER", new Integer(1500), "add {0} {1}\n"}, {"DROP_SERVER", new Integer(1500), "drop server {0}"}, {"GET_SERVER", new Integer(1500), "get servers {0}"}, {"GET_ALL_SERVERS", new Integer(1500), "get servers"}, {"GET_ALL_CONN_SPEC", new Integer(1500), "get network spec"}, {"GET_SERVERS_CONN_SPEC", new Integer(1500), "get network spec monitored"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public RMSDomain(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty domain name parameter.");
        this._domainName = string;
    }

    public static List getDomains() {
        List list = PluginSupport.readProfileStringList(DOMAIN_LIST_KEY);
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    public boolean load() {
        Dbg.trace(1, "Load RMS '" + this.getName() + "'");
        this._rmsAttributes = ConnAttributes.load(this.getName(), this.getName());
        return this._rmsAttributes != null;
    }

    @Override
    public void save() {
        List list = RMSDomain.getDomains();
        Dbg.wassert(list != null, "Unexpected null List. This List should not be null.");
        boolean bl = false;
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext() && !bl) {
            bl = listIterator.next().toString().equals(this.getName());
        }
        if (!bl) {
            list.add(this.getName());
            PluginSupport.writeProfileStringList(DOMAIN_LIST_KEY, list);
        }
        if (this.getRMSServer() != null) {
            this.getRMSServer().save(this.getName());
        }
        Dbg.trace(1, "Add RMS '" + this.getName() + "' to the SC repository.");
    }

    public void alter(String string, String string2, String string3, String string4, String string5, String string6) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty username parameter.");
        ConnectionManager.dropConnection(this.getRMSServer());
        this.getRMSServer().setUser(string);
        this.getRMSServer().setPassword(string2);
        this.getRMSServer().setCharset(string3);
        this.getRMSServer().setLanguage(string4);
        if (string5 != null && string5.length() > 0) {
            this.getRMSServer().setSaveAddress(true);
            this.getRMSServer().setHost(string5);
            this.getRMSServer().setPort(string6);
        }
        this.getRMSServer().save(this.getName());
    }

    public void delete() {
        this.disconnect();
        List list = RMSDomain.getDomains();
        Dbg.wassert(list != null, "Unexpected null List. This List should not be null.");
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            if (!listIterator.next().toString().equals(this.getName())) continue;
            listIterator.remove();
            PluginSupport.writeProfileStringList(DOMAIN_LIST_KEY, list);
            break;
        }
        if (!listIterator.hasNext() && !listIterator.hasPrevious()) {
            PluginSupport.deleteProfileString(DOMAIN_LIST_KEY);
        }
        ConnAttributes.remove(this.getName(), this.getName());
        Dbg.trace(1, "Remove RMS '" + this.getName() + "' from the SC repository.");
    }

    public void connect(ConnAttributes connAttributes, boolean bl) throws SQLException {
        Dbg.wassert(connAttributes != null, "Null RMS attributes parameter.");
        Dbg.trace(1, "Connect to RMS '" + this.getName() + "'");
        this._rmsAttributes = connAttributes;
        this._rmsAttributes.save(this.getName());
        if (bl) {
            this.test();
            PluginSupport.registerDomain(this);
            this.startMonitor();
        }
    }

    public void connect(String string, String string2, boolean bl) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty username parameter.");
        Dbg.trace(1, "Connect to RMS '" + this.getName() + "'");
        if (this.load()) {
            this.setUsername(string);
            this.setPassword(string2);
            if (bl) {
                this.test();
                PluginSupport.registerDomain(this);
                this.startMonitor();
            }
        } else {
            throw new SQLException(BundleManager.getString("DomainRes", "ERR_DOMAIN_LOAD", this.getName()));
        }
    }

    protected void test() throws SQLException {
        RSMConnection rSMConnection = ConnectionManager.testConnection(this.getRMSServer());
        if (rSMConnection != null) {
            if (!rSMConnection.isConnectionOpen()) {
                throw new SQLException(rSMConnection.getReason(), "_RSM_", rSMConnection.getState());
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
        rSMConnection.close();
        ConnectionManager.dropConnection(this.getRMSServer());
    }

    @Override
    public void disconnect() {
        this.stopMonitor();
        if (this._rmsAttributes != null) {
            ConnectionManager.dropConnection(this._rmsAttributes);
        }
        PluginSupport.unregisterDomain(this);
    }

    @Override
    public boolean isEnvironment() {
        return false;
    }

    @Override
    public boolean isRMS() {
        return true;
    }

    @Override
    public String getName() {
        Dbg.wassert(this._domainName != null && this._domainName.length() > 0, "Null or empty domain name attribute.");
        return this._domainName;
    }

    @Override
    public String getDescription() {
        return BundleManager.getString("DomainRes", "RMS_DOMAIN_DESC");
    }

    public String toString() {
        return this.getName();
    }

    public String toFormattedString() {
        String string = BundleManager.getString("DomainRes", "DOMAIN_SUMMARY_NAME", this.getName()) + "\n";
        if (this._rmsAttributes != null) {
            string = string + this._rmsAttributes.toFormattedString();
        }
        return string;
    }

    public String getUsername() {
        return this._rmsAttributes.getUser();
    }

    public void setUsername(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty username parameter.");
        this._rmsAttributes.setUser(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadUsername() {
        String string = null;
        RMSConnection rMSConnection = this.getRMSConnection();
        if (rMSConnection != null) {
            int n = this.getRMSVersionNumber();
            String string2 = _cmdBundle.getCommand(GET_USERNAME, n);
            Dbg.wassert(string2 != null, "Unable to get RMS username version: " + String.valueOf(n));
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string2);
                if (rSMResultSet.getNextRow()) {
                    string = rSMResultSet.getColumnString(2);
                }
            }
            catch (SQLException sQLException) {
                String string3 = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUsername(String string) {
        boolean bl = false;
        RMSConnection rMSConnection = this.getRMSConnection();
        if (rMSConnection != null) {
            int n = this.getRMSVersionNumber();
            String string2 = _cmdBundle.getCommand(SET_USERNAME, n, string);
            Dbg.wassert(string2 != null, "Unable to set RMS username version: " + String.valueOf(n));
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string2);
                bl = true;
            }
            catch (SQLException sQLException) {
                String string3 = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        if (bl) {
            ConnectionManager.dropConnection(this._rmsAttributes);
            this._rmsAttributes.setUser(string);
        }
    }

    public String getPassword() {
        return this._rmsAttributes.getPassword();
    }

    public void setPassword(String string) {
        this._rmsAttributes.setPassword(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePassword(String string) {
        boolean bl = false;
        RMSConnection rMSConnection = this.getRMSConnection();
        if (rMSConnection != null) {
            int n = this.getRMSVersionNumber();
            String string2 = _cmdBundle.getCommand(SET_PASSWORD, n, string);
            Dbg.wassert(string2 != null, "Unable to set RMS password version: " + String.valueOf(n));
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string2);
                bl = true;
            }
            catch (SQLException sQLException) {
                String string3 = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        if (bl) {
            ConnectionManager.dropConnection(this._rmsAttributes);
            this._rmsAttributes.setPassword(string);
        }
    }

    protected synchronized void startMonitor() {
        this._monitor = new RMSStatusMonitor(this);
        try {
            this._monitor.start();
        }
        catch (Exception exception) {
            PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(exception), MessageText.formatExceptionMessage(exception));
        }
    }

    protected synchronized void stopMonitor() {
        if (this._monitor != null) {
            this._monitor.stop();
        }
    }

    @Override
    public synchronized void refreshStatus() {
    }

    public StatusSO getStatus(String string, String string2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServer(ConnAttributes connAttributes) {
        Dbg.wassert(connAttributes != null, "Null attributes parameter.");
        RMSConnection rMSConnection = this.getRMSConnection();
        if (rMSConnection != null) {
            Object object;
            Object[] objectArray;
            String string = null;
            int n = this.getRMSVersionNumber();
            String string2 = connAttributes.getType();
            if (string2.equalsIgnoreCase("mirror replication agent")) {
                string2 = "MRA";
            }
            Dbg.wassert((string = _cmdBundle.getCommand(ADD_SERVER, n, objectArray = new String[]{string2, connAttributes.getServer()})) != null, "Unable to get add server command - version: " + String.valueOf(n));
            string = string + "\tset username to " + connAttributes.getUser() + "\n";
            if (connAttributes.getPassword() != null && connAttributes.getPassword().length() > 0) {
                string = string + "\tset password to " + connAttributes.getPassword() + "\n";
            }
            if (connAttributes.getCharset() != null && connAttributes.getCharset().length() > 0) {
                string = string + "\tset charset to " + connAttributes.getCharset() + "\n";
            }
            if (connAttributes.getLanguage() != null && connAttributes.getLanguage().length() > 0) {
                string = string + "\tset language to " + connAttributes.getLanguage() + "\n";
            }
            if (connAttributes.getType().equals("Replication Server")) {
                object = ((RSConnAttributes)connAttributes).getRSSD();
                string = string + "\tset rssd_username to " + ((ConnAttributes)object).getUser() + "\n";
                if (((ConnAttributes)object).getPassword() != null && ((ConnAttributes)object).getPassword().length() > 0) {
                    string = string + "\tset rssd_password to " + ((ConnAttributes)object).getPassword() + "\n";
                }
                if (((ConnAttributes)object).getCharset() != null && ((ConnAttributes)object).getCharset().length() > 0) {
                    string = string + "\tset rssd_charset to " + ((ConnAttributes)object).getCharset() + "\n";
                }
                if (((ConnAttributes)object).getLanguage() != null && ((ConnAttributes)object).getLanguage().length() > 0) {
                    string = string + "\tset rssd_language to " + ((ConnAttributes)object).getLanguage() + "\n";
                }
            }
            object = new RSMResultSet(rMSConnection);
            try {
                ((RSMResultSet)object).open(string);
                if (((RSMResultSet)object).getNextRow() && ((RSMResultSet)object).getColumnCount() == 2) {
                    PluginSupport.LogInfoMessage(((RSMResultSet)object).getColumnString(1), ((RSMResultSet)object).getColumnString(2));
                }
            }
            catch (SQLException sQLException) {
                String string3 = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
            }
            finally {
                ((RSMResultSet)object).close();
                rMSConnection.unlock();
            }
            try {
                if (this._monitor != null) {
                    this._monitor.reRegister();
                }
            }
            catch (Exception exception) {
                PluginSupport.LogErrorMessage(exception.getLocalizedMessage(), exception.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteServer(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty server name parameter.");
        RMSConnection rMSConnection = this.getRMSConnection();
        if (rMSConnection != null) {
            String string2 = null;
            int n = this.getRMSVersionNumber();
            string2 = _cmdBundle.getCommand(DROP_SERVER, n, string);
            Dbg.wassert(string2 != null, "Unable to get drop server command - version: " + String.valueOf(n));
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string2);
            }
            catch (SQLException sQLException) {
                String string3 = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
            try {
                if (this._monitor != null) {
                    this._monitor.reRegister();
                }
            }
            catch (Exception exception) {
                PluginSupport.LogErrorMessage(exception.getLocalizedMessage(), exception.getLocalizedMessage());
            }
        }
    }

    public ConnAttributes getRMSServer() {
        return this._rmsAttributes;
    }

    @Override
    public List getServerNames() {
        return this.getServerNames("*");
    }

    public List getASEServerNames() {
        return this.getServerNames("ASE");
    }

    public List getRepServerNames() {
        return this.getServerNames("Replication Server");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getServerNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        RMSConnection rMSConnection = this.getRMSConnection();
        if (rMSConnection != null) {
            String string2 = null;
            int n = this.getRMSVersionNumber();
            string2 = _cmdBundle.getCommand(GET_ALL_SERVERS, n);
            Dbg.wassert(string2 != null, "Unable to get monitored server command - version: " + String.valueOf(n));
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(1);
                    String string4 = rSMResultSet.getColumnString(2);
                    if (!string.equals("*") && !string.equals(string4)) continue;
                    arrayList.add(string3);
                }
            }
            catch (SQLException sQLException) {
                String string5 = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.LogErrorMessage(string5, MessageText.formatSQLExceptionDetails(sQLException));
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPartofDomain(String string) {
        RMSConnection rMSConnection;
        boolean bl = false;
        if (string != null && string.length() > 0 && (rMSConnection = this.getRMSConnection()) != null) {
            String string2 = null;
            int n = this.getRMSVersionNumber();
            string2 = _cmdBundle.getCommand(GET_SERVER, n, string);
            Dbg.wassert(string2 != null, "Unable to get monitored server command - version: " + String.valueOf(n));
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string2);
                if (rSMResultSet.getNextRow()) {
                    bl = true;
                }
            }
            catch (SQLException sQLException) {
                String string3 = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.LogErrorMessage(string3, MessageText.formatSQLExceptionDetails(sQLException));
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        return bl;
    }

    public RMSConnection getRMSConnection() {
        RMSConnection rMSConnection = null;
        if (this.getRMSServer() != null) {
            rMSConnection = (RMSConnection)ConnectionManager.getConnection(this.getRMSServer());
        }
        return rMSConnection;
    }

    public int getRMSVersionNumber() {
        int n = 0;
        if (this.getRMSServer() != null) {
            n = ConnectionManager.getVersionNumber(this.getRMSServer());
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getServerKeys() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        RMSConnection rMSConnection = this.getRMSConnection();
        if (rMSConnection != null) {
            String string = null;
            int n = this.getRMSVersionNumber();
            string = _cmdBundle.getCommand(GET_ALL_SERVERS, n);
            Dbg.wassert(string != null, "Unable to get monitored server command - version: " + String.valueOf(n));
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string);
                while (rSMResultSet.getNextRow()) {
                    String string2 = rSMResultSet.getColumnString(1);
                    String string3 = rSMResultSet.getColumnString(2);
                    String[] stringArray = new String[]{this.getName(), string2, string3};
                    arrayList.add(stringArray);
                }
            }
            catch (SQLException sQLException) {
                String string4 = MessageText.formatExceptionMessage(sQLException);
                PluginSupport.LogErrorMessage(string4, MessageText.formatSQLExceptionDetails(sQLException));
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getAvailableServers() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        RMSConnection rMSConnection = this.getRMSConnection();
        if (rMSConnection != null) {
            String string = null;
            int n = this.getRMSVersionNumber();
            string = _cmdBundle.getCommand(GET_ALL_CONN_SPEC, n);
            Dbg.wassert(string != null, "Unable to get all servers command - RMS version: " + String.valueOf(n));
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string);
                while (rSMResultSet.getNextRow()) {
                    String string2 = rSMResultSet.getColumnString(1);
                    arrayList.add(string2);
                }
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        return arrayList;
    }
}

