/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.sql;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.util.Dbg;
import java.util.List;

public class RSConnAttributes
extends ConnAttributes {
    protected static final String RSSD_PREFIX = "RSSD";
    private ConnAttributes _rssd = new ConnAttributes();

    public RSConnAttributes() {
        this.setType("Replication Server");
    }

    @Override
    protected void load(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Invalid base key parameter.");
        super.load(string);
        string = string + RSSD_PREFIX;
        ConnAttributes connAttributes = null;
        String string2 = PluginSupport.readProfileString(string + "Type");
        if (string2 != null && string2.length() > 0) {
            connAttributes = new ConnAttributes();
            connAttributes.setType(string2);
            String string3 = PluginSupport.readProfileString(string + "Server");
            connAttributes.setServer(string3);
            string2 = PluginSupport.readProfileString(string + "Host");
            if (string2 != null && string2.length() > 0) {
                connAttributes.setHost(string2);
                connAttributes.setPort(PluginSupport.readProfileString(string + "Port"));
                connAttributes.setSaveAddress(true);
            } else {
                connAttributes.setHost("");
                connAttributes.setPort("");
                connAttributes.setSaveAddress(false);
            }
            string2 = PluginSupport.readProfileString(string + "User");
            connAttributes.setUser(string2);
            string2 = PluginSupport.readProfileStringEncrypted(string + "Password");
            string2 = string2.equals("__XSRO__") ? "" : string2;
            connAttributes.setPassword(string2);
            string2 = PluginSupport.readProfileString(string + "Charset");
            connAttributes.setCharset(string2);
            string2 = PluginSupport.readProfileString(string + "Language");
            connAttributes.setLanguage(string2);
        }
        this.setRSSD(connAttributes);
    }

    @Override
    public void save(String string) {
        super.save(string);
        Dbg.trace(1, "Save connection attributes for env.server '" + string + "." + this.getServer() + "'. Spec: " + this.toString());
        String string2 = "Domain." + string + "." + this.getServer() + "." + RSSD_PREFIX;
        ConnAttributes connAttributes = this.getRSSD();
        if (connAttributes != null) {
            PluginSupport.writeProfileString(string2 + "Server", connAttributes.getServer());
            PluginSupport.writeProfileString(string2 + "Type", connAttributes.getType());
            PluginSupport.writeProfileString(string2 + "User", connAttributes.getUser());
            String string3 = connAttributes.getPassword();
            if (string3 == null || string3.length() == 0) {
                string3 = "__XSRO__";
            }
            PluginSupport.writeProfileStringEncrypted(string2 + "Password", string3);
            PluginSupport.writeProfileString(string2 + "Charset", connAttributes.getCharset());
            PluginSupport.writeProfileString(string2 + "Language", connAttributes.getLanguage());
            if (connAttributes.isAddressSavedLocally()) {
                PluginSupport.writeProfileString(string2 + "Host", connAttributes.getHost());
                PluginSupport.writeProfileString(string2 + "Port", connAttributes.getPort());
            }
        }
    }

    public static void remove(String string, String string2) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty domain name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty server name parameter.");
        String string3 = "Domain." + string + "." + string2 + "." + RSSD_PREFIX;
        PluginSupport.deleteProfileString(string3 + "Server");
        PluginSupport.deleteProfileString(string3 + "Type");
        PluginSupport.deleteProfileString(string3 + "User");
        PluginSupport.deleteProfileString(string3 + "Password");
        PluginSupport.deleteProfileString(string3 + "Charset");
        PluginSupport.deleteProfileString(string3 + "Language");
        PluginSupport.deleteProfileString(string3 + "Host");
        PluginSupport.deleteProfileString(string3 + "Port");
    }

    @Override
    public List toList() {
        List list = super.toList();
        list.add(this.getRSSD().getServer());
        list.add(this.getRSSD().getType());
        list.add(this.getRSSD().getUser());
        list.add(this.getRSSD().getPassword());
        list.add(this.getRSSD().getCharset());
        list.add(this.getRSSD().getLanguage());
        return list;
    }

    @Override
    public String toFormattedString() {
        String string = super.toFormattedString();
        string = string + BundleManager.getString("ProviderRes", "ATTR_SUMMARY_RSSD") + " ";
        string = string + this.getRSSD().toFormattedString();
        return string;
    }

    public ConnAttributes getRSSD() {
        Dbg.wassert(this._rssd != null, "Null RSSD ConnAttributes attribute.");
        return this._rssd;
    }

    public void setRSSD(ConnAttributes connAttributes) {
        Dbg.wassert(connAttributes != null, "Null RSSD ConnAttributes parameter.");
        this._rssd = connAttributes;
    }
}

