/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.sql;

import com.sybase.jdbcx.EedInfo;
import com.sybase.jdbcx.SybConnection;
import com.sybase.jdbcx.SybMessageHandler;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.RSConnAttributes;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;

public class RSConnection
extends RSMConnection {
    public static final int RS_SEVERITY_ERROR_MAX = 12;
    public static final int NELLIE_VERSION_NR = 1200;
    public static final int RABBIT_VERSION_NR = 1210;
    public static final int TITUS_VERSION_NR = 1250;
    public static final int DURGA_VERSION_NR = 1260;
    public static final int ZIRA_VERSION_NR = 1500;
    public static final int VIVACI_VERSION_NR = 1501;
    public static final int APOLLO_VERSION_NR = 1510;
    public static final int ALTAIR_VERSION_NR = 1520;
    public static final int TYCHO_VERSION_NR = 1550;
    public static final int[] SYSTEM_VERSION_LIST = new int[]{1000, 1001, 1002, 1003, 1010, 1011, 1100, 1101, 1102, 1103, 1150, 1200, 1210, 1250, 1260, 1500, 1501, 1510, 1520, 1550};
    public static final int[] SITE_VERSION_LIST = new int[]{1150, 1200, 1210, 1250, 1260, 1500, 1501, 1510, 1520, 1550};
    public static final int[] SUPPORTED_VERSION_LIST = new int[]{1200, 1210, 1250, 1260, 1500, 1501, 1510, 1520, 1550};
    public static final int MINIMUM_VERSION_NR = 1200;
    public static final String MINIMUM_VERSION_NR_STR = "12.0";
    private static final String VERSION_PRODUCT_NAME = "Replication Server";
    public static final int INVALID_CONNECTION_PARAM = 31124;
    protected String _versionNr = "12.0";
    protected String _versionString = null;
    protected int _iVersionNr = 1200;
    protected String _rssdServer = null;
    protected String _rssdDatabase = null;
    protected boolean _erssd = false;

    public RSConnection(ConnAttributes connAttributes) {
        super(connAttributes);
    }

    @Override
    public synchronized void open() throws SQLException {
        this._props.put("USE_METADATA", "false");
        super.open();
        ((SybConnection)this._conn).setSybMessageHandler((SybMessageHandler)new RSMessageHandler());
        try {
            this.initServerVersion();
        }
        catch (SQLException sQLException) {
            this.close();
            this.setState(5);
            this.setReason(BundleManager.getString("ProviderRes", "INVALID_REP_SERVER"));
            throw new SQLException(this.getReason(), "_RSM_", 1);
        }
        if (this.getVersionNumber() < 1200) {
            this.close();
            Object[] objectArray = new String[]{this.getDisplayVersionNumber(), MINIMUM_VERSION_NR_STR};
            this.setState(5);
            this.setReason(BundleManager.getString("ProviderRes", "INVALID_REP_SERVER_VERSION", objectArray));
            throw new SQLException(this.getReason(), "_RSM_", 2);
        }
        try {
            this.initRSSD();
        }
        catch (SQLException sQLException) {
            this.close();
            this.setState(5);
            this.setReason(BundleManager.getString("ProviderRes", "INVALID_RSSD"));
            throw new SQLException(this.getReason(), sQLException.getSQLState(), sQLException.getErrorCode());
        }
    }

    @Override
    public String getDisplayVersionNumber() {
        return this._versionNr;
    }

    @Override
    public int getVersionNumber() {
        return this._iVersionNr;
    }

    @Override
    public String getVersionString() {
        return this._versionString;
    }

    public String getRSSDServer() {
        String string = null;
        if (this._rssdServer != null && this._rssdServer.length() > 0) {
            string = this._rssdServer;
        } else {
            ConnAttributes connAttributes;
            RSConnAttributes rSConnAttributes = (RSConnAttributes)this.getAttributes();
            if (rSConnAttributes != null && (connAttributes = rSConnAttributes.getRSSD()) != null) {
                string = connAttributes.getServer();
            }
        }
        return string;
    }

    public String getRSSD() {
        return this._rssdDatabase;
    }

    public boolean isEmbeddedRSSD() {
        return this._erssd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initServerVersion() throws SQLException {
        RSMResultSet rSMResultSet = new RSMResultSet(this);
        try {
            rSMResultSet.open("admin version");
            if (rSMResultSet.getNextRow()) {
                this._versionString = rSMResultSet.getColumnString(1);
                if (this._versionString != null) {
                    if (this._versionString.length() > 0) {
                        if (PluginSupport.logSQL()) {
                            Object[] objectArray = new String[]{this.getType(), this.getServerName(), this._versionString};
                            String string = BundleManager.getString("ProviderRes", "VERSION_STRING_HDR", objectArray);
                            PluginSupport.LogInfoMessage(string, string);
                        }
                        this._versionNr = this.parseVersionNr(this._versionString);
                        if (this._versionNr != null && this._versionNr.length() > 0) {
                            this._iVersionNr = MessageText.toVersionNr(this._versionNr, 4);
                        } else {
                            this._versionNr = MINIMUM_VERSION_NR_STR;
                            this._iVersionNr = 1200;
                        }
                    } else {
                        this._versionString = null;
                    }
                }
            }
        }
        finally {
            rSMResultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initRSSD() throws SQLException {
        this.initEmbeddedRSSD();
        RSMResultSet rSMResultSet = new RSMResultSet(this);
        try {
            rSMResultSet.open("admin rssd_name");
            if (rSMResultSet.getNextRow()) {
                this._rssdServer = rSMResultSet.getColumnString(1);
                this._rssdDatabase = rSMResultSet.getColumnString(2);
            }
        }
        finally {
            rSMResultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initEmbeddedRSSD() {
        RSMResultSet rSMResultSet = new RSMResultSet(this);
        try {
            rSMResultSet.open("sysadmin erssd");
            if (rSMResultSet.getNextRow()) {
                if (Dbg.isOn()) {
                    String string = rSMResultSet.getColumnString(1);
                    Object[] objectArray = new String[]{this.getServerName(), string};
                    String string2 = BundleManager.getString("ProviderRes", "ERSSD_NAME", objectArray);
                    PluginSupport.LogInfoMessage(string2, string2);
                }
                this._erssd = true;
            }
        }
        catch (SQLException sQLException) {
            if (Dbg.isOn()) {
                String string = BundleManager.getString("ProviderRes", "NO_ERSSD_NAME", this.getServerName());
                PluginSupport.LogInfoMessage(string, MessageText.formatSQLExceptionDetails(sQLException));
            }
            this._erssd = false;
        }
        finally {
            rSMResultSet.close();
        }
    }

    class RSMessageHandler
    implements SybMessageHandler {
        RSMessageHandler() {
        }

        public SQLException messageHandler(SQLException sQLException) {
            EedInfo eedInfo;
            if (sQLException instanceof EedInfo && (eedInfo = (EedInfo)sQLException).getSeverity() < 12) {
                PluginSupport.LogInfoMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                return null;
            }
            return sQLException;
        }
    }
}

