/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.sql;

import com.sybase.jdbcx.SybMessageHandler;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.SQLListener;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class RSMConnection
implements Cloneable {
    public static final String CONN_APP_NAME = "APPLICATIONNAME";
    public static final String CONN_PROP_USER = "user";
    public static final String CONN_PROP_PWD = "password";
    public static final String CONN_PROP_CHARSET = "CHARSET";
    public static final String CONN_PROP_LANG = "LANGUAGE";
    public static final String CONN_PROP_HOST = "HOSTNAME";
    public static final String RSM_SQL_STATE = "_RSM_";
    public static final int INCORRECT_SERVER_TYPE = 1;
    public static final int INCORRECT_VERSION = 2;
    public static final int SERVER_NOT_FOUND = 3;
    public static final int SCRIPT_READ_ERROR = 4;
    public static final int SCRIPT_NOT_FOUND = 5;
    public static final int SYBASE_NOT_SET = 6;
    public static final int EXTENDED_ERROR_CODE = 7;
    public static final int DRIVER_CLASS_NOT_FND = 8;
    public static final int SERVER_COMMAND_MISMATCH = 9;
    public static final int OBJECT_NOT_FOUND = 10;
    public static final int URL_NOT_FOUND = 11;
    public static final int SERVER_UPGRADE_REQUIRED = 12;
    public static final int DB_BASE_ERROR = 13;
    public static final String LOGIN_FAILED_STATE = "JZ00L";
    public static final String CONNECT_FAILED_STATE = "JZ006";
    public static final String CONNECT_TIMEOUT_STATE = "JZ00M";
    public static final String CONNECT_CHARSET1_STATE = "JZ0IB";
    public static final String CONNECT_CHARSET2_STATE = "JZ0I5";
    public static final int LOGIN_FAILED_CODE = 14021;
    public static final int CONNECTION_CLOSED = 0;
    public static final int CONNECTION_OPENED = 1;
    public static final int CONNECTION_LOGIN_FAILED = 2;
    public static final int CONNECTION_TIMEOUT = 3;
    public static final int CONNECTION_CONN_FAILED = 4;
    public static final int CONNECTION_ERROR = 5;
    protected static final String VERSION_DELIMITER = "/";
    protected Connection _conn = null;
    protected Properties _props;
    private int _state;
    private String _reason;
    private boolean _lock = false;
    private long _lastAccessedTimeStamp = 0L;
    private String _controllingRMS = null;
    private String _owningThread = null;
    private ConnAttributes _attributes;
    private Vector _sqlListeners = new Vector();

    public RSMConnection(ConnAttributes connAttributes) {
        Dbg.wassert(connAttributes != null, "Null connection attributes parameter.");
        this._attributes = connAttributes;
        this._initialize();
    }

    public void reset(ConnAttributes connAttributes) throws SQLException {
        this._attributes = connAttributes;
        this._initialize();
        if (this.isConnectionOpen()) {
            this.open();
        }
    }

    protected void _initialize() {
        this._props = new Properties();
        this._props.put(CONN_APP_NAME, PluginSupport.getPlugin().getProviderName());
        this._props.put(CONN_PROP_USER, this.getAttributes().getUser());
        this._props.put(CONN_PROP_PWD, this.getAttributes().getPassword());
        if (this.getAttributes().getCharset() != null && this.getAttributes().getCharset().length() > 0) {
            this._props.put(CONN_PROP_CHARSET, this.getAttributes().getCharset());
        }
        if (this.getAttributes().getLanguage() != null && this.getAttributes().getLanguage().length() > 0) {
            this._props.put(CONN_PROP_LANG, this.getAttributes().getLanguage());
        }
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string = inetAddress.getHostName();
            this._props.put(CONN_PROP_HOST, string);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public String getType() {
        return this._attributes.getType();
    }

    public String getDisplayVersionNumber() {
        return null;
    }

    public int getVersionNumber() {
        return 0;
    }

    public String getVersionString() {
        return null;
    }

    public void open() throws SQLException {
        if (this.isConnectionOpen()) {
            this.close();
        }
        this.setReason(null);
        try {
            Class.forName("com.sybase.jdbc3.jdbc.SybDriver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.setState(5);
            this.setReason(classNotFoundException.getLocalizedMessage());
            throw new SQLException(this.getReason(), RSM_SQL_STATE, 8);
        }
        try {
            Object object;
            if (Dbg.isOn()) {
                Dbg.trace(4, "The following drivers have been loaded:");
                object = DriverManager.getDrivers();
                while (object.hasMoreElements()) {
                    Dbg.trace(4, "    " + object.nextElement().toString());
                }
            }
            if ((object = this.getURL()) != null && ((String)object).length() > 0) {
                if (PluginSupport.logSQL()) {
                    Object[] objectArray = new String[]{this.getType(), this.getServerName()};
                    PluginSupport.LogInfoMessage(BundleManager.getString("ProviderRes", "MSG_CONNECT", objectArray), (String)object);
                }
            } else {
                this.setState(5);
                String string = BundleManager.getString("ComponentRes", "URL_NOT_FOUND", this.getServerName());
                this.setReason(string);
                throw new SQLException(string, RSM_SQL_STATE, 11);
            }
            DriverManager.setLoginTimeout(60);
            this._conn = DriverManager.getConnection((String)object, this._props);
            Dbg.trace(4, "Connected to URL: " + (String)object);
            this.printSQLWarnings();
            this._conn.clearWarnings();
            this.printDriverInfo();
            this.setState(1);
        }
        catch (SQLException sQLException) {
            this.processOpenException(sQLException);
        }
    }

    protected void processOpenException(SQLException sQLException) throws SQLException {
        this.clearLastAccessedTime();
        if (sQLException.getSQLState() != null) {
            if (sQLException.getSQLState().equals(LOGIN_FAILED_STATE)) {
                SQLException sQLException2 = sQLException.getNextException();
                if (sQLException2 != null) {
                    if (sQLException2.getSQLState() != null && sQLException2.getSQLState().equals(CONNECT_TIMEOUT_STATE)) {
                        this.setState(3);
                        this.setReason(BundleManager.getString("ProviderRes", "SRV_TIMEOUT", this.getServerName()));
                    } else if (sQLException2.getSQLState() != null && sQLException2.getSQLState().equals(CONNECT_CHARSET1_STATE)) {
                        this.setState(2);
                        this.setReason(BundleManager.getString("ProviderRes", "SRV_CHARSET_FAILED", this.getServerName()));
                    } else if (sQLException2.getSQLState() != null && sQLException2.getSQLState().equals(CONNECT_CHARSET2_STATE)) {
                        this.setState(2);
                        this.setReason(BundleManager.getString("ProviderRes", "SRV_CHARSET_FAILED", this.getServerName()));
                    } else {
                        this.setState(2);
                        if (sQLException2.getErrorCode() == 14021) {
                            this.setReason(BundleManager.getString("ProviderRes", "SRV_LOGIN_FAILED", this.getServerName()));
                        } else {
                            this.setReason(sQLException.getLocalizedMessage());
                        }
                    }
                } else {
                    this.setState(2);
                    this.setReason(sQLException.getLocalizedMessage());
                }
            } else if (sQLException.getSQLState().equals(CONNECT_FAILED_STATE)) {
                this.setState(4);
                this.setReason(BundleManager.getString("ProviderRes", "SRV_CONN_FAILED", this.getServerName()));
            } else if (sQLException.getSQLState().equals(CONNECT_CHARSET2_STATE)) {
                this.setState(2);
                this.setReason(BundleManager.getString("ProviderRes", "SRV_CHARSET_FAILED2", this.getServerName()));
            } else {
                this.setState(5);
                this.setReason(sQLException.getLocalizedMessage());
            }
        } else {
            this.setState(5);
            this.setReason(sQLException.getLocalizedMessage());
        }
        throw new SQLException(this.getReason(), RSM_SQL_STATE, this.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this._conn != null) {
                this._conn.close();
            }
        }
        catch (SQLException sQLException) {
            Dbg.trace(4, "SQLException caught during close: " + sQLException.getLocalizedMessage());
        }
        finally {
            this.clearLastAccessedTime();
            this._conn = null;
            this.setReason(null);
            this.setState(0);
        }
    }

    public void execute(String string) throws SQLException {
        Object[] objectArray;
        if (PluginSupport.logSQL()) {
            objectArray = new String[]{this.getType(), this.getServerName(), MessageText.getStartOfCommand(string)};
            PluginSupport.LogInfoMessage(BundleManager.getString("ProviderRes", "LOG_SCRIPT_CMD", objectArray), string);
        } else {
            Dbg.trace(2, "execute command: '" + string + "'");
        }
        if (this.isConnectionOpen()) {
            objectArray = this.getConnection().createStatement();
            objectArray.setQueryTimeout(60);
            this._conn.clearWarnings();
            try {
                boolean bl = objectArray.execute(string);
                this.logWarnings(objectArray.getWarnings());
                objectArray.clearWarnings();
                int n = -1;
                do {
                    if (bl) {
                        try {
                            ResultSet resultSet = objectArray.getResultSet();
                            if (PluginSupport.logSQL()) {
                                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                                int n2 = resultSetMetaData.getColumnCount();
                                StringBuffer stringBuffer = new StringBuffer("Columns:");
                                for (int i = 1; i <= n2; ++i) {
                                    stringBuffer.append("\t" + resultSetMetaData.getColumnName(i));
                                }
                                String string2 = stringBuffer.toString() + "\n";
                                int n3 = 1;
                                while (resultSet.next()) {
                                    this.logWarnings(resultSet.getWarnings());
                                    resultSet.clearWarnings();
                                    stringBuffer = new StringBuffer("[" + n3 + "]");
                                    for (int i = 1; i <= n2; ++i) {
                                        stringBuffer.append("\t" + resultSet.getString(i));
                                    }
                                    string2 = string2 + stringBuffer.toString() + "\n";
                                    ++n3;
                                }
                                n = objectArray.getUpdateCount();
                                if (n >= 0) {
                                    string2 = string2 + "(" + String.valueOf(n) + " rows affected)\n";
                                }
                                PluginSupport.LogInfoMessage(BundleManager.getString("ProviderRes", "LOG_SQL_RESULTS_SET"), string2);
                            }
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                        continue;
                    }
                    this.logWarnings(objectArray.getWarnings());
                    objectArray.clearWarnings();
                    n = objectArray.getUpdateCount();
                } while ((bl = objectArray.getMoreResults()) || n != -1);
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            finally {
                try {
                    objectArray.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        throw new SQLException(BundleManager.getString("RepServerRes", "NULL_SERVER", this.getServerName()), RSM_SQL_STATE, 3);
    }

    private void logWarnings(SQLWarning sQLWarning) {
        if (sQLWarning != null && PluginSupport.logSQL()) {
            PluginSupport.LogInfoMessage(MessageText.formatSQLWarning(sQLWarning), MessageText.formatSQLWarningDetails(sQLWarning));
        }
    }

    public int getState() {
        return this._state;
    }

    public void setState(int n) {
        this._state = n;
    }

    public boolean isConnectionOpen() {
        boolean bl = false;
        if (this._conn != null) {
            try {
                if (this._conn.isClosed()) {
                    this.close();
                } else {
                    bl = this.getState() == 1;
                }
            }
            catch (SQLException sQLException) {
                this.close();
            }
        }
        return bl;
    }

    public long getLastAccessedTime() {
        long l = (System.currentTimeMillis() - this._lastAccessedTimeStamp) / 1000L;
        return l;
    }

    protected void setLastAccessedTime() {
        this._lastAccessedTimeStamp = System.currentTimeMillis();
    }

    protected void clearLastAccessedTime() {
        this._lastAccessedTimeStamp = 0L;
    }

    public String getControllingRMS() {
        return this._controllingRMS;
    }

    public void setControllingRMS(String string) {
        this._controllingRMS = string == null || string.length() == 0 ? null : string;
    }

    public String getReason() {
        return this._reason == null ? "" : this._reason;
    }

    protected void setReason(String string) {
        this._reason = string;
    }

    public final ConnAttributes getAttributes() {
        Dbg.wassert(this._attributes != null, "Null ConnAttributes object.");
        return this._attributes;
    }

    public final String getServerName() {
        return this.getAttributes().getServer();
    }

    public final String getCharSet() {
        String string = (String)this._props.get(CONN_PROP_CHARSET);
        if (string == null) {
            return "";
        }
        return string;
    }

    public final String getLanguage() {
        String string = (String)this._props.get(CONN_PROP_LANG);
        if (string == null) {
            return "";
        }
        return string;
    }

    public String getURL() {
        String string = null;
        String string2 = this.getAttributes().getAddress();
        if (string2 != null && string2.length() > 0) {
            string = "jdbc:sybase:Tds:" + string2;
        }
        return string;
    }

    public Connection getConnection() {
        Dbg.trace(4, "Server '" + this.getServerName() + "' has been accessed, the last accessed timestamp has been reset.");
        return this._conn;
    }

    public String getUsername() {
        String string = (String)this._props.get(CONN_PROP_USER);
        if (string == null) {
            Dbg.wassert(false, "Unexpected null username property");
            return "";
        }
        return string;
    }

    public String getPassword() {
        String string = (String)this._props.get(CONN_PROP_PWD);
        if (string == null) {
            return "";
        }
        return string;
    }

    private void printDriverInfo() {
        if (PluginSupport.logSQL()) {
            try {
                DatabaseMetaData databaseMetaData = this._conn.getMetaData();
                if (databaseMetaData != null) {
                    PluginSupport.LogInfoMessage("JDBC driver version", databaseMetaData.getDriverVersion());
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void printSQLWarnings() throws SQLException {
        if (Dbg.isOn()) {
            String string = "";
            for (SQLWarning sQLWarning = this._conn.getWarnings(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
                String string2 = sQLWarning.getMessage();
                string = string + string2;
                string2 = null;
            }
            if (string.length() != 0) {
                PluginSupport.LogWarningMessage(string, string);
            }
        }
    }

    protected String parseVersionNr(String string) throws SQLException {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, VERSION_DELIMITER);
        if (stringTokenizer.countTokens() < 2) {
            Object[] objectArray = new String[]{this.getType(), this.getServerName(), string, String.valueOf(stringTokenizer.countTokens())};
            SQLException sQLException = new SQLException(BundleManager.getString("ProviderRes", "VERSION_PARSE_ERR_MSG", objectArray));
            throw sQLException;
        }
        String string3 = stringTokenizer.nextToken();
        string2 = stringTokenizer.nextToken();
        return string2;
    }

    protected String parseProductName(String string) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, VERSION_DELIMITER);
        if (stringTokenizer.countTokens() >= 1) {
            string2 = stringTokenizer.nextToken();
        } else {
            Object[] objectArray = new String[]{this.getType(), this.getServerName(), string, String.valueOf(stringTokenizer.countTokens())};
            PluginSupport.showError(BundleManager.getString("ProviderRes", "VERSION_PARSE_ERR_HDR"), BundleManager.getString("ProviderRes", "VERSION_PARSE_ERR_MSG", objectArray));
        }
        return string2;
    }

    public void addSQLListener(SQLListener sQLListener) {
        this._sqlListeners.addElement(sQLListener);
    }

    public void removeSQLListener(SQLListener sQLListener) {
        this._sqlListeners.removeElement(sQLListener);
    }

    public boolean hasSQLListeners() {
        return this._sqlListeners.size() > 0;
    }

    public Enumeration getSQLListeners() {
        return this._sqlListeners.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void lock() {
        this.setLastAccessedTime();
        if (Dbg.isOn() && Dbg.isFlagOn(16384)) {
            this._owningThread = Thread.currentThread().getName();
        }
        this._lock = true;
    }

    public synchronized void unlock() {
        if (this.isLocked()) {
            Dbg.trace(24576, "Release the lock from the server connection '" + this.getServerName() + "'. " + this.getOwningThread());
            this._lock = false;
            this._owningThread = null;
            this.notifyAll();
        }
    }

    public synchronized boolean isLocked() {
        return this._lock;
    }

    public String getOwningThread() {
        String string = "";
        if (Dbg.isOn() && Dbg.isFlagOn(16384) && this.isLocked()) {
            string = this._owningThread == null ? "" : this._owningThread;
        }
        return string;
    }

    class RSMMessageHandler
    implements SybMessageHandler {
        RSMMessageHandler() {
        }

        public SQLException messageHandler(SQLException sQLException) {
            String string = "";
            SQLException sQLException2 = sQLException;
            do {
                if (sQLException2.getErrorCode() == 0 && sQLException2.getSQLState() == null) {
                    if (string.length() > 0) {
                        string = string + "\n";
                    }
                } else {
                    return sQLException;
                }
                string = string + sQLException2.getMessage();
            } while ((sQLException2 = sQLException2.getNextException()) != null);
            if (string.length() > 0) {
                PluginSupport.LogInfoMessage(sQLException.getMessage(), string);
            }
            return null;
        }
    }
}

