/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.sql;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;

public class RSMResultSet {
    private static final String NO_RESULT_SET_RETURNED = "JZ0R2";
    private RSMConnection _conn;
    private ResultSet _rSet;
    private int _rsetCount;
    private PreparedStatement _sqlStatement;
    private int _nColumns;
    private boolean _isClosed;
    private boolean _moreResults;
    private boolean _isResultSet;
    private ResultSetMetaData _metaData;

    public RSMResultSet(RSMConnection rSMConnection) {
        Dbg.wassert(rSMConnection != null, "Null connection parameter.");
        this._conn = rSMConnection;
        this._isClosed = true;
        this._rsetCount = 0;
        this._rSet = null;
        this._metaData = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this._isClosed) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public int getColumnCount() {
        return this._nColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void open(String string) throws SQLException {
        if (PluginSupport.logSQL()) {
            Object[] objectArray = new String[]{this._conn.getType(), this._conn.getServerName(), MessageText.getStartOfCommand(string)};
            PluginSupport.LogInfoMessage(BundleManager.getString("ProviderRes", "LOG_SCRIPT_CMD", objectArray), string);
        } else {
            Dbg.trace(2, "open results set: '" + string + "'");
        }
        Dbg.wassert(this._conn != null, "Null connection attribute.");
        if (!this._conn.isConnectionOpen()) throw new SQLException(BundleManager.getString("RepServerRes", "NULL_SERVER", this._conn.getServerName()), "_RSM_", 3);
        RSMConnection rSMConnection = this._conn;
        synchronized (rSMConnection) {
            Connection connection = this._conn.getConnection();
            if (connection == null) throw new SQLException(BundleManager.getString("RepServerRes", "NULL_SERVER", this._conn.getServerName()), "_RSM_", 3);
            this._sqlStatement = connection.prepareStatement(string);
            this._sqlStatement.setQueryTimeout(60);
            try {
                int n;
                this._rSet = this._sqlStatement.executeQuery();
                SQLWarning sQLWarning = this._sqlStatement.getWarnings();
                if (sQLWarning != null && (n = sQLWarning.getErrorCode()) > 0) {
                    PluginSupport.LogWarningMessage(MessageText.formatSQLWarning(sQLWarning), MessageText.formatSQLWarningDetails(sQLWarning));
                }
                if ((sQLWarning = this._rSet.getWarnings()) != null && (n = sQLWarning.getErrorCode()) > 0) {
                    PluginSupport.LogWarningMessage(MessageText.formatSQLWarning(sQLWarning), MessageText.formatSQLWarningDetails(sQLWarning));
                }
                this._metaData = this._rSet.getMetaData();
                this._nColumns = this._metaData.getColumnCount();
                this._isClosed = false;
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState() == NO_RESULT_SET_RETURNED) return;
                Dbg.trace(4, "SQL query did not return a result set.");
                throw sQLException;
            }
            return;
        }
    }

    public void close() {
        if (this._rSet != null) {
            try {
                this._rSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this._metaData = null;
            this._rSet = null;
        }
        if (this._sqlStatement != null) {
            try {
                this._sqlStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this._sqlStatement = null;
        }
        this._isClosed = true;
    }

    public boolean getNextRow() throws SQLException {
        if (this._rSet != null) {
            return this._rSet.next();
        }
        Dbg.trace(2, "RSMResultSet: NULL result set encountered.");
        return false;
    }

    public ResultSetMetaData getResultSetMetaData() throws SQLException {
        return this._metaData;
    }

    public boolean getNextResultSet() throws SQLException {
        if (this._isClosed) {
            return false;
        }
        this._isResultSet = this._sqlStatement.getMoreResults();
        if (!this.getResultsAndMetadata()) {
            this._isResultSet = this._sqlStatement.getMoreResults();
            this.getResultsAndMetadata();
        }
        return this._moreResults;
    }

    public String[] getColumnsAsArray() throws SQLException {
        String[] stringArray = new String[this._nColumns];
        for (int i = 0; i < this._nColumns; ++i) {
            stringArray[i] = this.getColumnString(i + 1);
        }
        return stringArray;
    }

    public String getColumnString(int n) throws SQLException {
        String string = this._rSet.getString(n);
        if (!this._rSet.wasNull()) {
            switch (this._metaData.getColumnType(n)) {
                case 1: {
                    string = string.trim();
                    break;
                }
                case 93: {
                    Timestamp timestamp = this._rSet.getTimestamp(n);
                    string = DateFormat.getDateTimeInstance(2, 3).format(timestamp);
                    break;
                }
                case 91: {
                    java.sql.Date date = this._rSet.getDate(n);
                    string = DateFormat.getDateInstance(2).format(date);
                    break;
                }
                case 92: {
                    java.sql.Date date = this._rSet.getDate(n);
                    string = DateFormat.getTimeInstance(3).format(date);
                    break;
                }
            }
        } else {
            string = "";
        }
        return string;
    }

    public int getColumnInt(int n) throws SQLException {
        return this._rSet.getInt(n);
    }

    public long getColumnLong(int n) throws SQLException {
        return this._rSet.getLong(n);
    }

    public boolean getColumnBool(int n) throws SQLException {
        return this._rSet.getBoolean(n);
    }

    public Date getColumnDate(int n) throws SQLException {
        return this._rSet.getTimestamp(n);
    }

    public byte[] getColumnBytes(int n) throws SQLException {
        return this._rSet.getBytes(n);
    }

    public long getColumnBigIntAsLong(int n) throws SQLException {
        BigDecimal bigDecimal = this._rSet.getBigDecimal(n);
        if (this._rSet.wasNull()) {
            return 0L;
        }
        return bigDecimal.longValue();
    }

    public static boolean isColumnYes(String string) {
        return string.equalsIgnoreCase("y") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("1");
    }

    public boolean isColumnYes(int n) throws SQLException {
        String string = "";
        string = this.getColumnString(n);
        return RSMResultSet.isColumnYes(string);
    }

    private boolean getResultsAndMetadata() throws SQLException {
        this._metaData = null;
        this._moreResults = false;
        if (this._isResultSet) {
            this._rSet = this._sqlStatement.getResultSet();
            if (this._rSet != null) {
                this._metaData = this._rSet.getMetaData();
                this._nColumns = this._metaData.getColumnCount();
                this._moreResults = true;
            }
        } else {
            int n = this._sqlStatement.getUpdateCount();
            if (n != -1) {
                this._moreResults = true;
                return false;
            }
        }
        return true;
    }

    public boolean wasNull() throws SQLException {
        return this._rSet.wasNull();
    }
}

