/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.sql;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import com.sybase.rsmplugin.util.RMEnv;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class SQLScript {
    public void execute(RSMConnection rSMConnection, String string) throws SQLException {
        Dbg.wassert(rSMConnection != null, "Null SQL connection parameter.");
        Dbg.wassert(string != null && string.length() > 0, "Null or empty SQL script name.");
        File file = this.getFile(string);
        if (file != null) {
            Object[] objectArray = new String[]{string, rSMConnection.getServerName()};
            PluginSupport.LogInfoMessage(BundleManager.getString("ProviderRes", "LOG_SCRIPT_EXEC", objectArray), file.getAbsolutePath());
            try {
                FileReader fileReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                String string2 = this.readCommand(bufferedReader);
                while (string2 != null && string2.length() > 0) {
                    try {
                        rSMConnection.execute(string2);
                    }
                    catch (SQLWarning sQLWarning) {
                        PluginSupport.LogInfoMessage(sQLWarning.getMessage(), MessageText.formatSQLExceptionDetails(sQLWarning));
                    }
                    string2 = this.readCommand(bufferedReader);
                }
                bufferedReader.close();
                fileReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Dbg.wassert(false, "Unexpected file not found exception.");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String readCommand(BufferedReader bufferedReader) throws IOException {
        String string = "";
        try {
            String string2 = bufferedReader.readLine();
            while (string2 != null && !string2.trim().equalsIgnoreCase("go")) {
                string = string + string2 + "\n";
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            string = null;
            throw iOException;
        }
        return string.trim();
    }

    public boolean findScript(String string) throws SQLException {
        boolean bl = false;
        File file = null;
        if (string.indexOf(File.pathSeparator) == -1) {
            String string2 = RMEnv.getRMScriptsDir();
            if (string2 == null) {
                throw new SQLException(BundleManager.getString("ProviderRes", "ERR_SYBROOT_NOT_SET"), "_RSM_", 6);
            }
            file = new File(string2, string);
        } else {
            file = new File(string);
        }
        if (file != null && file.exists()) {
            bl = true;
        }
        return bl;
    }

    protected File getFile(String string) throws SQLException {
        File file = null;
        if (string.indexOf(File.pathSeparator) == -1) {
            String string2 = RMEnv.getRMScriptsDir();
            if (string2 == null) {
                throw new SQLException(BundleManager.getString("ProviderRes", "ERR_SYBROOT_NOT_SET"), "_RSM_", 6);
            }
            file = new File(string2, string);
        } else {
            file = new File(string);
        }
        if (file != null) {
            if (!file.exists()) {
                throw new SQLException(BundleManager.getString("ProviderRes", "ERR_SCRIPT_NOT_FND", file.getAbsolutePath()), "_RSM_", 5);
            }
            if (!file.canRead()) {
                throw new SQLException(BundleManager.getString("ProviderRes", "ERR_READ_PERMISSIONS", file.getAbsolutePath()), "_RSM_", 4);
            }
        }
        return file;
    }
}

