/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.sql;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMConstants;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.RMEnv;
import com.sybase.util.ds.interfaces.SyInterfacesDriver;
import com.sybase.util.ds.interfaces.SyInterfacesEntry;
import com.sybase.util.ds.ldap.LDAPException;
import com.sybase.util.ds.ldap.LibctlDriver;
import com.sybase.util.ds.ldap.SyASEServer;
import com.sybase.util.ds.ldap.SyLDAPServer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class ServerInterfaces {
    public static final int LDAP_TIMEOUT = 180;
    public static final String PROF_LDAP = "LDAP";
    public static final String PROF_LDAP_TIMEOUT = "Timeout";
    public static final String PROF_LDAP_INCLUDE = "Include";
    private static long _interfaceFilelastModified = -1L;
    private static long _LDAP32FilelastModified = -1L;
    private static long _LDAP64FilelastModified = -1L;
    private static boolean _LDAPOption = true;
    private static int _LDAPTimeout = -1;
    public static Hashtable _Servers;
    private static Hashtable _lookupfromInterfaces;
    private static Hashtable _lookupfromLDAP;
    private int _ldapTimeout;
    private boolean _includeLDAP = false;
    private String _interfaceFileName;
    private LibctlDriver _libtcldriver;
    private static SyInterfacesDriver _interfacesDriver;

    public ServerInterfaces() throws Exception {
        this.initServerEntries();
    }

    public String getHostName(String string) {
        if (_Servers == null) {
            return null;
        }
        SyASEServer syASEServer = (SyASEServer)_Servers.get(string);
        String string2 = null;
        if (syASEServer != null) {
            string2 = syASEServer.getHost();
        }
        return string2;
    }

    public String getPortNumber(String string) {
        if (_Servers == null) {
            return null;
        }
        String string2 = null;
        SyASEServer syASEServer = (SyASEServer)_Servers.get(string);
        if (syASEServer != null) {
            string2 = syASEServer.getPort();
        }
        return string2;
    }

    public String getConnSpec(String string) {
        String string2 = this.getHostName(string);
        if (string2 != null && string2.length() > 0) {
            String string3 = this.getPortNumber(string);
            if (string3 != null && string3.length() > 0) {
                string2 = string2 + ":" + string3;
            }
        } else {
            string2 = this.getPortNumber(string);
            if (string2 == null) {
                string2 = "";
            }
        }
        return string2;
    }

    private void initLDAPValues() {
        String string = PluginSupport.readProfileString("LDAP.Include");
        this._includeLDAP = string == null ? false : new Boolean(string);
        String string2 = PluginSupport.readProfileString("LDAP.Timeout");
        this._ldapTimeout = string2 == null ? 180 : Integer.parseInt(string2);
    }

    private boolean isInterfacesFileModified() throws Exception {
        Object object;
        String string = null;
        String string2 = System.getProperty("file.separator");
        String string3 = System.getProperty("interfaces.file");
        if (string3 != null) {
            string = string3;
        } else {
            String string4 = RMEnv.getSybaseDir();
            if (string4 != null) {
                object = System.getProperty("os.name");
                string = RSMConstants.OS_WINDOWS ? string4 + string2 + "ini" + string2 + "sql.ini" : string4 + string2 + "interfaces";
            } else {
                Exception exception = new Exception(BundleManager.getString("ProviderRes", "ERR_SYBASE_NOT_SET"));
                throw exception;
            }
        }
        this._interfaceFileName = string;
        object = new File(string);
        if (((File)object).exists() && ((File)object).lastModified() != _interfaceFilelastModified) {
            _interfaceFilelastModified = ((File)object).lastModified();
            return true;
        }
        return false;
    }

    private boolean isLDAPFileModified() throws LDAPException, FileNotFoundException, IOException {
        this._libtcldriver = new LibctlDriver();
        File file = new File(this._libtcldriver.getLDAP32FileName());
        if (file.exists() && file.lastModified() != _LDAP32FilelastModified) {
            _LDAP32FilelastModified = file.lastModified();
            return true;
        }
        File file2 = new File(this._libtcldriver.getLDAP64FileName());
        if (file2.exists() && file2.lastModified() != _LDAP64FilelastModified) {
            _LDAP64FilelastModified = file2.lastModified();
            return true;
        }
        return false;
    }

    private boolean initServerEntries() throws Exception {
        SyInterfacesEntry syInterfacesEntry;
        Object object;
        Object object2;
        this.initLDAPValues();
        boolean bl = false;
        boolean bl2 = false;
        try {
            RMEnv.setSybaseDir();
            bl = this.isInterfacesFileModified();
            if (bl) {
                _lookupfromInterfaces = new Hashtable();
                object2 = this.getInterfacesDriver();
                if (object2 != null) {
                    object = object2.entries();
                    while (object.hasMoreElements()) {
                        syInterfacesEntry = (SyInterfacesEntry)object.nextElement();
                        try {
                            _lookupfromInterfaces.put(syInterfacesEntry.getName(), new SyASEServer(syInterfacesEntry));
                        }
                        catch (NullPointerException nullPointerException) {
                            Dbg.trace(4, "NullPointerException when reading Interfaces file: " + nullPointerException.toString());
                        }
                    }
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            Dbg.trace(4, "NullPointerException when reading Interfaces file: " + nullPointerException.toString());
        }
        catch (Exception exception) {
            PluginSupport.LogInfoMessage(BundleManager.getString("ProviderRes", "INI_ERR"), BundleManager.getString("ProviderRes", "INI_ERR_DETAILS", exception.toString()));
            throw exception;
        }
        try {
            if (this._includeLDAP && ((bl2 = this.isLDAPFileModified()) || _LDAPOption != this._includeLDAP || _LDAPTimeout != this._ldapTimeout)) {
                this.getEntriesfromLDAP();
            }
        }
        catch (LDAPException lDAPException) {
            PluginSupport.LogInfoMessage(BundleManager.getString("ProviderRes", "LDAP_ERR"), BundleManager.getString("ProviderRes", "LDAP_ERR_DETAILS", lDAPException.toString()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            PluginSupport.LogInfoMessage(BundleManager.getString("ProviderRes", "LDAP_ERR"), BundleManager.getString("ProviderRes", "LDAP_ERR_DETAILS", fileNotFoundException.toString()));
        }
        catch (IOException iOException) {
            PluginSupport.LogInfoMessage(BundleManager.getString("ProviderRes", "LDAP_ERR"), BundleManager.getString("ProviderRes", "LDAP_ERR_DETAILS", iOException.toString()));
        }
        if (_LDAPTimeout == -1) {
            _LDAPOption = this._includeLDAP;
            _LDAPTimeout = this._ldapTimeout;
        }
        bl = this.checkinterfacesFileExist(bl);
        bl2 = this.checkLDAPFileExist(bl2);
        if (_LDAPOption != this._includeLDAP || _LDAPTimeout != this._ldapTimeout || bl || bl2) {
            _Servers = null;
            _LDAPOption = this._includeLDAP;
            _LDAPTimeout = this._ldapTimeout;
            if (_lookupfromInterfaces != null) {
                _Servers = (Hashtable)_lookupfromInterfaces.clone();
            }
            if (this._includeLDAP && _lookupfromLDAP != null) {
                if (_Servers == null) {
                    _Servers = (Hashtable)_lookupfromLDAP.clone();
                } else {
                    object2 = _lookupfromLDAP.keys();
                    while (object2.hasMoreElements()) {
                        object = (String)object2.nextElement();
                        if (_Servers.containsKey(object)) {
                            syInterfacesEntry = (SyASEServer)_lookupfromLDAP.get(object);
                            _Servers.put((String)object + " [" + syInterfacesEntry.getHost() + ":" + syInterfacesEntry.getPort() + "]", syInterfacesEntry);
                            continue;
                        }
                        _Servers.put(object, (SyASEServer)_lookupfromLDAP.get(object));
                    }
                }
            }
        }
        return _Servers != null;
    }

    public boolean checkinterfacesFileExist(boolean bl) {
        if (bl) {
            return bl;
        }
        if (this._interfaceFileName != null) {
            File file = new File(this._interfaceFileName);
            if (!file.exists() && _lookupfromInterfaces != null) {
                _lookupfromInterfaces = null;
                _interfaceFilelastModified = -1L;
                return true;
            }
        } else {
            _lookupfromInterfaces = null;
            _interfaceFilelastModified = -1L;
            return true;
        }
        return bl;
    }

    private boolean checkLDAPFileExist(boolean bl) {
        if (bl) {
            return bl;
        }
        if (this._libtcldriver == null && _lookupfromLDAP != null) {
            _lookupfromLDAP = null;
            _LDAP32FilelastModified = -1L;
            _LDAP64FilelastModified = -1L;
            return true;
        }
        return bl;
    }

    public List getAllServerNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (_Servers != null) {
            Enumeration enumeration = _Servers.keys();
            while (enumeration.hasMoreElements()) {
                arrayList.add((String)enumeration.nextElement());
            }
            Collections.sort(arrayList, new ComparatorIgnoreCase());
        }
        return arrayList;
    }

    private void getEntriesfromLDAP() {
        Vector vector = this._libtcldriver.getLDAPServers();
        for (int i = 0; i < vector.size(); ++i) {
            SyLDAPServer syLDAPServer = (SyLDAPServer)vector.elementAt(i);
            try {
                _lookupfromLDAP = null;
                if (!syLDAPServer.connectLDAP(this._ldapTimeout)) continue;
                syLDAPServer.initASEEntries();
                _lookupfromLDAP = (Hashtable)syLDAPServer.getLookup().clone();
                break;
            }
            catch (Exception exception) {
                PluginSupport.LogInfoMessage(BundleManager.getString("ProviderRes", "LDAP_ERR"), BundleManager.getString("ProviderRes", "LDAP_ERR_DETAILS", exception.toString()));
            }
        }
    }

    public SyInterfacesDriver getInterfacesDriver() throws Exception {
        try {
            _interfacesDriver = new SyInterfacesDriver();
            _interfacesDriver.open();
        }
        catch (IOException iOException) {
            PluginSupport.LogInfoMessage(BundleManager.getString("ProviderRes", "INI_ERR"), BundleManager.getString("ProviderRes", "INI_ERR_DETAILS", iOException.toString()));
        }
        return _interfacesDriver;
    }

    class ComparatorIgnoreCase
    implements Comparator {
        ComparatorIgnoreCase() {
        }

        public int compare(Object object, Object object2) {
            return object.toString().compareToIgnoreCase(object2.toString());
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object);
        }
    }
}

