/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.status;

import com.sybase.rsmplugin.status.StatusSO;
import com.sybase.rsmplugin.util.Dbg;
import java.util.List;

public class ComponentState {
    private static final int CLEAR_STATE = 0;
    private static final int CHANGED_STATE = 1;
    private static final int UNCHANGED_STATE = 2;
    private static final int NEW_STATE = 3;
    private int _changeFlag;
    StatusSO _so;

    public ComponentState(StatusSO statusSO) {
        Dbg.wassert(statusSO != null, "Null Status SO parameter.");
        this._so = statusSO;
        this._changeFlag = 3;
    }

    public StatusSO getStatusSO() {
        Dbg.wassert(this._so != null, "Null Status SO attribute.");
        return this._so;
    }

    public boolean isClear() {
        return this._changeFlag == 0;
    }

    public void clear() {
        this._changeFlag = 0;
    }

    public boolean hasChanged() {
        return this._changeFlag == 1;
    }

    public void changed() {
        this._changeFlag = 1;
    }

    public boolean isUnchanged() {
        return this._changeFlag == 2;
    }

    public void unchanged() {
        this._changeFlag = 2;
    }

    public boolean isNewComponent() {
        return this._changeFlag == 3;
    }

    public void newComponent() {
        this._changeFlag = 3;
    }

    public int getState() {
        Dbg.wassert(this._so != null, "Null Status SO attribute.");
        return this._so.getRSState();
    }

    public void setState(int n) {
        Dbg.wassert(this._so != null, "Null Status Item attribute.");
        this._so.setState(n);
    }

    public String getReason() {
        Dbg.wassert(this._so != null, "Null Status SO attribute.");
        return this._so.getReason();
    }

    public List getReasons() {
        Dbg.wassert(this._so != null, "Null Status SO attribute.");
        return this._so.getReasons();
    }

    public void setReasons(List list) {
        Dbg.wassert(this._so != null, "Null Status SO attribute.");
        this._so.setReasons(list);
    }

    public String getType() {
        Dbg.wassert(this._so != null, "Null Status SO attribute.");
        return this._so.getType();
    }

    public String getName() {
        Dbg.wassert(this._so != null, "Null Status SO attribute.");
        return this._so.getName();
    }

    public boolean equals(ComponentState componentState) {
        Dbg.wassert(componentState != null, "Null ComponentState parameter.");
        return this.getType().equals(componentState.getType()) && this.getName().equals(componentState.getName());
    }

    public boolean equals(String string, String string2) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty type parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty name parameter.");
        return this.getType().equals(string) && this.getName().equals(string2);
    }

    public boolean equals(StatusSO statusSO) {
        Dbg.wassert(statusSO != null, "Null StatusSO parameter.");
        return this.getType().equals(statusSO.getType()) && this.getName().equals(statusSO.getName());
    }

    public void changed(int n, List list) {
        boolean bl;
        Dbg.wassert(list != null, "Null reason list.");
        boolean bl2 = bl = this.getState() == n;
        if (bl) {
            if (this.getReasons().size() != list.size()) {
                bl = false;
            } else {
                for (int i = 0; i < list.size() && bl; ++i) {
                    bl = this.getReasons().get(i).equals(list.get(i));
                }
            }
        }
        if (!bl) {
            this.changed();
            this.setState(n);
            this.setReasons(list);
        } else {
            this.unchanged();
        }
    }

    public void dump() {
        Dbg.trace(512, "Status Monitor component: " + this.getType() + "." + this.getName() + " - [" + String.valueOf(this.getState()) + "] " + this.getReason());
    }
}

