/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.status;

import com.sybase.central.SCProfile;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.util.Dbg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class EnvFilterManager {
    private static final String FILTER_SUB_PROFILE = "ConnFilter";
    private EnvDomain _env;
    private List _connFilterList = null;

    public EnvFilterManager(EnvDomain envDomain) {
        Dbg.wassert(envDomain != null, "Null environment connection parameter.");
        this._env = envDomain;
    }

    public boolean isRepAgentFiltered(String string) {
        ConnectionFilter connectionFilter;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty connection name parameter.");
        if (this._connFilterList == null) {
            this.load();
        }
        return (connectionFilter = this.find(string)) != null && connectionFilter.isRepAgentFiltered();
    }

    public void setRepAgentFilter(String string, boolean bl) {
        ConnectionFilter connectionFilter;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty connection name parameter.");
        if (this._connFilterList == null) {
            this.load();
        }
        if ((connectionFilter = this.find(string)) != null) {
            if (connectionFilter.isRepAgentFiltered() != bl) {
                connectionFilter.setRepAgentFilter(bl);
                if (!connectionFilter.isRepAgentFiltered() && !connectionFilter.isDSIFiltered()) {
                    this._connFilterList.remove(connectionFilter);
                }
                this.save();
            }
        } else if (bl) {
            connectionFilter = new ConnectionFilter(string);
            connectionFilter.setRepAgentFilter(true);
            this._connFilterList.add(connectionFilter);
            this.save();
        }
    }

    public boolean isDSIFiltered(String string) {
        ConnectionFilter connectionFilter;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty connection name parameter.");
        if (this._connFilterList == null) {
            this.load();
        }
        return (connectionFilter = this.find(string)) != null && connectionFilter.isDSIFiltered();
    }

    public void setDSIFilter(String string, boolean bl) {
        ConnectionFilter connectionFilter;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty connection name parameter.");
        if (this._connFilterList == null) {
            this.load();
        }
        if ((connectionFilter = this.find(string)) != null) {
            if (connectionFilter.isDSIFiltered() != bl) {
                connectionFilter.setDSIFilter(bl);
                if (!connectionFilter.isRepAgentFiltered() && !connectionFilter.isDSIFiltered()) {
                    this._connFilterList.remove(connectionFilter);
                }
                this.save();
            }
        } else if (bl) {
            connectionFilter = new ConnectionFilter(string);
            connectionFilter.setDSIFilter(true);
            this._connFilterList.add(connectionFilter);
            this.save();
        }
    }

    protected EnvDomain getEnvironment() {
        Dbg.wassert(this._env != null, "Null environment connection attribute.");
        return this._env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectionFilter find(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty connection name parameter.");
        List list = this._connFilterList;
        synchronized (list) {
            ListIterator listIterator = this._connFilterList.listIterator();
            while (listIterator.hasNext()) {
                ConnectionFilter connectionFilter = (ConnectionFilter)listIterator.next();
                if (!connectionFilter.getName().equals(string)) continue;
                return connectionFilter;
            }
        }
        return null;
    }

    protected void load() {
        String string = this.getEnvironment().getName();
        if (string != null && string.length() > 0) {
            if (this._connFilterList == null) {
                this._connFilterList = Collections.synchronizedList(new ArrayList());
            } else {
                this._connFilterList.clear();
            }
            String string2 = "ConnFilter." + string;
            SCProfile sCProfile = PluginSupport.getProfile().openSubProfile(string2);
            String[] stringArray = sCProfile.getValueNames();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        String string3 = sCProfile.readString(stringArray[i]);
                        int n = Integer.valueOf(string3);
                        ConnectionFilter connectionFilter = new ConnectionFilter(stringArray[i]);
                        connectionFilter.setFilterMask(n);
                        this._connFilterList.add(connectionFilter);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save() {
        String string = this.getEnvironment().getName();
        if (string != null && string.length() > 0) {
            String string2 = "ConnFilter." + string;
            PluginSupport.getProfile().deleteSubProfile(string2);
            SCProfile sCProfile = PluginSupport.getProfile().openSubProfile(string2);
            List list = this._connFilterList;
            synchronized (list) {
                ListIterator listIterator = this._connFilterList.listIterator();
                while (listIterator.hasNext()) {
                    ConnectionFilter connectionFilter = (ConnectionFilter)listIterator.next();
                    String string3 = String.valueOf(connectionFilter.getFilterMask());
                    sCProfile.writeString(connectionFilter.getName(), string3);
                }
            }
        }
    }

    public void delete() {
        String string = this.getEnvironment().getName();
        if (string != null && string.length() > 0) {
            String string2 = "ConnFilter." + string;
            PluginSupport.getProfile().deleteSubProfile(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump() {
        List list = this._connFilterList;
        synchronized (list) {
            ListIterator listIterator = this._connFilterList.listIterator();
            while (listIterator.hasNext()) {
                ConnectionFilter connectionFilter = (ConnectionFilter)listIterator.next();
                Dbg.trace(connectionFilter.dump());
            }
        }
    }

    class ConnectionFilter {
        public static final int RA_MASK = 1;
        public static final int DSI_MASK = 2;
        public String _name;
        public int _filters;

        public ConnectionFilter(String string) {
            Dbg.wassert(string != null && string.length() > 0, "Null or empty connection name parameter.");
            this._name = string;
        }

        public String getName() {
            Dbg.wassert(this._name != null && this._name.length() > 0, "Null or empty connection name attribute.");
            return this._name;
        }

        public int getFilterMask() {
            return this._filters;
        }

        public boolean isRepAgentFiltered() {
            return (this._filters & 1) == 1;
        }

        public boolean isDSIFiltered() {
            return (this._filters & 2) == 2;
        }

        public void setFilterMask(int n) {
            this._filters = n;
        }

        public void setRepAgentFilter(boolean bl) {
            this._filters = bl ? this._filters | 1 : this._filters ^ 1;
        }

        public void setDSIFilter(boolean bl) {
            this._filters = bl ? this._filters | 2 : this._filters ^ 2;
        }

        public String dump() {
            return this._name + (this.isRepAgentFiltered() ? " - Rep Agent" : "") + (this.isDSIFiltered() ? " - DSI" : "");
        }
    }
}

