/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.status;

import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.ase.DomainASE;
import com.sybase.rsmplugin.components.connection.DomainPhyConnection;
import com.sybase.rsmplugin.components.directconnect.DomainDirectConnect;
import com.sybase.rsmplugin.components.environment.Environment;
import com.sybase.rsmplugin.components.hds.DomainHDS;
import com.sybase.rsmplugin.components.lanrepagent.DomainLANRepAgent;
import com.sybase.rsmplugin.components.logical.DomainLogConnection;
import com.sybase.rsmplugin.components.logical.DomainLogServer;
import com.sybase.rsmplugin.components.mirrorrepagent.DomainMirrorRepAgent;
import com.sybase.rsmplugin.components.queue.DomainQueue;
import com.sybase.rsmplugin.components.repserver.DomainRepServer;
import com.sybase.rsmplugin.components.route.DomainRoute;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.status.ComponentState;
import com.sybase.rsmplugin.status.StatusManager;
import com.sybase.rsmplugin.status.StatusMap;
import com.sybase.rsmplugin.status.StatusSO;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class EnvStatusMonitor
extends Thread {
    private EnvDomain _domain = null;
    private StatusMap _statusMap = null;
    private int _state;
    private ArrayList _reason = new ArrayList();

    public EnvStatusMonitor(EnvDomain envDomain, StatusMap statusMap) {
        Dbg.wassert(envDomain != null, "Null Domain parameter.");
        Dbg.wassert(statusMap != null, "Null Status Map parameter.");
        this._domain = envDomain;
        this._statusMap = statusMap;
        this.setDaemon(true);
        this.setName(envDomain.getName() + "_Status_Monitor");
    }

    public String getDomainName() {
        Dbg.wassert(this._domain != null, "Null domain connection attribute.");
        return this._domain.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Dbg.trace(256, "Begin monitor cycle for Environment '" + this.getDomainName() + "'");
        EnvDomain envDomain = this._domain;
        synchronized (envDomain) {
            if (this._domain.isMonitoring()) {
                this._state = 5;
                this._reason.clear();
                this.monitorRAs();
                this.monitorMRAs();
                this.monitorDCs();
                this.monitorRepServers();
                this.monitorASEs();
                this.monitorHDSs();
                this.monitorLogicalServers();
                Environment environment = new Environment(this._domain);
                ComponentState componentState = this._statusMap.get(environment.getType(), environment.getName());
                if (componentState != null) {
                    componentState.changed(this._state, this._reason);
                } else {
                    environment.setState(this._state);
                    environment.setReasons(this._reason);
                    componentState = new ComponentState(environment);
                    this._statusMap.put(environment.getType(), environment.getName(), componentState);
                }
                this.refreshComponents();
                this._domain.setLastMonitoredDate(new Date());
            }
        }
    }

    protected void monitorRepServers() {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        if (semanticFactory != null) {
            List list = semanticFactory.getRepServers();
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                ComponentState componentState;
                DomainRepServer domainRepServer = (DomainRepServer)listIterator.next();
                if (domainRepServer.monitor()) {
                    this.getRSComponentStatus(domainRepServer);
                }
                if ((componentState = this._statusMap.get(domainRepServer.getType(), domainRepServer.getName())) != null) {
                    boolean bl;
                    boolean bl2 = bl = !(domainRepServer.getRSState() == 5 && componentState.getStatusSO().getRSState() == 10 || domainRepServer.getRSState() == 10 && componentState.getStatusSO().getRSState() == 5);
                    if (bl) {
                        bl = domainRepServer.getRSState() != 4 || componentState.getStatusSO().getRSState() != 4;
                    }
                    componentState.getStatusSO().setReportEvent(bl);
                    componentState.changed(domainRepServer.getRSState(), domainRepServer.getReasons());
                } else {
                    componentState = new ComponentState(domainRepServer);
                    this._statusMap.put(domainRepServer.getType(), domainRepServer.getName(), componentState);
                }
                if (domainRepServer.isUp()) continue;
                this._state = 4;
                this.addServerReasons(domainRepServer);
            }
        }
    }

    protected void monitorASEs() {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        if (semanticFactory != null) {
            ListIterator listIterator = semanticFactory.getASEs().listIterator();
            while (listIterator.hasNext()) {
                DomainASE domainASE = (DomainASE)listIterator.next();
                domainASE.monitor();
                ComponentState componentState = this._statusMap.get(domainASE.getType(), domainASE.getName());
                if (componentState != null) {
                    boolean bl = domainASE.getRSState() != 4 || componentState.getStatusSO().getRSState() != 4;
                    componentState.getStatusSO().setReportEvent(bl);
                    componentState.changed(domainASE.getRSState(), domainASE.getReasons());
                } else {
                    componentState = new ComponentState(domainASE);
                    this._statusMap.put(domainASE.getType(), domainASE.getName(), componentState);
                }
                if (domainASE.isUp()) continue;
                this._state = 4;
                this.addServerReasons(domainASE);
            }
        }
    }

    protected void monitorHDSs() {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        if (semanticFactory != null) {
            ListIterator listIterator = semanticFactory.getHDSs().listIterator();
            while (listIterator.hasNext()) {
                DomainHDS domainHDS = (DomainHDS)listIterator.next();
                domainHDS.monitor();
                ComponentState componentState = this._statusMap.get(domainHDS.getType(), domainHDS.getName());
                if (componentState != null) {
                    boolean bl = domainHDS.getRSState() != 4 || componentState.getStatusSO().getRSState() != 4;
                    componentState.getStatusSO().setReportEvent(bl);
                    componentState.changed(domainHDS.getRSState(), domainHDS.getReasons());
                } else {
                    componentState = new ComponentState(domainHDS);
                    this._statusMap.put(domainHDS.getType(), domainHDS.getName(), componentState);
                }
                if (domainHDS.isUp()) continue;
                this._state = 4;
                this.addServerReasons(domainHDS);
            }
        }
    }

    protected void monitorLogicalServers() {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        if (semanticFactory != null) {
            try {
                ListIterator listIterator = semanticFactory.getLogServers().listIterator();
                while (listIterator.hasNext()) {
                    DomainLogServer domainLogServer = (DomainLogServer)listIterator.next();
                    domainLogServer.monitor();
                    ComponentState componentState = this._statusMap.get(domainLogServer.getType(), domainLogServer.getName());
                    if (componentState != null) {
                        componentState.changed(domainLogServer.getRSState(), domainLogServer.getReasons());
                    } else {
                        componentState = new ComponentState(domainLogServer);
                        this._statusMap.put(domainLogServer.getType(), domainLogServer.getName(), componentState);
                    }
                    if (domainLogServer.isUp()) continue;
                    this._state = 4;
                    this.addServerReasons(domainLogServer);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }
    }

    protected void monitorRAs() {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        if (semanticFactory != null) {
            ListIterator listIterator = semanticFactory.getLANRepAgents().listIterator();
            while (listIterator.hasNext()) {
                DomainLANRepAgent domainLANRepAgent = (DomainLANRepAgent)listIterator.next();
                domainLANRepAgent.monitor();
                ComponentState componentState = this._statusMap.get(domainLANRepAgent.getType(), domainLANRepAgent.getName());
                if (componentState != null) {
                    componentState.changed(domainLANRepAgent.getRSState(), domainLANRepAgent.getReasons());
                } else {
                    componentState = new ComponentState(domainLANRepAgent);
                    this._statusMap.put(domainLANRepAgent.getType(), domainLANRepAgent.getName(), componentState);
                }
                if (domainLANRepAgent.isUp()) continue;
                this._state = 4;
                this.addServerReasons(domainLANRepAgent);
            }
        }
    }

    protected void monitorMRAs() {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        if (semanticFactory != null) {
            ListIterator listIterator = semanticFactory.getMirrorRepAgents().listIterator();
            while (listIterator.hasNext()) {
                DomainMirrorRepAgent domainMirrorRepAgent = (DomainMirrorRepAgent)listIterator.next();
                domainMirrorRepAgent.monitor();
                ComponentState componentState = this._statusMap.get(domainMirrorRepAgent.getType(), domainMirrorRepAgent.getName());
                if (componentState != null) {
                    componentState.changed(domainMirrorRepAgent.getRSState(), domainMirrorRepAgent.getReasons());
                } else {
                    componentState = new ComponentState(domainMirrorRepAgent);
                    this._statusMap.put(domainMirrorRepAgent.getType(), domainMirrorRepAgent.getName(), componentState);
                }
                if (domainMirrorRepAgent.isUp()) continue;
                this._state = 4;
                this.addServerReasons(domainMirrorRepAgent);
            }
        }
    }

    protected void monitorDCs() {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        if (semanticFactory != null) {
            ListIterator listIterator = semanticFactory.getDirectConnects().listIterator();
            while (listIterator.hasNext()) {
                DomainDirectConnect domainDirectConnect = (DomainDirectConnect)listIterator.next();
                domainDirectConnect.monitor();
                ComponentState componentState = this._statusMap.get(domainDirectConnect.getType(), domainDirectConnect.getName());
                if (componentState != null) {
                    componentState.changed(domainDirectConnect.getRSState(), domainDirectConnect.getReasons());
                } else {
                    componentState = new ComponentState(domainDirectConnect);
                    this._statusMap.put(domainDirectConnect.getType(), domainDirectConnect.getName(), componentState);
                }
                if (domainDirectConnect.isUp()) continue;
                this._state = 4;
                this.addServerReasons(domainDirectConnect);
            }
        }
    }

    protected void addServerReasons(StatusSO statusSO) {
        if (statusSO.getReasons() != null) {
            ListIterator listIterator = statusSO.getReasons().listIterator();
            while (listIterator.hasNext()) {
                String string = (String)listIterator.next();
                if (string == null || string.length() <= 0) continue;
                this._reason.add(statusSO.getName() + " - " + string);
            }
        }
    }

    protected void getRSComponentStatus(DomainRepServer domainRepServer) {
        Dbg.wassert(domainRepServer != null, "Null rep server parameter.");
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        if (semanticFactory != null) {
            try {
                List list = semanticFactory.getRSThreads(domainRepServer.getName());
                this.getConnectionStatus(domainRepServer, list);
                this.getRouteStatus(domainRepServer, list);
                this.getQueueStatus(domainRepServer);
                this.getLogConnectionStatus(domainRepServer);
            }
            catch (SQLException sQLException) {
                PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }
    }

    protected void getConnectionStatus(DomainRepServer domainRepServer, List list) {
        Dbg.wassert(domainRepServer != null, "Null rep server parameter.");
        Dbg.wassert(list != null, "Null RS threads list parameter.");
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        if (semanticFactory != null) {
            try {
                List list2 = semanticFactory.getPhyConnections(domainRepServer.getName());
                ListIterator listIterator = list2.listIterator();
                while (listIterator.hasNext()) {
                    ComponentState componentState;
                    DomainPhyConnection domainPhyConnection = (DomainPhyConnection)listIterator.next();
                    domainPhyConnection.monitor(list);
                    if (!domainPhyConnection.isUp()) {
                        if (domainRepServer.isUp()) {
                            domainRepServer.setState(4);
                        }
                        domainRepServer.addReason(domainPhyConnection.getReasons());
                    }
                    if ((componentState = this._statusMap.get(domainPhyConnection.getType(), domainPhyConnection.getName())) != null) {
                        componentState.changed(domainPhyConnection.getRSState(), domainPhyConnection.getReasons());
                        continue;
                    }
                    componentState = new ComponentState(domainPhyConnection);
                    this._statusMap.put(domainPhyConnection.getType(), domainPhyConnection.getName(), componentState);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }
    }

    protected void getLogConnectionStatus(DomainRepServer domainRepServer) {
        Dbg.wassert(domainRepServer != null, "Null rep server parameter.");
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        if (semanticFactory != null) {
            try {
                List list = semanticFactory.getLogConnections(domainRepServer.getName());
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    ComponentState componentState;
                    DomainLogConnection domainLogConnection = (DomainLogConnection)listIterator.next();
                    domainLogConnection.monitor();
                    if (!domainLogConnection.isUp()) {
                        if (domainRepServer.isUp()) {
                            domainRepServer.setState(4);
                        }
                        CollectionUtility.mergeLists(domainLogConnection.getReasons(), domainRepServer.getReasons());
                    }
                    if ((componentState = this._statusMap.get(domainLogConnection.getType(), domainLogConnection.getName())) != null) {
                        componentState.changed(domainLogConnection.getRSState(), domainLogConnection.getReasons());
                        continue;
                    }
                    componentState = new ComponentState(domainLogConnection);
                    this._statusMap.put(domainLogConnection.getType(), domainLogConnection.getName(), componentState);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }
    }

    protected void getRouteStatus(DomainRepServer domainRepServer, List list) {
        Dbg.wassert(domainRepServer != null, "Null rep server parameter.");
        Dbg.wassert(list != null, "Null RS threads list parameter.");
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        if (semanticFactory != null) {
            try {
                List list2 = semanticFactory.getRoutes(domainRepServer.getName());
                ListIterator listIterator = list2.listIterator();
                while (listIterator.hasNext()) {
                    ComponentState componentState;
                    DomainRoute domainRoute = (DomainRoute)listIterator.next();
                    if (domainRoute.getOriginRS() == null || !domainRoute.getOriginRS().equals(domainRepServer.getName())) continue;
                    domainRoute.monitor(list);
                    if (!domainRoute.isUp()) {
                        if (domainRepServer.isUp()) {
                            domainRepServer.setState(4);
                        }
                        domainRepServer.addReason(domainRoute.getReasons());
                    }
                    if ((componentState = this._statusMap.get(domainRoute.getType(), domainRoute.getName())) != null) {
                        componentState.changed(domainRoute.getRSState(), domainRoute.getReasons());
                        continue;
                    }
                    componentState = new ComponentState(domainRoute);
                    this._statusMap.put(domainRoute.getType(), domainRoute.getName(), componentState);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }
    }

    protected void getQueueStatus(DomainRepServer domainRepServer) {
        Dbg.wassert(domainRepServer != null, "Null rep server parameter.");
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        if (semanticFactory != null) {
            try {
                List list = semanticFactory.getQueues(domainRepServer.getName());
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    ComponentState componentState;
                    DomainQueue domainQueue = (DomainQueue)listIterator.next();
                    domainQueue.monitor();
                    if (!domainQueue.isUp()) {
                        if (domainRepServer.isUp()) {
                            domainRepServer.setState(4);
                        }
                        domainRepServer.addReason(domainQueue.getReasons());
                    }
                    if ((componentState = this._statusMap.get(domainQueue.getType(), domainQueue.getName())) != null) {
                        componentState.changed(domainQueue.getRSState(), domainQueue.getReasons());
                        continue;
                    }
                    componentState = new ComponentState(domainQueue);
                    this._statusMap.put(domainQueue.getType(), domainQueue.getName(), componentState);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }
    }

    protected void refreshComponents() {
        Iterator iterator = this._statusMap.iterator();
        while (iterator.hasNext()) {
            ComponentState componentState = (ComponentState)iterator.next();
            if (componentState.isClear()) {
                Dbg.trace(768, "Stop monitoring object:");
                componentState.dump();
                iterator.remove();
                continue;
            }
            if (componentState.hasChanged()) {
                Dbg.trace(768, "Object changed state:");
                componentState.dump();
                StatusManager.redisplay(this.getDomainName(), componentState.getType(), componentState.getName(), componentState.getState(), componentState.getReasons());
                if (componentState.getStatusSO().reportEvents()) {
                    PluginSupport.addEvent(componentState.getStatusSO());
                }
            } else if (componentState.isNewComponent()) {
                Dbg.trace(768, "Start monitoring object:");
                componentState.dump();
                StatusManager.redisplay(this.getDomainName(), componentState.getType(), componentState.getName(), componentState.getState(), componentState.getReasons());
            }
            componentState.clear();
        }
    }
}

