/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.status;

import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.status.ComponentState;
import com.sybase.rsmplugin.status.EnvStatusMonitor;
import com.sybase.rsmplugin.status.StatusMap;
import com.sybase.rsmplugin.status.StatusSO;
import com.sybase.rsmplugin.util.Dbg;
import java.util.Date;

public class MonitorTimer
extends Thread {
    private StatusMap _statusMap;
    private EnvDomain _domain;
    private boolean _isMonitoringOn = false;
    private int _interval;
    private Date _lastMonitoredDate;
    private boolean _refreshRequested = false;

    public MonitorTimer(EnvDomain envDomain, boolean bl, int n) {
        this._domain = envDomain;
        this._statusMap = new StatusMap();
        this._isMonitoringOn = bl;
        this._interval = n;
        this.setDaemon(true);
        this.setName(envDomain.getName() + "_Monitor_Timer");
    }

    public synchronized boolean isMonitoringOn() {
        return this._isMonitoringOn;
    }

    public synchronized void setMonitoring(boolean bl) {
        if (bl != this._isMonitoringOn) {
            this._isMonitoringOn = bl;
            if (this.isAlive() && this.isMonitoringOn()) {
                this.setRefreshRequested(true);
                this.notifyAll();
            }
        }
    }

    public synchronized void refreshStatus() {
        Dbg.trace(256, "Status refresh has been requested for the environment " + this._domain.getName());
        this.setRefreshRequested(true);
        if (this.isAlive()) {
            this.notifyAll();
        }
    }

    public synchronized int getInterval() {
        return this._interval;
    }

    public synchronized void setInterval(int n) {
        this._interval = n;
        if (this.isAlive()) {
            this.notifyAll();
        }
    }

    public synchronized Date getLastMonitoredDate() {
        return this._lastMonitoredDate;
    }

    public StatusSO getStatus(String string, String string2) {
        ComponentState componentState = this._statusMap.get(string, string2);
        if (componentState != null) {
            return componentState.getStatusSO();
        }
        return null;
    }

    public void end() {
        this.interrupt();
    }

    @Override
    public void run() {
        block5: {
            EnvStatusMonitor envStatusMonitor = null;
            try {
                while (!MonitorTimer.interrupted()) {
                    if (this.isMonitoringOn() || this.isRefreshRequested()) {
                        this.setRefreshRequested(false);
                        envStatusMonitor = new EnvStatusMonitor(this._domain, this._statusMap);
                        Dbg.trace(256, "Start the monitoring cycle for the environment " + this._domain.getName());
                        envStatusMonitor.start();
                        while (envStatusMonitor.isAlive()) {
                            envStatusMonitor.join();
                        }
                        this.setLastMonitoredDate();
                    }
                    this.sleep();
                }
            }
            catch (InterruptedException interruptedException) {
                Dbg.trace(256, "Monitor Timer thread " + this.getName() + " has been interrupted.");
                if (envStatusMonitor == null || !envStatusMonitor.isAlive()) break block5;
                envStatusMonitor.interrupt();
            }
        }
    }

    protected synchronized void sleep() throws InterruptedException {
        Date date = new Date();
        long l = date.getTime();
        long l2 = 0L;
        for (long i = (long)(this.getInterval() * 1000); !this.isRefreshRequested() && i > 0L; i -= l2) {
            this.wait(i);
            i = this.getInterval() * 1000;
            date = new Date();
            l2 = date.getTime() - l;
        }
    }

    private synchronized boolean isRefreshRequested() {
        return this._refreshRequested;
    }

    private synchronized void setRefreshRequested(boolean bl) {
        this._refreshRequested = bl;
    }

    private synchronized void setLastMonitoredDate() {
        this._lastMonitoredDate = new Date();
    }
}

