/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.status;

import com.sybase.rma.callback.RMSMonitorListener;
import com.sybase.rma.callback.RMSTriggerListener;
import com.sybase.rma.callback.Status;
import com.sybase.rma.callback.StatusClient;
import com.sybase.rma.callback.TriggerClient;
import com.sybase.rma.callback.TriggerMessage;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.RMSStatusSO;
import com.sybase.rsmplugin.components.ase.RMSASE;
import com.sybase.rsmplugin.components.connection.RMSPhyConnection;
import com.sybase.rsmplugin.components.directconnect.RMSDirectConnect;
import com.sybase.rsmplugin.components.lanrepagent.RMSLANRepAgent;
import com.sybase.rsmplugin.components.logical.RMSLogConnection;
import com.sybase.rsmplugin.components.mirrorrepagent.RMSMirrorRepAgent;
import com.sybase.rsmplugin.components.queue.RMSQueue;
import com.sybase.rsmplugin.components.remoterms.RMSRemoteRMS;
import com.sybase.rsmplugin.components.repserver.RMSRepServer;
import com.sybase.rsmplugin.components.rms.RMS;
import com.sybase.rsmplugin.components.route.RMSRoute;
import com.sybase.rsmplugin.sql.RMSConnection;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.status.StatusManager;
import com.sybase.rsmplugin.status.StatusSO;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class RMSStatusMonitor
implements RMSMonitorListener,
RMSTriggerListener {
    private static final String STATUS_SERVICES = "StatusService";
    private static final String TRIGGER_SERVICES = "TriggerService";
    private static final String GET_RMI_ADDRESS = "GET_RMI_ADDRESS";
    private static final Object[][] contents = new Object[][]{{"GET_RMI_ADDRESS", new Integer(1500), "get rmiAddress"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);
    private static DateFormat _dateFormat = null;
    private RMSDomain _domain = null;
    private StatusClient _statusClient = null;
    private TriggerClient _triggerClient = null;

    public RMSStatusMonitor(RMSDomain rMSDomain) {
        Dbg.wassert(rMSDomain != null, "Null Domain parameter.");
        this._domain = rMSDomain;
        if (_dateFormat == null) {
            _dateFormat = DateFormat.getDateTimeInstance(3, 2);
        }
    }

    public RMSDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain connection attribute.");
        return this._domain;
    }

    public String getDomainName() {
        return this.getDomain().getName();
    }

    public void start() throws Exception {
        Dbg.trace(768, "Start the RMS monitoring process for " + this.getDomainName());
        String string = this.getRMIAddress();
        if (string != null && string.length() > 0) {
            this._statusClient = new StatusClient();
            this._statusClient.setRmiAddress(string + STATUS_SERVICES);
            this._statusClient.register((RMSMonitorListener)this);
            this._triggerClient = new TriggerClient();
            this._triggerClient.setRmiAddress(string + TRIGGER_SERVICES);
            this._triggerClient.register((RMSTriggerListener)this);
        }
    }

    public void stop() {
        Dbg.trace(768, "Stop the RMS monitoring process for " + this.getDomainName());
        if (this._statusClient != null) {
            this._statusClient.cancel();
            this._statusClient = null;
        }
        if (this._triggerClient != null) {
            this._triggerClient.cancel();
            this._triggerClient = null;
        }
    }

    public void reRegister() throws Exception {
        this.stop();
        this.start();
    }

    protected String getRMIAddress() throws SQLException {
        String string = "";
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection != null) {
            String string2 = null;
            int n = this.getDomain().getRMSVersionNumber();
            string2 = _cmdBundle.getCommand(GET_RMI_ADDRESS, n);
            Dbg.wassert(string2 != null, "Unable to get the RMI address from the RMS - version: " + String.valueOf(n));
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(1);
                    string = string + string3;
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                throw sQLException;
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        Dbg.trace(768, "RMI Address: " + string);
        return string;
    }

    public void notifyStatus(ArrayList arrayList) {
        if (arrayList != null) {
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                Status status = (Status)listIterator.next();
                Object[] objectArray = new String[]{status.get_type(), status.get_componentName() != null && status.get_componentName().length() > 0 ? status.get_componentName() : status.get_serverName(), status.get_state(), status.get_descriptions().isEmpty() ? "" : (String)status.get_descriptions().get(0)};
                String string = BundleManager.getString("StatusMonitorRes", "STATUS_LOG_MSG", objectArray);
                Object[] objectArray2 = new String[]{this.getDomainName(), status.get_type(), status.get_serverName(), status.get_componentName() != null && status.get_componentName().length() > 0 ? status.get_componentName() : "", status.get_OldState(), status.get_state(), status.get_lastMonitored() != null ? _dateFormat.format(status.get_lastMonitored()) : "", status.get_descriptions().isEmpty() ? "" : (String)status.get_descriptions().get(0)};
                String string2 = BundleManager.getString("StatusMonitorRes", "STATUS_LOG_DETAILS", objectArray2);
                Dbg.trace(256, string);
                Dbg.trace(512, string2);
                PluginSupport.LogInfoMessage(string, string2);
                StatusSO statusSO = this.getSO(status.get_serverName(), status.get_componentName(), status.get_type(), status.get_stateConstant(), status.get_descriptions());
                StatusManager.redisplay(this.getDomainName(), statusSO.getType(), statusSO.getName(), statusSO.getRSState(), statusSO.getReasons());
                if (!statusSO.reportEvents()) continue;
                PluginSupport.addEvent(statusSO);
            }
        }
    }

    public void notifyTrigger(ArrayList arrayList) {
        if (arrayList != null) {
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                TriggerMessage triggerMessage = (TriggerMessage)listIterator.next();
                String string = triggerMessage.get_componentName() != null && triggerMessage.get_componentName().length() > 0 ? triggerMessage.get_componentName() : triggerMessage.get_serverName();
                String string2 = triggerMessage.get_componentType() != null && triggerMessage.get_componentType().length() > 0 ? triggerMessage.get_componentType() : triggerMessage.get_serverType();
                String string3 = triggerMessage.getExecutionStatus() != null && triggerMessage.getExecutionStatus().length() > 0 ? triggerMessage.getExecutionStatus() : BundleManager.getString("StatusMonitorRes", "TRIGGER_EXECUTION_MSG", triggerMessage.getScript());
                Object[] objectArray = new String[]{triggerMessage.get_triggerType(), string2, string, string3};
                String string4 = BundleManager.getString("StatusMonitorRes", "TRIGGER_LOG_MSG", objectArray);
                Object[] objectArray2 = new String[]{this.getDomainName(), triggerMessage.get_serverType(), triggerMessage.get_serverName(), triggerMessage.get_componentType(), triggerMessage.get_componentName(), triggerMessage.get_triggerType(), triggerMessage.get_state(), triggerMessage.getScript(), triggerMessage.getExecutionStatus(), triggerMessage.get_dateTime().toString(), triggerMessage.get_dateTime() != null ? _dateFormat.format(triggerMessage.get_dateTime()) : ""};
                String string5 = BundleManager.getString("StatusMonitorRes", "TRIGGER_LOG_DETAILS", objectArray2);
                Dbg.trace(256, string4);
                Dbg.trace(512, string5);
                PluginSupport.LogInfoMessage(string4, string5);
                String string6 = string + " (" + triggerMessage.get_triggerType() + ")";
                String string7 = triggerMessage.get_state();
                if (triggerMessage.get_triggerType().equalsIgnoreCase("latency")) {
                    string7 = BundleManager.getString("StatusMonitorRes", "LATENCY_TRIGGER_STATE", String.valueOf(triggerMessage.get_stateConstant()));
                } else if (triggerMessage.get_triggerType().equalsIgnoreCase("size")) {
                    if (triggerMessage.get_componentType().equalsIgnoreCase("partition")) {
                        string7 = BundleManager.getString("StatusMonitorRes", "PARTITION_SIZE_TRIGGER_STATE", String.valueOf(triggerMessage.get_stateConstant()));
                    } else if (triggerMessage.get_triggerType().equalsIgnoreCase("queue")) {
                        string7 = BundleManager.getString("StatusMonitorRes", "QUEUE_SIZE_TRIGGER_STATE", String.valueOf(triggerMessage.get_stateConstant()));
                    }
                }
                PluginSupport.addEvent(RSMImages.getTrigger(), string6, string7, this.getDomainName(), string3);
            }
        }
    }

    protected StatusSO getSO(String string, String string2, String string3, int n, List list) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty server parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty component type parameter.");
        RMSStatusSO rMSStatusSO = null;
        if (string3.equalsIgnoreCase("RMS")) {
            rMSStatusSO = string.equals(this.getDomainName()) ? new RMS(this.getDomain()) : new RMSRemoteRMS(string, this.getDomain());
            rMSStatusSO.setState(n);
            rMSStatusSO.addReason(list);
        } else if (string3.equalsIgnoreCase("Replication Server")) {
            rMSStatusSO = new RMSRepServer(string, this.getDomain());
            rMSStatusSO.setState(n);
            rMSStatusSO.addReason(list);
        } else if (string3.equalsIgnoreCase("ASE")) {
            rMSStatusSO = new RMSASE(string, this.getDomain());
            rMSStatusSO.setState(n);
            rMSStatusSO.addReason(list);
        } else if (string3.equalsIgnoreCase("Replication Agent")) {
            rMSStatusSO = new RMSLANRepAgent(string, this.getDomain());
            rMSStatusSO.setState(n);
            rMSStatusSO.addReason(list);
        } else if (string3.equalsIgnoreCase("Mirror Replication Agent")) {
            rMSStatusSO = new RMSMirrorRepAgent(string, this.getDomain());
            rMSStatusSO.setState(n);
            rMSStatusSO.addReason(list);
        } else if (string3.equalsIgnoreCase("DirectConnect")) {
            rMSStatusSO = new RMSDirectConnect(string, this.getDomain());
            rMSStatusSO.setState(n);
            rMSStatusSO.addReason(list);
        } else if (string3.equalsIgnoreCase("RA Connection") || string3.equalsIgnoreCase("DSI Connection")) {
            String[] stringArray = MessageText.parseRSComponent(string2);
            if (stringArray.length == 2) {
                rMSStatusSO = new RMSPhyConnection(string, stringArray[0], stringArray[1], this.getDomain());
                try {
                    ((RMSPhyConnection)rMSStatusSO).load();
                }
                catch (SQLException sQLException) {
                    String string4 = MessageText.formatExceptionMessage(sQLException);
                    PluginSupport.LogErrorMessage(string4, MessageText.formatSQLExceptionDetails(sQLException));
                    rMSStatusSO.clearReasons();
                    rMSStatusSO.addReason(string4);
                }
            } else {
                Object[] objectArray = new String[]{string3, string2};
                String string5 = BundleManager.getString("StatusMonitorRes", "STATUS_INVALID_NAME", objectArray);
                PluginSupport.LogErrorMessage(string5, string5);
            }
        } else if (string3.equalsIgnoreCase("Logical Connection")) {
            String[] stringArray = MessageText.parseRSComponent(string2);
            if (stringArray.length == 2) {
                rMSStatusSO = new RMSLogConnection(string, stringArray[0], stringArray[1], this.getDomain());
                rMSStatusSO.setState(n);
                rMSStatusSO.addReason(list);
            } else {
                Object[] objectArray = new String[]{string3, string2};
                String string6 = BundleManager.getString("StatusMonitorRes", "STATUS_INVALID_NAME", objectArray);
                PluginSupport.LogErrorMessage(string6, string6);
            }
        } else if (string3.equalsIgnoreCase("Route")) {
            String[] stringArray = MessageText.parseRSComponent(string2);
            if (stringArray.length == 2) {
                rMSStatusSO = new RMSRoute(string, stringArray[0], stringArray[1], this.getDomain());
                rMSStatusSO.setState(n);
                rMSStatusSO.addReason(list);
            } else {
                Object[] objectArray = new String[]{string3, string2};
                String string7 = BundleManager.getString("StatusMonitorRes", "STATUS_INVALID_NAME", objectArray);
                PluginSupport.LogErrorMessage(string7, string7);
            }
        } else if (string3.equalsIgnoreCase("Queue")) {
            rMSStatusSO = new RMSQueue(string2, string, this.getDomain());
            rMSStatusSO.setState(n);
            rMSStatusSO.addReason(list);
        }
        return rMSStatusSO;
    }
}

