/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.status;

import com.sybase.rsmplugin.status.StatusItem;
import com.sybase.rsmplugin.util.Dbg;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.SwingUtilities;

public class StatusManager {
    private static StatusManager _mgr = null;
    private ArrayList _listenerList = new ArrayList(50);

    protected StatusManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this._listenerList.clear();
            _mgr = null;
        }
        finally {
            super.finalize();
        }
    }

    public static void addStatusItem(StatusItem statusItem) {
        Dbg.wassert(statusItem != null, "Null status listener parameter");
        if (_mgr == null) {
            _mgr = new StatusManager();
        }
        _mgr.add(statusItem);
    }

    public static void removeStatusItem(StatusItem statusItem) {
        Dbg.wassert(statusItem != null, "Null status listener parameter");
        if (_mgr == null) {
            _mgr = new StatusManager();
        } else {
            _mgr.remove(statusItem);
        }
    }

    public static void refresh(String string, String string2, String string3, int n, List list) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty domain parameter");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty item type parameter");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty item name parameter");
        if (_mgr == null) {
            _mgr = new StatusManager();
        }
        List list2 = _mgr.find(string, string2, string3);
        ListIterator listIterator = list2.listIterator();
        while (listIterator.hasNext()) {
            StatusItem statusItem = (StatusItem)listIterator.next();
            _mgr.refresh(statusItem, n, list);
        }
        list2.clear();
    }

    public static void refresh(String string, String string2, String string3) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty domain parameter");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty item type parameter");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty item name parameter");
        if (_mgr == null) {
            _mgr = new StatusManager();
        }
        List list = _mgr.find(string, string2, string3);
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            StatusItem statusItem = (StatusItem)listIterator.next();
            _mgr.refresh(statusItem);
        }
        list.clear();
    }

    public static void redisplay(String string, String string2, String string3, int n, List list) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty domain parameter");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty item type parameter");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty item name parameter");
        if (_mgr == null) {
            _mgr = new StatusManager();
        }
        List list2 = _mgr.find(string, string2, string3);
        ListIterator listIterator = list2.listIterator();
        while (listIterator.hasNext()) {
            StatusItem statusItem = (StatusItem)listIterator.next();
            _mgr.redisplay(statusItem, n, list);
        }
        list2.clear();
    }

    public static void redisplay(String string, String string2, String string3) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty domain parameter");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty item type parameter");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty item name parameter");
        if (_mgr == null) {
            _mgr = new StatusManager();
        }
        List list = _mgr.find(string, string2, string3);
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            StatusItem statusItem = (StatusItem)listIterator.next();
            _mgr.redisplay(statusItem);
        }
        list.clear();
    }

    public static void delete(String string, String string2, String string3) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty domain parameter");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty item type parameter");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty item name parameter");
        if (_mgr == null) {
            _mgr = new StatusManager();
        }
        List list = _mgr.find(string, string2, string3);
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            StatusItem statusItem = (StatusItem)listIterator.next();
            _mgr.delete(statusItem);
        }
        list.clear();
    }

    protected synchronized void add(StatusItem statusItem) {
        Dbg.wassert(statusItem != null, "Null status listener parameter");
        Dbg.trace(768, "StatusMgr add listener: " + statusItem.getDomainName() + "." + statusItem.getType() + "." + statusItem.getName() + " - " + statusItem.toString());
        this._listenerList.add(statusItem);
        this.dumpListenerList();
    }

    protected synchronized void remove(StatusItem statusItem) {
        Dbg.wassert(statusItem != null, "Null status listener parameter");
        Dbg.trace(768, "StatusMgr remove listener: " + statusItem.getDomainName() + "." + statusItem.getType() + "." + statusItem.getName() + " - " + statusItem.toString());
        this._listenerList.remove(statusItem);
        this.dumpListenerList();
    }

    protected synchronized List find(String string, String string2, String string3) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty domain parameter");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty item type parameter");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty item name parameter");
        ArrayList<StatusItem> arrayList = new ArrayList<StatusItem>();
        this.dumpListenerList();
        ListIterator listIterator = this._listenerList.listIterator();
        while (listIterator.hasNext()) {
            StatusItem statusItem = (StatusItem)listIterator.next();
            if (!statusItem.getDomainName().equals(string) || !statusItem.getType().equals(string2) || !statusItem.getName().equals(string3)) continue;
            arrayList.add(statusItem);
            Dbg.trace(768, "StatusMgr listener found: " + statusItem.getDomainName() + "." + statusItem.getType() + "." + statusItem.getName() + " - " + statusItem.toString());
        }
        return arrayList;
    }

    protected void refresh(final StatusItem statusItem, final int n, final List list) {
        Dbg.wassert(statusItem != null, "Null StatusItem item parameter");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Thread.currentThread().isAlive()) {
                    statusItem.setState(n);
                    statusItem.setReasons(list);
                    statusItem.refresh();
                    Dbg.trace(768, "StatusMgr Refresh: " + statusItem.getDomainName() + "." + statusItem.getType() + "." + statusItem.getName() + " - " + statusItem.toString());
                }
            }
        });
    }

    protected void refresh(final StatusItem statusItem) {
        Dbg.wassert(statusItem != null, "Null StatusItem item parameter");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Thread.currentThread().isAlive()) {
                    statusItem.refresh();
                    Dbg.trace(768, "StatusMgr Refresh: " + statusItem.getDomainName() + "." + statusItem.getType() + "." + statusItem.getName() + " - " + statusItem.toString());
                }
            }
        });
    }

    protected void redisplay(final StatusItem statusItem, final int n, final List list) {
        Dbg.wassert(statusItem != null, "Null StatusItem item parameter");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Thread.currentThread().isAlive()) {
                    statusItem.setState(n);
                    statusItem.setReasons(list);
                    statusItem.redisplay();
                    Dbg.trace(768, "StatusMgr Redisplay: " + statusItem.getDomainName() + "." + statusItem.getType() + "." + statusItem.getName() + " - " + statusItem.toString());
                }
            }
        });
    }

    protected void redisplay(final StatusItem statusItem) {
        Dbg.wassert(statusItem != null, "Null StatusItem item parameter");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Thread.currentThread().isAlive()) {
                    statusItem.redisplay();
                    Dbg.trace(768, "StatusMgr Redisplay: " + statusItem.getDomainName() + "." + statusItem.getType() + "." + statusItem.getName() + " - " + statusItem.toString());
                }
            }
        });
    }

    protected void delete(final StatusItem statusItem) {
        Dbg.wassert(statusItem != null, "Null StatusItem item parameter");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Thread.currentThread().isAlive()) {
                    statusItem.delete();
                    Dbg.trace(768, "StatusMgr Remove: " + statusItem.getDomainName() + "." + statusItem.getType() + "." + statusItem.getName() + " - " + statusItem.toString());
                }
            }
        });
    }

    private synchronized void dumpListenerList() {
        if (Dbg.isOn() && Dbg.isFlagOn(512)) {
            Dbg.trace(512, "StatusMgr listener list [" + String.valueOf(this._listenerList.size()) + "]:");
            ListIterator listIterator = this._listenerList.listIterator();
            while (listIterator.hasNext()) {
                StatusItem statusItem = (StatusItem)listIterator.next();
                Dbg.trace(512, statusItem.getDomainName() + "." + statusItem.getType() + "." + statusItem.getName() + " - " + statusItem.toString());
            }
        }
    }
}

