/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.util;

import com.sybase.jdbcx.EedInfo;
import com.sybase.rsmplugin.util.Dbg;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.StringTokenizer;

public class MessageText {
    public static final int MAX_LINE_LENGTH = 100;

    public static String addSingleQuotes(String string) {
        return MessageText._quote(string, '\'', true, true);
    }

    public static String removeSingleQuotes(String string) {
        return MessageText._unquote(string, '\'', true, true);
    }

    public static String addDoubleQuotes(String string) {
        return MessageText._quote(string, '\"', true, true);
    }

    public static String removeDoubleQuotes(String string) {
        return MessageText._unquote(string, '\"', true, true);
    }

    public static String doubleUpSingleQuotes(String string) {
        return MessageText._quote(string, '\'', false, true);
    }

    public static String doubleUpBackslashes(String string) {
        return MessageText._quote(string, '\\', false, true);
    }

    private static String _quote(String string, char c, boolean bl, boolean bl2) {
        if (!(bl || string != null && string.indexOf(c) != -1)) {
            return string;
        }
        int n = string.length();
        char[] cArray = new char[n * 2 + 2];
        int n2 = 0;
        if (bl) {
            cArray[n2++] = c;
        }
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            cArray[n2++] = c2;
            if (!bl2 || c2 != c) continue;
            cArray[n2++] = c;
        }
        if (bl) {
            cArray[n2++] = c;
        }
        return new String(cArray, 0, n2);
    }

    private static String _unquote(String string, char c, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (string == null || (n5 = string.length()) <= 1 || (n4 = string.indexOf(c)) == -1) {
            return string;
        }
        if (bl && n4 == 0 && (n3 = string.lastIndexOf(c)) == n5 - 1) {
            n2 = 1;
            n = n5 - 1;
        } else {
            n2 = 0;
            n = n5;
        }
        char[] cArray = new char[n - n2];
        int n6 = 0;
        for (int i = n2; i < n; ++i) {
            char c2 = string.charAt(i);
            if (bl2 && c2 == c && i < n - 1 && string.charAt(i + 1) == c) {
                cArray[n6++] = c;
                ++i;
                continue;
            }
            cArray[n6++] = c2;
        }
        return new String(cArray, 0, n6);
    }

    public static String getDisplayString(String string) {
        return MessageText.getDisplayString(string, 100);
    }

    public static String getDisplayString(String string, int n) {
        String string2 = "";
        String string3 = "\n";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        while (stringTokenizer.hasMoreElements()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.length() > n) {
                string2 = string2 + MessageText.wrapString(string4, n) + string3;
                continue;
            }
            string2 = string2 + string4 + string3;
        }
        return string2;
    }

    public static String wrapString(String string, int n) {
        String string2 = " ";
        String string3 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            string3 = string3 + string4;
            if ((n2 += string4.length()) <= n || !string4.equals(string2)) continue;
            string3 = string3 + "\n";
            n2 = 0;
        }
        return string3;
    }

    public static String[] parseRSComponent(String string) {
        return MessageText.parse(string, ".");
    }

    public static String[] parse(String string, String string2) {
        String[] stringArray;
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            int n = stringTokenizer.countTokens();
            stringArray = new String[n];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                stringArray[n2++] = string3.trim();
            }
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public static String buildOwnerDotName(String string, String string2) {
        String string3 = "\"" + string.trim() + "\".\"" + string2.trim() + "\"";
        return string3;
    }

    public static String extractOwner(String string) {
        int n = string.indexOf(46);
        if (n == -1 || n == 0) {
            return "";
        }
        return MessageText._unquote(string.substring(0, n), '\"', true, false);
    }

    public static String extractName(String string) {
        int n = string.indexOf(46);
        int n2 = string.length();
        if (n == -1 || n == n2 - 1) {
            return "";
        }
        return MessageText._unquote(string.substring(n + 1, n2), '\"', true, false);
    }

    public static int toVersionNr(String string, int n) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty version number parameter.");
        Dbg.wassert(n > 0 && n < 10, "Digits parameter must be greater then 0 and less then 10.");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = "";
        while (stringTokenizer.hasMoreElements()) {
            String string3 = (String)stringTokenizer.nextElement();
            string2 = string2 + string3.replaceAll("\\D", "");
        }
        string2 = string2 + "00000000000000000000";
        int n2 = Integer.parseInt(string2.substring(0, n));
        return n2;
    }

    public static String formatExceptionMessage(Throwable throwable) {
        String string;
        block4: {
            String string2;
            string = "";
            Throwable throwable2 = throwable;
            if (throwable2 == null) break block4;
            if (string.length() > 0) {
                string = string + '\n';
            }
            if ((string2 = throwable2.getLocalizedMessage()) == null || string2.length() == 0) {
                string2 = throwable2.getMessage();
            }
            string = string + string2;
            if (throwable2 instanceof SQLException) {
                throwable2 = ((SQLException)throwable2).getNextException();
            } else {
                throwable2.printStackTrace();
                throwable2 = null;
            }
        }
        return string;
    }

    public static String formatSQLExceptionDetails(SQLException sQLException) {
        String string = "";
        while (sQLException != null) {
            String string2;
            if (string.length() > 0) {
                string = string + "\n";
            }
            string = (string2 = sQLException.getLocalizedMessage()) != null && string2.length() > 0 ? string + string2 : string + sQLException.getMessage();
            if (sQLException instanceof EedInfo) {
                EedInfo eedInfo = (EedInfo)sQLException;
                if (eedInfo.getSeverity() >= 13) {
                    string = string + " - Code '" + sQLException.getErrorCode() + "'" + ", Severity '" + eedInfo.getSeverity() + "'" + ", State '" + eedInfo.getState() + "'";
                    if (eedInfo.getServerName() != null) {
                        string = string + ", Server '" + eedInfo.getServerName() + "'";
                    }
                    if (eedInfo.getProcedureName() != null) {
                        string = string + ", Procedure '" + eedInfo.getProcedureName() + "'";
                    }
                    string = string + ", Line '" + eedInfo.getLineNumber() + "'" + ", Status '" + eedInfo.getStatus() + "'" + ", TranState '" + eedInfo.getTranState() + "'";
                } else {
                    if (eedInfo.getServerName() != null) {
                        string = string + " - Server '" + eedInfo.getServerName() + "'";
                    }
                    if (eedInfo.getProcedureName() != null) {
                        string = string + ", Procedure '" + eedInfo.getProcedureName() + "'";
                    }
                }
            } else {
                string = string + ", SQL State '" + sQLException.getSQLState() + "'";
                string = string + ", Error Code '" + sQLException.getErrorCode() + "'";
            }
            sQLException = sQLException.getNextException();
        }
        return string;
    }

    public static String formatSQLWarning(SQLWarning sQLWarning) {
        String string = sQLWarning.getLocalizedMessage();
        String string2 = string != null && string.length() > 0 ? string : sQLWarning.getMessage();
        if (sQLWarning.getNextWarning() != null) {
            string2 = string2 + " (more...)";
        }
        return string2;
    }

    public static String formatSQLWarningDetails(SQLWarning sQLWarning) {
        String string = "";
        while (sQLWarning != null) {
            String string2;
            if (string.length() > 0) {
                string = string + "\n";
            }
            string = (string2 = sQLWarning.getLocalizedMessage()) != null && string2.length() > 0 ? string + string2 : string + sQLWarning.getMessage();
            if (sQLWarning instanceof EedInfo) {
                EedInfo eedInfo = (EedInfo)sQLWarning;
                if (eedInfo.getServerName() != null) {
                    string = string + " - Server '" + eedInfo.getServerName() + "'";
                }
                if (eedInfo.getProcedureName() != null) {
                    string = string + ", Procedure '" + eedInfo.getProcedureName() + "'";
                }
            }
            sQLWarning = sQLWarning.getNextWarning();
        }
        return string;
    }

    public static String getStartOfCommand(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty command parameter.");
        String string2 = string;
        do {
            int n;
            if ((n = string2.indexOf(10)) == -1) {
                if ((string2 = string2.trim()).length() < 80) {
                    return string2;
                }
                return string2.substring(0, 80);
            }
            String string3 = string2.substring(0, n).trim();
            if (!(string3.length() == 0 || string3.startsWith("//") || string3.startsWith("/*") || string3.startsWith("*"))) {
                if (string3.length() < 80) {
                    return string3;
                }
                return string3.substring(0, 80);
            }
            string2 = string2.substring(n, string2.length());
            string2 = string2.trim();
        } while (string2.length() > 0);
        if (string.length() < 80) {
            return string;
        }
        return string.substring(0, 80);
    }
}

