/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.util;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumericsOnlyDocument
extends PlainDocument {
    private boolean _bInInteger = true;
    private double _minValue = 0.0;
    private double _maxValue = 2.147483647E9;

    public NumericsOnlyDocument() {
    }

    public NumericsOnlyDocument(boolean bl) {
        this();
        this._bInInteger = bl;
        this._minValue = 0.0;
        this._maxValue = 2.147483647E9;
    }

    public NumericsOnlyDocument(boolean bl, double d, double d2) {
        this(bl);
        this._minValue = d;
        this._maxValue = d2;
        if (this._minValue > 1.0) {
            this._minValue = 1.0;
        }
    }

    public boolean isInteger() {
        return this._bInInteger;
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        String string = this.getText(0, n) + this.getText(n + n2, this.getLength() - n2 - n);
        if (string.length() == 0 || string.equals("-")) {
            super.remove(n, n2);
        } else {
            double d = 0.0;
            try {
                if (this.isInteger()) {
                    Long.parseLong(string + "0");
                    d = string.equals("") ? 0.0 : (double)Long.parseLong(string);
                } else {
                    Double.valueOf(string + "0").doubleValue();
                    d = string.equals("") ? 0.0 : Double.valueOf(string);
                }
                super.remove(n, n2);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null || string.equalsIgnoreCase("e") || string.equals("f") || string.equals("d") || this._minValue > 0.0 && string.equals("-")) {
            return;
        }
        String string2 = this.getText(0, this.getLength());
        String string3 = string2.substring(0, n) + string + string2.substring(n);
        if (string3.equals("-")) {
            super.insertString(n, string, attributeSet);
        } else {
            double d = 0.0;
            try {
                if (this.isInteger()) {
                    Long.parseLong(string3 + "0");
                    d = Long.parseLong(string3);
                } else {
                    Double.valueOf(string3 + "0").doubleValue();
                    d = Double.valueOf(string3);
                }
                if (d >= this._minValue && d <= this._maxValue) {
                    super.insertString(n, string, attributeSet);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

