/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.util;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMConstants;
import com.sybase.rsmplugin.util.Dbg;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class RMEnv {
    private static final String SYBASE_HOME = "sybase.home";
    private static final String SYBASE_ENV = "SYBASE";
    private static final String SYBROOT_ENV = "SYBROOT";
    private static final String STR_EMPTY = "";

    public static boolean fileExists(String string) {
        File file = new File(string);
        return file.exists() && file.isFile();
    }

    public static boolean DirectoryExists(String string) {
        if (string.length() == 0) {
            return true;
        }
        File file = new File(string);
        return file.exists() && file.isDirectory();
    }

    public static String getDirectoryFromPath(String string) {
        File file = new File(string);
        String string2 = file.getParent();
        return string2 == null ? STR_EMPTY : string2;
    }

    public static String getFileFromPath(String string) {
        File file = new File(string);
        String string2 = file.getName();
        return string2 == null ? STR_EMPTY : string2;
    }

    public static String getFileWithoutExtensionFromPath(String string) {
        int n;
        String string2 = RMEnv.getFileFromPath(string);
        int n2 = string2.length();
        if (n2 > 0 && (n = string2.lastIndexOf(46)) > 0) {
            return string2.substring(0, n);
        }
        return string2;
    }

    public static String getFileExtensionFromPath(String string) {
        int n;
        String string2 = RMEnv.getFileFromPath(string);
        int n2 = string2.length();
        if (n2 > 0 && (n = string2.lastIndexOf(46)) > 0 && n < n2 - 1) {
            return string2.substring(n + 1);
        }
        return STR_EMPTY;
    }

    public static String getCanonicalPath(String string) {
        File file = new File(string);
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    public static String buildFullPathName(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        int n = string.length();
        if (n > 0 && string.charAt(n - 1) != File.separatorChar) {
            return string + File.separatorChar + string2;
        }
        return string + string2;
    }

    public static boolean createDirectory(String string) {
        File file = new File(string);
        return file.mkdirs();
    }

    public static boolean deleteFile(String string) {
        File file = new File(string);
        return file.delete();
    }

    public static String getEnvVariable(String string) {
        String string2 = null;
        if (RSMConstants.OS_WINDOWS) {
            try {
                Process process = null;
                process = RSMConstants.OS_NAME.indexOf("9") != -1 ? Runtime.getRuntime().exec("command /c echo %" + string + "%") : Runtime.getRuntime().exec("cmd /c echo %" + string + "%");
                InputStream inputStream = process.getInputStream();
                byte[] byArray = new byte[256];
                int n = inputStream.read(byArray);
                while (n != -1) {
                    string2 = new String(byArray, 0, n);
                    n = inputStream.read(byArray);
                }
                process.destroy();
            }
            catch (IOException iOException) {
                string2 = null;
            }
            if (string2 != null && string2.indexOf("%") != -1) {
                string2 = null;
            }
        } else {
            String[] stringArray = new String[]{"env"};
            Runtime runtime = Runtime.getRuntime();
            try {
                String string3;
                Process process = runtime.exec(stringArray);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (string3.indexOf(string + "=") != 0) continue;
                    string2 = string3.substring(string.length() + 1);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                string2 = null;
            }
        }
        return string2;
    }

    public static String getSybaseDir() {
        String string = System.getProperty(SYBASE_HOME);
        if (string != null) {
            String string2 = string = string.length() == 0 ? null : System.getProperty(SYBASE_ENV);
        }
        if (string == null && (string = RMEnv.getEnvVariable(SYBASE_ENV)) != null) {
            String string3 = string = string.length() == 0 ? null : string.trim();
        }
        if (string != null) {
            string = RMEnv.getCanonicalPath(string);
        }
        return string;
    }

    public static String getRMDir() {
        String string = PluginSupport.getLoader().getProviderDirectory();
        Dbg.wassert(string != null && string.length() > 0, "Unexpected null or empty SC provider directory.");
        string = string + "..";
        string = RMEnv.getCanonicalPath(string);
        Dbg.trace(1, "RMP Directory = " + string);
        return string;
    }

    public static String getRMScriptsDir() {
        String string = PluginSupport.getLoader().getProviderDirectory();
        Dbg.wassert(string != null && string.length() > 0, "Unexpected null or empty SC provider directory.");
        string = string + "..";
        String string2 = System.getProperty("file.separator");
        Dbg.wassert(string2 != null && string2.length() > 0, "Unexpected null or empty system property for 'file_separator'.");
        string = string + string2 + "scripts";
        string = RMEnv.getCanonicalPath(string);
        Dbg.trace(1, "RMP Scripts Directory = " + string);
        return string;
    }

    public static void setSybaseDir() throws Exception {
        String string = System.getProperty(SYBASE_HOME);
        if (string == null || string.length() == 0) {
            String string2 = RMEnv.getSybaseDir();
            if (string2 != null) {
                System.setProperty(SYBASE_HOME, string2);
            } else {
                Exception exception = new Exception(BundleManager.getString("ProviderRes", "ERR_SYBASE_NOT_SET"));
                throw exception;
            }
        }
    }
}

