/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.util;

import com.sybase.asa.ASAIconTextData;
import com.sybase.asa.ASAIconTextDataTableCellRenderer;
import com.sybase.asa.ASAMultiListTableCellRenderer;
import com.sybase.asa.ASAScrollPane;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.RSMColumnSort;
import com.sybase.rsmplugin.util.RSMObjectRow;
import com.sybase.rsmplugin.util.RSMObjectTableHeaderRenderer;
import com.sybase.rsmplugin.util.RSMObjectTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class RSMObjectMultiList
extends JTable
implements ActionListener {
    protected static final String STR_EMPTY = "";
    protected static final String STR_LIST_DELIMITER = ",";
    protected static final String STR_BORDER = "TableHeader.cellBorder";
    protected static final String[] DEFAULT_COLUMN_NAMES = new String[]{" "};
    protected ASAScrollPane _scrollPane;
    protected RSMObjectTableModel _tableModel;
    private boolean _autoKeySelectionEnabled = true;
    private Timer _timer = null;
    private StringBuffer _typedSoFar = null;
    private boolean _sameKeyChar = true;
    private int _ticksWithoutActivity = 0;
    private String[] _columnToolTips;
    private boolean _ascendingSortOrder = true;
    private int _sortedColumnNumber = -1;

    public RSMObjectMultiList(List list, List list2) {
        this.setModel(new RSMObjectTableModel(list2, list, this));
        this._init();
    }

    public RSMObjectMultiList(List list) {
        this.setModel(new RSMObjectTableModel(list, this));
        this._init();
    }

    private void _init() {
        this._scrollPane = new ASAScrollPane((Component)this);
        this._scrollPane.getViewport().setBackground(this.getBackground());
        this.setShowGrid(true);
        this.getTableHeader().setReorderingAllowed(false);
        this._typedSoFar = new StringBuffer();
        this._timer = new Timer(500, this);
        this._timer.start();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl && !this._timer.isRunning() && this._autoKeySelectionEnabled) {
            this._typedSoFar.setLength(0);
            this._sameKeyChar = true;
            this._timer.restart();
        } else if (!bl && this._timer.isRunning()) {
            this._timer.stop();
        }
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.columnMarginChanged(new ChangeEvent(this));
        }
    }

    public void setAutoKeySelectionEnabled(boolean bl) {
        if (bl && !this._timer.isRunning()) {
            this._timer.restart();
        }
        if (!bl && this._timer.isRunning()) {
            this._timer.stop();
        }
        this._autoKeySelectionEnabled = bl;
    }

    public boolean isAutoKeySelectionEnabled() {
        return this._timer.isRunning();
    }

    public void setSorting(boolean bl) {
        this._tableModel.setSorting(bl);
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.repaint();
        }
    }

    public int getSortedColumnNumber() {
        return this.isSorting() ? this._sortedColumnNumber : -1;
    }

    public void setSortedColumnNumber(int n) {
        JTableHeader jTableHeader = this.getTableHeader();
        this._sortedColumnNumber = n;
        if (jTableHeader != null) {
            jTableHeader.repaint();
        }
    }

    public boolean isAscendingSortOrder() {
        return this._ascendingSortOrder;
    }

    public void setAscendingSortOrder(boolean bl) {
        this._ascendingSortOrder = bl;
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.repaint();
        }
    }

    public boolean isSorting() {
        return this._tableModel.isSorting();
    }

    protected void setModel(RSMObjectTableModel rSMObjectTableModel) {
        Dbg.wassert(rSMObjectTableModel != null, "Null table model parameter.");
        this._tableModel = rSMObjectTableModel;
        super.setModel(rSMObjectTableModel);
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.setDefaultRenderer(new RSMObjectTableHeaderRenderer(this));
        }
    }

    public RSMObjectTableModel getTableModel() {
        Dbg.wassert(this._tableModel != null, "Null table model attribute.");
        return this._tableModel;
    }

    public boolean getColumnHasIconTextData(int n) {
        return this.getColumnModel().getColumn(n).getCellRenderer() instanceof ASAIconTextDataTableCellRenderer;
    }

    public void setColumnHasIconTextData(int n, boolean bl) {
        this.getColumnModel().getColumn(n).setCellRenderer((TableCellRenderer)(bl ? new ASAIconTextDataTableCellRenderer() : new ASAMultiListTableCellRenderer()));
    }

    public ASAScrollPane getScrollPane() {
        return this._scrollPane;
    }

    public void setColumnWidth(int n, int n2) {
        this.getColumnModel().getColumn(n).setPreferredWidth(n2);
    }

    public void setColumnWidths(int[] nArray) {
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            this.getColumnModel().getColumn(i).setPreferredWidth(nArray[i]);
        }
    }

    public void setColumnWidthToFit(int n) {
        JTableHeader jTableHeader;
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        TableCellRenderer tableCellRenderer2 = tableColumn.getCellRenderer();
        int n2 = 0;
        if (tableCellRenderer == null && (jTableHeader = this.getTableHeader()) != null) {
            tableCellRenderer = jTableHeader.getDefaultRenderer();
        }
        if (tableCellRenderer2 == null) {
            tableCellRenderer2 = tableCellRenderer;
        }
        if (tableCellRenderer != null) {
            n2 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)((String)tableColumn.getHeaderValue()), (boolean)false, (boolean)false, (int)-1, (int)n).getPreferredSize().width;
        }
        int n3 = this.getRowCount();
        for (int i = 0; i < n3; ++i) {
            int n4 = tableCellRenderer2.getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)i, (int)n), (boolean)false, (boolean)false, (int)-1, (int)n).getPreferredSize().width;
            n2 = Math.max(n2, n4);
        }
        tableColumn.setPreferredWidth(n2 += this.getIntercellSpacing().width);
    }

    public void setColumnWidthToFit(int n, String[] stringArray) {
        JTableHeader jTableHeader;
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        TableCellRenderer tableCellRenderer2 = tableColumn.getCellRenderer();
        int n2 = 0;
        if (tableCellRenderer == null && (jTableHeader = this.getTableHeader()) != null) {
            tableCellRenderer = jTableHeader.getDefaultRenderer();
        }
        if (tableCellRenderer2 == null) {
            tableCellRenderer2 = tableCellRenderer;
        }
        if (tableCellRenderer != null) {
            n2 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)((String)tableColumn.getHeaderValue()), (boolean)false, (boolean)false, (int)-1, (int)n).getPreferredSize().width;
        }
        int n3 = stringArray.length;
        for (int i = 0; i < n3; ++i) {
            int n4 = tableCellRenderer2.getTableCellRendererComponent((JTable)this, (Object)stringArray[i], (boolean)false, (boolean)false, (int)-1, (int)n).getPreferredSize().width;
            n2 = Math.max(n2, n4);
        }
        tableColumn.setPreferredWidth(n2 += this.getIntercellSpacing().width);
        tableColumn.setMinWidth(n2);
        tableColumn.setMaxWidth(n2);
    }

    public void setColumnWidthToFit(int n, int n2) {
        String string;
        JTableHeader jTableHeader;
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        TableCellRenderer tableCellRenderer2 = tableColumn.getCellRenderer();
        int n3 = 0;
        if (tableCellRenderer == null && (jTableHeader = this.getTableHeader()) != null) {
            tableCellRenderer = jTableHeader.getDefaultRenderer();
        }
        if (tableCellRenderer2 == null) {
            tableCellRenderer2 = tableCellRenderer;
        }
        if (tableCellRenderer != null) {
            n3 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)((String)tableColumn.getHeaderValue()), (boolean)false, (boolean)false, (int)-1, (int)n).getPreferredSize().width;
        }
        try {
            string = new Integer((int)Math.pow(10.0, n2 - 1)).toString();
        }
        catch (ArithmeticException arithmeticException) {
            Dbg.wassert(false, "Arithmetic exception thrown.");
            return;
        }
        int n4 = tableCellRenderer2.getTableCellRendererComponent((JTable)this, (Object)string, (boolean)false, (boolean)false, (int)-1, (int)n).getPreferredSize().width;
        int n5 = Math.max(n3, n4);
        tableColumn.setPreferredWidth(n5 += this.getIntercellSpacing().width);
        tableColumn.setMinWidth(n5);
        tableColumn.setMaxWidth(n5);
    }

    public void selectRow(int n) {
        this.setRowSelectionInterval(n, n);
    }

    public void selectRows(int n, int n2) {
        this.setRowSelectionInterval(n, n2);
    }

    public void selectRows(int[] nArray) {
        this.clearSelection();
        for (int n : nArray) {
            this.addRowSelectionInterval(n, n);
        }
    }

    public int getMinSelectionIndex() {
        return this.getSelectionModel().getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.getSelectionModel().getMaxSelectionIndex();
    }

    public Icon getIconAt(int n, int n2) {
        Object object = this._tableModel.getValueAt(n, n2);
        if (object == null) {
            return null;
        }
        if (object instanceof Icon) {
            return (Icon)object;
        }
        if (object instanceof ASAIconTextData) {
            return ((ASAIconTextData)object).icon;
        }
        return null;
    }

    public void setIconAt(Icon icon, int n, int n2) {
        Object object = this._tableModel.getValueAt(n, n2);
        if (object == null) {
            this._tableModel.setValueAt(icon, n, n2);
        } else if (object instanceof ASAIconTextData) {
            ((ASAIconTextData)object).icon = icon;
            this._tableModel.fireTableCellUpdated(n, n2);
        } else {
            this._tableModel.setValueAt(icon, n, n2);
        }
    }

    public String getStringAt(int n, int n2) {
        Object object = this._tableModel.getValueAt(n, n2);
        if (object == null) {
            return new String();
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    public void setStringAt(String string, int n, int n2) {
        Object object = this._tableModel.getValueAt(n, n2);
        if (object == null) {
            this._tableModel.setValueAt(string, n, n2);
        } else if (object instanceof ASAIconTextData) {
            ((ASAIconTextData)object).text = string;
            this._tableModel.fireTableCellUpdated(n, n2);
        } else {
            this._tableModel.setValueAt(string, n, n2);
        }
    }

    public RSMObjectRow getRSMObjectRow(int n) {
        return this._tableModel.GetRowAt(n);
    }

    public Vector getRow(int n) {
        int n2 = this.getColumnModel().getColumnCount();
        Vector<Object> vector = new Vector<Object>(n2);
        for (int i = 0; i < n2; ++i) {
            vector.add(this.getValueAt(n, i));
        }
        return vector;
    }

    public Vector getRowAsStringData(int n) {
        int n2 = this.getColumnModel().getColumnCount();
        Vector<String> vector = new Vector<String>(n2);
        for (int i = 0; i < n2; ++i) {
            vector.add(this.getStringAt(n, i));
        }
        return vector;
    }

    public Object[] getRowAsArray(int n) {
        int n2 = this.getColumnModel().getColumnCount();
        Object[] objectArray = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = this.getValueAt(n, i);
        }
        return objectArray;
    }

    public Object getRowAsStringDataArray(int n) {
        int n2 = this.getColumnModel().getColumnCount();
        Object[] objectArray = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = this.getStringAt(n, i);
        }
        return objectArray;
    }

    public List getData() {
        return this._tableModel.getRows();
    }

    public String getColumnToolTip(int n) {
        String string;
        if (this._columnToolTips != null && (string = this._columnToolTips[n]) != null && string.length() > 0) {
            return string;
        }
        return this._tableModel != null ? this._tableModel.getColumnName(n) : null;
    }

    public void setColumnToolTips(String[] stringArray) {
        this._columnToolTips = stringArray;
    }

    public int findRow(String string) {
        return this.findRow(string, 0);
    }

    public int findRow(String string, int n) {
        for (int i = n; i < this.getRowCount(); ++i) {
            if (!this.getStringAt(i, 0).equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int findRow(String[] stringArray) {
        return this.findRow(stringArray, 0);
    }

    public int findRow(String[] stringArray, int n) {
        int n2 = stringArray.length;
        for (int i = n; i < this.getRowCount(); ++i) {
            int n3;
            for (n3 = 0; n3 < n2 && this.getStringAt(i, n3).equals(stringArray[n3]); ++n3) {
            }
            if (n3 != n2) continue;
            return i;
        }
        return -1;
    }

    public RSMColumnSort getSortComparator() {
        return this._tableModel.getSortComparator();
    }

    public void setSortComparator(RSMColumnSort rSMColumnSort) {
        this._tableModel.setSortComparator(rSMColumnSort);
    }

    public void sort() {
        this._tableModel.sortByColumn(0, true);
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.repaint();
        }
    }

    public void sort(int n) {
        this._tableModel.sortByColumn(n, true);
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.repaint();
        }
    }

    public void sort(boolean bl) {
        this._tableModel.sortByColumn(0, bl);
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.repaint();
        }
    }

    public void sort(int n, boolean bl) {
        this._tableModel.sortByColumn(n, bl);
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.repaint();
        }
    }

    public void addRow(RSMObjectRow rSMObjectRow) {
        this._tableModel.add(rSMObjectRow);
        this.clearSelection();
    }

    public void addRows(List list) {
        this._tableModel.add(list);
        this.clearSelection();
    }

    public void removeRow(int n) {
        this._tableModel.remove(n);
    }

    public void clear() {
        this._tableModel.clear();
    }

    public void refresh() {
        this._tableModel.fireTableDataChanged();
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.getSelectionModel().removeListSelectionListener(listSelectionListener);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        int n2;
        if (this._timer.isRunning() && (keyEvent.getModifiers() == 0 || (keyEvent.getModifiers() & 1) != 0) && n == 0 && keyEvent.getKeyCode() == 0 && keyEvent.getKeyChar() != '\uffff' && (n2 = this.getRowCount()) > 0) {
            this._timer.stop();
            char c = keyEvent.getKeyChar();
            this._ticksWithoutActivity = 0;
            if (this._typedSoFar.length() > 0 && this._typedSoFar.charAt(this._typedSoFar.length() - 1) != c) {
                this._sameKeyChar = false;
            }
            this._typedSoFar.append(c);
            int n3 = 0;
            int[] nArray = this.getSelectedRows();
            if (nArray.length > 0) {
                n3 = nArray[nArray.length - 1];
            }
            boolean bl2 = false;
            bl2 = this._sameKeyChar ? this.selectMatchingRow(++n3, n2, String.valueOf(c)) : this.selectMatchingRow(n3, n2, this._typedSoFar.toString());
            if (!bl2) {
                if (this._sameKeyChar) {
                    this.selectMatchingRow(0, n3, String.valueOf(c));
                } else {
                    this.selectMatchingRow(0, n3, this._typedSoFar.toString());
                }
            }
            this._timer.restart();
        }
        if (keyEvent.getKeyCode() == 9 && this.getRowCount() == 0) {
            return true;
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    private boolean selectMatchingRow(int n, int n2, String string) {
        int n3 = string.length();
        for (int i = n; i < n2; ++i) {
            String string2;
            Object object = this._tableModel.getValueAt(i, 0);
            if (object == null || (string2 = object.toString()).length() < n3 || !string2.regionMatches(true, 0, string, 0, n3)) continue;
            this.setRowSelectionInterval(i, i);
            this.scrollRectToVisible(this.getCellRect(i, 0, true));
            return true;
        }
        return false;
    }

    public void releaseResources() {
        if (this._timer.isRunning()) {
            this._timer.stop();
        }
        this._timer.removeActionListener(this);
        this._tableModel.releaseResources();
        this._timer = null;
        this._typedSoFar = null;
        this._scrollPane = null;
        this._tableModel = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._timer && ++this._ticksWithoutActivity == 2) {
            this._typedSoFar.setLength(0);
            this._sameKeyChar = true;
        }
    }
}

