/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.util;

import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.RSMColumnSort;
import com.sybase.rsmplugin.util.RSMObjectMultiList;
import com.sybase.rsmplugin.util.RSMObjectRow;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class RSMObjectTableModel
extends AbstractTableModel {
    List _rows = null;
    List _headings;
    private RSMObjectMultiList _table = null;
    private boolean _sorting = false;
    private boolean _ascending = true;
    private int _lastSortedColumn = -1;
    private MouseAdapter _listMouseListener = null;
    protected RSMColumnSort _comparator = new RSMColumnSort();

    public RSMObjectTableModel(List list, List list2, RSMObjectMultiList rSMObjectMultiList) {
        Dbg.wassert(list2 != null && list2.size() > 0, "Null or empty column name list parameter.");
        Dbg.wassert(list != null && list.size() > 0, "Null or empty row list parameter.");
        Dbg.wassert(rSMObjectMultiList != null, "Null RSMObjectMultiList table parameter.");
        this.diagnose(list);
        this._rows = list;
        this._headings = list2;
        this._table = rSMObjectMultiList;
        this.addMouseListenerToHeaderInTable();
    }

    public RSMObjectTableModel(List list, RSMObjectMultiList rSMObjectMultiList) {
        Dbg.wassert(list != null && list.size() > 0, "Null or empty column name list parameter.");
        Dbg.wassert(rSMObjectMultiList != null, "Null RSMObjectMultiList table parameter.");
        this._rows = new ArrayList();
        this._headings = list;
        this._table = rSMObjectMultiList;
        this.addMouseListenerToHeaderInTable();
    }

    public RSMColumnSort getSortComparator() {
        return this._comparator;
    }

    public void setSortComparator(RSMColumnSort rSMColumnSort) {
        Dbg.wassert(rSMColumnSort != null, "Null table comparator object.");
        this._comparator = rSMColumnSort;
    }

    @Override
    public int getRowCount() {
        if (this._rows == null) {
            return 0;
        }
        return this._rows.size();
    }

    @Override
    public int getColumnCount() {
        if (this._headings == null) {
            return 0;
        }
        return this._headings.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Dbg.wassert(n >= 0, "Invalid row index.");
        Dbg.wassert(n2 >= 0, "Invalid column index.");
        if (this.getRowCount() < n) {
            return null;
        }
        Dbg.wassert(n2 < this.getColumnCount(), "Invalid column index.");
        return ((RSMObjectRow)this._rows.get(n)).getValueAt(n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ((RSMObjectRow)this._rows.get(n)).setValueAt(object, n2);
    }

    public List getRows() {
        Dbg.wassert(this._rows != null, "Null row array.");
        return this._rows;
    }

    public RSMObjectRow GetRowAt(int n) {
        Dbg.wassert(n >= 0, "Invalid row index.");
        if (this.getRowCount() < n) {
            return null;
        }
        return (RSMObjectRow)this._rows.get(n);
    }

    @Override
    public String getColumnName(int n) {
        Dbg.wassert(n >= 0, "Invalid column index.");
        if (this._headings == null || this._headings.size() < n) {
            Dbg.wassert(false, "Null headings or column size mismatch");
            return " ";
        }
        String string = (String)this._headings.get(n);
        if (string == null || string.length() == 0) {
            return " ";
        }
        return string;
    }

    public Class getColumnClass(int n) {
        Dbg.wassert(n >= 0, "Invalid column index.");
        Object object = this.getValueAt(0, n);
        if (object != null) {
            return object.getClass();
        }
        return Object.class;
    }

    public void add(RSMObjectRow rSMObjectRow) {
        Dbg.wassert(rSMObjectRow != null, "Null row parameter.");
        Dbg.wassert(this._rows != null, "Null rows array attribute.");
        this.diagnose(rSMObjectRow);
        this._rows.add(rSMObjectRow);
    }

    public void add(List list) {
        Dbg.wassert(list != null && list.size() > 0, "Null or empty new row list parameter.");
        Dbg.wassert(this._rows != null, "Null rows array attribute.");
        this.diagnose(list);
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            this._rows.add(listIterator.next());
        }
    }

    public void remove(int n) {
        Dbg.wassert(n >= 0, "Invalid row index.");
        if (n < this.getRowCount()) {
            Dbg.trace(1, "Remove row '" + this.getValueAt(n, 0).toString() + "'");
            this._rows.remove(n);
        }
    }

    public void clear() {
        this._rows.clear();
    }

    public void setSorting(boolean bl) {
        this._sorting = bl;
    }

    public boolean isSorting() {
        return this._sorting;
    }

    public void releaseResources() {
        JTableHeader jTableHeader = this._table.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.removeMouseListener(this._listMouseListener);
        }
        this.clear();
        this._headings.clear();
        this._rows = null;
        this._headings = null;
        this._table = null;
    }

    private void diagnose(List list) {
        if (Dbg.isOn()) {
            Dbg.wassert(list != null, "Null row list parameter.");
            Dbg.trace(1, "New TableModel Rows.");
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Object e = listIterator.next();
                Dbg.wassert(e instanceof RSMObjectRow, "Invalid row. Row objects must be of type RSMObjectRow.");
                for (int i = 0; i < this.getRowCount(); ++i) {
                    Dbg.traceBuffer(1, ((RSMObjectRow)e).getValueAt(i).toString());
                }
                Dbg.traceDumpBuffer(1);
            }
        }
    }

    private void diagnose(RSMObjectRow rSMObjectRow) {
        if (Dbg.isOn()) {
            Dbg.wassert(rSMObjectRow != null, "Null row parameter.");
            Dbg.trace(1, "New TableModel Row.");
            for (int i = 0; i < this.getRowCount(); ++i) {
                Dbg.traceBuffer(1, rSMObjectRow.getValueAt(i).toString());
            }
            Dbg.traceDumpBuffer(1);
        }
    }

    public void sortByColumn(int n, boolean bl) {
        this._ascending = bl;
        this._lastSortedColumn = n;
        Dbg.wassert(this._rows != null, "Null rows array attribute.");
        Dbg.trace(1, "Sort TableModel by column: " + String.valueOf(n));
        this._table.setSortedColumnNumber(this._lastSortedColumn);
        this._table.setAscendingSortOrder(this._ascending);
        this.getSortComparator().setColumn(n);
        this.getSortComparator().setAscending(bl);
        Collections.sort(this._rows, this.getSortComparator());
        this._table.repaint();
    }

    private void addMouseListenerToHeaderInTable() {
        this._table.setColumnSelectionAllowed(false);
        this._listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (RSMObjectTableModel.this._table.isEnabled() && RSMObjectTableModel.this._sorting) {
                    RSMObjectTableModel.this._table.getSelectionModel().clearSelection();
                    TableColumnModel tableColumnModel = RSMObjectTableModel.this._table.getColumnModel();
                    int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                    int n2 = RSMObjectTableModel.this._table.convertColumnIndexToModel(n);
                    if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                        if (n2 == RSMObjectTableModel.this._lastSortedColumn) {
                            RSMObjectTableModel.this.sortByColumn(n2, !RSMObjectTableModel.this._ascending);
                        } else {
                            RSMObjectTableModel.this.sortByColumn(n2, true);
                        }
                    }
                }
            }
        };
        JTableHeader jTableHeader = this._table.getTableHeader();
        jTableHeader.addMouseListener(this._listMouseListener);
    }
}

