/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.util;

import com.sybase.central.editor.EditorEvent;
import com.sybase.central.editor.EditorFrame;
import com.sybase.central.editor.EditorListener;
import com.sybase.central.editor.Parser;
import com.sybase.central.editor.SCEditorFrame;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.bkgnd.BkgndThread;
import com.sybase.rsmplugin.sql.Domain;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import com.sybase.rsmplugin.util.SubmitDlg;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.sql.SQLException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public abstract class ScriptEditor
implements EditorListener {
    protected SCEditorFrame _editor = null;
    protected String _saveFileName = null;

    protected EditorFrame getEditor() {
        return this._editor;
    }

    protected abstract String getTitle();

    protected abstract Image getEditorIcon();

    protected abstract Parser getParser();

    protected abstract List getServerList();

    public void init(String string) {
        if (string == null) {
            string = "";
        }
        if (this._editor == null) {
            this._editor = (SCEditorFrame)PluginSupport.getViewerSupport().getEditor(this.getTitle(), this.getEditorIcon(), string, this.getParser(), true, true, false, true, true, true, true);
            this._editor.addEditorListener((EditorListener)this);
            this._editor.addAction((Action)new SubmitAction(), null);
        } else {
            Dbg.trace(128, "Script editor window already open.");
            String string2 = this._editor.getText();
            if (string2 != null && string2.length() > 0) {
                if (!string2.endsWith("\n")) {
                    string2 = string2 + "\n";
                }
                string2 = string2 + "go" + "\n" + string;
                this._editor.setText(string2);
            } else {
                this._editor.setText(string);
            }
            this._editor.requestFocus();
        }
    }

    protected void releaseResources() {
        this._editor = null;
    }

    public void editorSaveRequested(EditorEvent editorEvent) {
        Dbg.wassert(editorEvent != null, "Null event parameter.");
        if (this._saveFileName == null) {
            JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
            jFileChooser.setDialogType(1);
            int n = jFileChooser.showSaveDialog(this._editor.getParent());
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this._saveFileName = file.getAbsolutePath();
                this._editor.saveFile(this._saveFileName);
            }
        } else {
            String string = this._editor.getFileName();
            if (string != null && !this._saveFileName.equalsIgnoreCase(string)) {
                this._saveFileName = string;
            }
            this._editor.saveFile(this._saveFileName);
        }
    }

    public void editorClosed(EditorEvent editorEvent) {
        Dbg.trace(128, "Close the Script Editor window");
        this.releaseResources();
    }

    public class SubmitAction
    extends AbstractAction {
        public SubmitAction() {
            this.putValue("Name", BundleManager.getString("ProviderRes", "SUBMIT_MENU"));
            this.putValue("SmallIcon", new ImageIcon(RSMImages.getPlay()));
            this.putValue("MnemonicKey", new Integer(BundleManager.getMnemonic("ProviderRes", "SUBMIT_MENU_MNEM")));
            this.putValue("LongDescription", BundleManager.getString("ProviderRes", "SUBMIT_MENU_DESC"));
            this.putValue("ShortDescription", BundleManager.getString("ProviderRes", "SUBMIT_DLG_TITLE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = ScriptEditor.this.getEditor().getText();
            if (string != null && string.length() > 0) {
                List list = ScriptEditor.this.getServerList();
                SubmitDlg submitDlg = new SubmitDlg(PluginSupport.getDialogSupport((JFrame)ScriptEditor.this.getEditor()), list);
                if (submitDlg.showDialog()) {
                    this.submitScript(submitDlg.getDomain(), submitDlg.getServer(), string);
                }
            }
        }

        protected void submitScript(final String string, final String string2, final String string3) {
            Dbg.wassert(string != null && string.length() > 0, "Null or empty domain parameter.");
            Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty server parameter.");
            Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty command script parameter");
            Dbg.trace(128, "Submit the commands from the editor window to server '" + string2 + "', domain '" + string + "'.");
            BkgndThread bkgndThread = new BkgndThread(BundleManager.getString("ProviderRes", "SUBMIT_BKGND_TITLE", string2), string){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Domain domain = PluginSupport.getDomain(string);
                    if (domain != null && domain.isEnvironment()) {
                        EnvDomain envDomain = (EnvDomain)domain;
                        RSMConnection rSMConnection = envDomain.getConnection(string2);
                        if (rSMConnection != null) {
                            try {
                                StringBuffer stringBuffer = new StringBuffer(string3);
                                do {
                                    String string4;
                                    if ((string4 = SubmitAction.this.getCommand(stringBuffer)) == null || string4.length() <= 0) continue;
                                    this.setStatus(SubmitAction.this.getCmdInfo(string4));
                                    Dbg.trace(128, "Execute:\n" + string4);
                                    rSMConnection.execute(string4);
                                } while (!1.interrupted() && stringBuffer != null && stringBuffer.length() > 0);
                            }
                            catch (SQLException sQLException) {
                                SubmitAction.this.displayError(sQLException);
                                this.setError(true);
                                this.setStatus(MessageText.formatExceptionMessage(sQLException));
                            }
                            finally {
                                rSMConnection.unlock();
                            }
                        } else {
                            String string5 = BundleManager.getString("ProviderRes", "SRV_UNABLE_TO_CONNECT", string2);
                            SubmitAction.this.displayError(string5, string5);
                            this.setError(true);
                            this.setStatus(string5);
                        }
                    }
                    this.close();
                }
            };
            bkgndThread.start();
        }

        protected String getCommand(StringBuffer stringBuffer) {
            Dbg.wassert(stringBuffer != null && stringBuffer.length() > 0, "Null or empty buffer attribute.");
            String string = "";
            boolean bl = false;
            while (!bl && stringBuffer != null && stringBuffer.length() > 0) {
                String string2 = null;
                int n = stringBuffer.indexOf("\n");
                if (n >= 0) {
                    string2 = stringBuffer.substring(0, n);
                    stringBuffer = stringBuffer.delete(0, n + 1);
                } else {
                    string2 = stringBuffer.substring(0);
                    stringBuffer = stringBuffer.delete(0, stringBuffer.length());
                }
                if (string2 != null) {
                    if ((string2 = string2.trim()).equalsIgnoreCase("go")) {
                        bl = true;
                        continue;
                    }
                    if (string.length() > 0) {
                        string = string + "\n" + string2;
                        continue;
                    }
                    string = string2;
                    continue;
                }
                bl = true;
            }
            return string;
        }

        protected String getCmdInfo(String string) {
            String string2 = null;
            boolean bl = false;
            boolean bl2 = false;
            StringBuffer stringBuffer = new StringBuffer(string);
            while (!bl && stringBuffer != null && stringBuffer.length() > 0) {
                int n = stringBuffer.indexOf("\n");
                if (n >= 0) {
                    string2 = stringBuffer.substring(0, n);
                    stringBuffer = stringBuffer.delete(0, n + 1);
                } else {
                    string2 = stringBuffer.substring(0);
                    stringBuffer = stringBuffer.delete(0, stringBuffer.length());
                }
                string2 = string2.trim();
                if (string2.startsWith("/*")) {
                    if (string2.indexOf("*/") >= 0) continue;
                    bl2 = true;
                    continue;
                }
                if (bl2 && string2.indexOf("*/") >= 0) {
                    bl2 = false;
                    continue;
                }
                if (bl2 || string2.startsWith("--") || string2.length() <= 0) continue;
                bl = true;
            }
            if (string2 == null || string2.length() == 0) {
                string2 = string;
            }
            if (string2.length() > 50) {
                string2 = string2.substring(0, 50) + "...";
            }
            return BundleManager.getString("ProviderRes", "SUBMIT_CURRENT_CMD", string2);
        }

        protected void displayError(SQLException sQLException) {
            Dbg.wassert(sQLException != null, "Null SQLException parameter.");
            this.displayError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }

        protected void displayError(final String string, final String string2) {
            Dbg.wassert(string != null, "Null error message parameter.");
            Dbg.wassert(string2 != null, "Null detailed error message parameter.");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PluginSupport.showError(string, string2);
                }
            });
        }
    }
}

