/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.Ber;
import com.sun.jndi.ldap.BerDecoder;
import com.sun.jndi.ldap.BerEncoder;
import com.sun.jndi.ldap.LdapClient;
import com.sun.jndi.ldap.LdapRequest;
import com.sun.jndi.ldap.Obj;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import javax.naming.CommunicationException;
import javax.naming.InterruptedNamingException;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.ldap.Control;

public final class Connection
implements Runnable {
    private static final boolean debug = false;
    private static final int dump = 0;
    private Thread worker;
    private boolean v3 = true;
    String host;
    int port;
    private boolean bound = false;
    private OutputStream traceFile = null;
    private String traceTagIn = null;
    private String traceTagOut = null;
    public InputStream inStream;
    public OutputStream outStream;
    public Socket sock;
    private LdapClient parent = null;
    private int outMsgId = 0;
    private LdapRequest pendingRequests = null;
    private Object streamLock = new Object();
    private boolean updateStream = false;
    static /* synthetic */ Class class$java$lang$String;

    Connection(LdapClient ldapClient, String string, int n, String string2, OutputStream outputStream) throws NamingException {
        this.host = string;
        this.port = n;
        this.parent = ldapClient;
        if (outputStream != null) {
            this.traceFile = outputStream;
            this.traceTagIn = "<- " + string + ":" + n + "\n\n";
            this.traceTagOut = "-> " + string + ":" + n + "\n\n";
        }
        try {
            Object object;
            if (string2 != null) {
                object = Obj.helper.loadClass(string2);
                Method method = ((Class)object).getMethod("getDefault", new Class[0]);
                Object object2 = method.invoke(null, new Object[0]);
                Method method2 = ((Class)object).getMethod("createSocket", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = Connection.class$("java.lang.String")), Integer.TYPE);
                this.sock = (Socket)method2.invoke(object2, string, new Integer(n));
            } else {
                this.sock = new Socket(string, n);
            }
            this.inStream = new BufferedInputStream(this.sock.getInputStream());
            object = this.sock.getOutputStream();
            ((OutputStream)object).write(new byte[0]);
            this.outStream = new BufferedOutputStream((OutputStream)object);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            CommunicationException communicationException = new CommunicationException(String.valueOf(string) + ":" + n);
            communicationException.setRootCause(throwable);
            throw communicationException;
        }
        catch (Exception exception) {
            CommunicationException communicationException = new CommunicationException(String.valueOf(string) + ":" + n);
            communicationException.setRootCause(exception);
            throw communicationException;
        }
        this.worker = Obj.helper.createThread(this);
        this.worker.setDaemon(true);
        this.worker.start();
    }

    synchronized void abandonOutstandingReqs(Control[] controlArray) {
        LdapRequest ldapRequest = this.pendingRequests;
        while (ldapRequest != null) {
            this.abandonRequest(ldapRequest, controlArray);
            this.pendingRequests = ldapRequest = ldapRequest.next;
        }
    }

    void abandonRequest(LdapRequest ldapRequest, Control[] controlArray) {
        this.removeRequest(ldapRequest);
        BerEncoder berEncoder = new BerEncoder(256);
        int n = this.getMsgId();
        try {
            berEncoder.beginSeq(48);
            berEncoder.encodeInt(n);
            berEncoder.encodeInt(ldapRequest.msgId, 80);
            if (this.v3) {
                LdapClient.encodeControls(berEncoder, controlArray);
            }
            berEncoder.endSeq();
            if (this.traceFile != null) {
                Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
            }
            Connection connection = this;
            synchronized (connection) {
                this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
                this.outStream.flush();
            }
        }
        catch (IOException iOException) {}
    }

    private synchronized void addRequest(LdapRequest ldapRequest) {
        LdapRequest ldapRequest2 = this.pendingRequests;
        if (ldapRequest2 == null) {
            this.pendingRequests = ldapRequest;
            ldapRequest.next = null;
        } else {
            ldapRequest.next = this.pendingRequests;
            this.pendingRequests = ldapRequest;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    synchronized void cleanup(Control[] var1_1) {
        block10: {
            if (this.sock != null) {
                block8: {
                    this.abandonOutstandingReqs(var1_1);
                    if (!this.bound) break block8;
                    this.ldapUnbind(var1_1);
                }
                var3_2 = null;
                try {
                    this.outStream.flush();
                    this.sock.close();
                }
                catch (IOException var4_4) {
                    // empty catch block
                }
                var4_4 = this.pendingRequests;
                while (var4_4 != null) {
                    var4_4.cancel();
                    var4_4 = var4_4.next;
                }
                this.sock = null;
                break block10;
                catch (Throwable var2_6) {
                    var3_3 = null;
                    try {
                        this.outStream.flush();
                        this.sock.close();
                    }
                    catch (IOException var4_5) {
                        // empty catch block
                    }
                    var4_5 = this.pendingRequests;
                    ** while (var4_5 != null)
                }
lbl-1000:
                // 1 sources

                {
                    var4_5.cancel();
                    var4_5 = var4_5.next;
                    continue;
                }
lbl37:
                // 1 sources

                this.sock = null;
                throw var2_6;
            }
        }
    }

    synchronized LdapRequest findRequest(int n) {
        LdapRequest ldapRequest = this.pendingRequests;
        while (ldapRequest != null) {
            if (ldapRequest.msgId == n) {
                return ldapRequest;
            }
            ldapRequest = ldapRequest.next;
        }
        return null;
    }

    synchronized int getMsgId() {
        return ++this.outMsgId;
    }

    private void ldapUnbind(Control[] controlArray) {
        BerEncoder berEncoder = new BerEncoder(256);
        int n = this.getMsgId();
        try {
            berEncoder.beginSeq(48);
            berEncoder.encodeInt(n);
            berEncoder.encodeByte(66);
            berEncoder.encodeByte(0);
            if (this.v3) {
                LdapClient.encodeControls(berEncoder, controlArray);
            }
            berEncoder.endSeq();
            if (this.traceFile != null) {
                Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
            }
            Connection connection = this;
            synchronized (connection) {
                this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
                this.outStream.flush();
            }
        }
        catch (IOException iOException) {}
    }

    BerDecoder readReply(LdapRequest ldapRequest) throws IOException, NamingException {
        BerDecoder berDecoder;
        while ((berDecoder = ldapRequest.getReplyBer()) == null) {
            try {
                Object object = this;
                synchronized (object) {
                    if (this.sock == null) {
                        throw new ServiceUnavailableException(String.valueOf(this.host) + ":" + this.port + "; socket closed");
                    }
                }
                object = ldapRequest;
                synchronized (object) {
                    berDecoder = ldapRequest.getReplyBer();
                    if (berDecoder != null) {
                        Object var4_4 = null;
                        break;
                    }
                    ldapRequest.wait(15000L);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedNamingException("Interrupted during LDAP operation");
            }
        }
        return berDecoder;
    }

    synchronized void removeRequest(LdapRequest ldapRequest) {
        LdapRequest ldapRequest2 = this.pendingRequests;
        LdapRequest ldapRequest3 = null;
        while (ldapRequest2 != null) {
            if (ldapRequest2 == ldapRequest) {
                ldapRequest2.cancel();
                if (ldapRequest3 != null) {
                    ldapRequest3.next = ldapRequest2.next;
                } else {
                    this.pendingRequests = ldapRequest2.next;
                }
                ldapRequest2.next = null;
            }
            ldapRequest3 = ldapRequest2;
            ldapRequest2 = ldapRequest2.next;
        }
    }

    public void replaceInputStream(InputStream inputStream) throws IOException {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.inStream == inputStream) {
                Object var3_3 = null;
                return;
            }
            this.inStream = inputStream;
            this.updateStream = true;
            this.worker.interrupt();
            try {
                try {
                    while (this.updateStream) {
                        this.streamLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException("Cannot replace input stream");
                }
                Object var5_4 = null;
                this.updateStream = false;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.updateStream = false;
                throw throwable;
            }
        }
    }

    public void replaceOutputStream(OutputStream outputStream) throws IOException {
        try {
            this.outStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.outStream = outputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block24: {
            try {
                try {}
                catch (IOException iOException) {
                    break block24;
                }
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                this.cleanup(null);
                throw throwable;
            }
            block11: while (true) {
                try {
                    while (true) {
                        int n;
                        byte[] byArray = new byte[2048];
                        int n2 = 0;
                        int n3 = 0;
                        int n4 = 0;
                        int n5 = this.inStream.read(byArray, n2, 1);
                        if (n5 < 0) break block11;
                        if (byArray[n2++] != 48) continue;
                        n5 = this.inStream.read(byArray, n2, 1);
                        if (n5 < 0) break block11;
                        if (((n3 = byArray[n2++]) & 0x80) == 128) {
                            n4 = n3 & 0x7F;
                            n5 = 0;
                            boolean bl = false;
                            while (n5 < n4) {
                                int n6 = this.inStream.read(byArray, n2 + n5, n4 - n5);
                                if (n6 < 0) {
                                    bl = true;
                                    break;
                                }
                                n5 += n6;
                            }
                            if (bl) break block11;
                            n3 = 0;
                            int n7 = 0;
                            while (true) {
                                if (n7 >= n4) {
                                    n2 += n5;
                                    break;
                                }
                                n3 = (n3 << 8) + (byArray[n2 + n7] & 0xFF);
                                ++n7;
                            }
                        }
                        if (n2 + (n = n3) > byArray.length) {
                            byte[] byArray2 = new byte[n2 + n];
                            System.arraycopy(byArray, 0, byArray2, 0, n2);
                            byArray = byArray2;
                        }
                        while (n > 0 && (n5 = this.inStream.read(byArray, n2, n)) >= 0) {
                            n2 += n5;
                            n -= n5;
                        }
                        try {
                            BerDecoder berDecoder = new BerDecoder(byArray, 0, n2);
                            if (this.traceFile != null) {
                                Ber.dumpBER(this.traceFile, this.traceTagIn, byArray, 0, n2);
                            }
                            berDecoder.parseSeq(null);
                            int n8 = berDecoder.parseInt();
                            berDecoder.reset();
                            if (n8 == 0) {
                                this.parent.processUnsolicited(berDecoder);
                                continue;
                            }
                            LdapRequest ldapRequest = this.findRequest(n8);
                            if (ldapRequest == null) continue;
                            ldapRequest.addReplyBer(berDecoder);
                        }
                        catch (Ber.DecodeException decodeException) {}
                    }
                }
                catch (IOException iOException) {
                    Object object = this.streamLock;
                    synchronized (object) {
                        if (!this.updateStream) {
                            throw iOException;
                        }
                        this.updateStream = false;
                        this.streamLock.notify();
                    }
                }
            }
        }
        Object var12_17 = null;
        this.cleanup(null);
    }

    void setBound() {
        this.bound = true;
    }

    void setV3(boolean bl) {
        this.v3 = bl;
    }

    LdapRequest writeRequest(BerEncoder berEncoder, int n) throws IOException {
        LdapRequest ldapRequest = new LdapRequest(n);
        this.addRequest(ldapRequest);
        if (this.traceFile != null) {
            Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
        }
        Connection connection = this;
        synchronized (connection) {
            this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
            this.outStream.flush();
        }
        return ldapRequest;
    }
}

