/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa;

import com.sybase.asa.ASAIconTextDataListCellRenderer;
import com.sybase.asa.ASAUserData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class ASAComboBox
extends JComboBox
implements ActionListener {
    private static final String ESCAPE_KEY_PRESS = "ESCAPE_KEY_PRESS";
    private static final String ACTN_ENTER = "0";
    private static final String ACTN_ESCAPE = "1";
    private static final KeyStroke KSTR_ENTER = KeyStroke.getKeyStroke(10, 0);
    private static final KeyStroke KSTR_ESCAPE = KeyStroke.getKeyStroke(27, 0, false);

    public ASAComboBox() {
        this._init();
    }

    public ASAComboBox(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        this._init();
    }

    public ASAComboBox(Object[] objectArray) {
        super(objectArray);
        this._init();
    }

    public ASAComboBox(Vector vector) {
        super(vector);
        this._init();
    }

    private void _init() {
        Component component;
        ComboBoxEditor comboBoxEditor = this.getEditor();
        this.registerKeyboardAction(this, ACTN_ENTER, KSTR_ENTER, 0);
        this.registerKeyboardAction(this, ACTN_ESCAPE, KSTR_ESCAPE, 0);
        if (comboBoxEditor != null && (component = comboBoxEditor.getEditorComponent()) != null && component instanceof JTextField) {
            JTextField jTextField = (JTextField)component;
            jTextField.registerKeyboardAction(this, ACTN_ENTER, KSTR_ENTER, 0);
            jTextField.registerKeyboardAction(this, ACTN_ESCAPE, KSTR_ESCAPE, 1);
        }
    }

    public void setPreferredWidth(int n) {
        this.setPreferredSize(new Dimension(n, this.getPreferredSize().height));
    }

    public boolean getHasIconTextData() {
        return this.getRenderer() instanceof ASAIconTextDataListCellRenderer;
    }

    public void setHasIconTextData(boolean bl) {
        this.setRenderer(bl ? new ASAIconTextDataListCellRenderer() : new DefaultListCellRenderer());
    }

    public String getSelectedString() {
        if (this.isEditable()) {
            return ((JTextComponent)this.getEditor().getEditorComponent()).getText();
        }
        Object object = this.getSelectedItem();
        return object != null ? object.toString() : null;
    }

    public Object getSelectedUserData() {
        Object object;
        Object object2 = this.getSelectedItem();
        if (object2 == null) {
            object = null;
        } else if (object2 instanceof ASAUserData) {
            object = ((ASAUserData)object2).getUserData();
        } else {
            throw new UnsupportedOperationException();
        }
        return object;
    }

    public int findItem(String string) {
        return this.findItem(string, 0);
    }

    public int findItem(String string, int n) {
        int n2 = this.getItemCount();
        for (int i = n; i < n2; ++i) {
            if (!this.getItemAt(i).toString().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int matchItem(String string) {
        return this.matchItem(string, 0);
    }

    public int matchItem(String string, int n) {
        int n2 = this.getItemCount();
        for (int i = n; i < n2; ++i) {
            if (!this.getItemAt(i).toString().startsWith(string)) continue;
            return i;
        }
        return -1;
    }

    public void setSelectedItem(String string) {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            Object e = this.getItemAt(i);
            if (e == null || !e.toString().equals(string)) continue;
            this.setSelectedIndex(i);
            return;
        }
        if (n > 0) {
            this.setSelectedIndex(0);
        }
    }

    public void setSelectedUserData(Object object) {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            ASAUserData aSAUserData;
            Object e = this.getItemAt(i);
            if (e == null || !(e instanceof ASAUserData) || !(aSAUserData = (ASAUserData)e).getUserData().equals(object)) continue;
            this.setSelectedIndex(i);
            return;
        }
        if (n > 0) {
            this.setSelectedIndex(0);
        }
    }

    public void clear() {
        this.removeAllItems();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Component component;
        boolean bl;
        Object object = actionEvent.getSource();
        ComboBoxEditor comboBoxEditor = this.getEditor();
        String string = actionEvent.getActionCommand();
        boolean bl2 = bl = comboBoxEditor != null && (component = comboBoxEditor.getEditorComponent()) != null && object == component;
        if ((object == this || bl) && string != null) {
            if (string.equals(ACTN_ENTER)) {
                if (this.isPopupVisible()) {
                    this.hidePopup();
                } else {
                    JButton jButton;
                    JRootPane jRootPane = this.getRootPane();
                    if (jRootPane != null && (jButton = jRootPane.getDefaultButton()) != null) {
                        jButton.doClick();
                    }
                }
            } else if (string.equals(ACTN_ESCAPE)) {
                if (this.isPopupVisible()) {
                    this.hidePopup();
                } else {
                    ActionListener actionListener;
                    JRootPane jRootPane = this.getRootPane();
                    if (jRootPane != null && (actionListener = jRootPane.getActionForKeyStroke(KSTR_ESCAPE)) != null) {
                        actionListener.actionPerformed(new ActionEvent(jRootPane, 0, ESCAPE_KEY_PRESS));
                    }
                }
            }
        }
    }
}

