/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa;

import com.sybase.asa.ASATextField;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ASAIntegerTextField
extends ASATextField {
    private Toolkit _toolkit = Toolkit.getDefaultToolkit();

    public ASAIntegerTextField() {
        this._init();
    }

    public ASAIntegerTextField(String string) {
        super(string);
        this._init();
    }

    public ASAIntegerTextField(int n) {
        super(n);
        this._init();
    }

    public ASAIntegerTextField(String string, int n) {
        super(string, n);
        this._init();
    }

    private void _init() {
        this.setDocument(new IntegerDocument());
        this.setHorizontalAlignment(4);
    }

    public int getValue() {
        try {
            return Integer.parseInt(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void setValue(int n) {
        this.setText(String.valueOf(n));
    }

    public void setPreferredWidthToDigits(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        try {
            int n2 = (int)(Math.pow(10.0, n) - 1.0);
            int n3 = fontMetrics.stringWidth(String.valueOf(n2));
            this.setPreferredWidth(n3, true);
            this.setMinimumSize(new Dimension(n3, this.getMinimumSize().height));
        }
        catch (ArithmeticException arithmeticException) {
            return;
        }
    }

    private class IntegerDocument
    extends PlainDocument {
        private IntegerDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            int n3 = cArray2.length;
            for (int i = 0; i < n3; ++i) {
                if (Character.isDigit(cArray[i])) {
                    cArray2[n2++] = cArray[i];
                    continue;
                }
                ASAIntegerTextField.this._toolkit.beep();
            }
            super.insertString(n, new String(cArray2, 0, n2), attributeSet);
        }
    }
}

