/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa;

import com.sybase.asa.ASAIconTextData;
import com.sybase.asa.ASAIconTextDataListCellRenderer;
import com.sybase.asa.ASAScrollPane;
import com.sybase.asa.ASAUserData;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.Timer;

public class ASAList
extends JList
implements ActionListener {
    private static final String STR_EMPTY = "";
    private boolean _autoKeySelectionEnabled;
    private Timer _timer;
    private StringBuffer _typedSoFar;
    private DefaultListModel _model;
    private ASAScrollPane _scrollPane;

    public ASAList() {
        this._model = new DefaultListModel();
        this.setModel(this._model);
        this._init();
    }

    public ASAList(Object[] objectArray) {
        this.setModel(objectArray);
        this._init();
    }

    public ASAList(Vector vector) {
        this.setModel(vector);
        this._init();
    }

    private void _init() {
        this._scrollPane = new ASAScrollPane(this);
        this._autoKeySelectionEnabled = true;
        this._timer = new Timer(1000, this);
        this._typedSoFar = new StringBuffer();
        this._timer.start();
    }

    public void releaseResources() {
        if (this._timer.isRunning()) {
            this._timer.stop();
        }
        this._timer.removeActionListener(this);
        this._timer = null;
        this._typedSoFar = null;
        this._model = null;
        this._scrollPane = null;
    }

    public void setModel(Object[] objectArray) {
        this._model = new DefaultListModel();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            this._model.addElement(objectArray[i]);
        }
        this.setModel(this._model);
    }

    public void setModel(Vector vector) {
        this._model = new DefaultListModel();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this._model.addElement(vector.get(i));
        }
        this.setModel(this._model);
    }

    public boolean isAutoKeySelectionEnabled() {
        return this._autoKeySelectionEnabled;
    }

    public void setAutoKeySelectionEnabled(boolean bl) {
        this._autoKeySelectionEnabled = bl;
        if (bl && !this._timer.isRunning()) {
            this._timer.restart();
        } else if (!bl && this._timer.isRunning()) {
            this._timer.stop();
        }
    }

    public boolean getHasIconTextData() {
        return this.getCellRenderer() instanceof ASAIconTextDataListCellRenderer;
    }

    public void setHasIconTextData(boolean bl) {
        this.setCellRenderer(bl ? new ASAIconTextDataListCellRenderer() : new DefaultListCellRenderer());
    }

    public ASAScrollPane getScrollPane() {
        return this._scrollPane;
    }

    public int getItemCount() {
        return this._model.getSize();
    }

    public void selectItem(int n) {
        this.setSelectionInterval(n, n);
    }

    public void selectRows(int n, int n2) {
        this.setSelectionInterval(n, n2);
    }

    public void selectItems(int[] nArray) {
        this.clearSelection();
        for (int n : nArray) {
            this.addSelectionInterval(n, n);
        }
    }

    public Object getValueAt(int n) {
        return this._model.get(n);
    }

    public void setValueAt(int n, Object object) {
        this._model.set(n, object);
    }

    public String getStringAt(int n) {
        Object e = this._model.get(n);
        return e == null ? STR_EMPTY : e.toString();
    }

    public void setStringAt(int n, String string) {
        Object object;
        Object e = this._model.get(n);
        if (e == null || e instanceof String) {
            object = string;
        } else if (e instanceof ASAIconTextData) {
            ASAIconTextData aSAIconTextData = (ASAIconTextData)e;
            aSAIconTextData.text = string;
            object = aSAIconTextData;
        } else {
            throw new UnsupportedOperationException();
        }
        this._model.set(n, object);
    }

    public Icon getIconAt(int n) {
        Icon icon;
        Object e = this._model.get(n);
        if (e == null) {
            icon = null;
        } else if (e instanceof Icon) {
            icon = (Icon)e;
        } else if (e instanceof ASAIconTextData) {
            icon = ((ASAIconTextData)e).icon;
        } else {
            throw new UnsupportedOperationException();
        }
        return icon;
    }

    public void setIconAt(int n, Icon icon) {
        Object object;
        Object e = this._model.get(n);
        if (e == null || e instanceof Icon) {
            object = icon;
        } else if (e instanceof ASAIconTextData) {
            ASAIconTextData aSAIconTextData = (ASAIconTextData)e;
            aSAIconTextData.icon = icon;
            object = aSAIconTextData;
        } else {
            throw new UnsupportedOperationException();
        }
        this._model.set(n, object);
    }

    public Object getUserDataAt(int n) {
        Object e = this._model.get(n);
        if (e == null || !(e instanceof ASAUserData)) {
            throw new UnsupportedOperationException();
        }
        Object object = ((ASAUserData)e).getUserData();
        return object;
    }

    public void setUserDataAt(int n, Object object) {
        Object e = this._model.get(n);
        if (e == null || !(e instanceof ASAUserData)) {
            throw new UnsupportedOperationException();
        }
        ASAUserData aSAUserData = (ASAUserData)e;
        aSAUserData.setUserData(object);
        this._model.set(n, aSAUserData);
    }

    public int findItem(String string) {
        return this.findItem(string, 0, this._model.getSize(), false, false);
    }

    public int findItem(String string, int n) {
        return this.findItem(string, n, this._model.getSize(), false, false);
    }

    public int findItem(String string, int n, int n2, boolean bl, boolean bl2) {
        int n3 = string.length();
        for (int i = n; i < n2; ++i) {
            String string2 = this.getStringAt(i);
            if (string2 == null || !string2.regionMatches(bl, 0, string, 0, bl2 ? n3 : string2.length())) continue;
            return i;
        }
        return -1;
    }

    public void moveItem(int n, int n2) {
        Object e = this._model.remove(n);
        this._model.add(n2, e);
    }

    public void addItem(Object object) {
        this._model.addElement(object);
    }

    public void insertItem(int n, Object object) {
        this._model.add(n, object);
    }

    public void removeItem(int n) {
        this._model.remove(n);
    }

    public void clear() {
        this._model.clear();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl && this._autoKeySelectionEnabled && !this._timer.isRunning()) {
            this._timer.restart();
            this._typedSoFar.setLength(0);
        } else if (!bl && this._timer.isRunning()) {
            this._timer.stop();
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        int n;
        int n2;
        char c;
        if (this._timer.isRunning() && keyEvent.getKeyCode() == 0 && (c = keyEvent.getKeyChar()) != '\uffff' && ((n2 = keyEvent.getModifiers()) == 0 || n2 == 1) && (n = this.getItemCount()) > 0) {
            String string;
            this._timer.stop();
            this._typedSoFar.append(c);
            int n3 = this.isSelectionEmpty() ? 0 : this.getMaxSelectionIndex();
            int n4 = this._typedSoFar.length();
            if (n4 == 1 || this._typedSoFar.charAt(n4 - 2) == c) {
                ++n3;
                string = String.valueOf(c);
            } else {
                string = this._typedSoFar.toString();
            }
            int n5 = this.findItem(string, n3, n, true, true);
            if (n5 != -1 || (n5 = this.findItem(string, 0, n3, true, true)) != -1) {
                this.setSelectedIndex(n5);
                this.ensureIndexIsVisible(n5);
            }
            this._timer.restart();
            keyEvent.consume();
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._timer) {
            this._typedSoFar.setLength(0);
        }
    }
}

