/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa;

import com.sybase.asa.ASACheckedData;
import com.sybase.asa.ASACheckedDataTableCellRenderer;
import com.sybase.asa.ASACheckedIconTextDataTableCellRenderer;
import com.sybase.asa.ASAIconTextData;
import com.sybase.asa.ASAIconTextDataTableCellRenderer;
import com.sybase.asa.ASAListCheckEvent;
import com.sybase.asa.ASAListCheckListener;
import com.sybase.asa.ASAMultiList;
import com.sybase.asa.ASAMultiListColumnInfo;
import com.sybase.asa.ASAMultiListTableModel;
import com.sybase.asa.ASAUserData;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ASAMultiCheckList
extends ASAMultiList
implements ActionListener,
MouseListener {
    Vector _listCheckListeners = new Vector();
    int _pressedRow = -1;

    public ASAMultiCheckList() {
        this._init();
    }

    public ASAMultiCheckList(Vector vector, Vector vector2) {
        super(vector, vector2);
        this._init();
    }

    public ASAMultiCheckList(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this._init();
    }

    public ASAMultiCheckList(Vector vector) {
        super(vector);
        this._init();
    }

    public ASAMultiCheckList(Object[] objectArray) {
        super(objectArray);
        this._init();
    }

    public ASAMultiCheckList(ASAMultiListColumnInfo[] aSAMultiListColumnInfoArray) {
        super(aSAMultiListColumnInfoArray);
        this._init();
    }

    private void _init() {
        this.setSelectionMode(0);
        this.tableColumnModel.getColumn(0).setCellRenderer(new ASACheckedDataTableCellRenderer());
        this.addMouseListener(this);
        this.registerKeyboardAction(this, KeyStroke.getKeyStroke(32, 0), 0);
    }

    @Override
    public void releaseResources() {
        this.removeMouseListener(this);
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(32, 0));
        this._listCheckListeners = null;
        super.releaseResources();
    }

    @Override
    public void setModel(ASAMultiListTableModel aSAMultiListTableModel) {
        super.setModel(aSAMultiListTableModel);
        this.tableColumnModel.getColumn(0).setCellRenderer(new ASACheckedDataTableCellRenderer());
    }

    @Override
    public boolean getColumnHasIconTextData(int n) {
        TableCellRenderer tableCellRenderer = this.tableColumnModel.getColumn(n).getCellRenderer();
        if (n == 0) {
            return tableCellRenderer instanceof ASACheckedIconTextDataTableCellRenderer;
        }
        return tableCellRenderer instanceof ASAIconTextDataTableCellRenderer;
    }

    @Override
    public void setColumnHasIconTextData(int n, boolean bl) {
        TableColumn tableColumn = this.tableColumnModel.getColumn(n);
        if (n == 0) {
            if (bl) {
                tableColumn.setCellRenderer(new ASACheckedIconTextDataTableCellRenderer());
            } else {
                tableColumn.setCellRenderer(new ASACheckedDataTableCellRenderer());
            }
        } else if (bl) {
            tableColumn.setCellRenderer(new ASAIconTextDataTableCellRenderer());
        } else {
            tableColumn.setCellRenderer(new DefaultTableCellRenderer());
        }
    }

    public void addListCheckListener(ASAListCheckListener aSAListCheckListener) {
        this._listCheckListeners.add(aSAListCheckListener);
    }

    public void removeListCheckListener(ASAListCheckListener aSAListCheckListener) {
        this._listCheckListeners.remove(aSAListCheckListener);
    }

    protected void fireCheckValueChanged(int n, int n2) {
        ASAListCheckEvent aSAListCheckEvent = new ASAListCheckEvent(this, n, n2);
        this.tableModel.fireTableChanged(new TableModelEvent(this.tableModel, n, n2));
        int n3 = this._listCheckListeners.size();
        for (int i = 0; i < n3; ++i) {
            ((ASAListCheckListener)this._listCheckListeners.get(i)).valueChanged(aSAListCheckEvent);
        }
    }

    public boolean isRowEnabled(int n) {
        return ((ASACheckedData)this.getValueAt((int)n, (int)0)).isEnabled;
    }

    public void setRowEnabled(int n, boolean bl) {
        ASACheckedData aSACheckedData = (ASACheckedData)this.getValueAt(n, 0);
        aSACheckedData.isEnabled = bl;
        this.setValueAt(aSACheckedData, n, 0);
        this.tableModel.fireTableChanged(new TableModelEvent(this.tableModel, n, n));
    }

    public boolean isRowChecked(int n) {
        return ((ASACheckedData)this.getValueAt((int)n, (int)0)).isChecked;
    }

    public void setRowChecked(int n, boolean bl) {
        ASACheckedData aSACheckedData = (ASACheckedData)this.getValueAt(n, 0);
        aSACheckedData.isChecked = bl;
        this.setValueAt(aSACheckedData, n, 0);
        this.fireCheckValueChanged(n, n);
    }

    public void toggleRowChecked(int n) {
        ASACheckedData aSACheckedData = (ASACheckedData)this.getValueAt(n, 0);
        aSACheckedData.isChecked = !aSACheckedData.isChecked;
        this.setValueAt(aSACheckedData, n, 0);
        this.fireCheckValueChanged(n, n);
    }

    public void checkAllRows() {
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            ASACheckedData aSACheckedData = (ASACheckedData)this.getValueAt(i, 0);
            aSACheckedData.isChecked = true;
            this.setValueAt(aSACheckedData, i, 0);
        }
        this.fireCheckValueChanged(0, n);
    }

    public void uncheckAllRows() {
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            ASACheckedData aSACheckedData = (ASACheckedData)this.getValueAt(i, 0);
            aSACheckedData.isChecked = false;
            this.setValueAt(aSACheckedData, i, 0);
        }
        this.fireCheckValueChanged(0, n);
    }

    public int getCheckedRowCount() {
        int n = 0;
        int n2 = this.getRowCount();
        for (int i = 0; i < n2; ++i) {
            if (!this.isRowChecked(i)) continue;
            ++n;
        }
        return n;
    }

    public int getCheckedRow() {
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (!this.isRowChecked(i)) continue;
            return i;
        }
        return -1;
    }

    public int[] getCheckedRows() {
        int n = this.getRowCount();
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.isRowChecked(i)) continue;
            nArray[n2++] = i;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public int getUncheckedRowCount() {
        int n = 0;
        int n2 = this.getRowCount();
        for (int i = 0; i < n2; ++i) {
            if (this.isRowChecked(i)) continue;
            ++n;
        }
        return n;
    }

    public int getUncheckedRow() {
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (this.isRowChecked(i)) continue;
            return i;
        }
        return -1;
    }

    public int[] getUncheckedRows() {
        int n = this.getRowCount();
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.isRowChecked(i)) continue;
            nArray[n2++] = i;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public Object getCheckedData(int n) {
        return ((ASACheckedData)this.getValueAt((int)n, (int)0)).object;
    }

    public void setCheckedData(Object object, int n) {
        ASACheckedData aSACheckedData = (ASACheckedData)this.getValueAt(n, 0);
        aSACheckedData.object = object;
        this.setValueAt(aSACheckedData, n, 0);
    }

    @Override
    public Icon getIconAt(int n, int n2) {
        if (n2 == 0) {
            Object object = ((ASACheckedData)this.tableModel.getValueAt((int)n, (int)n2)).object;
            if (object == null) {
                return null;
            }
            if (object instanceof Icon) {
                return (Icon)object;
            }
            if (object instanceof ASAIconTextData) {
                return ((ASAIconTextData)object).icon;
            }
            return null;
        }
        return super.getIconAt(n, n2);
    }

    @Override
    public void setIconAt(Icon icon, int n, int n2) {
        if (n2 == 0) {
            Object object = ((ASACheckedData)this.tableModel.getValueAt((int)n, (int)n2)).object;
            if (object == null) {
                this.tableModel.setValueAt(icon, n, n2);
            } else if (object instanceof ASAIconTextData) {
                ((ASAIconTextData)object).icon = icon;
                this.tableModel.fireTableCellUpdated(n, n2);
            } else {
                this.tableModel.setValueAt(icon, n, n2);
            }
        } else {
            super.setIconAt(icon, n, n2);
        }
    }

    @Override
    public Object getUserDataAt(int n, int n2) {
        if (n2 == 0) {
            Object object = ((ASACheckedData)this.tableModel.getValueAt((int)n, (int)n2)).object;
            return ((ASAUserData)object).getUserData();
        }
        return super.getUserDataAt(n, n2);
    }

    @Override
    public void setUserDataAt(Object object, int n, int n2) {
        if (n2 == 0) {
            Object object2 = ((ASACheckedData)this.tableModel.getValueAt((int)n, (int)n2)).object;
            ((ASAUserData)object2).setUserData(object);
            this.tableModel.fireTableCellUpdated(n, n2);
        } else {
            super.setUserDataAt(object, n, n2);
        }
    }

    @Override
    public Vector getRow(int n) {
        Vector<Object> vector = new Vector<Object>(this.columnCount);
        for (int i = 0; i < this.columnCount; ++i) {
            if (i == 0) {
                vector.add(((ASACheckedData)this.getValueAt((int)n, (int)i)).object);
                continue;
            }
            vector.add(this.getValueAt(n, i));
        }
        return vector;
    }

    @Override
    public Object[] getRowAsArray(int n) {
        Object[] objectArray = new Object[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            objectArray[i] = i == 0 ? ((ASACheckedData)this.getValueAt((int)n, (int)i)).object : this.getValueAt(n, i);
        }
        return objectArray;
    }

    @Override
    public void setRow(int n, Vector vector) {
        for (int i = 0; i < this.columnCount; ++i) {
            if (i == 0) {
                this.tableModel.setValueAt(new ASACheckedData(this.isRowChecked(n), vector.get(i)), n, i);
                continue;
            }
            this.tableModel.setValueAt(vector.get(i), n, i);
        }
    }

    public void setRow(int n, boolean bl, Vector vector) {
        for (int i = 0; i < this.columnCount; ++i) {
            if (i == 0) {
                this.tableModel.setValueAt(new ASACheckedData(bl, vector.get(i)), n, i);
                continue;
            }
            this.tableModel.setValueAt(vector.get(i), n, i);
        }
    }

    @Override
    public void setRow(int n, Object[] objectArray) {
        for (int i = 0; i < this.columnCount; ++i) {
            if (i == 0) {
                this.tableModel.setValueAt(new ASACheckedData(this.isRowChecked(n), objectArray[i]), n, i);
                continue;
            }
            this.tableModel.setValueAt(objectArray[i], n, i);
        }
    }

    public void setRow(int n, boolean bl, Object[] objectArray) {
        for (int i = 0; i < this.columnCount; ++i) {
            if (i == 0) {
                this.tableModel.setValueAt(new ASACheckedData(bl, objectArray[i]), n, i);
                continue;
            }
            this.tableModel.setValueAt(objectArray[i], n, i);
        }
    }

    @Override
    public void addRow(Vector vector) {
        super.addRow(this._createCheckableRowData(true, false, vector));
    }

    public void addRow(boolean bl, Vector vector) {
        super.addRow(this._createCheckableRowData(true, bl, vector));
    }

    public void addRow(boolean bl, boolean bl2, Vector vector) {
        super.addRow(this._createCheckableRowData(bl, bl2, vector));
    }

    @Override
    public void addRow(Object[] objectArray) {
        super.addRow(this._createCheckableRowData(true, false, objectArray));
    }

    public void addRow(boolean bl, Object[] objectArray) {
        super.addRow(this._createCheckableRowData(true, bl, objectArray));
    }

    public void addRow(boolean bl, boolean bl2, Object[] objectArray) {
        super.addRow(this._createCheckableRowData(bl, bl2, objectArray));
    }

    @Override
    public void insertRow(int n, Vector vector) {
        super.insertRow(n, this._createCheckableRowData(true, false, vector));
    }

    public void insertRow(int n, boolean bl, Vector vector) {
        super.insertRow(n, this._createCheckableRowData(true, bl, vector));
    }

    public void insertRow(int n, boolean bl, boolean bl2, Vector vector) {
        super.insertRow(n, this._createCheckableRowData(bl, bl2, vector));
    }

    @Override
    public void insertRow(int n, Object[] objectArray) {
        super.insertRow(n, this._createCheckableRowData(true, false, objectArray));
    }

    public void insertRow(int n, boolean bl, Object[] objectArray) {
        super.insertRow(n, this._createCheckableRowData(true, bl, objectArray));
    }

    public void insertRow(int n, boolean bl, boolean bl2, Object[] objectArray) {
        super.insertRow(n, this._createCheckableRowData(bl, bl2, objectArray));
    }

    private Vector _createCheckableRowData(boolean bl, boolean bl2, Vector vector) {
        int n = vector.size();
        Vector<ASACheckedData> vector2 = new Vector<ASACheckedData>(n);
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                vector2.add(new ASACheckedData(bl, bl2, vector.get(i)));
                continue;
            }
            vector2.add((ASACheckedData)vector.get(i));
        }
        return vector2;
    }

    private Object[] _createCheckableRowData(boolean bl, boolean bl2, Object[] objectArray) {
        int n = objectArray.length;
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        objectArray2[0] = new ASACheckedData(bl, bl2, objectArray[0]);
        return objectArray2;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (actionEvent.getSource() == this && (n = this.getSelectedRow()) >= 0 && this.isEnabled() && ((ASACheckedData)this.getValueAt((int)n, (int)0)).isEnabled) {
            this.toggleRowChecked(n);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this._pressedRow = this.rowAtPoint(mouseEvent.getPoint());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        int n;
        Point point = mouseEvent.getPoint();
        if (this.isEnabled() && (n = this.rowAtPoint(point)) >= 0 && n == this._pressedRow && ((ASACheckedData)this.getValueAt((int)n, (int)0)).isEnabled && this.columnAtPoint(point) == 0) {
            this.toggleRowChecked(n);
        }
    }
}

