/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa;

import com.sybase.asa.ASAMultiColumnLabelTableCellRenderer;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ASAMultiColumnLabel
extends JTable {
    private static final String STR_EMPTY = "";
    private ASAMultiColumnLabelTableCellRenderer _renderer = new ASAMultiColumnLabelTableCellRenderer();
    private boolean _useDefaultRenderer = true;
    private boolean _calculateColumnWidths = true;
    private int _rowCount;
    private int _columnCount;
    private TableColumnModel _tableColumnModel;
    private int[] _extraIntercolumnSpacing;
    private int _extraIntercolumnSpacingCount;

    public ASAMultiColumnLabel() {
        this._init();
    }

    public ASAMultiColumnLabel(Vector vector) {
        this.setDataVector(vector);
        this._init();
    }

    public ASAMultiColumnLabel(Object[][] objectArray) {
        this.setDataVector(objectArray);
        this._init();
    }

    private void _init() {
        this.setForeground(SystemColor.controlText);
        this.setBackground(SystemColor.control);
        this.setSelectionForeground(this.getForeground());
        this.setSelectionBackground(this.getBackground());
        this.setShowGrid(false);
        this.setFocusable(false);
    }

    public boolean getUseDefaultRenderer() {
        return this._useDefaultRenderer;
    }

    public void setUseDefaultRenderer(boolean bl) {
        this._useDefaultRenderer = bl;
        if (bl) {
            this._useDefaultRenderer();
        }
    }

    public boolean getCalculateColumnWidths() {
        return this._calculateColumnWidths;
    }

    public void setCalculateColumnWidths(boolean bl) {
        this._calculateColumnWidths = bl;
        if (bl) {
            this._calculateColumnWidths();
        }
    }

    public int[] getExtraIntercolumnSpacing() {
        return this._extraIntercolumnSpacing;
    }

    public void setExtraIntercolumnSpacing(int[] nArray) {
        this._extraIntercolumnSpacing = nArray;
        if (nArray != null) {
            this._extraIntercolumnSpacingCount = nArray.length;
            this._calculateColumnWidths();
        }
    }

    public void setDataVector(Vector vector) {
        this._rowCount = vector == null ? 0 : vector.size();
        this._columnCount = this._rowCount == 0 ? 0 : ((Vector)vector.get(0)).size();
        ((DefaultTableModel)this.getModel()).setDataVector(vector, this._createEmptyColumnNamesVector());
        this._tableColumnModel = this.getColumnModel();
        if (this._useDefaultRenderer) {
            this._useDefaultRenderer();
        }
        if (this._calculateColumnWidths) {
            this._calculateColumnWidths();
        }
    }

    public void setDataVector(Object[][] objectArray) {
        this._rowCount = objectArray == null ? 0 : objectArray.length;
        this._columnCount = this._rowCount == 0 ? 0 : objectArray[0].length;
        ((DefaultTableModel)this.getModel()).setDataVector(objectArray, this._createEmptyColumnNamesArray());
        this._tableColumnModel = this.getColumnModel();
        if (this._useDefaultRenderer) {
            this._useDefaultRenderer();
        }
        if (this._calculateColumnWidths) {
            this._calculateColumnWidths();
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    private Vector _createEmptyColumnNamesVector() {
        Vector<String> vector = new Vector<String>(this._columnCount);
        for (int i = 0; i < this._columnCount; ++i) {
            vector.add(STR_EMPTY);
        }
        return vector;
    }

    private String[] _createEmptyColumnNamesArray() {
        String[] stringArray = new String[this._columnCount];
        for (int i = 0; i < this._columnCount; ++i) {
            stringArray[i] = STR_EMPTY;
        }
        return stringArray;
    }

    private void _useDefaultRenderer() {
        for (int i = 0; i < this._columnCount; ++i) {
            this._tableColumnModel.getColumn(i).setCellRenderer(this._renderer);
        }
    }

    private void _calculateColumnWidths() {
        int n = 0;
        for (int i = 0; i < this._columnCount; ++i) {
            int n2 = 0;
            for (int j = 0; j < this._rowCount; ++j) {
                Object object = this.getValueAt(j, i);
                if (object == null) continue;
                int n3 = this._renderer.getTableCellRendererComponent((JTable)this, (Object)object, (boolean)false, (boolean)false, (int)j, (int)i).getPreferredSize().width;
                n2 = Math.max(n2, n3);
            }
            if (this._extraIntercolumnSpacing != null && i < this._extraIntercolumnSpacingCount) {
                n2 += this._extraIntercolumnSpacing[i];
                n += this._extraIntercolumnSpacing[i];
            }
            TableColumn tableColumn = this._tableColumnModel.getColumn(i);
            tableColumn.setPreferredWidth(n2 += 5);
            tableColumn.setMinWidth(n2);
            tableColumn.setMaxWidth(n2);
        }
        Dimension dimension = this.getPreferredSize();
        dimension.width += this.getIntercellSpacing().width * this._columnCount;
        dimension.width += n;
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
    }
}

