/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa;

import com.sybase.asa.ASACheckBox;
import com.sybase.asa.ASAComboBox;
import com.sybase.asa.ASAIconTextData;
import com.sybase.asa.ASAIconTextDataListCellRenderer;
import com.sybase.asa.ASAIntegerTextField;
import com.sybase.asa.ASAPropertyData;
import com.sybase.asa.ASAPropertyList;
import com.sybase.asa.ASATextField;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;

public class ASAPropertyDataTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
DocumentListener,
ItemListener,
ActionListener {
    private static final String ACTN_CANCEL_EDITING = "0";
    private ASAPropertyList _propertyList;
    private ASAPropertyData _data;
    private int _editingRow;
    private int _editingColumn;
    private boolean _firePropertyListChangeEvents;
    private ASACheckBox _checkBox;
    private ASATextField _textField;
    private ASAIntegerTextField _intTextField;
    private ASAComboBox _comboBox;
    private JTextField _comboBoxEditor;
    private DefaultListCellRenderer _comboBoxRenderer;
    private ASAIconTextDataListCellRenderer _comboBoxIconTextDataRenderer;

    public ASAPropertyDataTableCellEditor(ASAPropertyList aSAPropertyList) {
        this._propertyList = aSAPropertyList;
        this._checkBox = new ASACheckBox();
        this._checkBox.setBackground(SystemColor.window);
        this._checkBox.setHorizontalAlignment(0);
        this._checkBox.setVerticalAlignment(0);
        this._textField = new ASATextField();
        this._intTextField = new ASAIntegerTextField();
        this._intTextField.setHorizontalAlignment(2);
        this._comboBox = new ASAComboBox();
        this._comboBoxEditor = (JTextField)this._comboBox.getEditor().getEditorComponent();
        this._comboBoxRenderer = new DefaultListCellRenderer();
        this._comboBoxIconTextDataRenderer = new ASAIconTextDataListCellRenderer();
        this._checkBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this._textField.getForeground(), 1), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this._textField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this._textField.getForeground(), 1), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this._intTextField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this._intTextField.getForeground(), 1), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this._comboBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this._comboBox.getForeground(), 1), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this._checkBox.addItemListener(this);
        this._textField.getDocument().addDocumentListener(this);
        this._textField.registerKeyboardAction(this, ACTN_CANCEL_EDITING, KeyStroke.getKeyStroke(27, 0), 0);
        this._intTextField.getDocument().addDocumentListener(this);
        this._intTextField.registerKeyboardAction(this, ACTN_CANCEL_EDITING, KeyStroke.getKeyStroke(27, 0), 0);
        this._comboBox.addItemListener(this);
        this._comboBox.registerKeyboardAction(this, ACTN_CANCEL_EDITING, KeyStroke.getKeyStroke(27, 0), 0);
        this._comboBoxEditor.getDocument().addDocumentListener(this);
        this._comboBoxEditor.registerKeyboardAction(this, ACTN_CANCEL_EDITING, KeyStroke.getKeyStroke(27, 0), 1);
    }

    public void releaseResources() {
        this._checkBox.removeItemListener(this);
        this._textField.getDocument().removeDocumentListener(this);
        this._textField.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        this._intTextField.getDocument().removeDocumentListener(this);
        this._intTextField.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        this._comboBox.removeItemListener(this);
        this._comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        this._comboBoxEditor.getDocument().removeDocumentListener(this);
        this._comboBoxEditor.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        this._propertyList = null;
        this._data = null;
        this._checkBox = null;
        this._textField = null;
        this._intTextField = null;
        this._comboBox = null;
        this._comboBoxEditor = null;
        this._comboBoxRenderer = null;
        this._comboBoxIconTextDataRenderer = null;
    }

    @Override
    public boolean stopCellEditing() {
        if (this._data != null) {
            switch (this._data.type) {
                case 1: {
                    this._data.value = new Boolean(this._checkBox.isSelected());
                    break;
                }
                case 2: {
                    this._data.value = this._textField.getText();
                    break;
                }
                case 3: {
                    this._data.value = this._intTextField.getText();
                    break;
                }
                case 4: {
                    this._data.value = this._comboBox.getSelectedItem();
                    break;
                }
                case 5: {
                    this._data.value = this._comboBoxEditor.getText();
                }
            }
        }
        this._propertyList.firePropertyListEditingStopped(this._editingRow, this._editingColumn);
        return super.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this._propertyList.firePropertyListEditingCanceled(this._editingRow, this._editingColumn);
        super.cancelCellEditing();
    }

    private ListCellRenderer _getRendererForOptions(Object[] objectArray) {
        if (objectArray.length > 0 && objectArray[0] instanceof ASAIconTextData) {
            return this._comboBoxIconTextDataRenderer;
        }
        return this._comboBoxRenderer;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (!(object instanceof ASAPropertyData)) {
            return null;
        }
        this._data = (ASAPropertyData)object;
        this._editingRow = n;
        this._editingColumn = n2;
        if (this._data != null) {
            switch (this._data.type) {
                case 0: {
                    return null;
                }
                case 1: {
                    this._firePropertyListChangeEvents = false;
                    this._checkBox.setSelected((Boolean)this._data.value);
                    this._firePropertyListChangeEvents = true;
                    return this._checkBox;
                }
                case 2: {
                    this._firePropertyListChangeEvents = false;
                    this._textField.setText(this._data.toString());
                    this._firePropertyListChangeEvents = true;
                    return this._textField;
                }
                case 3: {
                    this._firePropertyListChangeEvents = false;
                    this._intTextField.setText(this._data.toString());
                    this._firePropertyListChangeEvents = true;
                    return this._intTextField;
                }
                case 4: {
                    this._firePropertyListChangeEvents = false;
                    this._comboBox.setEditable(false);
                    this._comboBox.setRenderer(this._getRendererForOptions(this._data.options));
                    this._comboBox.removeAllItems();
                    int n3 = this._data.options.length;
                    for (int i = 0; i < n3; ++i) {
                        this._comboBox.addItem(this._data.options[i]);
                    }
                    if (this._data.value != null) {
                        this._comboBox.setSelectedItem(this._data.value);
                    }
                    this._firePropertyListChangeEvents = true;
                    return this._comboBox;
                }
                case 5: {
                    this._firePropertyListChangeEvents = false;
                    this._comboBox.setEditable(true);
                    this._comboBox.setRenderer(this._getRendererForOptions(this._data.options));
                    this._comboBox.removeAllItems();
                    int n4 = this._data.options.length;
                    for (int i = 0; i < n4; ++i) {
                        this._comboBox.addItem(this._data.options[i]);
                    }
                    this._comboBoxEditor.setText(this._data.toString());
                    this._firePropertyListChangeEvents = true;
                    return this._comboBox;
                }
            }
        }
        return null;
    }

    @Override
    public Object getCellEditorValue() {
        return this._data;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this._handleDocumentEvent();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this._handleDocumentEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this._handleDocumentEvent();
    }

    private void _handleDocumentEvent() {
        if (this._firePropertyListChangeEvents) {
            String string;
            switch (this._data.type) {
                case 2: {
                    string = this._textField.getText();
                    break;
                }
                case 3: {
                    string = this._intTextField.getText();
                    break;
                }
                case 5: {
                    string = this._comboBoxEditor.getText();
                    break;
                }
                default: {
                    string = null;
                }
            }
            this._propertyList.firePropertyListValueChanged(this._editingRow, this._editingColumn, string);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this._firePropertyListChangeEvents) {
            switch (this._data.type) {
                case 1: {
                    this._propertyList.firePropertyListValueChanged(this._editingRow, this._editingColumn, new Boolean(this._checkBox.isSelected()));
                    break;
                }
                case 4: 
                case 5: {
                    this._propertyList.firePropertyListValueChanged(this._editingRow, this._editingColumn, this._comboBox.getSelectedItem());
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if ((object == this._textField || object == this._intTextField || object == this._comboBox || object == this._comboBoxEditor) && actionEvent.getActionCommand().equals(ACTN_CANCEL_EDITING)) {
            this.cancelCellEditing();
        }
    }
}

