/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa;

import com.sybase.asa.ASAIconTextData;
import com.sybase.asa.ASAMultiList;
import com.sybase.asa.ASAMultiListTableModel;
import com.sybase.asa.ASAPercentData;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ASASortingTableModel
extends AbstractTableModel
implements TableModelListener {
    public static final Collator COLLATOR = Collator.getInstance();
    private ASAMultiList _table = null;
    private ASAMultiListTableModel _model = null;
    private boolean _sorting = true;
    private Integer[] _mappingIndexes = null;
    private boolean _ascending = true;
    private int _lastSortedColumn = -1;
    private MouseAdapter _listMouseListener = null;
    private boolean _enableChangeEvents = true;

    public ASASortingTableModel(ASAMultiList aSAMultiList) {
        this._table = aSAMultiList;
        this._model = (ASAMultiListTableModel)this._table.getModel();
        this.addMouseListenerToHeaderInTable();
    }

    public ASASortingTableModel(ASAMultiList aSAMultiList, ASAMultiListTableModel aSAMultiListTableModel) {
        this._table = aSAMultiList;
        this.setModel(aSAMultiListTableModel);
        this.resetIndexes(true);
        this.addMouseListenerToHeaderInTable();
    }

    public void clear() {
        this._model.setNumRows(0);
        this.resetIndexes(true);
    }

    public void setSorting(boolean bl) {
        this._sorting = bl;
    }

    public boolean isSorting() {
        return this._sorting;
    }

    public void setModel(ASAMultiListTableModel aSAMultiListTableModel) {
        this._model = aSAMultiListTableModel;
        this._model.addTableModelListener(this);
        this.resetIndexes(true);
        this._table.createDefaultColumnsFromModel();
        this._lastSortedColumn = -1;
        this._ascending = true;
    }

    public TableModel getModel() {
        return this._model;
    }

    public int getDataIndexForTableIndex(int n) {
        return this._mappingIndexes[n];
    }

    public int getTableIndexForDataIndex(int n) {
        for (int i = 0; i < this._mappingIndexes.length; ++i) {
            if (this._mappingIndexes[i] != n) continue;
            return i;
        }
        return -1;
    }

    public void releaseResources() {
        JTableHeader jTableHeader = this._table.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.removeMouseListener(this._listMouseListener);
        }
        this._table = null;
        this._model = null;
        this._mappingIndexes = null;
    }

    private void addMouseListenerToHeaderInTable() {
        this._table.setColumnSelectionAllowed(false);
        this._listMouseListener = new MouseAdapter(){
            private int[] _oldWidths;
            private int _col;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = ASASortingTableModel.this._table.getColumnModel();
                this._oldWidths = new int[tableColumnModel.getColumnCount() - 1];
                for (int i = 0; i < this._oldWidths.length; ++i) {
                    this._oldWidths[i] = tableColumnModel.getColumn(i).getWidth();
                }
                this._col = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n;
                TableColumnModel tableColumnModel = ASASortingTableModel.this._table.getColumnModel();
                if (tableColumnModel.getColumnCount() - 1 == this._oldWidths.length) {
                    for (n = 0; n < tableColumnModel.getColumnCount() - 1; ++n) {
                        if (tableColumnModel.getColumn(n).getWidth() == this._oldWidths[n]) continue;
                        return;
                    }
                } else {
                    return;
                }
                if (ASASortingTableModel.this._table.isEnabled() && ASASortingTableModel.this._sorting && this._col == (n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX()))) {
                    ASASortingTableModel.this._table.getSelectionModel().clearSelection();
                    int n2 = ASASortingTableModel.this._table.convertColumnIndexToModel(n);
                    if (n2 != -1) {
                        if (n2 == ASASortingTableModel.this._lastSortedColumn) {
                            ASASortingTableModel.this._ascending = !ASASortingTableModel.this._ascending;
                        } else {
                            ASASortingTableModel.this._ascending = true;
                        }
                        ASASortingTableModel.this._lastSortedColumn = n2;
                        ASASortingTableModel.this.sortByColumn(n2);
                    }
                }
            }
        };
        JTableHeader jTableHeader = this._table.getTableHeader();
        jTableHeader.addMouseListener(this._listMouseListener);
    }

    public void sortByColumn(int n, boolean bl) {
        this._ascending = bl;
        this.sortByColumn(n);
        this._table.setSortedColumnNumber(this._lastSortedColumn);
        this._table.setAscendingSortOrder(this._ascending);
    }

    private void sortByColumn(int n) {
        TableCellEditor tableCellEditor = this._table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        this._table.setSortedColumnNumber(this._lastSortedColumn);
        this._table.setAscendingSortOrder(this._ascending);
        this.resetIndexes(false);
        Arrays.sort(this._mappingIndexes, new SortComparator(n));
        this.tableChanged(new TableModelEvent(this));
    }

    private void resetIndexes(boolean bl) {
        this._mappingIndexes = new Integer[this.getRowCount()];
        for (int i = 0; i < this.getRowCount(); ++i) {
            this._mappingIndexes[i] = new Integer(i);
        }
        if (bl) {
            this._lastSortedColumn = -1;
            this._ascending = true;
            this._table.setSortedColumnNumber(this._lastSortedColumn);
            this._table.setAscendingSortOrder(this._ascending);
        }
    }

    private void addRowToMappingArray(int n) {
        Integer[] integerArray = null;
        if (this._mappingIndexes != null) {
            integerArray = new Integer[this._mappingIndexes.length + 1];
            System.arraycopy(this._mappingIndexes, 0, integerArray, 0, n);
            if (this._mappingIndexes.length > n) {
                System.arraycopy(this._mappingIndexes, n, integerArray, n + 1, this._mappingIndexes.length - n);
            }
        } else {
            integerArray = new Integer[1];
        }
        integerArray[n] = new Integer(integerArray.length - 1);
        this._mappingIndexes = integerArray;
        integerArray = null;
        this.tableChanged(new TableModelEvent(this, n, n, -1, 1));
    }

    private void removeRowFromMappingArray(int n) {
        Integer[] integerArray = new Integer[this._mappingIndexes.length - 1];
        int n2 = 0;
        int n3 = this._mappingIndexes[n];
        for (int i = 0; i < this._mappingIndexes.length; ++i) {
            if (this._mappingIndexes[i] < n3) {
                integerArray[n2++] = new Integer(this._mappingIndexes[i]);
                continue;
            }
            if (this._mappingIndexes[i] <= n3) continue;
            integerArray[n2++] = new Integer(this._mappingIndexes[i] - 1);
        }
        this._mappingIndexes = integerArray;
        integerArray = null;
        this.tableChanged(new TableModelEvent(this, n, n, -1, -1));
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this._model.getValueAt(this._mappingIndexes[n], n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this._model.setValueAt(object, this._mappingIndexes[n], n2);
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public int getRowCount() {
        if (this._model == null) {
            return 0;
        }
        return this._model.getRowCount();
    }

    @Override
    public int getColumnCount() {
        if (this._model == null) {
            return 0;
        }
        return this._model.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this._model.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this._model.getColumnClass(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this._model.isCellEditable(this.getDataIndexForTableIndex(n), n2);
    }

    public Vector getDataVector() {
        return this._model.getDataVector();
    }

    public void moveRow(int n, int n2, int n3) {
        this._enableChangeEvents = false;
        this._model.moveRow(n, n2, n3);
        this._enableChangeEvents = true;
        this.fireTableDataChanged();
    }

    public void insertRow(int n, Object[] objectArray) {
        this._enableChangeEvents = false;
        this._model.addRow(objectArray);
        this._enableChangeEvents = true;
        this.addRowToMappingArray(n);
    }

    public void insertRow(int n, Vector vector) {
        this._enableChangeEvents = false;
        this._model.addRow(vector);
        this._enableChangeEvents = true;
        this.addRowToMappingArray(n);
    }

    public void addRow(Vector vector) {
        this._enableChangeEvents = false;
        this._model.addRow(vector);
        this._enableChangeEvents = true;
        this.addRowToMappingArray(this._mappingIndexes.length);
    }

    public void addRow(Object[] objectArray) {
        this._enableChangeEvents = false;
        this._model.addRow(objectArray);
        this._enableChangeEvents = true;
        this.addRowToMappingArray(this._mappingIndexes.length);
    }

    public void removeRow(int n) {
        this._enableChangeEvents = false;
        this._model.removeRow(this.getDataIndexForTableIndex(n));
        this._enableChangeEvents = true;
        this.removeRowFromMappingArray(n);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this._enableChangeEvents) {
            this.fireTableChanged(tableModelEvent);
        }
    }

    class SortComparator
    implements Comparator {
        private int _column = 0;

        SortComparator(int n) {
            this._column = n;
        }

        public int compare(Object object, Object object2) {
            int n = this.compareRowsByColumn((Integer)object, (Integer)object2, this._column);
            if (n != 0) {
                return ASASortingTableModel.this._ascending ? n : -n;
            }
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object);
        }

        private int compareRowsByColumn(int n, int n2, int n3) {
            Class clazz = ASASortingTableModel.this.getColumnClass(n3);
            Object object = ASASortingTableModel.this._model.getValueAt(n, n3);
            Object object2 = ASASortingTableModel.this._model.getValueAt(n2, n3);
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (clazz.getSuperclass() == Number.class) {
                Number number;
                double d;
                Number number2 = (Number)ASASortingTableModel.this._model.getValueAt(n, n3);
                double d2 = number2.doubleValue();
                if (d2 < (d = (number = (Number)ASASortingTableModel.this._model.getValueAt(n2, n3)).doubleValue())) {
                    return -1;
                }
                if (d2 > d) {
                    return 1;
                }
                return 0;
            }
            if (clazz == Date.class) {
                Date date;
                long l;
                Date date2 = (Date)ASASortingTableModel.this._model.getValueAt(n, n3);
                long l2 = date2.getTime();
                if (l2 < (l = (date = (Date)ASASortingTableModel.this._model.getValueAt(n2, n3)).getTime())) {
                    return -1;
                }
                if (l2 > l) {
                    return 1;
                }
                return 0;
            }
            if (clazz == ASAIconTextData.class) {
                ASAIconTextData aSAIconTextData = (ASAIconTextData)ASASortingTableModel.this._model.getValueAt(n, n3);
                ASAIconTextData aSAIconTextData2 = (ASAIconTextData)ASASortingTableModel.this._model.getValueAt(n2, n3);
                int n4 = COLLATOR.compare(aSAIconTextData.text, aSAIconTextData2.text);
                if (n4 < 0) {
                    return -1;
                }
                if (n4 > 0) {
                    return 1;
                }
                return 0;
            }
            if (clazz == ASAPercentData.class) {
                ASAPercentData aSAPercentData = (ASAPercentData)ASASortingTableModel.this._model.getValueAt(n, n3);
                ASAPercentData aSAPercentData2 = (ASAPercentData)ASASortingTableModel.this._model.getValueAt(n2, n3);
                if (aSAPercentData.value < aSAPercentData2.value) {
                    return -1;
                }
                if (aSAPercentData.value > aSAPercentData2.value) {
                    return 1;
                }
                return 0;
            }
            if (clazz == String.class) {
                String string;
                String string2 = (String)ASASortingTableModel.this._model.getValueAt(n, n3);
                int n5 = COLLATOR.compare(string2, string = (String)ASASortingTableModel.this._model.getValueAt(n2, n3));
                if (n5 < 0) {
                    return -1;
                }
                if (n5 > 0) {
                    return 1;
                }
                return 0;
            }
            if (clazz == Boolean.class) {
                Boolean bl;
                boolean bl2;
                Boolean bl3 = (Boolean)ASASortingTableModel.this._model.getValueAt(n, n3);
                boolean bl4 = bl3;
                if (bl4 == (bl2 = (bl = (Boolean)ASASortingTableModel.this._model.getValueAt(n2, n3)).booleanValue())) {
                    return 0;
                }
                if (bl4) {
                    return 1;
                }
                return -1;
            }
            Object object3 = ASASortingTableModel.this._model.getValueAt(n, n3);
            String string = object3.toString();
            Object object4 = ASASortingTableModel.this._model.getValueAt(n2, n3);
            String string3 = object4.toString();
            if (string == null || string3 == null) {
                return 0;
            }
            int n6 = COLLATOR.compare(string, string3);
            if (n6 < 0) {
                return -1;
            }
            if (n6 > 0) {
                return 1;
            }
            return 0;
        }
    }
}

