/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa;

import com.sybase.asa.ASAIconTextDataTreeCellRenderer;
import com.sybase.asa.ASAScrollPane;
import com.sybase.asa.ASATreeNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ASATree
extends JTree
implements ActionListener {
    private boolean _autoKeySelectionEnabled;
    private Timer _timer;
    private StringBuffer _typedSoFar;
    private DefaultTreeModel _model;
    private ASAScrollPane _scrollPane;

    public ASATree() {
        super(new DefaultTreeModel(new ASATreeNode()));
        this._init();
    }

    private void _init() {
        this._model = (DefaultTreeModel)this.getModel();
        this._scrollPane = new ASAScrollPane(this);
        this._autoKeySelectionEnabled = true;
        this._timer = new Timer(1000, this);
        this._typedSoFar = new StringBuffer();
        this._timer.start();
    }

    public void releaseResources() {
        if (this._timer.isRunning()) {
            this._timer.stop();
        }
        this._timer.removeActionListener(this);
        this._timer = null;
        this._typedSoFar = null;
        this._model = null;
        this._scrollPane = null;
    }

    public boolean isAutoKeySelectionEnabled() {
        return this._autoKeySelectionEnabled;
    }

    public void setAutoKeySelectionEnabled(boolean bl) {
        this._autoKeySelectionEnabled = bl;
        if (bl && !this._timer.isRunning()) {
            this._timer.restart();
        } else if (!bl && this._timer.isRunning()) {
            this._timer.stop();
        }
    }

    public boolean getHasIconTextData() {
        return this.getCellRenderer() instanceof ASAIconTextDataTreeCellRenderer;
    }

    public void setHasIconTextData(boolean bl) {
        this.setCellRenderer(bl ? new ASAIconTextDataTreeCellRenderer() : new DefaultTreeCellRenderer());
    }

    public ASAScrollPane getScrollPane() {
        return this._scrollPane;
    }

    public void setSelectionMode(int n) {
        this.getSelectionModel().setSelectionMode(n);
    }

    public ASATreeNode getRoot() {
        return (ASATreeNode)this._model.getRoot();
    }

    public void setRoot(Object object) {
        ASATreeNode aSATreeNode = new ASATreeNode(object);
        this._model.setRoot(aSATreeNode);
    }

    public int getChildCount(ASATreeNode aSATreeNode) {
        return this._model.getChildCount(aSATreeNode);
    }

    public ASATreeNode getChild(ASATreeNode aSATreeNode, int n) {
        return (ASATreeNode)this._model.getChild(aSATreeNode, n);
    }

    public int findNode(String string) {
        return this.findNode(string, 0, this.getRowCount(), false, false);
    }

    public int findNode(String string, int n) {
        return this.findNode(string, n, this.getRowCount(), false, false);
    }

    public int findNode(String string, int n, int n2, boolean bl, boolean bl2) {
        int n3 = string.length();
        for (int i = n; i < n2; ++i) {
            String string2;
            TreePath treePath = this.getPathForRow(i);
            if (treePath == null || (string2 = treePath.getLastPathComponent().toString()) == null || !string2.regionMatches(bl, 0, string, 0, bl2 ? n3 : string2.length())) continue;
            return i;
        }
        return -1;
    }

    public ASATreeNode addNode(Object object, ASATreeNode aSATreeNode, boolean bl) {
        return this.insertNode(object, aSATreeNode, aSATreeNode.getChildCount(), bl);
    }

    public ASATreeNode insertNode(Object object, ASATreeNode aSATreeNode, int n, boolean bl) {
        ASATreeNode aSATreeNode2 = new ASATreeNode(object);
        aSATreeNode2.setLeaf(bl);
        this._model.insertNodeInto(aSATreeNode2, aSATreeNode, n);
        return aSATreeNode2;
    }

    public void removeNode(int n) {
        TreePath treePath = this.getPathForRow(n);
        ASATreeNode aSATreeNode = (ASATreeNode)treePath.getLastPathComponent();
        this._model.removeNodeFromParent(aSATreeNode);
    }

    public void removeNodeFromParent(ASATreeNode aSATreeNode) {
        this._model.removeNodeFromParent(aSATreeNode);
    }

    public void clear() {
        this.setRoot(new ASATreeNode());
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        int n;
        int n2;
        char c;
        if (this._timer.isRunning() && keyEvent.getKeyCode() == 0 && (c = keyEvent.getKeyChar()) != '\uffff' && ((n2 = keyEvent.getModifiers()) == 0 || n2 == 1) && (n = this.getRowCount()) > 0) {
            String string;
            this._timer.stop();
            this._typedSoFar.append(c);
            TreePath treePath = this.getSelectionPath();
            int n3 = treePath == null ? 0 : this.getRowForPath(treePath);
            int n4 = this._typedSoFar.length();
            if (n4 == 1 || this._typedSoFar.charAt(n4 - 2) == c) {
                ++n3;
                string = String.valueOf(c);
            } else {
                string = this._typedSoFar.toString();
            }
            int n5 = this.findNode(string, n3, n, true, true);
            if (n5 != -1 || (n5 = this.findNode(string, 0, n3, true, true)) != -1) {
                this.setSelectionInterval(n5, n5);
                this.scrollRowToVisible(n5);
            }
            this._timer.restart();
            keyEvent.consume();
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._timer) {
            this._typedSoFar.setLength(0);
        }
    }
}

