/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa;

import com.sybase.central.SCProfile;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.UIManager;

public class ASAUtils {
    private static final String STR_EMPTY = "";
    private static final String STR_OS_DOT_NAME = "os.name";
    private static final String STR_OS_DOT_VERSION = "os.version";
    private static final String STR_WINDOWS = "Windows";
    private static final String STR_WINDOWS_95 = "Windows 95";
    private static final String STR_WINDOWS_98 = "Windows 98";
    private static final String STR_WINDOWS_ME = "Windows Me";
    private static final String STR_WINDOWS_NT = "Windows NT";
    private static final String STR_WINDOWS_2000 = "Windows 2000";
    private static final String STR_WINDOWS_XP = "Windows XP";
    private static final String STR_5_DOT_1 = "5.1";
    private static final String STR_5_DOT_2 = "5.2";
    private static final String STR_SOLARIS = "Solaris";
    private static final String STR_SUNOS = "SunOS";
    private static final String STR_LINUX = "Linux";
    private static final String STR_Y = "Y";
    private static final String STR_N = "N";
    private static final String STR_COMMA = ",";
    private static final String STR_COMMA_SPACE = ", ";
    private static final String STR_SPACE_DASH_SPACE = " - ";
    private static final String STR_SPACE_OPEN_PAREN = " (";
    private static final String STR_CLOSE_PAREN_SPACE_DASH_SPACE = ") - ";
    private static final Integer INT_ZERO = new Integer(0);
    private static final String REGEXP_NON_NEGATIVE_INT = "[0-9]+";
    private static final String REGEXP_PROFILE_STRING = "\"([^\"]+|(\"\"))*\"";
    private static final int BUFFER_SIZE = 1024;

    public static String getOSName() {
        return System.getProperty(STR_OS_DOT_NAME);
    }

    public static String getOSVersion() {
        return System.getProperty(STR_OS_DOT_VERSION);
    }

    public static boolean isWindows() {
        return ASAUtils.getOSName().indexOf(STR_WINDOWS) != -1;
    }

    public static boolean isWindowsFake32() {
        return ASAUtils.isWindows95() || ASAUtils.isWindows98() || ASAUtils.isWindowsMe();
    }

    public static boolean isWindowsReal32() {
        return ASAUtils.isWindows() && !ASAUtils.isWindowsFake32();
    }

    public static boolean isWindows95() {
        return ASAUtils.getOSName().indexOf(STR_WINDOWS_95) != -1;
    }

    public static boolean isWindows98() {
        return ASAUtils.getOSName().indexOf(STR_WINDOWS_98) != -1;
    }

    public static boolean isWindowsMe() {
        return ASAUtils.getOSName().indexOf(STR_WINDOWS_ME) != -1;
    }

    public static boolean isWindowsNT() {
        return ASAUtils.getOSName().indexOf(STR_WINDOWS_NT) != -1;
    }

    public static boolean isWindows2000() {
        return ASAUtils.getOSName().indexOf(STR_WINDOWS_2000) != -1;
    }

    public static boolean isWindowsXP() {
        return ASAUtils.getOSName().indexOf(STR_WINDOWS_XP) != -1 && ASAUtils.getOSVersion().indexOf(STR_5_DOT_1) != -1;
    }

    public static boolean isWindows2003() {
        return ASAUtils.getOSName().indexOf(STR_WINDOWS_XP) != -1 && ASAUtils.getOSVersion().indexOf(STR_5_DOT_2) != -1;
    }

    public static boolean isUnix() {
        return ASAUtils.isSolaris() || ASAUtils.isLinux();
    }

    public static boolean isSolaris() {
        String string = ASAUtils.getOSName();
        return string.indexOf(STR_SOLARIS) != -1 || string.indexOf(STR_SUNOS) != -1;
    }

    public static boolean isLinux() {
        return ASAUtils.getOSName().indexOf(STR_LINUX) != -1;
    }

    public static boolean isExistingFile(String string) {
        File file = new File(string);
        return file.exists() && file.isFile();
    }

    public static boolean isExistingDirectory(String string) {
        if (string.length() == 0) {
            return true;
        }
        File file = new File(string);
        return file.exists() && file.isDirectory();
    }

    public static String getDirectoryFromPath(String string) {
        File file = new File(string);
        String string2 = file.getParent();
        return string2 == null ? STR_EMPTY : string2;
    }

    public static String getExistingDirectoryFromPath(String string) {
        if (string.length() == 0) {
            return string;
        }
        for (File file = new File(string); file != null; file = file.getParentFile()) {
            if (!file.exists() || !file.isDirectory()) continue;
            return file.getPath();
        }
        return STR_EMPTY;
    }

    public static String getFileFromPath(String string) {
        File file = new File(string);
        String string2 = file.getName();
        return string2 == null ? STR_EMPTY : string2;
    }

    public static String getFileWithoutExtensionFromPath(String string) {
        int n;
        String string2 = ASAUtils.getFileFromPath(string);
        int n2 = string2.length();
        if (n2 > 0 && (n = string2.lastIndexOf(46)) > 0) {
            return string2.substring(0, n);
        }
        return string2;
    }

    public static String getFileExtensionFromPath(String string) {
        int n;
        String string2 = ASAUtils.getFileFromPath(string);
        int n2 = string2.length();
        if (n2 > 0 && (n = string2.lastIndexOf(46)) > 0 && n < n2 - 1) {
            return string2.substring(n + 1);
        }
        return STR_EMPTY;
    }

    public static String getCanonicalPath(String string) {
        File file = new File(string);
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    public static String buildFullPathName(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        int n = string.length();
        if (n > 0 && string.charAt(n - 1) != File.separatorChar) {
            return string + File.separatorChar + string2;
        }
        return string + string2;
    }

    public static boolean createDirectory(String string) {
        File file = new File(string);
        return file.mkdirs();
    }

    public static boolean deleteFile(String string) {
        File file = new File(string);
        return file.delete();
    }

    public static String quote(String string, char c, char c2, boolean bl, boolean bl2) {
        if (!bl && (string == null || string.indexOf(c) == -1 && string.indexOf(c2) == -1)) {
            return string;
        }
        boolean bl3 = c2 != '\u0000';
        int n = string != null ? string.length() : 0;
        char[] cArray = new char[n * 2 + 2];
        int n2 = 0;
        if (bl) {
            cArray[n2++] = c;
        }
        for (int i = 0; i < n; ++i) {
            char c3 = string.charAt(i);
            cArray[n2++] = c3;
            if (bl2 && c3 == c) {
                cArray[n2++] = c;
            }
            if (!bl3 || c3 != c2) continue;
            cArray[n2++] = c2;
        }
        if (bl) {
            cArray[n2++] = c;
        }
        return new String(cArray, 0, n2);
    }

    public static String unquote(String string, char c, char c2, boolean bl, boolean bl2) {
        int n;
        int n2;
        if (string == null || string.length() <= 1 || string.indexOf(c) == -1 && string.indexOf(c2) == -1) {
            return string;
        }
        boolean bl3 = c2 != '\u0000';
        int n3 = string.length();
        if (bl && string.indexOf(c) == 0 && string.lastIndexOf(c) == n3 - 1) {
            n2 = 1;
            n = n3 - 1;
        } else {
            n2 = 0;
            n = n3;
        }
        char[] cArray = new char[n - n2];
        int n4 = 0;
        for (int i = n2; i < n; ++i) {
            char c3 = string.charAt(i);
            if (bl2 && c3 == c && i < n - 1 && string.charAt(i + 1) == c) {
                cArray[n4++] = c;
                ++i;
                continue;
            }
            if (bl3 && c3 == c2 && i < n - 1 && string.charAt(i + 1) == c2) {
                cArray[n4++] = c2;
                ++i;
                continue;
            }
            cArray[n4++] = c3;
        }
        return new String(cArray, 0, n4);
    }

    public static String buildIntegerList(int[] nArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int n : nArray) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(String.valueOf(n));
        }
        return stringBuffer.toString();
    }

    public static String buildProfileIntegerList(int[] nArray) {
        return ASAUtils.buildIntegerList(nArray, STR_COMMA);
    }

    public static String buildSQLIntegerList(int[] nArray) {
        return ASAUtils.buildIntegerList(nArray, STR_COMMA_SPACE);
    }

    public static int[] parseIntegerList(String string, String string2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            Integer n;
            String string3 = matcher.group();
            try {
                n = Integer.valueOf(string3);
            }
            catch (NumberFormatException numberFormatException) {
                n = INT_ZERO;
            }
            arrayList.add(n);
        }
        int n = arrayList.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }

    public static int[] parseProfileIntegerList(String string) {
        return ASAUtils.parseIntegerList(string, REGEXP_NON_NEGATIVE_INT);
    }

    public static String buildStringList(String[] stringArray, String string, char c, char c2, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : stringArray) {
            if (string2 == null || string2.length() == 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(ASAUtils.quote(string2, c, c2, bl, bl2));
        }
        return stringBuffer.toString();
    }

    public static String buildStringList(Collection collection, String string, char c, char c2, boolean bl, boolean bl2) {
        return ASAUtils.buildStringList(collection.toArray(new String[collection.size()]), string, c, c2, bl, bl2);
    }

    public static String buildProfileStringList(String[] stringArray) {
        return ASAUtils.buildStringList(stringArray, STR_COMMA, '\"', '\u0000', true, true);
    }

    public static String buildSQLIdentifierList(String[] stringArray) {
        return ASAUtils.buildStringList(stringArray, STR_COMMA_SPACE, '\"', '\\', true, true);
    }

    public static String buildSQLStringList(String[] stringArray) {
        return ASAUtils.buildStringList(stringArray, STR_COMMA_SPACE, '\'', '\\', true, true);
    }

    public static String buildSQLKeywordList(String[] stringArray) {
        return ASAUtils.buildStringList(stringArray, STR_COMMA_SPACE, '\u0000', '\u0000', false, false);
    }

    public static String buildDisplayStringList(String[] stringArray) {
        return ASAUtils.buildStringList(stringArray, STR_COMMA_SPACE, '\u0000', '\u0000', false, false);
    }

    public static String buildProfileStringList(Collection collection) {
        return ASAUtils.buildProfileStringList(collection.toArray(new String[collection.size()]));
    }

    public static String buildSQLIdentifierList(Collection collection) {
        return ASAUtils.buildSQLIdentifierList(collection.toArray(new String[collection.size()]));
    }

    public static String buildSQLStringList(Collection collection) {
        return ASAUtils.buildSQLStringList(collection.toArray(new String[collection.size()]));
    }

    public static String buildSQLKeywordList(Collection collection) {
        return ASAUtils.buildSQLKeywordList(collection.toArray(new String[collection.size()]));
    }

    public static String buildDisplayStringList(Collection collection) {
        return ASAUtils.buildDisplayStringList(collection.toArray(new String[collection.size()]));
    }

    public static String[] parseStringList(String string, String string2, char c, char c2, boolean bl, boolean bl2) {
        ArrayList arrayList = ASAUtils.parseStringListIntoArrayList(string, string2, c, c2, bl, bl2);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static ArrayList parseStringListIntoArrayList(String string, String string2, char c, char c2, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string3 = matcher.group();
            arrayList.add(ASAUtils.unquote(string3, c, c2, bl, bl2));
        }
        return arrayList;
    }

    public static String[] parseProfileStringList(String string) {
        return ASAUtils.parseStringList(string, REGEXP_PROFILE_STRING, '\"', '\u0000', true, true);
    }

    public static ArrayList parseProfileStringListIntoArrayList(String string) {
        return ASAUtils.parseStringListIntoArrayList(string, REGEXP_PROFILE_STRING, '\"', '\u0000', true, true);
    }

    public static String buildNameWithOwner(String string, String string2) {
        int n = string.length() + string2.length() + 3;
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(string);
        stringBuffer.append(STR_SPACE_OPEN_PAREN);
        stringBuffer.append(string2);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String buildNameWithNameWithOwner(String string, String string2, String string3) {
        int n = string.length() + string2.length() + string3.length() + 6;
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(string);
        stringBuffer.append(STR_SPACE_DASH_SPACE);
        stringBuffer.append(string2);
        stringBuffer.append(STR_SPACE_OPEN_PAREN);
        stringBuffer.append(string3);
        stringBuffer.append(')').toString();
        return stringBuffer.toString();
    }

    public static String buildNameWithUser(String string, String string2) {
        int n = string.length() + string2.length() + 3;
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(string);
        stringBuffer.append(STR_SPACE_DASH_SPACE);
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public static String buildNameWithOwnerWithUser(String string, String string2, String string3) {
        int n = string.length() + string2.length() + string3.length() + 6;
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(string);
        stringBuffer.append(STR_SPACE_OPEN_PAREN);
        stringBuffer.append(string2);
        stringBuffer.append(STR_CLOSE_PAREN_SPACE_DASH_SPACE);
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    public static String compressWhitespace(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        StringBuffer stringBuffer = new StringBuffer(n);
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken()).append(' ');
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static String removeCarriageReturns(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == '\r') continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public static String buildHexString(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer(n * 4 + 2);
        stringBuffer.append('\'');
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i];
            if (n2 < 0) {
                n2 += 256;
            }
            int n3 = n2 >>> 4;
            int n4 = n2 & 0xF;
            stringBuffer.append("\\x");
            if (n3 < 10) {
                stringBuffer.append((char)(48 + n3));
            } else {
                stringBuffer.append((char)(97 + n3 - 10));
            }
            if (n4 < 10) {
                stringBuffer.append((char)(48 + n4));
                continue;
            }
            stringBuffer.append((char)(97 + n4 - 10));
        }
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    public static String buildScript(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : stringArray) {
            if (string == null || string.length() <= 0) continue;
            stringBuffer.append(string);
            stringBuffer.append(";\n");
        }
        return stringBuffer.toString();
    }

    public static boolean isValid24HourTime(String string) {
        try {
            return string.length() == 4 && Integer.parseInt(string.substring(0, 2)) <= 23 && Integer.parseInt(string.substring(2)) <= 59;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean equals(String string, String string2) {
        return ASAUtils.equals(string, string2, true);
    }

    public static boolean equals(String string, String string2, boolean bl) {
        if (string == null || string.length() == 0) {
            return string2 == null || string2.length() == 0;
        }
        return bl ? string.equals(string2) : string.equalsIgnoreCase(string2);
    }

    public static boolean equals(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray.length == 0) {
            return nArray2 == null || nArray2.length == 0;
        }
        return Arrays.equals(nArray, nArray2);
    }

    public static boolean equals(Collection collection, Collection collection2) {
        if (collection == null || collection.size() == 0) {
            return collection2 == null || collection2.size() == 0;
        }
        return ((Object)collection).equals(collection2);
    }

    public static boolean equals(Date date, Date date2) {
        return date == null ? date2 == null : date.equals(date2);
    }

    public static boolean equals(Time time, Time time2) {
        return time == null ? time2 == null : time.equals(time2);
    }

    public static boolean equals(Timestamp timestamp, Timestamp timestamp2) {
        return timestamp == null ? timestamp2 == null : timestamp.equals(timestamp2);
    }

    public static boolean getBooleanPreference(SCProfile sCProfile, String string, boolean bl) {
        String string2 = sCProfile.readString(string);
        if (string2 == null) {
            return bl;
        }
        if (string2.equalsIgnoreCase(STR_Y)) {
            return true;
        }
        if (string2.equalsIgnoreCase(STR_N)) {
            return false;
        }
        return bl;
    }

    public static void setBooleanPreference(SCProfile sCProfile, String string, boolean bl) {
        sCProfile.writeString(string, bl ? STR_Y : STR_N);
    }

    public static Image loadImage(String string) {
        try {
            int n;
            InputStream inputStream = UIManager.getLookAndFeel().getClass().getResourceAsStream(string);
            if (inputStream == null) {
                return null;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            byte[] byArray = new byte[1024];
            while ((n = bufferedInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
            byteArrayOutputStream.flush();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            if (byArray2 == null || byArray2.length == 0) {
                return null;
            }
            return Toolkit.getDefaultToolkit().createImage(byArray2);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

